      SUBROUTINE setup_ncdf_op

      USE flags_module,ONLY: printphoto_fg,jall_fg,prevflag,iscape
      USE io_units_module,ONLY: lout
      USE time_mgmt_module,ONLY: ntstep,nskip,ntout,ntprint, &
                                 tstart,tstop
      USE printphoto_module,ONLY: n_printphoto,idprintphoto, &
                                  photoreac_names
      USE NetCDF_vars_module,ONLY: ncid_out,ncid_prev,maskval, &
                                   attname,line1,line2
      USE solver_params_module,ONLY: rtol,atol, dtmin
      USE forcing_params_module
      USE module_data_gecko_main

      IMPLICIT NONE

! LOCAL VARIABLES
      INTEGER :: iunit, nhdr
      CHARACTER(1) :: chdr1
      CHARACTER(2) :: chdr2
      CHARACTER(4) :: keyword
      CHARACTER(llin) :: line

!---------------------------------------------------

        PRINT*,"opening NetCDF output file"


        if (prevflag .eq. 0) then
!--copy NetCDF input (link) file to form basis for new output file
          CALL SYSTEM('cp indat.nc outdat.nc')
          CALL open_ncfile_readwrite('outdat.nc',ncid_out)

!--rename mech's existing global atts in output file
          CALL eznc_rename_globalatt(ncid_out,"mechanism","mech_name")
          CALL eznc_rename_globalatt(ncid_out,"date",    "mech_date")
          CALL eznc_rename_globalatt(ncid_out,"user",    "mech_user")
          CALL eznc_rename_globalatt(ncid_out,"platform","mech_platform")
          CALL eznc_rename_globalatt(ncid_out,"Git_branch", &
                                              "mech_Git_branch")
          CALL eznc_rename_globalatt(ncid_out,"Git_commit", &
                                            "mech_Git_commit")
!--update file_description attribute in o/p file
!  (delete then re-define inserts new version at BOTTOM of att list)
!  (re-define alone overwrites old version in same position in list)

          CALL eznc_def_globalatt(ncid_out,"file_description", &
                 "GECKO-A boxmodel output: initialisation")

!++define boxmodel run name ASSUMING output is in a self-named directory
!++.. and that this program is being run in that directory.
          print *, "defining name"
          CALL eznc_def_sysglobatt(ncid_out,"run_name", &
                    "`pwd | awk -F/ '{print $NF}'`")

!++{user, date, platform} for box model run
          CALL eznc_def_sysglobatt(ncid_out,"run_date","`date`")
          CALL eznc_def_sysglobatt(ncid_out,"run_user","$USER")
          CALL eznc_def_sysglobatt(ncid_out,"run_platform","$HOSTNAME")

!++{Git_branch, Git_commit}
!        CALL eznc_def_sysglobatt(ncid_out,"Git_branch", &
!                  "`git rev-parse --abbrev-ref HEAD`")
!        CALL eznc_def_sysglobatt(ncid_out,"Git_commit", &
!                                     "`git describe`")

!-- if  git calls do not work on your platform, substitute the
!following:
!++ reads ascii file generated by script run_boxmod.bash
          filename="indat.gitinfo"
          OPEN(20,FILE=filename,STATUS='OLD')
          READ(20,'(a)') line1
          CALL eznc_def_globalatt(ncid_out,"Git_branch",line1)
          READ(20,'(a)') line2
          CALL eznc_def_globalatt(ncid_out,"Git_commit",line2)
          CLOSE(20)

!==================================================

          CALL eznc_def_dim(ncid_out,"nbox",nbox)

!      CALL eznc_def_dim_unlim(ncid_out,"ntout")

!==================================================
!--define JVALUES table in output file
! define dimensions njtab & nsza in NetCDF output file
      CALL eznc_def_dim(ncid_out,"njtab",njtab)
      CALL eznc_def_dim(ncid_out,"nsza",nsza)
      CALL eznc_def_dim(ncid_out,"llin",llin)
      IF (jall_fg.EQ.1) CALL eznc_def_dim(ncid_out,"nchrom",nchrom)
! maxcoe is defined in akparameter_module

! define space for tables in NetCDF output file
      CALL eznc_def_2Dreal  (ncid_out,"jvref","nsza","njtab")
      CALL eznc_def_localatt(ncid_out,"jvref","title", &
                                      "reference j-values")
      CALL eznc_def_localatt(ncid_out,"jvref","units","s-1")

!----------------------------------------
! reopen jvalues file to read headers
      iunit=12
      nhdr = 0
      OPEN(iunit,file='jfile.phot',form='formatted',status='old')

190   DO
      READ(iunit,'(a1,(a))',end=199) keyword,line
! if the line is a header comment, write as attribute
      IF(keyword(1:1).EQ.'/'.AND.line.NE.''.AND.line(1:1).NE.' ')THEN
        nhdr = nhdr + 1
        IF(nhdr.LT.10)THEN
          WRITE(chdr1,"(i1)")nhdr
          attname(1:8)= "header_"//chdr1
        ELSE
          WRITE(chdr2,"(i2)")nhdr
          attname(1:8)= "header"//chdr2
        ENDIF
        CALL eznc_def_localatt(ncid_out,"jvref",attname,line)
        CYCLE
        GOTO 190
! detect end of file
      ELSE IF(keyword(1:1).EQ.'E'.AND.line(1:3).EQ.'ND')THEN
        EXIT
        GOTO 200

! if not useful text, go back to read next data line
      ELSE
        CYCLE
        GOTO 190
      ENDIF !(keyword(1:1).EQ.'/')THEN

! label to check that the keyword 'END' was found
199    WRITE(lout,*)' --error--  keyword END not found in readj'
200   ENDDO

!----------------------------------------
! define chromophore name
! (conveniently, "maxcoe" is the correct size for the names)
      CALL eznc_def_1Dchar  (ncid_out,"jnam","maxcoe","njtab")
      CALL eznc_def_localatt(ncid_out,"jnam","title", &
                                      "j-value species name")
! define chromophore reaction text
      CALL eznc_def_1Dchar  (ncid_out,"jreac","llin","njtab")
      CALL eznc_def_localatt(ncid_out,"jreac","title", &
                                      "j-value reaction string")
! define chromophore reaction id number
      CALL eznc_def_1Dint   (ncid_out,"idjtab","njtab")
      CALL eznc_def_localatt(ncid_out,"idjtab","title", &
                        "model photolysis species id, in input order")
      CALL eznc_def_localatt(ncid_out,"idjtab","cross-reference",&
                                      "idhv in mechanism")
! define values for j-input tables
      CALL eznc_def_1Dreal  (ncid_out,"jsza","nsza")
      CALL eznc_def_localatt(ncid_out,"jsza","title", &
                             "solar angles for reference j-values")
      CALL eznc_def_localatt(ncid_out,"jsza","units", &
                                      "degrees from zenith")

! define values for j-output tables
      IF (jall_fg.EQ.1) THEN
        CALL eznc_def_1Dint  (ncid_out,"idchrom","nchrom")
        CALL eznc_def_localatt(ncid_out,"idchrom","title", &
                         "model photolysis species id, in output order")
        CALL eznc_def_localatt(ncid_out,"idchrom","cross-reference",&
                                        "idhv in mechanism")
      ENDIF

!==================================================
!--define input flags in output file
!  (these may have been set via the keyfile, or in flags.h)
        CALL defflags_ncdf(ncid_out)

!==define keyfile inputs in output file
        CALL defenvinp_ncdf(ncid_out)
!        CALL defenvinp_ncdf(ncid_out, &
!                            tstart,tstop,ntstep,ntprint, &
!                            nbox,rtol,atol,cbg,cnv, &
!                            emi_spec, cons_spec, surface_emi, &
!                            njf,jftim,jfval,szafix,szaval, &
!                            jo2,jh2o,f185,f254, &
!                            nhd,htop,boxt,boxh,nmx,mixt,mixr, &
!                            tempm,tempa,temptm,ntk,tktim,tkval, &
!                            rhm,rha,rhtm,nrh,rhtim,rhval, &
!                            waterfix,water,sumcfix,sumc,noxfix, &
!                            windm,winda,windtm,nws,wstim,wsval, &
!                            saero,nseed,tseed,cseed,nsd,surft,psurf, &
!                            sla,slo,tz,iy,im,id, &
!                            iscape,iseas,nskip,ntout,maskval)

!==define ARRAY SIZE DECLARATIONS
        CALL defopvals_ncdf(ncid_out)

!==define printphoto in output file
        IF (printphoto_fg) THEN
          IF (n_printphoto .GT. 0) THEN

! define space in NetCDF file for photo rates
            CALL eznc_def_dim(ncid_out,"n_printphoto", n_printphoto)
            CALL eznc_def_dim(ncid_out,"maxreac_char", maxreac_char)
            CALL eznc_def_1Dint(ncid_out,"idprintphoto","n_printphoto")
            CALL eznc_def_1Dchar(ncid_out,"photoreac_names", &
                                          "maxreac_char","n_printphoto")
            CALL eznc_def_2Dreal(ncid_out,"photorates","n_printphoto", &
                                                       "ntout")
          ENDIF !(n_printphoto .GT. 0)
        ENDIF !(printphoto_fg)


!----------------------------------
! ! NetCDF OUTPUT "HEADERS"
! (done after get_envinp because we need nbox)

! SWITCH NETCDF TO DATA MODE FOR OUTPUT WRITING
        CALL switch_ncfile_to_data_mode(ncid_out)

! INPUT FLAGS
        CALL wrtflags_ncdf(ncid_out)
! J-VALUE PARAMETERS
        CALL wrtjvinp_ncdf(ncid_out,njtab,nsza, &
                               mxjtab,mxsza,llin, &
                               idjtab,jsza,jvref,jnam,jreac)

        CALL wrtenvinp_ncdf(ncid_out,numsp, &
                            tstart,tstop,ntstep,ntprint, &
                            nbox,rtol,atol,dtmin,cbg,cnv, &
                            gamm, Mp, Rpo, &
                            emi_spec, cons_spec, &
                            surface_emi, &
                            njf,jftim,jfval,szafix,szaval, &
                            jo2,jh2o,f185,f254, &
                            nhd,htop,boxt,boxh,nmx,mixt,mixr,vs, &
                            tempm,tempa,temptm,ntk,tktim,tkval, &
                            rhm,rha,rhtm,nrh,rhtim,rhval, &
                            waterfix,water,sumcfix,sumc,noxfix, &
                            windm,winda,windtm,nws,wstim,wsval, &
                            saero,nseed,tseed,cseed,nsd,surft,psurf, &
                            sla,slo,tz,iy,im,id, &
                            iscape,iseas,nskip,maskval)

! write value of ndim to netCDF output file
        call eznc_def_0Dint(ncid_out,"ndim")
        CALL eznc_put_0Dint(ncid_out,"ndim",ndim)

! PHOTO REACTION IDS AND NAMES
        IF (printphoto_fg .AND. n_printphoto .GT. 0) THEN
          CALL eznc_put_1Dint(ncid_out,"idprintphoto", &
                                        idprintphoto, &
                                        1, n_printphoto)
          CALL eznc_put_1Dchar(ncid_out,"photoreac_names", &
                                         photoreac_names, &
                                         maxreac_char,1,n_printphoto)
        ENDIF !(printphoto_fg .AND. n_printphoto .GT. 0)
        
!----------------------------------
! Transfer attributes from previous file (if supplied)
      ELSE IF (prevflag.EQ.1) THEN
!--copy NetCDF previous file (link) file to form basis for new output file
          CALL SYSTEM('cp prevdat.nc outdat.nc')
          CALL open_ncfile_readwrite('outdat.nc',ncid_out)

          print*, ncid_prev, ncid_out

! SWITCH NETCDF TO DATA MODE FOR OUTPUT WRITING
          CALL switch_ncfile_to_data_mode(ncid_out)          

      ENDIF ! (prevflag.EQ.1) THEN
!----------------------------------
      END SUBROUTINE setup_ncdf_op
!----------------------------------
