      SUBROUTINE open_op_files

! open output files (if not already open)

      USE flags_module,ONLY: iofmt_fg,soa_fg,jall_fg,printphoto_fg, &
                             iscape
      USE io_units_module,ONLY: lppf,lppa,lpff,lpaa,ljval, &
                                ljall,lsoa,lpbl,lro2
      USE printphoto_module,ONLY: n_printphoto
      USE forcing_params_module,ONLY: nbox

      IMPLICIT NONE

!---------------------------------------------------
! open ascii file for output reference jvals

      IF (printphoto_fg.AND.n_printphoto .GT. 0) THEN
        OPEN(ljval,file='outdat.jvals',status='unknown')
      ENDIF !(printphoto_fg.AND.n_printphoto .GT. 0) THEN

!---------------------------------------------------
! open binary files for box 1 and box 2 results

      IF (iofmt_fg.EQ.1.OR.iofmt_fg.EQ.2) THEN
        PRINT*,"opening binary output files"

        OPEN(lppf,file='outdat.ppf',form='unformatted',status='unknown')
        IF (soa_fg.EQ.1) THEN
          OPEN(lppa,file='outdat.ppa',form='unformatted', &
             status='unknown')
        ENDIF

        IF (nbox == 2) THEN
          OPEN(lpff,file='outdat.pff',form='unformatted', &
               status='unknown')
          IF (soa_fg.GE.1) THEN
            OPEN(lpaa,file='outdat.paa',form='unformatted', &
                 status='unknown')
          ENDIF
        ENDIF

! open ascii file to output ALL jvals
        IF (jall_fg.NE.0) THEN
          OPEN(ljall,file='outdat.jall',status='unknown')
        ENDIF !(jall_fg)


      ENDIF !(iofmt_fg.EQ.1.OR.iofmt_fg.EQ.2)

! write ascii & binary output headers
      CALL write_op_hdrs

!---------------------------------------------------
! open NetCDF file for results output

      IF (iofmt_fg.EQ.0.OR.iofmt_fg.EQ.2) THEN
        CALL setup_ncdf_op
      ENDIF !(iofmt_fg.EQ.0.OR.iofmt_fg.EQ.2) 

!---------------------------------------------------
! open files for results linked to thermodynamical calculation

        IF (iscape.eq.1) THEN
          OPEN(20,file='outdat.distri',status='unknown')
          OPEN(67,file='outdat.aerodep',status='unknown')
          OPEN(71,file='outdat.1rhdat',status='unknown')
          OPEN(72,file='outdat.1res',status='unknown')
          OPEN(73,file='outdat.p1dat',status='unknown')
          OPEN(74,file='outdat.1brhdat',status='unknown')
          OPEN(75,file='outdat.p1bdat',status='unknown')
          IF (nbox == 2) THEN
            OPEN(81,file='outdat.2rhdat',status='unknown')
            OPEN(82,file='outdat.2res',status='unknown')
            OPEN(83,file='outdat.p2dat',status='unknown')
            OPEN(84,file='outdat.2brhdat',status='unknown')
            OPEN(85,file='outdat.p2bdat',status='unknown')
          ENDIF
        ENDIF

!---------------------------------------------------
! open some other ascii files 

      OPEN(lpbl,file='outdat.pbl',form='formatted',status='unknown')
      WRITE(lpbl,*) "Time [s], PBL Height [cm]"

! RO2 concentration 
      OPEN(lro2,file='outdat.ro2',form='formatted',status='unknown')
      WRITE(lro2,*) "time(s), PERO1, PERO2, PERO3, PERO4, PERO5, "// &
                    "PERO6, PERO7, PERO8, PERO9 (molec/cc)"

      IF(soa_fg.NE.0)THEN
        OPEN(lsoa,file='outdat.soa',form='formatted',status='unknown')
        WRITE(lsoa,*) "Time [s], ctotaer, [molec/cc], Rp [cm],"// &
                     " mwaer(mean) [g/mole] "
      ENDIF
!---------------------------------------------------
      END SUBROUTINE open_op_files
!---------------------------------------------------
