      SUBROUTINE find_concs(cbox)
!!-----------------------------------------------------------------
! rates of :
! dilution and exchange between the 2 boxes (box-specific)
! emission & deposition (box-specific) 
!!-----------------------------------------------------------------

      USE flags_module,ONLY: iofmt_fg,ro2_fg,dimer_fg
      USE io_units_module,ONLY: lro2
      USE time_mgmt_module,ONLY: iskip,nskip,time
      USE akparameter_module
      USE forcing_params_module,ONLY: water
      USE module_data_gecko_main

      IMPLICIT NONE

      REAL,DIMENSION(maxsp) :: cbox
!------------------------------------------------------
      !PRINT*,"starting find_concentrations"

! compute RO2 concentration
      cro2(1:nclro2) = 0.

      IF (ro2_fg.ne.0) THEN
        DO i=1,nclro2
          DO k=1,numchemro2(i)
            cro2(i)=cro2(i)+cbox(idchemro2(k,i))
          ENDDO
        ENDDO
      ENDIF

! write time & pre-solver [RO2] to ascii output file
! (netCDF output is done POST-solver)

      IF (iskip.eq.nskip) THEN
        IF (iofmt_fg.EQ.1.OR.iofmt_fg.EQ.2) THEN
          WRITE(lro2,'(10(ES13.3))') &
                time/(3600.*24.),(cro2(i),i=1,nclro2)
        ENDIF ! (iofmt_fg.EQ.1.OR.iofmt_fg.EQ.2)
      ENDIF

! compute dimer concentration
      IF (dimer_fg.EQ.1) THEN
        cdimer(1:ncldimer)=0.
        DO i=1,ncldimer
          DO k=1,numchemdimer(i)
            cdimer(i)=cdimer(i)+cbox(idchemdimer(k,i))
          ENDDO
        ENDDO
      ENDIF ! (dimer_fg.EQ.1)

! set CH3O2 concentration (and check for 0 value)
      IF (ro2_fg.NE.0)    cmeo2 = cbox(idch3o2)
      IF (cmeo2.LT.1E-13) cmeo2 = 1E-13

! set sum of NOx for this box
      IF (noxfix(ibox) == 1) sumnox = cbox(idno) + cbox(idno2)

! apply water concentration constraint from input file 
! and O2 concentration constraint from sumc
! (overwrite calculation-updated concentrations)
      cbox(idh2o) = water(ibox)
      cbox(ido2dic) = sumc(ibox)*0.2

      !PRINT*,"after find_concentrations"
! -------------------------------------
      END SUBROUTINE find_concs
! -------------------------------------

