==================================================
README_BOXMOD_INDAT
==================================================
Date: 23 March, 2020
Author: Jula Lee-Taylor, NCAR
Purpose:
This file describes all keywords available for the 
GECKO-A boxmodel input files indat_*.key
Most keywords have default values defined in the code,
in subroutine init_defaults.f90. Keyword can be omitted
if the default value is desired.
==================================================
==== Integer flags : Format in this file =========
KYWD : in-code-variable-name : default value : explanation
   m = meaning of value 'm'
==================================================
==== Integer flags : FOR GENERAL USE =============
==================================================
NBOX : nbox : number of boxes where chemistry is solved  
   (valid values = 1, 2)
...................
PREV : prevflag : 0 : are we continuing from a previous run?
   0 = fresh run, from scratch DEFAULT
   1 = use output from a previous run as initial conditions
...................
LAGR : lagflag : 0 : Eulerian or Lagrangian mode?
   0 = Eulerian
   1 = Lagrangian
...................
DEPO : depos_fg : 0 : deposition (0/1 = off/on)
...................
PVAP : pvap_fg : 2 : vapour pressure estimation method
   2 = Nannoolal
   3 = SIMPOL.1
   DEPRECATED OPTION: 1 = Myrdal & Yalkowski
...................
SOAF : soa_fg : 2 : SOA (0/2 = off/on)
   0 = no SOA
   2 = SOA with mass transfer method 
   DEPRECATED OPTION: 1 = basic equilirium SOA method 
...................
NVID : seedtyp_fg : 0 : identity of aerosol seed (affects density, allocation of organic mass for partitioning)
   0 = organic
   1 = inorganic
...................
WALL : wall_fg : 0 : wall losses (0/1 = off/on)
...................
CHAM : icham : 0 : identity of chamber for wall losses
NB: Each chamber has its own subroutine, to enable addition of other well-characterized chambers.
   0 = none
   1 = Matsunaga & Ziemann
   2 = CU: Ziemann
   3 = CU: Jimenez 
==================================================
==== Integer flags : FOR USE WITH CARE
==================================================
DIMR : dimer_fg : 0 : dimerisation (0/1 = off/on)
...................
RO2F : ro2_fg : 1 : allow RO2+RO2 reactions (0/1 = off/on)
...................
OFR : OFR_fg : 0 : OFR mode (0/1 = off/on)
     !! also requires keywords {F185, F254}, see below.
...................
ISOA : isopsoa_fg : 0 : isoprene aq. soa (0/1 = off/on)
       (CAUTION! ONLY FOR USE IN SPECIFIC CASES. ASK!)
     !! also requires keywords {PHAR, NITR, SULF, KAPA}, see below.
=================================================================
DATA : placeholder between flags and data sections (COMPULSORY)
=================================================================
==== Input data variables : Format in this file =========
==== default format: 
KWYD  value
==== sinusoidal format: 
KYWD followed by nbox lines containing 3 variables a,b,c where:
     m = mean; a = amplitude; tm = time of maximum
==== table format: 
KYWD nlin; followed by nlin lines of format:
     time(s)  value
     NB: table format overrides single-line or sinusoidal formats
==== box-wise table format: 
KYWD BOT/TOP nlin; for bottom / top box, followed by nlin lines of format:
     time(s)  value
==== multi-table format: 
KYWD ntab; followed by ntab tables of format:
     PNAME nlin  (PNAME = GECKO name with phase prefix G/A/W etc)
     time(s)  value
=================================================================
==== Input data variables : REQUIRED =========
=================================================================
TSTR : tstart(s) : time at start of simulation
...................
TSTP : tstop(s) : time at end of simulation
...................
TLEN : tlen(s) : length of timestep for interpolation of environmental inputs. 
...................
SKIP : nskip(unitless) : number of interpolation timesteps per output time-point
...................
REAC : pname conc1(molec/cc) conc2(molec/cc) conc3(molec/cc)
       initial concentrations of species "pname" in:
       box1, box2 (background if nbox = 1), background (if nbox = 2)
       one line per species
...................
END : keyword marking end of input data
=================================================================
==== Input data variables : 1 OPTION REQUIRED IN EACH CASE ======
=================================================================
::::::::::::::::::::::::
HTOP : htop(cm) : altitude of top of box 2 (if present)
.....AND/OR.................
HBOX : (table format)
::::::::::::::::::::::::
TEMP : temperature, sinusoidal format (separate line per box)
 tempm(K)  tempa(K) temptm(s)  <- box 1
 tempm(K)  tempa(K) temptm(s)  <- box 2 (if applicable)
.....OR.................
TKTB ntk : temperature (table format)
  tktim(s)  tkval(1:nbox)(K)
::::::::::::::::::::::::
WATR : water concentration (molecules/cm3)
.....OR.................
RHUM : relative humidity sinusoidal format (separate line per box)
 tempa(K)  tempb(K) rhtm(s)  <- box 1
 tempa(K)  tempb(K) rhtm(s)  <- box 2 (if applicable)
.....OR.................
RHTB nrh : relative humidity (table format)
  rhtim (s)  rhvals(1:nbox) (%)
::::::::::::::::::::::::
WIND : winda(m.s-1)  windb(m.s-1) windtm(s)
       wind speed, sinusoidal format (all on one line), applies to box1 only
       used for deposition
.....OR.................
WSTB nws : box 1 wind speed (table format)
  wstim (s)  wsval (m.s-1)
::::::::::::::::::::::::
PPHO : sla(degrees), slo(degrees), tz(HH), iy(yyyy), im(mm), id(dd)
       {lat,         lon,     timezone, year,    month,  day}
       parameters to calculate diurnally varying solar zenith angle 
       timezone = hours west of Greenwich (in case o/p desired in UT)
.....OR.................
SZAF : szaval(degrees) : fixed solar zenith angle. Sets flag szafix = 1
=================================================================
==== Input data variables : OPTIONAL =========
=================================================================
::::::::::::::::::::::::
PRES : pres(hPa) : atmospheric pressure (fixed, currently same for all boxes)
                  (If NOT set here, sumc calculated from lapse rate & gas const)
.....OR.................
NDEN : sumc(1:nbox)(molec/cc) : number density of atmosphere (fixed)
                  (overrides PRES)
                  (If NOT set here, sumc calculated from lapse rate & gas const)
::::::::::::::::::::::::
DILF : dilconst(s-1) : constant dilution rate - sets dilfix = 1
.....OR.................
DILT ndil : varying dilution rate (table format) TODO
  diltim(s) dilval(s-1)
...................
SUBS : vs(m.s-1) : tropospheric subsidence velocity 
...................
MIX nmx : diffusive/advective mixing rate (table format)
    mixt(s) mixr(s-1)(box1) mixr(s-1)(box2, if appropriate)
...................
SEAS : iseas : 0 : season i.d.
   (used for deposition parameterization)
   (1 = summer, luxuriant vegetation)
   (2 = late autumn, no leaves, no snow)
....AND............
SURF nsd : fraction of surface occupied by vegetation type(n) (table format) 
   surft(t)(s) psurf(t,n=1:4)
   (4 surface types are URB1 : CULT : FLEA : FCON ) 
   (i.e. urban, cultivated, forest:leafy, forest:coniferous)
   (4 values must add up to 1.0)
   (used for deposition parameterization)
   (REQUIRES SEAS)
...................
CONS : constrained concentrations (multi-table format)
...................
EMIS : emissions (multi-table format)
...................
SEMI : surface-dependent emissions (multi-table format)
...................
NOEM : noem_fg (fraction) Surface NO emissions per Amazon rainforest 
               (standard flux = 2.6 ngN m-2 s-1 for wet soil, Yienger & Levy 95)
               (default fraction = 0)
...................
ISOP : isop_fac (isoprene emission factor, default = 1)
...................
MTER : mterp_fac (monoterpene emission factor, default = 1)
:::::::::::::::::::
SEED : cnv(mole/cc) : concentration of non-volatile seed particles
.....OR..............
SEET : nseed : time-varying nonvolatile seed aerosol concentration (table format)
     tseed(s) cseed(molec/cc)
:::::::::::::::::::
NVMW : Mp(amu) : mean molecular mass of non-volatile seed particles
...................
NVRO : Rpo(cm) : initial radius of nonvolatile aerosol particles
...................
GAMM : gamm(unitless) : bulk activity coeff for SOA, default = 1.
...................
JFAC : njf : time-varying across-the-board multiplier for j-values (table format)
     jftim(s) jfval(real, unitless)
===========================================================
==== Input data variables : ONLY FOR USE IN SPECIFIC CASES
===========================================================
RTOL : rtol(unitless) : relative solver tolerance. Default = 1e-2
...................
ATOL : atol(unitless) : absolute solver tolerance. Default = 1e2
...................
PHAR : ph_const(unitless) : constrained pH (box-wise table format)
(requires ISOA=1)
...................
NITR : nitrate_const(unitless) : constrained nitrate (box-wise table format)
(requires ISOA=1)
...................
SULF : sulfate_const(unitless) : constrained sulfate (box-wise table format)
(requires ISOA=1)
...................
KAPA : kappa_const(unitless) : constrained sulfate (box-wise table format)
(requires ISOA=1)
...................
AERO : saero(cm2/cm3)(t=0) : initial wet aerosol surface area
(for inorganic aerosol use)
...................
F185 : f185(photons.cm-2.s-1) : photon flux at 185 nm 
(for OFR only)
...................
F254 : f254(photons.cm-2.s-1) : photon flux at 254 nm 
(for OFR only)
==================================================
==================================================
==== INPUT KEYWORDS NOT IN CURRENT USE ===========
==================================================
CROM : jall_fg : 1 : FLAG : text o/p for all reference j-values (0/1 = off/on) 
...................
DYNF : dyn_fg : 1 : FLAG : dynamic representation of gas-> aerosol transfer?
   0 = off (equilibrium only: DEPRECATED)
   1 = on 
...................
IFMT : iofmt_fg : 0 : FLAG : input/output file format (Standard i/o is NetCDF) 
   0 = NetCDF only
   1 = binary only (DEPRECATED)
   2 = NetCDF AND binary (DEPRECATED)
...................
NPAS : total number of timesteps requested : DATA section
...................
NPRT : number of output data time-points requested : DATA section
...................
PSSF : print_steadystate_fg : 1 : FLAG : produce separate output for last time
   0 = no
   1 = yes (OBSOLETE, NOT WORKING)
...................
SCAP : iscape : 0 : FLAG : calculate "thermodynamic equilibrium for inorganic aerosol" ("thermo" inputs are NOT invoked in NetCDF version). Also invokes NH3 emission from surface vegetation (0/1 = off/on)
...................
C0EQ : DATA : thermodynamic equilibrium species initial concs (1 line/species/box), requires SCAP = 1
...................
JO2  : jo2 : DATA: j-value of O2 (s-1): requires OFRM=1
             (now calculated from f185)
...................
JH2O : jho2 : DATA: j-value of H2O (s-1): requires OFRM = 1
             (now calculated from f185)
==================================================
