# General

 file.in.stalayers                   = station.layers
 file.in.refprofile                  = reference.prf
 file.in.spectrum                    = synspec.in
 file.in.modulation_fcn              = ils_poly.mf
 file.in.phase_fcn                   = ils_poly.phs
 file.in.sa_matrix                   = sa.input
 file.in.solarlines                  = /Users/jamesw/FDP/sfit/400/sfit-core/linelist/solar/120621/solar.dat
 file.in.isotope                     = isotope.input
 file.in.linelist                    = ./02965.792000-03004.208000.hbin

 file.out.pbpfile                    = pbpfile
 file.out.statevec                   = statevec
 file.out.k_matrix                   = k.output
 file.out.kb_matrix                  = kb.output
 file.out.sa_matrix                  = sa.complete
 file.out.retprofiles                = rprfs.table
 file.out.aprprofiles                = aprfs.table
 file.out.ab_matrix                  = ab.output
 file.out.summary                    = summary
 file.out.parm_vectors               = parm.output
 file.out.seinv_vector               = seinv.output
 file.out.sainv_matrix               = sainv.complete
 file.out.smeas_matrix               = smeas.target
 file.out.shat_matrix                = shat.complete
 file.out.ssmooth_matrix             = ssmooth.target
 file.out.ak_matrix                  = ak.target
 file.out.solarspectrum              = solar.output

# Definition for retrieval gases

 gas.layers                          = 1
 gas.profile.list                    =

 gas.profile.C2H6.scale               = 1.0D0
 gas.profile.C2H6.correlation         = T
 gas.profile.C2H6.correlation.type    = 2
 gas.profile.C2H6.correlation.width   = 4.0
 gas.profile.C2H6.correlation.minalt  = 0.000
 gas.profile.C2H6.correlation.maxalt  = 120.000
 gas.profile.C2H6.logstate            = F
 gas.profile.C2H6.sigma               =
    0.080178    0.088465    0.098374    0.104765    0.111571    0.118864
    0.126547    0.135113    0.144673    0.155126    0.166667    0.179284
    0.192450    0.206529    0.219971    0.231455    0.240966    0.246598
    0.250000    0.252646    0.256307    0.259161    0.263117    0.267261
    0.270501    0.275010    0.278543    0.283473    0.288675    0.292770
    0.298511    0.303046    0.309196    0.315458    0.320311    0.327307
    0.332718    0.340579    0.349026    0.355634    0.365257    80.
    80.    80.

 gas.profile.O3.scale               = 1.0D0
 gas.profile.O3.correlation         = T
 gas.profile.O3.correlation.type    = 2
 gas.profile.O3.correlation.width   = 4.0
 gas.profile.O3.correlation.minalt  = 0.000
 gas.profile.O3.correlation.maxalt  = 120.000
 gas.profile.O3.logstate            = F
 gas.profile.O3.sigma               =
    0.080178    0.088465    0.098374    0.104765    0.111571    0.118864
    0.126547    0.135113    0.144673    0.155126    0.166667    0.179284
    0.192450    0.206529    0.219971    0.231455    0.240966    0.246598
    0.250000    0.252646    0.256307    0.259161    0.263117    0.267261
    0.270501    0.275010    0.278543    0.283473    0.288675    0.292770
    0.298511    0.303046    0.309196    0.315458    0.320311    0.327307
    0.332718    0.340579    0.349026    0.355634    0.365257    0.372851
    0.383985    0.396249

 gas.profile.CH4.scale               = 1.0D0
 gas.profile.CH4.correlation         = T
 gas.profile.CH4.correlation.type    = 2
 gas.profile.CH4.correlation.width   = 4.0
 gas.profile.CH4.correlation.minalt  = 0.000
 gas.profile.CH4.correlation.maxalt  = 120.000
 gas.profile.CH4.logstate            = F
 gas.profile.CH4.sigma               =
    0.080178    0.088465    0.098374    0.104765    0.111571    0.118864
    0.126547    0.135113    0.144673    0.155126    0.166667    0.179284
    0.192450    0.206529    0.219971    0.231455    0.240966    0.246598
    0.250000    0.252646    0.256307    0.259161    0.263117    0.267261
    0.270501    0.275010    0.278543    0.283473    0.288675    0.292770
    0.298511    0.303046    0.309196    0.315458    0.320311    0.327307
    0.332718    0.340579    0.349026    0.355634    0.365257    0.372851
    0.383985    0.396249

 gas.column.list                            = C2H6 HDO H2O CH4 O3

 gas.column.C2H6.scale                       = 1.0
 gas.column.C2H6.sigma                       = 1.

 gas.column.CH4.scale                       = 1.0
 gas.column.CH4.sigma                       = 0.1

 gas.column.O3.scale                        = 1.0
 gas.column.O3.sigma                        = 0.1

 gas.column.HDO.scale                       = 1.0
 gas.column.HDO.sigma                       = 0.5

 gas.column.H2O.scale                       = 1.0
 gas.column.H2O.sigma                       = 0.5



# Forward model parameters
 fw.raytonly                         = F
 fw.isotope_separation               = T
 fw.delnu                            = 0.1D0
 fw.lshapemodel                      = 0
 fw.linemixing                       = T
 fw.linemixing.gas                   = CO2
 fw.solar_spectrum                   = T
 fw.pressure_shift                   = T
 fw.apod_fcn                         = F
 fw.apod_fcn.type                    = 2
 fw.apod_fcn.order                   = 5
 fw.phase_fcn                        = F
 fw.phase_fcn.type                   = 2
 fw.phase_fcn.order                  = 5
 fw.emission                         = F
# fw.emission.T_infinity = 6000.0
# fw.emission.object = E
# fw.emission.normalized = T


# Retrieval parameter

 rt                                  = T
 rt.lm                               = T
 rt.lm.gamma_start                   = 10000.
 rt.lm.gamma_dec                     = 10.0
 rt.lm.gamma_inc                     = 10.0
 rt.convergence                      = 0.05
 rt.tolerance                        = 0.05
 rt.max_iteration                    = 21
 rt.wshift                           = T
 rt.wshift.type                      = 1
 rt.wshift.apriori                   = 0.000
 rt.wshift.sigma                     = 0.0100
 rt.dwshift                          = T
 rt.slope                            = T
 rt.slope.apriori                    = 0.000
 rt.slope.sigma                      = 0.100
 rt.curvature                        = F
 rt.curvature.apriori                = 0.000
 rt.curvature.sigma                  = 0.100
 rt.phase                            = F
 rt.phase.apriori                    = 0.000
 rt.phase.sigma                      = 0.000
 rt.apod_fcn                         = F
 rt.apod_fcn.apriori                 = 0.000
 rt.apod_fcn.sigma                   = 0.100
 rt.phase_fcn                        = F
 rt.phase_fcn.apriori                = 0.000
 rt.phase_fcn.sigma                  = 0.100
 rt.solshift                         = T
 rt.solshift.apriori                 = 0.00
 rt.solshift.sigma                   = 0.100
 rt.solstrnth                        = F
 rt.solstrnth.apriori                = 0.000
 rt.solstrnth.sa                     = 0.010
 rt.ifcalc_se                        = F
 rt.temperature                      = F
 rt.temperature.sigma                =
    1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0
    1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0
    1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0
    1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0
    1.0 1.0 1.0 1.0 1.0 1.0 1.0



# Microwindows and their parameters

 band                                = 1
 band.1.nu_start                     = 2970.000
 band.1.nu_stop                      = 2980.000
 band.1.zshift                       = T
 band.1.zshift.type                  = 1
 band.1.zshift.apriori               = 0.000
 band.1.zshift.sigma                 = 0.0100
 band.1.calc_point_space             = 0.900E-03
 band.1.wave_factor                  = 1.000
 band.1.max_opd                      = 20.000
 band.1.omega                        = 1.914
 band.1.apodization_code             = 0
 band.1.beam                         =
 band.1.beam.model                   = IP
 band.1.beam.1.apriori               = 0.01161 1.97530 4882.98981 0.00000
 band.1.beam.1.sa                    = 0.01 0.01 0.01 0.000
 band.1.gasb                         = C2H6 CH4 O3 HDO H2O
 band.1.tempretb                     = F

# spectrum parameters

 sp.snr                              = 1
 sp.snr.1.nu_start                   = 2000.0
 sp.snr.1.nu_stop                    = 3000.0
 sp.snr.1.snr                        = 100.0
 sp.snr.2.nu_start                   =
 sp.snr.2.nu_stop                    =
 sp.snr.2.snr                        = 100.0


# Output Files Section

 out.level                           = 1
 out.gas_spectra                     = T
 out.gas_spectra.type                = 1
 out.sa_matrix                       = T
 out.statevec                        = T
 out.k_matrix                        = T
 out.shat_matrix                     = T
 out.retprofiles                     = T
 out.aprprofiles                     = T
 out.ab_matrix                       = F
 out.ak_matrix                       = F
 out.summary                         = T
 out.pbpfile                         = T
 out.channel                         = F
 out.parm_vectors                    = T
 out.seinv_vector                    = T
 out.sainv_matrix                    = F
 out.smeas_matrix                    = F
 out.ssmooth_matrix                  = F
 out.raytrace                        = T
 out.raytrace.type                   = 3
 out.solarspectrum                   = F
 out.levmardet                       = F
 out.xscdetail                       = F

# Kb derivative calculations

 kb                                  = F
 kb.temperature                      = F
 kb.slope                            = T
 kb.curvature                        = T
 kb.solshft                          = T
 kb.solstrnth                        = T
 kb.phase                            = T
 kb.dwshift                          = T
 kb.wshift                           = T
 kb.apod_fcn                         = T
 kb.phase_fcn                        = T
 kb.zshift                           = T
 kb.sza                              = T
 kb.omega                            = T
 kb.max_opd                          = T
 kb.line                             = T
 kb.line.type                        = 1
 kb.line.gas                         = CO2

