pro oex4, site=site, ps=ps, nsm=nsm, ftype=ftype, thicklines=thicklines, big=big, dir=dir, ptop=ptop

; idl script to plot sfit4 output
; originally scripted in matlab now converted to idl
; adapted 18/3/2010 to add in total column amount from retrieval rb

; august 2013
; plots gas files not just pbpfile, vmr including t if its retrieved & k matrix
; reads in sfit 4 output
; still to do error matrix, bnr file

   ;close,/all

	forward_function plotak, plotaegv, plotk, covarplot, plotbnr, readgasf, plotprfs, plotgases, readfiles

   funcs = [ 'readkmat4', 'readsum4', 'readprfs4', 'readsbctl4', 'colorbar', 'readt154', 'readstat4', 'usemol', 'readnxn4', 'readnxn4e', 'readlayr','readpbp4', 'exponent', 'readsctl4' ]
   resolve_routine, funcs, /either, /compile_full_file

	print, ' usage : oex, site="mlo | tab | acf", /ps, /nsm, /thick, ftype= "b" | "l"'

	if( not keyword_set( site )) then begin
		print, '  main : keyword site not set...stop'
      stop
	endif

	if( not keyword_set( thicklines )) then begin
		print, '  main : keyword thicklines  not set.'
		print, '  main : setting default thicklines=0 -> use thin lines.'
		thicklines = 0  		 ;  0 means thin lines, 1 means thick lines
	endif

	if( not keyword_set( ftype )) then begin
		print, '  main : keyword ftype not set.'
		print, '  main : setting default ftype=b -> use big endian for mac.'
		ftype = 'b'
	endif

	if( not keyword_set( nsm )) then begin
		print, '  main : keyword nsm not set.'
		print, '  main : setting default nsm=0 -> plot smoothing error figure.'
		nsm = 0
	endif

	if( not keyword_set( ps )) then begin
		print, '  main : keyword ps not set.'
		print, '  main : setting default ps=0 -> do not create ps output.'
		ps = 0
	endif

	if( not keyword_set( ptop )) then begin
		print, '  main : keyword ptop not set.'
		print, '  main : setting default ptop=120.'
		plottop = 120
	endif else plottop = ptop

	; ppos running position & id of last plot on screen
   ppos = intarr(3)
   psiz = intarr(2)
	if( keyword_set( big )) then begin
      ppos = [ 10, 660, 0 ]		; dual display
      psiz = [ 1200, 640 ]       ; dual display
	endif else begin
      ppos = [ 10, 390, 0 ]		; mbp - retina
      psiz = [ 760, 500 ]			; mbp - retina
   endelse

	encap = 0

   rc = readfiles( site, dir, ctl, smf, pbp, stat, rvmr, avmr, a, stgrd, kmf, ak, t15, bnr, bnrfile, evmr, eprt, eranv, eranp, esysv, esysp )

	usite = strupcase( site )

	; 0 = x, 1 = ps
	for tops = 0 , ps do begin

		thick = 1.0
		if tops then begin ;1
			set_plot, 'ps'
			;!p.font = 0
			psfile = 'oex.ps'
			if( keyword_set( dir ) )then psfile = dir + psfile
			print, 'saving ps file to : ', psfile
			;device, /color, /landscape, /helvetica, filename = psfile, encapsulated = encap, bits=8
			device, /color, /landscape, /helvetica, filename = psfile, encapsulated = encap, bits=8
			; full page ps

	      if thicklines then thick=3.5
			!p.charsize = 1
			!p.charthick = 4.0
			!x.thick = thick
			!y.thick = thick
			stickthick = 8
			charsize = 2.
			lthick = thick
			fillcolor = 170
			tek = 0 ; black

		endif else begin
			set_plot,'x'
			!p.font = -1
			device, decompose = 0 ; allow for terminals with > 256 color

			if thicklines then thick=2.0
			!p.charsize = 1
			!p.charthick = 1
			!p.thick = thick
			!x.thick = thick
			!y.thick = thick
			stickthick = 1
			charsize = 1.5
			lthick = thick
			fillcolor = 0
			tek = 1 ; white

		endelse

      ; plot vmr profiles from statevector

      rc = plotprfs( 0, stat, stgrd, tops, ppos, psiz, tek, lthick, plottop )

      if( evmr.val )then rc = plotprfe( avmr, rvmr, stat.gas[0,0], evmr, tops, ppos, psiz, tek, lthick, plottop )
      if( eprt.val )then rc = plotprte( avmr, rvmr, stat.gas[0,0], eprt, tops, ppos, psiz, tek, lthick, plottop )

      if( eranv.val && eranp.val && esysv.val && esysp.val )then begin
         rc = ploterrd( avmr, rvmr, stat.gas[0,0], evmr, eprt, eranv, eranp, esysv, esysp, tops, ppos, psiz, tek, lthick, plottop )
         rc = ploterrd( avmr, rvmr, stat.gas[0,0], evmr, eprt, eranv, eranp, esysv, esysp, tops, ppos, psiz, tek, lthick, plottop, /prtc )
      endif

      ;goto, skipplots

      for ii=1 , stat.ngas-1 do begin
		   rc = plotprfs( ii, stat, stgrd, tops, ppos, psiz, tek, lthick, plottop )
      endfor

      ; if temperature retrieval plot it
      if( stat.iftm )then rc = plott( stat, stgrd, tops, ppos, psiz, tek, lthick, plottop )

		; 2d countour of k matrix
		if( kmf.nlev ne 0 )then rc = plotk( kmf, stat, smf, tops, ppos, psiz, stickthick, plottop )

		; plot smooth & measurement error, profiles
		;rc = ploterrs( sserr, smerr, stat, kmf, tops, ppos, psiz, a.vmrscl, a.vmrunits, $
		;		tek, lthick, plottop, rms, vmrng )

		; plot averaging kernels
		if( ak.val )then rc = plotak( ak, stat, tops, ppos, psiz, tek, lthick, plottop, usite, auc )

		; plot averaging kernels
		if( ak.val )then rc = plotak( ak, stat, tops, ppos, psiz, tek, lthick, plottop, usite, auc, /nrm )

		; plot bnr file
		if( bnr )then rc = plotbnr( pbp, bnrfile, tops, ppos, psiz, stickthick, plottop, ftype )

      ; print summary file
      rc = prntsum( smf, tops, ppos, psiz )

		; plot spectra
      rc = plotgases( pbp, tops, ppos, psiz, tek, lthick, summary, stat, a.mol, dir )

     skipplots:

		if( tops ) then device, /close_file

	endfor ; tops

	print, ' oex .done.', format='(/,a,/)'

end


; plot error diagonals --------------------------------------------------------------------

function ploterrd, avmr, rvmr, ucmol, evmr, eprt, eranv, eranp, esysv, esysp, tops, ppos, psiz, tek, lthick, plottop, prtc=prtc

	; set up windows
	tek_color
	if tops then begin
		erase
		!p.charsize = 1.
		chrsz = 1.
	endif else begin
		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : error budget',  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.6
		chrsz = 1.5
	endelse

	!p.multi = [ 0, 2, 1 ]

	nlev  = avmr.nlev
	dex = where( avmr.zbar le plottop, nz )
	if( nz eq 0 )then stop, 'plotprf & z & plottop'
   z = avmr.zbar[dex]

   ; pick out the gas from the vmr output tables by the gas name - umol is the first gas in the statevec file
   molid = where( strcmp( ucmol, avmr.name ), nmolid)
   if( nmolid eq 1 )then begin
      if( keyword_set( prtc ))then begin
         rv = rvmr.vmr[dex,molid[0]] * avmr.a[dex]
         toterrmat  = eprt.mat
         ranerrcomp = eranp
         syserrcomp = esysp
         titles = 'Partial Column'
         smid = where( strcmp( 'Smoothing', esysp.name ), nsmid)
         smmat = esysp.mat[smid,*,*]
      endif else begin
         ; get mixing ratios
         rv  = rvmr.vmr[dex,molid[0]]
         toterrmat  = evmr.mat
         ranerrcomp = eranv
         syserrcomp = esysv
         titles = 'Mixing Ratio'
         smid = where( strcmp( 'Smoothing', esysv.name ), nsmid)
         smmat = esysv.mat[smid,*,*]
      endelse
   endif else begin
      print, 'ploterrd : could not find unique gas name for gas: ', ucmol
      for i=0, nmolid-1 do print, avmr.name[i], format='(a8,1x)'
      stop
   endelse

   ; remove the smoothing from the systematic error
   toterrmat[ 1, *, * ] =  toterrmat[ 1, *, * ] - smmat


   ; get total errors random = 0 sys = 1
   toterr = dblarr(2,nz)
   for j=0, 1 do begin
      for i=0, nz-1 do begin
         toterr[j,i] = sqrt( toterrmat[ j, dex[i], dex[i] ] ) / rv[i] * 100.
      endfor
   endfor

   ; get normalized diagonals for error components
   ; random amy have different # of components then systematic!
   nmatran   = ranerrcomp.nmatr
   errorsran = dblarr( nmatran, nz )
   nmatsys   = syserrcomp.nmatr
   errorssys = dblarr( nmatsys, nz )

   for j=0, nmatran-1 do begin
      for i=0, nz-1 do begin
         errorsran[j,i] = sqrt( ranerrcomp.mat[ j, dex[i], dex[i] ] ) / rv[i] * 100.
      endfor
   endfor

   for j=0, nmatsys-1 do begin
      for i=0, nz-1 do begin
         errorssys[j,i] = sqrt( syserrcomp.mat[ j, dex[i], dex[i] ] ) / rv[i] * 100.
      endfor
   endfor

   mx = max( toterr, min=mn )

   print, mn, mx
   mn = 0.
   mx = mx +10.
   scl = 1.
;   while( mx lt 1. )do begin
;      scl = scl * 10.
;      mx  = mx * 10.
;      mn  = mn * 10.
;   endwhile
;   ex = alog10( scl )

   ; vmr , column
   ; 0 = random, 1 = systematic
j=0

      ; plot random errors mixing ratio
      plot, toterr[j,*]*scl, z, /nodata, yrange=[0.0, plottop], xrange=[mn,mx], ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
         xtitle = 'Percent Error : ' + ucmol, title = 'Percent ' + evmr.name[j] + ' Error on the ' + titles, charsize=chrsz

      oplot, toterr[j,*], z, color = 2, thick = lthick
      xyouts, 0.3, 0.15+nmatran*0.03, 'Total', /normal, color = 2, charsize=1.5
      for i=0, nmatran-1 do begin
         oplot, errorsran[i,*], z, color = i+3, thick = lthick
         xyouts, 0.3, 0.15+i*0.03, ranerrcomp.name[i], /normal, color = i+3, charsize=1.5
      endfor

j=1
      ; plot systematic errors mixing ratio
      plot, toterr[j,*]*scl, z, /nodata, yrange=[0.0, plottop], xrange=[mn,mx], ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
         xtitle = 'Percent Error : ' + ucmol, title = 'Percent ' + evmr.name[j] + ' Error on the ' + titles, charsize=chrsz

      oplot, toterr[j,*], z, color = 2, thick = lthick
      xyouts, 0.85, 0.15+nmatsys*0.03, 'Total', /normal, color = 2, charsize=1.5
      for i=0, nmatsys-1 do begin
         if( i eq smid )then continue
         oplot, errorssys[i,*], z, color = i+3, thick = lthick
         xyouts, 0.85, 0.15+i*0.03, syserrcomp.name[i], /normal, color = i+3, charsize=1.5
      endfor

	return, 0

end


; plot partial column profiles --------------------------------------------------------------------

function plotprte, avmr, rvmr, ucmol, eprt, tops, ppos, psiz, tek, lthick, plottop

	; set up windows
	tek_color
	if tops then begin
		erase
		!p.charsize = 1.
		chrsz = 1.2
	endif else begin
		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : apriori and retrieved partial columns with errors',  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.6
		chrsz = 2.5
	endelse

	!p.multi = [ 0, 4, 1 ]

	nlev  = avmr.nlev
	dex = where( avmr.zbar le plottop, nz )
	if( nz eq 0 )then stop, 'plotprf & z & plottop'
   z = avmr.zbar[dex]

   ; pick out the gas from the vmr output tables by the gas name - umol is the first gas in the statevec file
   molid = where( strcmp( ucmol, avmr.name ), nmolid)
   if( nmolid eq 1 )then begin
      ; get mixing ratios
      av  = avmr.vmr[dex,molid[0]] * avmr.a[dex]
      rv  = rvmr.vmr[dex,molid[0]] * avmr.a[dex]
   endif else begin
      print, 'plotprte : could not find unique gas name for gas: ', umol
      for i=0, nmolid-1 do print, avmr.name[i], format='(a8,1x)'
      stop
   endelse

   ; get errors random for now - from matrix 1
   ranerr = dblarr(2,nlev)
   for j=0, 1 do begin
      for i=0, eprt.n-1 do begin
         ranerr[j,i] = sqrt( eprt.mat[j,i,i] )
      endfor
   endfor
   err = ranerr[0:1,dex]

	; calculate ymin and ymax for profiles plot
	omx = max( rv, min=omn )
	cmx = max( av, min=cmn )
	if (omx gt cmx) then mx = omx else mx = cmx
	if (omn lt cmn) then mn = omn else mn = cmn

   scl = 1.
   while( mx gt 1. ) do begin
      scl = scl / 10.
      mx  = mx / 10.
      mn  = mn / 10.
   endwhile
   ex = alog10(scl)

   ; 0 = random, 1 = systematic
      for j=0, 1 do begin

      ; plot vmrs log
      plot, av*scl, z, /xlog, /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
         ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
         xtitle = 'partial column for ' + ucmol + ' *10!u ' + string(ex,format='(i03)'), $
         title = eprt.name[j] + ' partial column', charsize=chrsz, xtickformat = 'exponent'

      oplot, rv*scl, z, color = 2, thick = lthick
      oplot, av*scl, z, color = 3, thick = lthick
      for i=0, nz-1 do begin
         x = [rv[i] - err[j,i], rv[i] + err[j,i] ] * scl
         y = [ z[i], z[i] ]
         oplot, x, y, color=2, thick = lthick
      endfor

      xyouts, 0.5, 0.55, 'retrieved partial column ', /normal, color = 2, charsize=1.5, orientation = 90
      xyouts, 0.5, 0.25, 'a priori partial column ',  /normal, color = 3, charsize=1.5, orientation = 90

      ; plot vmrs linear
      plot, rv*scl, z, /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
         ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
         xtitle = 'partial column  for ' + ucmol + ' *10!u ' + string(ex,format='(i03)'), $
         title  = eprt.name[j] + ' partial column ', charsize=chrsz ;xtickformat = 'exponent'

      oplot, rv*scl,  z, color = 2, thick = lthick
      oplot, av*scl, z, color = 3, thick = lthick

      for i=0, nz-1 do begin
         x = [rv[i] - err[j,i], rv[i] + err[j,i] ] * scl
         y = [ z[i], z[i] ]
         oplot, x, y, color=2, thick = lthick
      endfor

   endfor

	return, 0

end




; plot vmr profiles --------------------------------------------------------------------

function plotprfe, avmr, rvmr, ucmol, evmr, tops, ppos, psiz, tek, lthick, plottop

	; set up windows
	tek_color
	if tops then begin
		erase
		!p.charsize = 1.
		chrsz = 1.2
	endif else begin
		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : apriori and retrieved mixing ratio with errors',  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.6
		chrsz = 2.5
	endelse

	!p.multi = [ 0, 4, 1 ]

	nlev  = avmr.nlev
	dex = where( avmr.zbar le plottop, nz )
	if( nz eq 0 )then stop, 'plotprf & z & plottop'
   z = avmr.zbar[dex]

   ; pick out the gas from the vmr output tables by the gas name - umol is the first gas in the statevec file
   molid = where( strcmp( ucmol, avmr.name ), nmolid)
   if( nmolid eq 1 )then begin
      ; get mixing ratios
      av  = avmr.vmr[dex,molid[0]] ; * avmr.a[dex]
      rv  = rvmr.vmr[dex,molid[0]] ; * avmr.a[dex]
   endif else begin
      print, 'plotprte : could not find unique gas name for gas: ', umol
      for i=0, nmolid-1 do print, avmr.name[i], format='(a8,1x)'
      stop
   endelse

   ; get errors random for now - from matrix 1
   ranerr = dblarr(2,nlev)
   for j=0, 1 do begin
      for i=0, evmr.n-1 do begin
         ranerr[j,i] = sqrt( evmr.mat[j,i,i] )
      endfor
   endfor
   err = ranerr[0:1,dex]

	; calculate ymin and ymax for profiles plot
	omx = max( rv, min=omn )
	cmx = max( av, min=cmn )
	if (omx gt cmx) then mx = omx else mx = cmx
	if (omn lt cmn) then mn = omn else mn = cmn

   scl = 1.
   while( mx lt 1. ) do begin
      scl = scl * 10.
      mx  = mx * 10.
      mn  = mn * 10.
   endwhile
   ex = alog10(scl)

   ; 0 = random, 1 = systematic
   for j=0, 1 do begin

      ; plot vmrs log
      plot, av*scl, z, /xlog, /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
         ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
         xtitle = 'mixing ratio for ' + ucmol + ' *10!u ' + string(ex,format='(i03)'), $
         title = evmr.name[j] + 'mixing ratio', charsize=chrsz, xtickformat = 'exponent'

      oplot, rv*scl, z, color = 2, thick = lthick
      oplot, av*scl, z, color = 3, thick = lthick
      for i=0, nz-1 do begin
         x = [rv[i] - err[j,i], rv[i] + err[j,i] ] * scl
         y = [ z[i], z[i] ]
         oplot, x, y, color=2, thick = lthick
      endfor

      xyouts, 0.5, 0.55, 'retrieved mixing ratio ', /normal, color = 2, charsize=1.5, orientation = 90
      xyouts, 0.5, 0.25, 'a priori mixing ratio ',  /normal, color = 3, charsize=1.5, orientation = 90

      ; plot vmrs linear
      plot, rv*scl, z, /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
         ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
         xtitle = 'mixing ratio for ' + ucmol + ' *10!u ' + string(ex,format='(i03)'), $
         title  = evmr.name[j] + ' mixing ratio ', charsize=chrsz ;xtickformat = 'exponent'

      oplot, rv*scl, z, color = 2, thick = lthick
      oplot, av*scl, z, color = 3, thick = lthick

      for i=0, nz-1 do begin
         x = [rv[i] - err[j,i], rv[i] + err[j,i] ] * scl
         y = [ z[i], z[i] ]
         oplot, x, y, color=2, thick = lthick
      endfor

   endfor

	return, 0

end


; print out retrieval details to a plot window --------------------------------------------------------------------

function prntsum, smf, tops, ppos, psiz

	; set up windows
	tek_color
	if tops then begin
		erase
		!p.charsize = 1.
		chrsz = 0.8
	endif else begin
		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : retrieval summary',  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.2
		chrsz = 0.8
	endelse

   y = 0.99
   x = 0.03
   step = chrsz  * 0.03

   xyouts, x, y, smf.ver, /normal
   xyouts, x+0.4, y, smf.tag, /normal

   y = y - 0.02
   for j=0, smf.nfit-1 do begin
      y = y - step
      xyouts, x, y, 'fit :' + string(j+1,format='(i3,1x)') + smf.shead[j], /normal
   endfor

   y = y - 0.05
   subs = strsplit( smf.hret, /extract, count=cnt )
   thistr = string( subs[0:cnt-1], format='(3a9,2a15)' )
   ;print, thistr
   ;xyouts, x, y, smf.hret, /normal
   xyouts, x, y, thistr, /normal
   ;y = y - 0.02
   for j=0, smf.nret-1 do begin
      y = y - step
      subs = strsplit( smf.sret[j], /extract, count=cnt )
      thistr = string( strcompress(subs[0:cnt-1],/remove_all), format='(3a9,3a15)' )
      ;print, thistr
;      xyouts, x, y, smf.sret[j], /normal
      xyouts, x, y, thistr, /normal
   endfor

   y = y - 0.05
   pos = strpos( smf.hbnd, 'NSCAN' )
   thistr = strmid(smf.hbnd,0,pos+5)
   xyouts, x, y, thistr, /normal
   for j=0, smf.nbnd-1 do begin
      y = y - step
      xyouts, x, y, smf.sbnd[j], /normal
      if( j eq 0 )then begin
         ;y = y - step
         ;xyouts, x, y, '        ' + strmid(smf.hbnd,pos+5, strlen( smf.hbnd )), /normal
      endif
      for k = 0, smf.nscn[j]-1 do begin
         y = y - step
         xyouts, x, y, '      ' + strtrim(smf.sjscn[k], 2 ), /normal
      endfor
   endfor

   y = y - 0.05
   xyouts, x, y, strtrim(smf.hprm,2), /normal
   y = y - step
   xyouts, x, y, strtrim(smf.sprm,2), /normal

return, 0
end


; plot temperature profile  --------------------------------------------------------------------
function plott, stat, stgrd, tops, ppos, psiz, tek, lthick, plottop

	; set up windows
	tek_color
	if tops then begin
		erase
		!p.charsize = 1.6
		chrsz = 1.5
	endif else begin
		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : temperature retrieval',  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.6
		chrsz = 1.5
	endelse

   !p.multi = [ 0,0,0,0,0 ]

	z     = stat.z
	dex   = where(z le plottop, cnt)
	if( cnt eq 0 )then stop, 'plotprf & z & plottop'
	nlev  = stgrd.k

   ; calculate ymin and ymax for transmission plot
   omx = max( stat.t,  min=omn )
   cmx = max( stat.tr, min=cmn )
   mx = cmx
   if( omx gt cmx ) then mx = omx
   mn = cmn
   if( omn lt cmn ) then mn = omn

   plot, stat.t, z[dex], /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
      ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03,     	 $
      xtitle = 'temperature ', $
      title  = 'temperature', charsize=chrsz

   oplot, stat.tr, z[dex], color = 2, thick = lthick
   oplot, stat.t,  z[dex], color = 3, thick = lthick

	return, 0

end




; plot vmr profiles --------------------------------------------------------------------

function plotprfs, ii, stat, stgrd, tops, ppos, psiz, tek, lthick, plottop

	; set up windows
	tek_color
	if tops then begin
		erase
		!p.charsize = 1.
		chrsz = 1.2
	endif else begin
		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : apriori and retrieved vmrs',  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.6
		chrsz = 1.5
	endelse

   q = 2
   if( stat.iftm )then q = q +1
   ;if( evmr.val )then q = q +1
	!p.multi = [ 0, q, 1 ]

	z     = stat.z
	dex   = where(z le plottop, cnt)
	if( cnt eq 0 )then stop, 'plotprf & z & plottop'

   ; get mixing ratios
	avmr  = stat.vmr[0,ii,dex] ;* vmrscl
	vmr   = stat.vmr[1,ii,dex] ;* vmrscl
	nlev  = stgrd.k
   ucmol = stat.gas[0,ii]

   ; get errors random for now
   ;if( evmr.val )then begin
   ;   ranerr = dblarr(nlev)
   ;   for i=0, nlev-1 do begin
   ;      ranerr[i] = sqrt( evmr.nxn[0,i,i] )
   ;   endfor
   ;endif

	; calculate ymin and ymax for profiles plot
	omx = max( vmr,  min=omn )
	cmx = max( avmr, min=cmn )
	if (omx gt cmx) then begin
		mx = omx
	endif else begin
		mx = cmx
	endelse
	if (omn lt cmn) then begin
		mn = omn
	endif else begin
		mn = cmn
	endelse

   scl = 1.
   while( mx lt 1. ) do begin
      scl = scl * 10.
      mx  = mx * 10.
      mn  = mn * 10.
   endwhile
   ex     = alog10(scl)

	; plot vmrs log
	plot, vmr*scl, z[dex], /xlog, /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
		ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
		xtitle = 'mixing ratio for ' + ucmol + ' *10!u ' + string(ex,format='(i02)'), $
		title = 'mixing ratio', charsize=chrsz, xtickformat = 'exponent'

	oplot, vmr*scl,  z[dex], color = 2, thick = lthick
	oplot, avmr*scl, z[dex], color = 3, thick = lthick

	xyouts, 0.5, 0.55, 'retrieved vmr', /normal, color = 2, charsize=1.5, orientation = 90
	xyouts, 0.5, 0.25, 'a priori vmr',  /normal, color = 3, charsize=1.5, orientation = 90

	; plot vmrs linear
	plot, vmr*scl, z[dex], /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
		ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
		xtitle = 'mixing ratio for ' + ucmol + ' *10!u ' + string(ex,format='(i02)'), $
		title  = 'mixing ratio', charsize=chrsz ;xtickformat = 'exponent'

	oplot, vmr*scl,  z[dex], color = 2, thick = lthick
	oplot, avmr*scl, z[dex], color = 3, thick = lthick



;   if( stat.iftm )then begin
;      mn = 0.
;      mx = 0.
;      plot, stat.t, z[dex], /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
;         ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
;         xtitle = 'temperature ', $
;         title = 'temperature', charsize=chrsz ;xtickformat = 'exponent'
;
;      oplot, stat.tr, z[dex], color = 2, thick = lthick
;      oplot, stat.t,  z[dex], color = 3, thick = lthick

;   endif

	return, 0

end


; plot spectra --------------------------------------------------------------------

function plotgases, pbp, tops, ppos, psiz, tek, lthick, summary, stat, mol, dir

   suffix = 'final'

	!p.multi = 2

	dfpos = fltarr(4)
	sppos = fltarr(4)
	ftpos = fltarr(5); changed from 3 rb

	nfit  = pbp[0].nfit
   nband = pbp[0].nband
   ngas = stat.ngas

   if( ngas eq 0 )then smol = '' else $ smol = stat.gas[0,0]

	tek_color
	print, ' # fits to plot : ', nfit, ' in : ', nband, ' bands'
	for kk = 0, nfit-1 do begin

      iband = pbp[kk].idex[0]
      jscan = pbp[kk].idex[1]
      ngasb = pbp[kk].idex[2]

		; set up windows
		if tops then begin

         erase
         !p.charsize = 1.
         chsize = 1.0
         lcsz = 1.0
         right = 0.90
         dsbrk = 0.77
         difmd = 0.86
			dfpos = [0.12, dsbrk+0.01, right, 0.97]	; ps
			sppos = [0.12, 0.20, right, dsbrk ]
			ftpos = [0.00, .02, .04, .06, 0.08]
			hdpos = .90
			if( kk ne 0 ) then erase

		endif else begin

         !p.charsize = 1.0
         chsize = 1.1
         lcsz = 1.4
         right = 0.90
         difmd = 0.86
         dsbrk = 0.77
			dfpos[*] = [0.08, dsbrk+0.01, right, 0.95 ]	; x
			sppos[*] = [0.08, 0.08, right, dsbrk ]
			ftpos[*] = [ .00, .02, 0.04, 0.06, 0.08]
			hdpos    = 0.95
			ppos     = ppos + [ 20, -20, 1 ]

			window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
				title = string( 'plot ', ppos[2], $
				format = '(a,i02)') + ' : spectral fit : ' + string( kk+1, nfit, format='(i02,"/",i02)' ), $
				xpos = ppos[0], ypos = ppos[1]

		endelse

		npt1 = pbp[kk].npt -1

		; set diff range
		difs = 100.* pbp[kk].difspc[0:npt1]
		mx = max( difs, min=mn )
		if( abs(mn) gt abs(mx) ) then mx = mn
		!y.range = [ -abs(mx), abs(mx) ]

		rms = moment( difs )
		if( stat.ngas eq 0 )then gases = '' else $
		   gases = string( transpose( stat.gas[0,0:stat.ngas-1]), /print )

		titl = 'fts retrieval : ' + gases + string( ', %rms=',sqrt(rms[1]),format='(a,f6.3)')

		; plot difference on top from pbpfile
		plot, pbp[kk].wnu[0:npt1], difs, position = dfpos, yticks = 4, title = titl,   $
			/nodata, ytitle='% difference', charsize = chsize, xtickname = replicate(' ',30), xticklen = 0.08, $
			xstyle=1 ;	$
			;xtitle = 'wavenumber [cm!e-1!n]'

		oplot, pbp[kk].wnu[0:npt1], difs, color = 4,	thick = lthick
		xyouts, right+0.01, difmd+0.003, 'obs-calc', /normal, color = 4, charsize=lcsz
		oplot, !x.crange, [0.0,0.0], color = tek, thick = lthick/2

		; calculate ymin and ymax for transmission plot
		omx = max( pbp[kk].obsspc[0:npt1], min=omn )
		cmx = max( pbp[kk].synspc[0:npt1], min=cmn )

		if( omx gt cmx ) then begin
			mx = omx
		endif else begin
			mx = cmx
		endelse

		if( omn lt cmn ) then begin
			mn = omn
		endif else begin
			mn = cmn
		endelse

		; set range and ticks on ordinate
		ymn = 5
		if( mn gt 0.8 ) then mn = 0.8
		if( mn eq 0.8 ) then ymn = 2
		if( mn lt 0.8 and mn ge .4) then mn = 0.4
		if( mn eq 0.4 ) then ymn = 3
		;if( mn lt 0.4 and mn ge .2) then mn = 0.2
		if( mn eq 0.2 ) then ymn = 4
		if( mn lt 0.2 ) then mn = 0.0
		if( mn eq 0.0 ) then ymn = 5
		if( mx gt 1.0 ) then mx = 1.0

      omx      = mx
      yoff     = 0.05*(mx-mn)
      yoff     = 0.02*(ngasb+1)*(mx-mn)
      mx       = mx + (ngasb+1)*yoff +0.005
      print, 'yrange : ', mn, mx, (ngasb+1), yoff
      ;if( mx lt 1. )then mx = 1.
		!y.range = [mn,mx]

		; plot spectra
      tickv = fltarr(5)
      tickv = [ 0.0, 0.25, 0.5, 0.75, 1.0]
		plot, pbp[kk].wnu[0:npt1], pbp[kk].obsspc[0:npt1], position = sppos,						$
			/nodata, ytitle='arbitrary', charsize = chsize, xticklen = 0.06, $
			ystyle = 1, yminor = ymn,		$
			xtitle = 'wavenumber [cm!e-1!n]', xstyle=1 ;, yticks = 4, ytickv=tickv

		if( !y.crange[0] lt 0.0 ) then oplot, !x.crange, [0.0,0.0], color = tek
		if( !y.crange[1] gt 1.0 ) then oplot, !x.crange, [1.0,1.0], color = tek


      ; put solar at top
      gasfile = 'spc.sol.' + string(iband,jscan,format='(i02,".",i02,".")') + suffix
      if( keyword_set( dir ) )then gasfile = dir + gasfile
      if( file_test( gasfile, /regular ))then begin

         rc = readgasf( gasfile, title, w1, w2, spac, npt, ary )

         ; calculate complete wavenumber array for simulated spectra
         nu = fltarr(npt)
         nu(0:npt-1) = findgen(npt) * spac + w1

         clr = ngasb+4
         if(clr ge 7 )then clr++

         print, 'solar offset : ', yoff*(ngasb+1)
         soff = yoff*(ngasb+1)
         if( soff lt 1. )then begin
            soff = 0
            ary = ary * mx
         endif

         oplot, nu, ary + soff, color = clr, thick = lthick, /noclip

         res = convert_coord( 0., omx+yoff*(ngasb+1), /to_normal )
         xyouts, right+0.01, res[1]-0.01, 'solar', /normal, color = clr, charsize=lcsz

      endif

      ; gasfile : gas.h2o.1.1.final  iband, jscan, iteration
      n=0
      for j=0, ngas-1 do begin

         gasfile = 'spc.' + stat.gas[0,j] + '.'+string(iband,jscan,format='(i02,".",i02,".")') + suffix
         if( keyword_set( dir ) )then gasfile = dir + gasfile
         if( file_test( gasfile, /regular ))then begin

            rc = readgasf( gasfile, title, w1, w2, spac, npt, ary )

            ;print, stat.gas[0,j]

            nu = fltarr(npt)
            nu(0:npt-1) = findgen(npt) * spac + w1

            clr = n+4
            if(clr ge 7 )then clr++
            oplot, nu, ary/(max(ary)) + yoff*(n+1), color = clr, thick = lthick, /noclip

            res = convert_coord( 0., omx+yoff*(n+1), /to_normal )
            res[1] = res[1]
            xyouts, right+0.01, res[1]-0.01, stat.gas[0,j], /normal, color = clr, charsize=lcsz
            n++
         endif

      endfor

      ; plot the obs & syn spectra
		oplot, pbp[kk].wnu[0:npt1], pbp[kk].obsspc[0:npt1], color = 3, thick = lthick, /noclip
		oplot, pbp[kk].wnu[0:npt1], pbp[kk].synspc[0:npt1], color = 2, thick = lthick, /noclip

;		xyouts, right+0.01, dsbrk-0.03*ngas-0.05, 'observed',   /normal, color = 3, charsize=lcsz
;		xyouts, right+0.01, dsbrk-0.03*ngas-0.08, 'calculated', /normal, color = 2, charsize=lcsz

		xyouts, !x.crange[1], 1.-(1.-mn)*0.1, 'observed', color = 3, charsize=lcsz
		xyouts, !x.crange[1], 1.-(1.-mn)*0.2, 'calculated', color = 2, charsize=lcsz


	endfor

	return, 0

end

; read in gas files --------------------------------------------------------------------

function readgasf, filename, title, w1, w2, spac, npt, ary

   ; read simul gas file no struct

   ;print, 'gasfile : ', filename

   openr, gflun, filename, /get_lun, error=ioerr
   if (ioerr ne 0) then begin
      printf, -2, filename, !err_string
      return,0
   endif

   title=''
   w1=0.0d
   w2=0.0d
   spac=0.0d
   npt=0l

	readf, gflun, title
	;print, '   ', title
	readf, gflun, w1, w2, spac, npt

	ary = fltarr(npt)
	readf, gflun, ary

free_lun,gflun
return,1
end


; plot bnr --------------------------------------------------------------------------

function plotbnr, pbp, file, tops, ppos, psiz, stickthick, plottop, ftype

	if( tops )then print, '  bnr file &  type : ', file, '  ', ftype

	if( ftype eq 'l' ) then 			$
		openr, sftlun, file, /get_lun ,/f77_unformatted, /swap_endian, error=ioerr	$
	else if( ftype eq 'c' ) then 		$
		openr, sftlun, file, /get_lun, error=ioerr 		$
	else					$
		openr, sftlun, file, /get_lun ,/f77_unformatted, error=ioerr

	if( ioerr ne 0 ) then begin
		printf, -2, !err_string
		return, 1
	endif

	header = string(replicate(32b,80))
	readu, sftlun, header
	header = strtrim( header, 2 )
	if( tops )then begin
      print, '  bnr file header:'
      print, '   ', '"', header, '"'
      print, ''
   endif

	wlo=0d & whi=0d & spa=0d & npp=0l

	readu,sftlun,wlo,whi,spa,npp
	;print, wlo, whi, spa, npp

	arr=fltarr(npp)
	readu, sftlun, arr
	free_lun, sftlun

	xar = float( wlo + spa*findgen(npp) )

	cbpos = fltarr(4)
	ctpos = fltarr(4)

	tek_color
	; set up windows
	if tops then begin

		erase
		ctpos = [0.12, 0.10, 0.93, 0.83]
		xcharsz = 1.0
		ycharsz = 1.0

	endif else begin

		ppos = ppos + [ 20, -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : spectra region' ,  $
			xpos = ppos[0], ypos = ppos[1]
		;!p.charsize = 1.2
		device, decompose = 0  ; allow for terminals with > 256 color
		ctpos = [0.10, 0.15, 0.92, 0.80]
		xcharsz = 1.4
		ycharsz = 1.4
		!p.charsize = 1

	endelse

	minnu = min( pbp[*].nulo )
	maxnu = max( pbp[*].nuhi )

	buffer = 10
	xr = [ minnu -buffer, maxnu +buffer ]

	ix = lindgen(npp)
	yr = [ 0, max(arr(ix))+0.1*max(arr(ix)) ]
	yr = [0,0]

	q1 = min( arr )
	q3 = max( arr )
	qx = where( arr lt 0.0, qc )
	if( qc gt 0 ) then begin
		q2 = mean( arr[qx] )
		xt = string( '!c', q3,' to ', q1, ' # neg : ', qc, ' mean : ', q2, -q1/q3*100, '%', $
			format = '(a, f7.4, a, f8.5, a, i6, a, f8.5, f6.2, a1 )' )
	endif else begin
		xt = string( '!cmax : ', q3,' min : ', q1, $
			format = '(a, f8.5, a, f8.5)' )
	endelse

	plot, xar(ix), arr(ix), linestyle = 0,				$
		xtitle ='wavenumber [cm-1]' + xt, 				$
		ytitle ='transmission',  						$
		yrange = yr, xrange = xr, title =header, 		$
		xtickformat ='(f7.2)', 	ytickformat ='(f5.2)',	$
		xstyle = 1, ystyle = 0, position = ctpos, 		$
		xcharsize = xcharsz, ycharsize = ycharsz

	oplot, !x.crange, [0,0], color = 2, thick = 2. ; red

	for i=0, pbp[0].nfit-1 do begin

		oplot, [ pbp[i].nulo, pbp[i].nulo ], !y.crange, color= i +3, thick = 2.
		oplot, [ pbp[i].nuhi, pbp[i].nuhi ], !y.crange, color= i +3, thick = 2.

	endfor

	return, 0
end


; contour plot sa ------------------------------------------------------------------

function covarplot, mat, prfs, tops, ppos, psiz, stickthick, title, plottop

	!p.multi = [2]

	cbpos = fltarr(4)
	ctpos = fltarr(4)

	; set up windows
	if tops then begin

		cbpos = [0.20, 0.91, 0.80, 0.96]	; ps
		ctpos = [0.20, 0.10, 0.80, 0.81]
		erase

	endif else begin

		cbpos = [0.20, 0.87, 0.90, 0.92]	; x
		ctpos = [0.25, 0.10, 0.85, 0.80]
		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : ' + title,  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.2
		device, decompose = 0  ; allow for terminals with > 256 color
      chsiz = 1
	endelse

	if( tops ) then print, ' covarplot : ', title

	nlev = prfs.nlev
	z    = prfs.zbar
	bnd  = [ prfs.zbnd, 80.0 ]

	div = 0
	while( max( mat ) gt 10. ) do begin
		div = div -1
		mat = mat / 10.
	endwhile

	while( max( mat ) lt 1. ) do begin
      div = div +1
		mat = mat * 10.
	endwhile

	; set up contours
	ndiv = 7
	nclr = 200
	scal = 1.0
	span = max(mat)/scal - min(mat) + 0.0*(max(mat) - min(mat))
	clvs = min(mat) - 0.0*span + indgen( nclr+1 ) * span/(nclr -1)

	;if( not tops ) then print, ' min, max of contour levels              : ', min( clvs ), max( clvs )
	;if( not tops ) then print, ' number of contour divisions in colorbar : ', ndiv
	;if( not tops ) then print, ' number of color levels in contour plot  : ', nclr

	; define contours names for color table ticks
	cbtics = strarr( ndiv + 1 )
	for i = 0, ndiv do begin
		cbtics[i] = string( clvs[i*(nclr/ndiv)], format = '(f7.3)' )
		;print, i, nclr/ndiv, nclr/ndiv*i, clvs[i*(nclr/ndiv)], cbtics[i]
	end

	; tell max and min out of range
	for i=0, nlev-1 do begin
		for j=0, nlev-1 do begin
			if mat[j,i] lt min( clvs ) then print, 'less : ', j, i, mat[j,i]
			if mat[j,i] gt max( clvs ) then print, 'more : ', j, i, mat[j,i]
		end
	end

; contour - set up the plot window
	; colorbar at top

	loadct, 5, ncolors = nclr+40, /silent;, bottom = 10

	cbtitle = title + ' [x10!e' + string( div, format='(i+2)' ) + '!n]'
	colorbar, ncolors = nclr, position = cbpos, charsize = chsiz,		$
		divisions = ndiv, ticknames = cbtics, title = cbtitle, bottom=00

	contour, mat, z, z, position = ctpos, nlevels = nclr,				$
		yrange = [0.0, plottop], xrange = [0.0, plottop],				$
		;c_colors = indgen(nclr)+00,									$
		charsize = chsiz, /fill, yticklen = -0.02, xticklen = -0.02, 		$
		ytitle = 'altitude [km]', xtitle = 'altitude [km]'

	;print,''
	;print, mat[indgen(40),indgen(40)]
	return, 0

end

; contour plot k matrix ------------------------------------------------------------------

function plotk, kmf, stat, smf, tops, ppos, psiz, stickthick, plottop

	nfit = smf.nfit
	nbnd = smf.nbnd
	print, ' plotk : nfits in nbands : ', nfit, nbnd

	cbpos = fltarr(4)
	ctpos = fltarr(4)

	; set up windows
	if tops then begin

		erase
		cbpos = [0.20, 0.92, 0.80, 0.97]	; ps
		ctpos = [0.12, 0.10, 0.93, 0.83]
		ftpos = [ .00, .04, 0.08 ]
      !p.charsize = 1.0
      chsize = 1.2
		xcharsz = 1.2
		ycharsz = 1.2

	endif else begin

		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1],	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : k matrix',	$
			xpos = ppos[0], ypos = ppos[1]
		device, decompose = 0  ; allow for terminals with > 256 color
		cbpos = [0.20, 0.87, 0.90, 0.92]	; x
		ctpos = [0.10, 0.10, 0.95, 0.80]
		ftpos = [0.02, 0.05, 0.08 ]
		!p.charsize = 1.1
      chsize = 1.3
		xcharsz = 1.4
		ycharsz = 1.4

	endelse

	nlev = kmf.nlev
	ismx = kmf.ismx
	npts = kmf.npts
	z = stat.z

	;help, z
	; kmat is npts x npar in sfit 4 & from readkmat4
   ;print, 'k matrix :'
   ;help, kmf.mat
   mat = kmf.mat[ ismx:ismx+nlev-1, 0:npts-1 ]
   ;help, mat
   mat = transpose( mat )
   ;print, 'k matrix target to plot:'
   ;help, mat

	;mat  = reverse( mat[ 0:npts-1, ismx:ismx+nlev-1 ], 2); *1000.0

	title = ' jacobian matrix : ' + string( nlev, npts, format='( i2,"x",i5 )' )
;	mat = kmf.kmat *1000.0

	div = 0
	while( max( mat ) gt 10. ) do begin
		div = div -1
		mat = mat / 10.
	endwhile

	while( max( mat ) lt 1. ) do begin
		div = div +1
		mat = mat * 10.
	endwhile

	; set up contours
	ndiv = 7
	nclr = 240
	scal = 1.0
	span = max(mat)/scal - min(mat) + 0.0*(max(mat) - min(mat))
	clvs = min(mat) - 0.0*span + indgen( nclr +1 ) * span/(nclr -1)

	;if( not tops ) then print, ' min, max of contour levels             : ', min( clvs ), max( clvs )
	;if( not tops ) then print, ' number of contour divisions in colorbar : ', ndiv
	;if( not tops ) then print, ' number of color levels in contour plot  : ', nclr

	; define contours names for color table ticks
	cbtics = strarr( ndiv + 1 )
	for i = 0, ndiv do begin
		cbtics[i] = string( clvs[i*(nclr/ndiv)], format = '(f7.3)' )
		;print, i, nclr/ndiv, nclr/ndiv*i, clvs[i*(nclr/ndiv)], cbtics[i]
	end

	; tell max and min out of range
	for i=0, nlev-1 do begin
		for j=0, nlev-1 do begin
			if mat[j,i] lt min( clvs ) then print, 'less : ', j, i, mat[j,i]
			if mat[j,i] gt max( clvs ) then print, 'more : ', j, i, mat[j,i]
		end
	end

; contour - set up the plot window
	; colorbar at top

	loadct, 5, ncolors = nclr, /silent ;, bottom=20
	cbtitle = title + ' [x10!e' + string( div, format='(i+2)' ) + '!n]'
	colorbar, ncolors = nclr-40, position = cbpos, charsize=chsize,	$
		divisions = ndiv, ticknames = cbtics, title = cbtitle

	offset = 0
	pointoff = 0
	pwidth = ctpos[2] - ctpos[0]
	thispos = fltarr(4)
	thistic = fltarr(8)

	;tick step size for major ticks. ie 1 = every wavenumber
	tick_interval = 1
	minor = 10

	for kk = 0, nbnd-1 do begin

	   jscan = smf.nscn(kk)

      for j = 0, jscan-1 do begin

         print , ' plotting band : ', kk, ' scan : ', j
         thispos = ctpos
         ;print, kk, smf.npts[kk], smf.wstr[kk], smf.wstp[kk], smf.nspac[kk]
         pratio = float( smf.npts[kk] ) / float( npts	)
         ;pratio = float( pbp[kk].npt ) / float( npts	)

         pw = pratio * pwidth

         thispos[0] = ctpos[0] + offset
         thispos[2] = ctpos[0] + offset + pw
         offset = offset + pw

         if( kk eq 0 ) then begin
            thispos[2] = thispos[2] - 0.01
         endif else if( kk eq nfit -1 ) then begin
            thispos[0] = thispos[0] + 0.01
         endif else begin
            thispos[2] = thispos[2] - 0.0005
            thispos[0] = thispos[0] + 0.0005
         endelse

         ;npt      = pbp[kk].npt
         ;x        = pbp[kk].wnu[0:npt-1]
         npt       = smf.npts[kk]
         x         = smf.wstr[kk] + indgen(npt)*smf.nspac[kk]
         thismat   = mat[ pointoff:pointoff+npt-1, * ]
         pointoff  = pointoff + npt

         ;nulo = pbp[kk].nulo
         ;nuhi = pbp[kk].nuhi
         nulo = smf.wstr[kk]
         nuhi = smf.wstp[kk]
         ;if( not tops ) then print, ' wv # range : ', kk, nulo, nuhi, pw

         leftmost_tick = floor(nulo / tick_interval)*tick_interval + tick_interval
         rightmost_tick = floor(nuhi / tick_interval)*tick_interval

         num_ticks = (rightmost_tick - leftmost_tick) / tick_interval + 1
         if (not tops) then begin
            ;print, 'number of major ticks: ',num_ticks
            if (num_ticks eq 1) then begin
               print, 'warning: only 1 major tick for interval, no minor tick marks will show'
            endif
            if (num_ticks eq 0) then begin
               print, 'warning: no major ticks for interval, no major or minor tick marks will show'
            endif
         endif

         ;set character size along y-axis to have characters only for left-most plot
         ys = 0
         if( kk eq 0 ) then begin
         ys = ycharsz
         endif else begin
         ys = 0.0001;small enough to suppress characters showing up
         ;if set to 0, idl scales to a small, but visible size
         endelse

         contour, thismat, x, z, position = thispos, nlevels = nclr-40,$
            yrange = [0.0, plottop], /fill, /noerase, $
            charsize = charsz, yticklen = -0.02, xticklen = -0.02,$
            ytitle = 'altitude [km]', xtitle = '', xcharsize = xcharsz,$
            ycharsize = ys,$
            xrange = [nulo,nuhi],$
            xstyle = 1,$
            xtickinterval = tick_interval,$
            xminor = minor


         endfor

	endfor

	xtitl = 'wavenumber [cm!e-1!n]'
	xyouts, 0.5, ftpos[0], xtitl, /normal, charsize=1.2, alignment = 0.5

	return, 0

end




; plot averaging kernels --------------------------------------------------------------------

function plotak, ak, stat, tops, ppos, psiz, tek, lthick, plottop, site, auc, nrm=nrm

	!p.multi = [ 0, 2, 1 ]

	yrng = [0.,plottop]
   nlev = stat.nlev
   v    = stat.vmr[0,0,*]  ; top to bottom
   z    = stat.z

   mat = dblarr(nlev,nlev)
   mat = ak.mat
   ;print, 'Before mat[1,*] = ',mat[1,*]

   ;mat = transpose(ak.mat)
   ;print, v[0], mat[0,0:2]

   xtitl = 'fractional value'
   ; scale apriori relative kernel for vmrs
   if( keyword_set( nrm ) )then begin
      xtitl = 'vmr normalized value'
      for i=0, nlev-1 do begin
        ;Because the rows are stored in second index we mulitple by v[j]/v[i] rather than v[i]/v[j]
         for j=0, nlev-1 do mat[i,j] = mat[i,j] * v[j] / v[i]
      endfor
   endif
   ;print, 'After mat[1,*] = ',mat[1,*]

	; set up windows
	if tops then begin
		erase
		!p.charsize = 1.2
	endif else begin
		ppos = ppos + [ 20, -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : averging kernels',  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.2
	endelse

	omx = max( mat, min=omn )
	cmx = max( mat, min=cmn )
	if (omx gt cmx) then begin
		mx = omx
	endif else begin
		mx = cmx
	endelse
	if (omn lt cmn) then begin
		mn = omn
	endif else begin
		mn = cmn
	endelse

	tek_color
	; plot all averaging kernels on left
	plot, mat[*,0], z, /nodata, $
	   yrange = yrng,	$
		ytitle = 'altitude [km]', $
		yticklen = 0.06, $
		xticklen = 0.03,		$
		title = 'all averging kernels', $
		xtitle = xtitl,	$
		xticks=4, $
		xrange=[mn,mx]

   xr = !x.crange
   yr = !y.crange

	cc = 1
	for i = 0, nlev-1, 2 do begin
		cc = cc + 1 mod 32
		; 0,1 are black and white, resp, which we want to skip
		if( cc eq 0 )then cc = 2
		; switching kernels to rows - second index
		;oplot, mat[i,*], z, color = cc, thick = lthick
		; with ak mat not transposed use first index as rox from ak file
		oplot, mat[*,i], z, color = cc, thick = lthick
	   xyouts, xr[0], z[i], string(z[i],format='(i2)'), color=cc, noclip=0
	endfor

	; sum several kernels
	; from ground - irwg
	if( site ne 'acf' ) then begin
		bnds  = [ [0, 8], [8, 17], [17, 26], [26, 40], [0, 120], [0,5], [0,8], [0,11] ]
		bname = [ ' 0- 8km', ' 8-17km', '17-26km', '26-40km', ' 0-120km', 'prior cont', ' 0-5km', ' 0-8km',' 0-11km' ]
		nband = 8
	endif else begin
	; aircraft
		print, '!!!! plotting aircraft summed kernels!!!!'
		bnds  = [ [10, 13], [13, 18], [18, 26], [26, 40], [10, 80] ]
		bname = [ '10-13km', '13-18km', '18-26km', '26-40km', '10-80km', 'prior cont' ]
		nband = 5
	endelse
	bpos  = [ [0.84, 0.90], [0.84, 0.86], [0.84, 0.82], [0.84, 0.78], [0.84, 0.74], [0.84, 0.70]];, [0.84, 0.66]];!added [0.84, 0.66] rb 4/8/10

	; plot summed averaging kernels on right
	plot, total( mat, 1 ), z, /nodata, yrange=yrng, xrange = [-0.5, 1.5], $
		ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, $
		title = 'summed partial kernels', xtitle = xtitl

	smaks = dblarr( nlev, nband )

   for i = 0, nband-1 do begin
      ids        = where(( z ge bnds[0,i] ) and ( z le bnds[1,i] ), cnt )
      q          = dblarr(nlev)
      q[ids]     = 1.
      smak       = q#mat
      smaks[*,i] = smak

		if( i gt 4 )then continue

		oplot, smaks[ *, i ], z, color = i+2, thick = lthick
		xyouts, bpos[0,i], bpos[1,i], bname[i], /normal, color = i+2, charsize=1.

	endfor

	oplot, [0.0,0.0], [0.0,80.0], color = tek

	; compute 'area under curve for ak's as apriori contribution
	auc = dblarr( nlev )

   for i=0, nlev-1 do auc[i] = total( mat[*,i], /double )

	cc = 12	; purple
	xyouts, bpos[0,5], bpos[1,5], bname[5], /normal, color = cc, charsize=1.

   oplot, 1.-auc, z, color=cc, thick=lthick, linestyle=1

	; printout summed kernels
;	if( tops )then begin
;		openw, lun, 'partkrnl.dat', /get_lun
;		printf, lun, 'alt[km]', bname, format='(10a13)'
;		for i=0, nlev-1 do printf, lun, z[i], smaks[i, 0:4], 1.-auc[i],smaks[i, 5:7], format='(f8.2, 10f14.6)'
;		free_lun, lun
;		pre_k = smak[0]
;		for i=1, cnt-1 do begin
;			if( pre_k ge 0.5 and i eq 1 ) then print, 'min alt tcak gt 0.5 : ', z[ids[0]]
;			if( pre_k lt 0.5 and smak[ids[i]] ge 0.5 ) then print, 'min alt tcak gt 0.5 : ', z[ids[i-1]]
;			if( pre_k ge 0.5 and smak[ids[i]] lt 0.5 ) then print, 'max alt tcak gt 0.5 : ', z[ids[i-1]]
;			pre_k = smak[ids[i]]
;		endfor
;	endif

	return, 0
end


; plot smooth & measurement error, profiles --------------------------------------------------------------------
function ploterrs, sserr, smerr, stat, kmf, tops, ppos, psiz, vmrscl, vmrunits, $
				tek, lthick, plottop, rms, vmrng

	!p.multi = [ 0, 3, 1 ]

	nlev  = smerr.n
	z     = stat.z
	sqrsm = dblarr( nlev )
	sqrss = sqrsm

	diag = indgen( nlev )

	layr = dblarr(nlev)
	for i=0, nlev-2 do layr[i] = ( z[i+1] - z[i] ) ;*1.0e5
	layr[nlev-1] = ( 80. - z[nlev-1] )

	sqrsm = sqrt( smerr.mat[ diag, diag ] )
	sqrss = sqrt( sserr.mat[ diag, diag ] )

	npar = kmf.npar
	npts = kmf.npts
	nlev = kmf.nlev
	ismx = kmf.ismx

	sa   = reverse( reverse( kmf.sa[ ismx:ismx+nlev-1, ismx:ismx+nlev-1 ], 1), 2)
	shat = reverse( reverse( kmf.shat[ ismx:ismx+nlev-1, ismx:ismx+nlev-1 ], 1), 2)

	sqrsa = sqrt( sa[ diag, diag ] )
	sqrsh = sqrt( shat[ diag, diag ] )
	;print, sqrsa


	; set up windows
	if tops then begin

		erase
		!p.charsize = 1.
	endif else begin

		ppos = ppos +  [ 20,  -20, 1 ]
		window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1], 	$
			title= string( 'plot ', ppos[2], format='(a,i02)') + ' : error diagonals & vmrs',  $
			xpos = ppos[0], ypos = ppos[1]
		!p.charsize = 1.6

	endelse

	dex = where( z le plottop )
	mx = max( [ sqrsm[dex], sqrss[dex], sqrsa[dex]*layr, sqrsh[dex]], min=mn )
	;print, mx, mn

	if( tops ) then begin
		print, '  i   alt     sm        ss       sa       shat'
		for i=0, nlev-1 do print, i, z[i], sqrsm[i], sqrss[i], sqrsa[i], sqrsh[i], $
								format='(i4, f6.2, 4f9.5)'
	endif

	rms = sqrt( total( sqrsm*sqrsm )/nlev)
	print, ' rms measurement error : ', rms*100, format='(a, f7.2, "%" )'

	; plot uncertainty diagonals
	plot, sqrsm, z, /nodata, yrange=[0.0, plottop], $
		ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, $
		title = 'uncertainty diagonals', xtitle = 'fractional value', $
		xrange = [ mn, mx ], xtickformat = 'exponent', xstyle=0,charsize=1.5 ;/xlog

	oplot, sqrsm, z, color = 2, thick = lthick
	oplot, sqrss, z, color = 3, thick = lthick
	oplot, sqrsa*layr, z, color = 4, thick = lthick
	oplot, sqrsh, z, color = 5, thick = lthick

	xyouts, 0.34, 0.50, 'measure', /normal, color = 2, charsize=1.5, $
		orientation = 90
	xyouts, 0.34, 0.30, 'smooth', /normal, color = 3, charsize=1.5, $
		orientation = 90
	xyouts, 0.34, 0.10, 'a-priori', /normal, color = 4, charsize=1.5, $
		orientation = 90
	xyouts, 0.34, 0.70, 'total', /normal, color = 5, charsize=1.5, $
		orientation = 90

	; calculate ymin and ymax for profiles plot

	dex = where(z le plottop, cnt)
	if( cnt eq 0 )then stop, 'plotprf & z & plottop'
	avmr = stat.vmr[0,0,dex] * vmrscl
	vmr = stat.vmr[1,0,dex] * vmrscl

	omx = max( vmr, min=omn )
	cmx = max( avmr, min=cmn )
	if (omx gt cmx) then begin
		mx = omx
	endif else begin
		mx = cmx
	endelse
	if (omn lt cmn) then begin
		mn = omn
	endif else begin
		mn = cmn
	endelse

	; plot vmrs log
	plot, vmr, z[dex], /xlog, /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
		ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
		xtitle = 'mixing ratio for ' + stat.gas[0] + ' ' + vmrunits, $
		title = 'mixing ratio', xtickformat = 'exponent',charsize=1.5

	oplot, vmr, z[dex], color = 2, thick = lthick
	oplot, avmr, z[dex], color = 3, thick = lthick

	xyouts, 0.67, 0.55, 'retrieved vmr', /normal, color = 2, charsize=1.5, $
		orientation = 90
	xyouts, 0.67, 0.25, 'a priori vmr', /normal, color = 3, charsize=1.5, $
		orientation = 90

	; plot vmrs linear
	plot, vmr, z[dex], /nodata, yrange=[0.0, plottop], xrange=[mn,mx], $
		ytitle = 'altitude [km]', yticklen = 0.06, xticklen = 0.03, 	$
		xtitle = 'mixing ratio for ' + stat.gas[0] + ' ' + vmrunits, $
		title = 'mixing ratio' ;, xtickformat = 'exponent'

	oplot, vmr, z[dex], color = 2, thick = lthick
	oplot, avmr, z[dex], color = 3, thick = lthick

	;xyouts, 0.67, 0.55, 'retrieved vmr', /normal, color = 2, charsize=1.7, $
	;	orientation = 90
	;xyouts, 0.67, 0.25, 'a priori vmr', /normal, color = 3, charsize=1.7, $
	;	orientation = 90

	return, 0



end



function readfiles, site, dir, ctl, smf, pbp, stat, rvmr, avmr, a, stgrd, kmf, ak, t15, bnr, bnrfile, evmr, eprt, eranv, eranp, esysv, esysp

; read in sfit4.ctl file
	rc = 0
	ctlfile = 'sfit4.ctl'
	if( keyword_set( dir ) )then ctlfile=dir + ctlfile
	rc = readsctl4( ctl, ctlfile )
	if( rc ne 0 ) then begin
		printf, -2,'could not read sfit4.ctl file: ', ctlfile
		stop
	endif

; read summary file
   rc = 0
   smmfile = ctl.summary
	if( keyword_set( dir ) )then smmfile = dir + smmfile
   rc = readsum4( smf, smmfile )
   if( rc ne 0 ) then begin
      printf, -2,'could not read summary file: ', smmfile
      stop
   endif

; read in pbpfile - local to sfit4.cfl
	rc = 0
	pbpfile = ctl.pbpfile
	if( keyword_set( dir ) )then pbpfile = dir + pbpfile
	rc = readpbp4( pbp, pbpfile )
	if( rc ne 0 ) then begin
		printf, -2,'could not read pbp file: ', pbpfile
		stop
	endif

; read in statevector file - local to sfit4.ctl
	rc = 0
	stfile = ctl.statevec
	if( keyword_set( dir ) )then stfile = dir + stfile
	rc = readstat4( stat, stfile )
	if( rc ne 0 ) then begin
		printf, -2,'could not read st file: ', stfile
		stop
	endif

; read in retrieved profiles file - local to sfit4.ctl
	rc = 0
	rvfile = ctl.retprofiles
	if( keyword_set( dir ) )then rvfile = dir + rvfile
	rc = readprfs4( rvmr, rvfile )
	if( rc ne 0 ) then begin
		printf, -2,'could not read retrieved profile file: ', rvfile
		stop
	endif

; read in apriori profiles file - local to sfit4.ctl
	rc = 0
	avfile = ctl.aprprofiles
	if( keyword_set( dir ) )then avfile = dir + avfile
	rc = readprfs4( avmr, avfile )
	if( rc ne 0 ) then begin
		printf, -2,'could not read apriori profile file: ', avfile
		stop
	endif

; get site and gas info
   ;if( stat.ngas gt 0 )then print, stat.ngas, transpose(stat.gas[0,0:stat.ngas-1])
	ucmol = strupcase( stat.gas[0,0] )
	usite = strupcase( site )
   usemol, usite, ucmol, a

; get grid data
   nlev =  readlayr( stgrd, ctl.stalayers)
   if( nlev eq 1 )then nlev =  readlayr( stgrd, '~/ndsc/tab/current/waccm.layers/station.layers' )
   if( nlev eq 1 )then stop, 'no station.layers file'

; read in k matrix file
	rc = 0
	kfile = ctl.k_matrix
	if( keyword_set( dir ) )then kfile = dir + ctl.k_matrix
	rc = readkmat4( kmf, kfile )
	if( rc ne 0 ) then begin
		printf, -2,'could not read k file: ', kfile
		stop
	endif

; read in averaging kernels file
	rc = 0
   akfile = ctl.ak_matrix
	if( keyword_set( dir ) )then akfile = dir + ctl.ak_matrix
	if( ~file_test( akfile ))then begin
      ak  = { val : 0 }
	endif else begin
   	rc = readnxn4( ak, akfile )
      if( rc ne 0 ) then begin
         printf, -2,'could not read ak file: ', akfile
      endif
   endelse


; read in t15asc file
	rc = 0
   t15file = ctl.spectrum
	if( keyword_set( dir ) )then t15file = dir + ctl.spectrum
	rc = readt154( t15, t15file )
	if( rc ne 0 ) then begin
		printf, -2,'could not read ak file: ', t15file
		stop
	endif

; read in bnr file
   bnr = 1
	bnrfile = strtrim(string(t15.tstmp[0]),2) + '.bnr'
	if( keyword_set( dir ) )then bnrfile = dir + bnrfile
	if( ~file_test( bnrfile ))then begin
	  bnrfile = 'temp.bnr.00'
  	  if( keyword_set( dir ) )then bnrfile = dir + bnrfile
     if( ~file_test( bnrfile ))then begin
	     bnrfile = 'temp.bnr'
  	     if( keyword_set( dir ) )then bnrfile = dir + bnrfile
        if( ~file_test( bnrfile ))then bnr = 0
     endif
  endif


; see if there is an sb control file

; read in sb.ctl file
	rc = 0
	sbctlfile = 'sb.ctl'
	if( keyword_set( dir ) )then sbctlfile = dir + sbctlfile
	rc = readsbctl4( sbctl, sbctlfile )
	if( rc ne 0 ) then begin
		printf, -2,'could not read sb.ctl file: ', sbctlfile
		evmr  = { val : 0 }
		eprt  = { val : 0 }
		eranv = { val : 0 }
		eranp = { val : 0 }
		esysv = { val : 0 }
		esysp = { val : 0 }
		return, 0
	endif


; read in total uncertainty matricies vmr
	rc = 0
	rufile = sbctl.terrvmr
   if( keyword_set( dir ) )then rufile = dir + rufile
   if( ~file_test( rufile ))then begin
      evmr = {	val : 0 }
   endif else begin
      rc = readnxn4e( evmr, rufile )
      if( rc ne 0 ) then begin
         printf, -2,'could not read total random vmr error file: ', rufile
         stop
      endif
   endelse


; read in total uncertainty matricies partial column
	rc = 0
	rufile = sbctl.terrprt
   if( keyword_set( dir ) )then rufile = dir + rufile
   if( ~file_test( rufile ))then begin
      eprt = {	val : 0 }
   endif else begin
      rc = readnxn4e( eprt, rufile )
      if( rc ne 0 ) then begin
         printf, -2,'could not read total random partial column error file: ', rufile
         stop
      endif
   endelse

; read in random components uncertainty matricies vmr
	rc = 0
	rufile = sbctl.ranvmr
   if( keyword_set( dir ) )then rufile = dir + rufile
   if( ~file_test( rufile ))then begin
      eranv = { val : 0 }
   endif else begin
      rc = readnxn4e( eranv, rufile )
      if( rc ne 0 ) then begin
         printf, -2,'could not read random component vmr error file: ', rufile
         stop
      endif
   endelse


; read in random components uncertainty matricies partial column
	rc = 0
	rufile = sbctl.ranprt
   if( keyword_set( dir ) )then rufile = dir + rufile
   if( ~file_test( rufile ))then begin
      eranp = { val : 0 }
   endif else begin
      rc = readnxn4e( eranp, rufile )
      if( rc ne 0 ) then begin
         printf, -2,'could not read random component partial column error file: ', rufile
         stop
      endif
   endelse

; read in components uncertainty matricies systematic vmr
	rc = 0
	rufile = sbctl.sysvmr
   if( keyword_set( dir ) )then rufile = dir + rufile
   if( ~file_test( rufile ))then begin
      esysv = { val : 0 }
   endif else begin
      rc = readnxn4e( esysv, rufile )
      if( rc ne 0 ) then begin
         printf, -2,'could not read systematic component vmr error file: ', rufile
         stop
      endif
   endelse


; read in components uncertainty matricies systematic partial column
	rc = 0
	rufile = sbctl.sysprt
   if( keyword_set( dir ) )then rufile = dir + rufile
   if( ~file_test( rufile ))then begin
      esysp = { val : 0 }
   endif else begin
      rc = readnxn4e( esysp, rufile )
      if( rc ne 0 ) then begin
         printf, -2,'could not read systematic component partial column error file: ', rufile
         stop
      endif
   endelse



   return, rc

end



; read in smoothing error file
;	rc = 0
;	rc = readnxn( sserr, ssfile )
;
;	if( rc ne 0 ) then begin
;		printf, -2,'could not read ss file: ', ssfile
;		stop
;	endif

; read in measurement error file
;	rc = 0
;	rc = readnxn( smerr, smfile )
;
;	if( rc ne 0 ) then begin
;		printf, -2,'could not read sm file: ', smfile
;		stop
;	endif



	;stop
		;	color table 5				tek_color
		; color on screen,   on ps 		on screen		on ps
		;  	0		black 				0				1
		;	50		blue				4				4
		;  	80		purple				6				6
		;  	100		red					2				2
		;  	150 	yellow
		;	200		orange
		;	230		pale yellow
		;	180		yellow green
		;  	255		white				1				0
		;			green				3				3
		;  			teal				5				5


