function mkdavg, data, davg, nobsday, mavg, nobmnth, pcrng, yys, mol

;rc = mkdavg( data, nlat, davg, nobsday, mavg, nobmnth, as.pcaltrng[*,0], [y1,y2], mol, pvmask)

; add into structure mean trop vmrs
; use 0-8km for tab for now

; input:
; data 		-  struct from sav file
; mol			- molecule name
; pvmask		- scren for high pv datys
; pcrng     - 2 element vector start & stop alt range for mean vmr and summed partial column
; yys    	- 2 element vector start & stop year
; maxline	- maximum declared array of lines and linepc

; average all columns in a day

; output
; davg 		- da struct of daily averages
; nobsday	- # of days with averge values, standard deviation...
; mavg		- da struct of monthly average
; nobmnth	- # of days with averge values, standard deviation...


; calculate julian date for all data
   hh      = fix( data.hrs )
   mns     = ( data.hrs - hh ) * 60.
   mm      = fix( mns )
   ss      = fix(( mns - mm ) * 60.)
   jday    = julday( data.month, data.day, data.year, hh, mm, ss )

   i     = 0l
   ndays = 0
   for i = julday( 1, 1, yys[0], 12, 0, 0 ), julday( 1, 1, yys[1], 12, 0, 0 ) do begin
      dex = where(((jday gt float(i)-0.5) and (jday le float(i)+0.5)), count )
      if( count ge 1 )then ndays++
   endfor

   print, 'found unique number of obs days : ', ndays

   d = { da,         $
         dat : 0l,   $				; date yyyymmdd
         avg : 0.0d, $				; daily or monthly average of (partial) column
         								; weighted by column error
         std : 0.0d, $				; standard deviation
         mvg : 0.0d, $				; daily or monthly average of (partial) vmr
         mvd : 0.0d, $				; standard deviation
         vmr : dblarr(255), $		; components making up vmr average
         nob : 0,    $				; number of obs per day or month
         doy : 0,    $				; mid-point day of year of obs in average
         tyr : 0.D0, $           ; yyyy.fffffff
         jld : 0l,   $				; julian day of midpoint
         n   : 0l }					; # of days (months) of observations saved in davg[0]

   davg = replicate( {da}, ndays )
   mavg = replicate( {da}, (yys[1]-yys[0]+1)*12 )
   help, mavg

   ; mean vmr per measurement
   ; elements in xd correspond to lines and linpc
   nlat = n_elements( data )
   alt  = data[0].altitude
   mvmr = dblarr( nlat, 4 )

   if( n_elements( yys ) eq 0 ) then yys = [ min( data.year ), max( data.year ) ]
   if( n_elements( pcrng ) eq 0 ) then pcrng = [0.,7.]


   trop = 1
   idx = where( alt ge pcrng[0] and alt le pcrng[1], cnt )
   if( cnt gt 2 ) then begin
   for i=0, nlat-1 do begin
      mvmr[i,0] = total( data[i].ms[idx] )                                       ; sum total airmass
      mvmr[i,2] = total( data[i].retvmr[idx] * data[i].ms[idx]  ) / mvmr[i,0]    ; wet air
      mvmr[i,1] = total( (1. - data[i].h2o_vmr[idx] ) * data[i].ms[idx] )        ; sum airmass
      mvmr[i,3] = total( data[i].retvmr[idx] * data[i].ms[idx]  ) / mvmr[i,1]    ; dry air
      ;print, i+1, data[i].tyr, '  ', data[i].yyyymmdd, '  ', data[i].hhmmss, xh[i], xd[i], data[i].rettc, data[i].sza, data[i].dofs, data[i].rms
   endfor
   endif else begin
      print,'  mkdavg: no vmr values in range :', pcrng
      for i=0, nlat -1 do mvmr[i,*] = 0.0d0
      trop = 0
   endelse

;  loop over all days in year range yys
   nobsday = 0
   i       = 0l
   for i = julday( 1, 1, yys[0], 12, 0, 0 ), julday( 1, 1, yys[1], 12, 0, 0 ) do begin

      dex = where(((jday gt float(i)-0.5) and (jday le float(i)+0.5)), count )

      if( count ne 0 ) then begin
         ;print, count, lines[dex[0]].datd

			; save the day
         davg[nobsday].jld = i
         davg[nobsday].nob = count
         davg[nobsday].doy = data[dex[0]].doy
         thisyear = data[dex[0]].year
         n = julday( 12, 31, thisyear ) - julday( 1, 1, thisyear ) + 1
         davg[nobsday].tyr = thisyear + float(data[dex[0]].doy/n)
         ;print, thisyear, data[dex[0]].doy, n, davg[nobsday].tyr

         m = moment( data[dex].rettc, /double )
         davg[nobsday].avg = m[0]
         davg[nobsday].std = sqrt( m[1] )
         davg[nobsday].dat = data[dex[0]].yyyymmdd

         ; daily average column
         ;var = lines[dex].col*lines[dex].cer/100.0 * lines[dex].col*lines[dex].cer/100.0;
         ; weighted average
         ;davg[nobsday].avg = total( lines[dex].col / var ) / total( 1.0 / var )
         ; weighted stdev
         ;davg[nobsday].std = sqrt( 1.0 / total( 1.0 / var ))
         ; print, nobsday, davg[nobsday].dat


         ; daily average mean vmr
         if( count eq 1 ) then begin
            ;print, xd[dex[0]]
            davg[nobsday].mvg    = mvmr[dex[0],2]
            davg[nobsday].mvd    = mvmr[dex[0],2] * 0.05
            davg[nobsday].vmr[0] = mvmr[dex[0],2]
         endif else begin
            if( trop )then begin
               ;print, xd[dex]
               m = moment( mvmr[dex,2], /double )
               davg[nobsday].mvg            = m[0]
               davg[nobsday].mvd            = sqrt( m[1] )
               davg[nobsday].vmr[0:count-1] = mvmr[dex,2]
            endif
         endelse

         nobsday = nobsday +1

      endif

   endfor

   print, '  mkdavg : number of obs days :', nobsday
   davg[0].n = nobsday

; print out the daily averages in a list
   openw,  lun1, mol+'-davg_col.txt', /get_lun
   printf, lun1, nobsday
   printf, lun1, '   i  julian     date      doy  n    daily_avg     std_dev  %std_dev'

   if( trop )then begin
      openw,  lun2, mol+'-davg_tropvmr.txt', /get_lun
      printf, lun2, nobsday
      printf, lun2, '   i  julian     date      doy  n    daily_avg     std_dev  %std_dev  mean_trop_vmrs...'
   endif

   ls = 26.87773d24 / 1.0d9

   for i=0, nobsday-1 do begin

      n = davg[i].nob

      if( strupcase(mol) eq 'o3' )then begin
			printf, lun1, i, davg[i].jld, davg[i].dat, davg[i].doy, n, davg[i].avg, davg[i].std, $
					  davg[i].std/davg[i].avg*100., davg[i].avg/ls, $
					  format='(i4, f10.1, i10, i5, i4, 2e13.4, f7.2, f8.2)'
      endif else begin
			printf, lun1, i, davg[i].jld, davg[i].dat, davg[i].doy, n, davg[i].avg, davg[i].std, $
					  davg[i].std/davg[i].avg*100., $
					  format='(i4, f10.1, i10, i5, i4, 2e13.4, f7.2)'
      endelse

      if( trop )then begin
         printf, lun2, i, davg[i].jld, davg[i].dat, davg[i].doy, n, davg[i].mvg, davg[i].mvd, $
                 davg[i].mvd/davg[i].mvg*100.,  davg[i].vmr[0:n-1], $
                 format='(i4, f10.1, i10, i5, i4, 2e13.4, f7.2, 18e13.4)'
      endif

   endfor

   free_lun, lun1
   if( trop )then free_lun, lun2


  ; monthly average
   openw,  lun1, mol + '-mavg_col.txt', /get_lun
   printf, lun1, yys[1]-yys[0]+1, 12
   printf, lun1, 'year jan                            feb                            mar                            apr                            may                            jun                            jul                            aug                            sep                            oct                            nov                            dec'

   if( trop )then begin
      openw,  lun2, mol+'-mavg_tropvmr.txt', /get_lun
      printf, lun2, yys[1]-yys[0]+1, 12
      printf, lun2, 'year jan                            feb                            mar                            apr                            may                            jun                            jul                            aug                            sep                            oct                            nov                            dec'
   endif

   i = 0l
   j = 0
   k = 0
   ;print, yys
   for i=yys[0], yys[1] do begin

      printf, lun1, i, format='(i4,2x,$)'
      if( trop )then printf, lun2, i, format='(i4,2x,$)'

      m=0l
      for m=1l, 12 do begin
            maxn = 31l
            if( m eq 9 )then maxn=30l
            if( m eq 4 )then maxn=30l
            if( m eq 6 )then maxn=30l

            dex = where( jday ge julday( m, 1, i ) and $
                         jday le julday( m, maxn, i) )
                          ;and pv   lt pvmask, cnt )
            ;print, i, m, cnt
            avgcol = 0.0
            sdvcol = 0.0
            ncol = 0

            if( cnt gt 0 )then k++
            if( cnt eq 1 )then begin
               mavg[j].avg = data[dex[0]].rettc
               mavg[j].std = data[dex[0]].rettc*0.05
               mavg[j].nob = 1
               if( trop )then begin
                  mavg[j].mvg = mvmr[dex[0],2]
                  mavg[j].mvd = mvmr[dex[0],2] * 0.05
               endif
               mavg[j].jld = jday
               caldat, mavg[j].jld, mm, dd, yyyy
               mavg[j].dat = 1000*yyyy + 100*mm + dd
            endif else if( cnt gt 1 ) then begin
               mm = moment( data[dex].rettc, /double )
               mavg[j].avg = mm[0]
               mavg[j].std = sqrt( mm[1] )
               mavg[j].nob = cnt
               if( trop )then begin
                  mm = moment( mvmr[dex,2], /double )
                  mavg[j].mvg = mm[0]
                  mavg[j].mvd = sqrt( mm[1] )/ sqrt(cnt)
               endif
               mm = moment( jday, /double )
               mavg[j].jld = mm[0]
               caldat, mavg[j].jld, mm, dd, yyyy
               mavg[j].dat = 1000*yyyy + 100*mm + dd
            endif

         printf, lun1,  mavg[j].jld, mavg[j].avg, mavg[j].std, mavg[j].nob, format='(f11.2,2e9.2,i4,$)'
         if( trop )then $
         printf, lun2,  mavg[j].jld, mavg[j].mvg, mavg[j].mvd, mavg[j].nob, format='(f11.2,2e9.2,i4,$)'

         j++

      endfor
      printf, lun1, ''
      if( trop )then printf, lun2, ''

   endfor

   nobmnth = j
   nmonths = k

   print, '  mkdavg : number of obs months :', nobmnth, ' in ', nmonths
   mavg[0].n = nmonths

   free_lun, lun1
   if( trop )then free_lun, lun2

   return, 0

end
