PRO bnr_read,bnrfile,outrec
;DS Aug 2010
;fixed dur bug, need to code for ' Infi' , as well as ***** and NaN

;Open and read a bnr file
;output data to a structure
;also calculate abissica values ie wavenumber values per spectral point
;also calculate other temperol products and output
;do some quick checks as well

;Architecture
;open,read
;calculate time parameters
;construct and output to structure

;Main
;initialise
diy = 365.0

;open file
OPENR,1,bnrfile,ERROR = err
IF (err NE 0) THEN STOP,'Error opeing bnr file: ',bnrfile

;read header
header = BYTARR(80)
READU,1,header
headerstr = string(header)

;read parameters
stxv = 0.0d
enxv = 0.0d
pntsp = 0.0d
npts = long(0)
READU,1,stxv,enxv,pntsp,npts

;quick check of parameters
calpts = (enxv - stxv )/pntsp + 1
calpts = LONG(ROUND(calpts)) 
IF (calpts NE npts) THEN BEGIN
 PRINT,bnrfile,' WARNING: Number of spectral points differ from calculated spectral points'
 PRINT,bnrfile, ' registered number of points: ',npts
 PRINT,bnrfile,' Calculated number of points: ',calpts
ENDIF

;set up and read spectral points
data = FLTARR(npts)
READU,1,data,TRANSFER_COUNT = ndata
CLOSE,1

;extract header data 
;time stuff
year = FIX(STRING(header(3:6)))
month = FIX(STRING(header(8:9)))
day = FIX(STRING(header(11:12)))
hour = FIX(STRING(header(14:15)))
minute = FIX(STRING(header(17:18)))
sec = FIX(STRING(header(20:21)))
hrs = FLOAT((((sec/60.0) + minute)/60.0) + hour)
IF ((year mod 4) EQ 0 ) THEN diy = 366.0
jd = JULDAY(month,day,year)
fracyr = (JULDAY(month,day,year,hour,minute,sec) -JULDAY(1,1,year,0,0,0)) / diy
doy = FIX(jd - JULDAY(1,1,year) + 1)
tyr = DOUBLE(year + fracyr)
 
;spectra stuff
sza = FLOAT(STRING(header(27:31)))
res = FLOAT(STRING(header(37:42)))
fov = FLOAT(STRING(header(48:51)))
dur = (STRING(header(57:61)))
IF dur EQ '*****' OR dur EQ ' NaN ' OR dur EQ ' Infi' THEN BEGIN
 dur = -1.0
ENDIF ELSE BEGIN
 dur = FLOAT(dur)
ENDELSE
apod = (STRING(header(67:68)))

;construct abisscia numbers
x = ( DINDGEN(npts) * pntsp ) + stxv
IF (FLOAT(x(npts-1)) NE FLOAT(enxv)) THEN BEGIN
 PRINT,bnrfile,' WARNING: End point differ from calculated End point'
 PRINT,bnrfile,' registered end point: ',enxv
 PRINT,bnrfile,' Calculated end point: ',x(npts-1)
 envx = x(npts-1)
ENDIF

;set up structure
 outrec={header:'',$
         stxv:0.0d,$
         enxv:0.0d,$
         pntsp:0.0d,$
         npts:long(0),$
         jd:long(0),$
         tyr:0.0d,$
         doy:0,$
         fracyr:0.0,$
         hrs:0.0,$ 
         sza:0.0,$
         res:0.0,$
         fov:0.0,$
         dur:0.0,$
         apod:'',$
         spec:fltarr(npts),$
         x:fltarr(npts)}

;assign values to structure
 outrec.header = headerstr
 outrec.stxv = stxv
 outrec.enxv = enxv
 outrec.pntsp = pntsp
 outrec.npts = npts
 outrec.jd = jd
 outrec.tyr = tyr
 outrec.doy = doy
 outrec.fracyr = fracyr
 outrec.hrs = hrs
 outrec.sza = sza
 outrec.res = res
 outrec.fov = fov
 outrec.dur = dur
 outrec.apod = apod
 outrec.spec = data
 outrec.x = x 

END
