function readnxn4e, nxn, file, rev=rev, quiet=quiet

; Read in n by n file with multiple blocks from error analysis output --------------------------------------------------------------------

   funcs = [ 'isnumeric']
   resolve_routine, funcs, /either
   forward_function isnumeric

   if( not keyword_set( quiet ))then print,'Readnxn4e openinf file : ', file

	openr, lun, file, /get_lun, error=ioerr
	if( ioerr ne 0 ) then begin
		printf, -2, !err_string
		;free_lun, lun, /force
		return, 1
	endif

   buf = ''
	readf, lun, buf
	ttl = strtrim( buf, 2 )
	if( strpos( buf, '#' ) NE -1 )then ttl = strtrim(strmid( buf, strpos( buf, '#' ) +1 ), 2)
	if( not keyword_set( quiet ))then print, ttl
	ver = ''
	tag = ''

	readf, lun, buf
	subs = strsplit( buf, /extract, count=count )
   if( strpos( buf, 'nmatr' ) NE -1 )then nmatr = fix(subs(count-1))
   if( not keyword_set( quiet ))then print, '   # matricies :   ', nmatr

	readf, lun, buf
	subs = strsplit( buf, /extract, count=count )
   if( strpos( buf, 'nrows' ) NE -1 ) then nrow = fix(subs(count-1))
   if( not keyword_set( quiet ))then print, '   # rows :        ', nrow

	readf, lun, buf
	subs = strsplit( buf, /extract, count=count )
   if( strpos( buf, 'ncols' ) NE -1 ) then ncol = fix(subs(count-1))
   if( not keyword_set( quiet ))then print, '   # columns :     ', ncol

	if( ncol ne nrow )then begin
	   print, 'readnxn4e : hmmm... matrix should be square : ', nrow, ncol
	   free_lun, lun
	   stop
	endif

   n = nrow
   nxn = {		               $
	   val   : 0,              $
	   ver   : ver,            $
      tag   : tag,            $
      ttl   : ttl,            $
      nmatr : nmatr,          $
		n	   : n,		  			$
		name  : strarr( nmatr ),$
		mat	: dblarr( nmatr, n, n )	$
	}

   for i=0, nmatr -1 do begin

      buf = ''
      while( isnumeric( buf ) ) do begin
         readf, lun, buf
         ;print, buf
      endwhile

      if( not keyword_set( quiet ))then print, '   found block : ', buf
      nxn.name[i] = buf
      mat = dblarr( n, n )
      readf, lun, mat

      if( keyword_set(rev) )then begin
         if( ~keyword_set(quiet) )then print, 'Readnxn4: Reversing each dimension'
         mat = reverse( mat, 1 )
         mat = reverse( mat, 2 )
      endif

      nxn.mat[i,*,*] = mat

   endfor

   nxn.val = 1
   mat = 0
   print, 'Readnxn4e : ', file, ' file done'
	free_lun, lun
	return, 0

end

function isnumeric,input
  on_ioerror, false
  test = double(input)
  return, 1
  false: return, 0
end
