pro pspecnoise

openr, lun, 'noisefit.txt' , /get_lun

   c1 ='1 initial spectra snr region'
   readf, lun, b1, n1
   x1 = dblarr(2,n1)
   readf, lun, x1

   c2 = '2 wider +- ~1cm-1'
   readf, lun, b2, n2
   x2 = dblarr(2,n2)
   readf, lun, x2

   c3 = '3 interpolated reduced res if done'
   readf, lun, b3, n3
   x3 = dblarr(2,n3)
   readf, lun, x3

   c4 = 'index, wave, snr region, fitted curve, difference'
   c42 = '42 fitted snr region'
   c43 = '43 polynomial fit'
   c44 = '44 difference'
   wstart=0.0d0
   readf, lun, b4, n4, wstart, dnu
   x4 = dblarr(5,n4)
   readf, lun, x4

free_lun, lun

tek_color
set_plot, 'x'
device, decompose=0

plot,  x2[0,*], x2[1,*], /nodata

print, n2
oplot, x2[0,*], x2[1,*], color=2
xyouts, 0.1, 0.1, c1, /normal, color=2

print, n1
oplot, x1[0,*], x1[1,*], color=3
xyouts, 0.1, 0.14, c2, /normal, color=3

print, n3
oplot, x3[0,*], x3[1,*], color=4
xyouts, 0.1, 0.18, c3, /normal, color=4

print, n4, wstart, dnu
oplot, x4[1,*], x4[2,*], color=5
xyouts, 0.1, 0.22, c42, /normal, color=5

print, n4, wstart, dnu
oplot, x4[1,*], x4[3,*], color=6
xyouts, 0.1, 0.26, c43, /normal, color=6

stop
end