pro fixref, zpt=zpt, file=file, nozero=nozero

   if( not keyword_set( file )) then begin
      file = 'reference.prf'
   endif

   openr, lun, file, /get_lun
   openw, lu2, file+'.fix', /get_lun

   nlines = 10

   buffer = ''
   readf, lun, updn, nlay, nmol
   print, lun, updn, nlay, nmol
   printf, lu2, fix(updn), fix(nlay), fix(nmol),format='(3i5)'

   arr = fltarr(nlay)

   if( keyword_set (zpt) ) then begin

      readf, lun, buffer
      printf, lu2, buffer
      readf, lun, arr
      printf, lu2, arr, format='(5(f12.4,1x))'

      readf, lun, buffer
      printf, lu2, buffer
      readf, lun, arr
      printf, lu2, arr, format='(5(e12.4,1x))'

      readf, lun, buffer
      printf, lu2, buffer
      readf, lun, arr
      printf, lu2, arr, format='(5(f12.4,1x))'

   endif


   for i = 0, nmol -1 do begin

      readf, lun, buffer
      readf, lun, arr
      print, buffer
      strs = strsplit( buffer, count=count, /extract )
      ;print, count
      buffer = ''
      for j=2,count-1 do begin
         buffer = buffer + ' ' + strs[j]
      end

      buf8 = '        '
      strput, buf8, strs[1]
      buf8 = strs[1]
      printf, lu2, fix(strs[0]), buf8, buffer, format='(i5, a8, a )'

      if( keyword_set(nozero) )then begin
         idx = where( arr eq 0.0, cnt )
         if( cnt gt 0 )then arr[idx] = 1.0d-30
      endif

      printf, lu2, arr, format='(5(e12.4,1x))'

      ;for j=0, nlines-1 do begin
      ;  readf, lun, buffer
      ;  printf, lu2, buffer
      ;end

   end

   free_lun, lun, lu2

stop
end