pro cprf4, file=file, mol=mol, site=site, yy1=yy1, yy2=yy2, pvmask=pvmask, mxrms=mxrms

; October 2013
; move to reading save file

; external procedures requires
; usemol
; usesite
; lfileread
; pfileread
; mkdavg
; colorbar

forward_function plotcnt, plotprf1, plotprf2, plotprf3, plotpv, plotratio, plotpc, $
              plotanom, ycycle, plotmonthly, plotdoyv, plotdoyc, plothist, plotprfm, $
              plotrnd, getpv, usehf, readlayr

; October 2013
; use .sav file ********

; from cprf cycle
; compute cycle and trends in a time series of data from a q file
; last worked on : posters for WCRP Oct 2011 trop gases at MLO & TAB
;  see NDSC/Analysis/WCRP2011


if( not keyword_set( bot )) then begin
   bot  = 0.
   print, '  main : setting bot to: ', bot
endif

if( not keyword_set( xscl )) then begin
   xscl  = 1.
   print, '  main : extra scale: ', xscl
endif

if( not keyword_set( top )) then begin
   top=120.
   print, '  main : setting top to: ', top
endif

if( not keyword_set( local )) then begin
   print, '  main : unset local search path...'
   local = 0
endif

if( not keyword_set( mol )) then begin
   print, '  main : must set mol argument...'
   stop
endif

if( not keyword_set( mvmr )) then begin
   mvmr = 0
   print, '  main : setting variable to mean vmr.'
endif

if( not keyword_set( site )) then begin
   print, '  main : must set site arg.'
   stop
endif

if( not keyword_set( file )) then begin
   print, '  main : must set file arg pointing to the .sav file.'
   stop
endif

if( not keyword_set( mxrms )) then begin
   mxrms = 1.0
   print, '  main : setting mxrms limit to : ', mxrms
endif

   ct = 5
   psiz = intarr(2)
   psiz = [ 1000, 465 ]

   ppos = intarr(3)
   ppos = [ 700, 550, 0 ]        ; work - double screens
   ;ppos = [ 200, 200, 0 ]        ; laptop


   print, ' Restoring save file : ', file
   restore, file
   ;help, ds, /structure

   print, 'Number of retrievals in save file : ',  n_elements(ds)
   idx = where( ds.rms LT mxrms, nobs )
   print, 'Number of retrievals in max rms criteria : ',  nobs

   thisidx = intarr(nobs)
   j = -1
   for i=0, nobs-1 do begin
      idx2 = where( ds[idx[i]].retvmr[*] LT 0.0, cnt )
      if( cnt EQ 0 )then begin
         j++
         thisidx[j] = idx[i]
      endif
   endfor

   nobs = j + 1
   data = ds[thisidx[0:nobs-1]]
   print, 'Number of retrievals in non negative vmr criteria : ',  nobs


   tek_color
   ;plot, data[*].tyr, data[*].rettc, psym=4
   ;oplot, data[*].tyr, data[*].aprtc, psym=5, color=3

   ;for i=0, nobs -1 do print , data[i].yyyymmdd + '.' + data[i].hhmmss, data[i].dofs, data[i].aprtc, data[i].rettc

; get molecule - dependent info for plots
   ucmol = STRUPCASE( mol )
   usite = STRUPCASE( site )
   uusite = usite
   if( uusite eq 'TAB41' ) then usite  = 'TAB'

   usemol, usite, ucmol, Ag
   usesite, uusite, As, Ag

   y1 = min(data.year)
   y2 = max(data.year)
   ny = y2 - y1 +1
   latrng = [ JULDAY(1,1,y1), JULDAY(12,31,y2) ]

; Read in layers file station.layers
	rc = 0
	klay = n_elements(data.altitude)
	alt  = data.altitude

; mean trop vmr per measurement
	nlat = n_elements( data )
   xd   = DBLARR( nlat )
   nd   = 1
   day  = data[0].year*10000 + data[0].month*100 + data[0].day

	idx = where( alt LE top AND alt GE bot, cnt )
	;print, alt[idx]

	IF( usite EQ 'TAB' ) THEN BEGIN
		cbtitle = 'NDACC / NCAR Thule, GR, FTS Total Column & Profile Retrieval Trends for ' + Ag.smol + Ag.vmrunits
		dbtitle = 'NDACC / NCAR Thule, GR, FTS Total Column Retrieval for ' + Ag.smol + Ag.vmrunits
		prtitle = 'NDACC / NCAR Thule, GR, FTS Profiles by DOY for ' + Ag.smol + Ag.vmrunits
		sztitle = 'NDACC / NCAR Thule, GR, FTS Profiles by SZA for ' + Ag.smol + Ag.vmrunits
		rmtitle = 'NDACC / NCAR Thule, GR, FTS Profiles by RMS for ' + Ag.smol + Ag.vmrunits
	ENDIF ELSE IF( usite EQ 'FL0' ) THEN BEGIN
		cbtitle = 'NCAR FL0, FTS Total Column & Profile Retrieval Trends for ' + Ag.smol + Ag.vmrunits
		dbtitle = 'NCAR FL0, FTS Total Column Retrieval for ' + Ag.smol + Ag.vmrunits
		prtitle = 'NCAR FL0, FTS Profiles by DOY for ' + Ag.smol + Ag.vmrunits
		sztitle = 'NCAR FL0, FTS Profiles by SZA for ' + Ag.smol + Ag.vmrunits
		rmtitle = 'NCAR FL0, FTS Profiles by RMS for ' + Ag.smol + Ag.vmrunits
	ENDIF ELSE IF( usite EQ 'MLO' ) THEN BEGIN
		cbtitle = 'NDACC / NCAR MLO, FTS Total Column & Profile Retrieval Trends for ' + Ag.smol + Ag.vmrunits
		dbtitle = 'NDACC / NCAR MLO, FTS Total Column Retrieval for ' + Ag.smol + Ag.vmrunits
		prtitle = 'NDACC / NCAR MLO, FTS Profiles by DOY for ' + Ag.smol + Ag.vmrunits
		sztitle = 'NDACC / NCAR MLO, FTS Profiles by SZA for ' + Ag.smol + Ag.vmrunits
		rmtitle = 'NDACC / NCAR MLO, FTS Profiles by RMS for ' + Ag.smol + Ag.vmrunits
   ENDIF ELSE IF( usite EQ 'ACF' ) THEN BEGIN
		cbtitle = 'NCAR Airborne FTS Total Column & Profile Retrieval Trends for ' + Ag.smol + Ag.vmrunits
		dbtitle = 'NCAR Airborne FTS Total Column Retrieval for ' + Ag.smol + Ag.vmrunits
		prtitle = 'NCAR Airborne FTS Profiles by DOY for ' + Ag.smol + Ag.vmrunits
		sztitle = 'NCAR Airborne FTS Profiles by SZA for ' + Ag.smol + Ag.vmrunits
		rmtitle = 'NCAR Airborne FTS Profiles by RMS for ' + Ag.smol + Ag.vmrunits
   ENDIF ELSE BEGIN
		PRINT, ' site out of range : ', site
		STOP
	ENDELSE

   goto, plotnow

	print,''
   if( mvmr ) then begin
      ; mean vmr for some subset of layers
      print, ' Variable is mean vmr between', bot, ' and ', top
      for i=0, nlat -1 do begin
         thisday = data[i].year*10000 + data[i].month*100 + data[i].day
         if( thisday ne day )then begin
            nd++
            day = thisday
         endif
         x = total( data[idx].ms ) ; sum airmass
         xd[i] = total( data[i].retvmr[idx] * data[i].ms[idx] ) / x
         ;print, linpc[i].date, '   ', linpc[i].time, ' ',  xd[i]*Ag.vmrscl, linpc[i].sza
      endfor
      thisyrng = Ag.vmrng
      thisyscl = Ag.vmrscl * xscl
      ytitl = 'Mean VMR !C!C' + Ag.smol + ' ' + Ag.vmrunits
   endif else begin
      ; some partial column
      print, ' Variable is partial column between', bot, ' and ', top
      for i=0, nlat -1 do begin
         thisday = data[i].year*10000 + data[i].month*100 + data[i].day
         if( thisday ne day )then begin
            nd++
            day = thisday
         endif
         xd[i] = total( data[i].retvmr[idx] * data[i].ms[idx] )
      endfor
      thisyrng = Ag.colrng
      thisyscl = Ag.colscl * xscl
      ytitl = 'Total Column ' + Ag.smol + '!C!C x' + string( thisyscl, format='(g0.0)') + '[molec/cm!U2!N]'
   endelse

   print, 'Number of unique days : ', nd
	q = moment(xd)
	print, 'average, sdev & %sdev : ', q[0], sqrt(q[1]), sqrt(q[1])/q[0]*100

   datds = lonarr( nd )
   nd = 1
   thisday = 0L
   datds[0] = long(data[0].year*10000. + data[0].month*100. + data[0].day)
   i=1
   ;print, long(data[i].year*100.)
   ;+ data[i].month*100 + data[i].day)
	for i=0, nlat -1 do begin
	   ;print, data[i].year, data[i].month, data[i].day
	   thisday = long(data[i].year*10000. + data[i].month*100. + data[i].day)
	   if(datds[nd-1] ne thisday )then begin
	      datds[nd] = thisday
	      ;print, datds[nd]
	      nd++
      endif
   endfor

; calculate monthly
   xm = dblarr( ny*12, 9 )
   k = 0
   years = intarr(ny)
   for i=0, ny-1 do begin
      year = As.y1 + i
      years[i] = year
      for j=0, 12-1 do begin
         k = 12*i + j
         month = j +1
         thisjd = julday( month, 15, year )
         xm[k,0] = thisjd
         dex = where( data[*].year EQ year AND data[*].month EQ month, cnt )
         ;print, i, j, k, year, month, cnt
         if( cnt EQ 0 ) then begin
            xm[k,1:8] = [ 0, 0, 0, year, 0, year, month, 15 ]
         endif else if( cnt EQ 1 )then begin
            xm[k,1:8] = [ xd[dex[0]], 0.1*xd[dex[0]], 1, year, 0, year, month, 15 ]
         endif else begin
            m = moment( xd[dex] )
            xm[k,1:8] = [ m[0], sqrt( m[1] ), cnt, year, 0, year, month, 15 ]
         endelse
         ;print, xm[k,*]
      endfor
   endfor


plotnow:
; make plots to X & PS ----------------------------------------------------------

; set up date labels
   months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
   days   = [1]
   joe = LABEL_DATE( DATE_FORMAT="%D%M!C%Y", MONTHS=months, DAYS=days )
   xtitle = 'Date for Year ' + string( format='(i4)', 2000 )
   xtitle = ''
   xticks = ny
   xtickv = JULDAY(1,1,INDGEN(ny+1) +y1)
   ;PRINT, '  Xticks : ', xticks
   ;CALDAT, xtickv, m, d, y
   ;print, m,d,y

   prtitle = 'FTS Retrieval'

   FOR toPS = 0, 1 DO BEGIN

      PRINT, 'toPS = ---------------------------------------------------------------', toPS

      IF toPS THEN BEGIN ; 1 is true
         SET_PLOT, 'PS'
         pos = strpos( file, '.' )
         psfile =  strmid( file, 0, pos ) + '-cprf.ps'
         ;psfile = 'cprf4.ps'
         PRINT,''
         PRINT, '   Main : Saving ps file to : ', psfile
         DEVICE, /COLOR, /LANDSCAPE, FILENAME = psfile, ENCAPSULATED = encap, BITS=8

         !P.CHARTHICK = 4.0
         !X.THICK     = 4.
         !Y.THICK     = 4.
         stickthick   = 2
         charsize     = 2.
         lthick       = 6
         fillcolor    = 170

      ENDIF ELSE BEGIN
         SET_PLOT,'X'
         DEVICE, DECOMPOSE=0  ; allow for terminals with > 256 color

         ;TEK_COLOR
         !P.CHARSIZE  = 1
         !P.CHARTHICK = 1
         !P.THICK     = 1
         !X.THICK     = 1
         !Y.THICK     = 1
         stickthick   = 1
         charsize     = 1.5
         lthick       = 2
         fillcolor    = 0

      ENDELSE

   	; plot all profiles on a vmr vs alt plot color coded by doy
      rc = plotprf1( data, Ag, toPS, ppos, psiz, lthick, prtitle, site, ct )

   	; plot all profiles on a vmr vs alt plot color coded by doy but to plot altitude
      rc = plotprf2( data, Ag, toPS, ppos, psiz, lthick, prtitle, site, ct )

   	; plot all profiles on a vmr vs alt plot color coded by SZA
      rc = plotprf3( data, Ag, toPS, ppos, psiz, lthick, prtitle, site, ct  )

   	; plot all profiles on a vmr vs alt plot color coded by SZA
      rc = plotprf4( data, Ag, toPS, ppos, psiz, lthick, prtitle, site, ct, 0 )

   	; plot all profiles on a vmr vs alt plot color coded by SZA
      rc = plotprf4( data, Ag, toPS, ppos, psiz, lthick, prtitle, site, ct, 1 )

   	; plot main contour with sticks
      rc = plotcnt( data, Ag, toPS, ppos, psiz, lthick, xtitle, ct, xticks, cbtitle, xtickv )

      ;plot some quality checking
      rc = plotchecks( data, Ag, toPS, ppos, psiz, lthick, ct, cbtitle )

   	; plot histograms
      rc = plothist( data, toPS, ppos, psiz )

goto, next

   	; plot all profiles on a vmr vs alt plot by month
      rc = plotprfM( lines, alt, Ag, toPS, ppos, psiz, lthick, nlat, sztitle, ct, naltmax, months, site )

   	; plot all columns vs day of year
      rc = plotdoyC( lines, alt, Ag, toPS, ppos, psiz, lthick, nlat, sztitle, ct )

   	; plot all tropospheric VMR's vs day of year - no trop from ac spectra
   	IF( site NE 'ACF' )THEN rc = plotdoyV( lines, linpc, alt, Ag, toPS, ppos, psiz, lthick, nlat, sztitle, ct )


      ; plot monthly averages over y1 - y2
      rc = plotmonthly( mavg, nobmnth, toPS, ppos, psiz, Ag, xticks, cbtitle, xtickv, $
                        latrng, ct, lthick, pdes )


   	; plot pv
      IF( npv NE 0 )THEN rc = plotpv( pvd, pv, npv, latrng, toPS, ppos, psiz, lthick, ct, xticks, xtickv )

   	; plot hf ratio
      IF( nratio NE 0 )THEN rc = plotratio( hfratio, nratio, latrng, toPS, ppos, psiz, lthick, ct, xticks, xtickv )

   	; plot 3 partial columns on a page
      rc = plotpc( linpc, nlat, latrng, ldex, alt, toPS, ppos, psiz, lthick, ct, $
                   Ag, xticks, xtickv, mol, site)

   	; plot partial columns anomoly one for each plot
     	FOR i=0, 2 DO BEGIN
        	rc = plotanom( linpc, nlat, latrng, ldex, alt, toPS, ppos, psiz, lthick, ct, $
                   		Ag, xticks, xtickv, mol, pcavg, npcday, anomyr, ycrc, i, site)
     	ENDFOR

   	; plot 3 vmr ranges on a page
      rc = plot3v( lines, linpc, nlat, latrng, ldex, alt, toPS, ppos, psiz, lthick, ct, $
                   Ag, xticks, xtickv, mol, site)



      IF toPS THEN DEVICE, /CLOSE_FILE

   next:
   IF toPS THEN device, /close_file

   ENDFOR ; toPS

   PRINT,''
   PRINT, '.DONE.'

END


; Plot parameters in histograms in 4 panels -------------------------------------------------------

FUNCTION plothist, data, toPS, ppos, psiz

   !P.MULTI = [0, 2, 2, 0, 0]

   IF toPS THEN BEGIN
      ERASE
      csz = 1.0

   ENDIF ELSE BEGIN
      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],          $
              title='NCAR FTS Retrieval Histogram Distributions',    $
              XPOS = ppos[0], YPOS = ppos[1]
      csz = 1.0

   ENDELSE

   nlat = n_elements( data )

   FOR i=0, 3 DO BEGIN

      SWITCH i OF

      0: BEGIN
         ds = data[0:nlat-1].sza
         title = 'SZA'
         xtitle = 'Solar Zenith Angle [deg]'
         BREAK
         END

      1: BEGIN
         ds = data[0:nlat-1].rms
         title = 'FIT RMS'
         xtitle = 'Fit RMS [%]'
         BREAK
         END

      2: BEGIN
         ds = data[0:nlat-1].dofs
         title = 'DOFS'
         xtitle = 'Degrees of Freedom for Signal'
         BREAK
         END

      3: BEGIN
         ds = data[0:nlat-1].azi
         title = 'SAZM'
         xtitle = 'Solar Azimuth Angle [deg]'
         BREAK
         END

      ENDSWITCH

      IF( MAX( ds ) GT 0.0 )THEN BEGIN
			hist = HISTOGRAM(ds, nbins=60, LOCATIONS=locs)
			bins = FINDGEN(N_ELEMENTS(hist)) + MIN(ds)
			;PRINT, MIN(hist)
			;PRINT, bins
			;PRINT, locs
			PLOT, locs, hist, YRANGE = [0.0, MAX(hist)+1], /NODATA, PSYM = 10, XTITLE = xtitle, YTITLE = 'Density per Bin', TITLE=title
			OPLOT, locs, hist, PSYM = 10, COLOR=50
      ENDIF

   ENDFOR

   ;FOR i=0, nlat-1 DO BEGIN
   ;PRINT, lines[i].sza, lines[i].rms, lines[i].dofs, lines[i].sazm
   ;ENDFOR


RETURN, 0

END

; plot all profiles on a vmr vs alt plot color coded by doy  ---------------------------------------------

FUNCTION plotprf1, data, Ag, toPS, ppos, psiz, lthick, prtitle, site, ct

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotPrf1 : plot profiles color coded by DOY on log scale...'

   !P.MULTI = 2

   gpos = FLTARR(2,4)

   IF toPS THEN BEGIN
   ;  ERASE ;                                       first plot so no erase
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.07, 0.98, 0.86]

   ENDIF ELSE BEGIN
      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.10, 0.95, 0.82]
      ppos = ppos +  [ 20,  -20, 1 ]                  ; increments up w/ each plot
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], title='NCAR FTS Profile Retrieval 1',      $
              XPOS = ppos[0], YPOS = ppos[1]
   ENDELSE

; define colorbar labels for doy profile plots
   ndiv   = 12
   dstart = 25
   dend   = 30
   nclr   = 255 - dstart - dend
   cbt    = STRARR( ndiv +1 )
   minz   = 1
   maxz   = 366
   cdivs  = (maxz-minz)/ndiv
   ;print, dstart, nclr, dend, ndiv, minz, maxz, cdivs

   FOR i=0, ndiv DO BEGIN
       cbt[i] = STRING( i*30.5, format='(i3)' )
   ENDFOR

; ct = 5 goes from black to white
   LOADCT, ct, NCOLORS = 255, /SILENT

; crunch in colors at top by dend
   COLORBAR, NCOLORS = nclr-dend, POSITION = gpos[0,*], CHARSIZE=1.2,        $
             DIVISIONS = ndiv, TICKNAMES = cbt, TITLE = prtitle + ' : Day of Year', BOTTOM = dstart

   xrng = Ag.logrng
   alt  = data[0].altitude
   nlat = n_elements( data )

   PLOT, data[0].retvmr[*]*Ag.vmrscl, alt, YRANGE = Ag.altrng, POSITION = gpos[1,*], $
         /NODATA, YTITLE='Altitude [km]', CHARSIZE = 1.4, $
         XTITLE=' Mixing Ratio for ' + Ag.smol + Ag.vmrunits, /XLOG, $
         xrange = xrng, xstyle=1

   thiscolor = bytscl( [1,data[*].doy, 366], top = nclr-dend ) + dstart

   for i=0, nlat-1 do begin
       oplot, data[i].retvmr[*]*ag.vmrscl, alt, color = thiscolor[i+1]
   endfor

   return, 0

end


; plot all profiles on a vmr vs alt plot color coded by doy but to plot altitude ---------------------

function plotprf2, data, ag, tops, ppos, psiz, lthick,  prtitle, site, ct

   if( not tops )then print, ''
   IF( NOT toPS )THEN PRINT, '  PlotPrf2 : plot profiles color coded by DOY on linear scale...'

   !P.MULTI = 2
   gpos = FLTARR(2,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]   ; top
      gpos[1,*] = [0.05, 0.07, 0.98, 0.86]   ; bottem

   ENDIF ELSE BEGIN
      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.10, 0.95, 0.82]

      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], title='NCAR FTS Profile Retrieval 2',      $
              XPOS = ppos[0], YPOS = ppos[1]

   ENDELSE

; define colorbar labels for doy profile plots
   ndiv   = 12
   dstart = 25
   dend   = 30
   nclr   = 255 - dstart - dend
   cbt    = STRARR( ndiv +1 )
   minz   = 1
   maxz   = 366
   cdivs  = (maxz-minz)/ndiv
   ;print, dstart, nclr, dend, ndiv, minz, maxz, cdivs

   FOR i=0, ndiv DO BEGIN
       cbt[i] = STRING( i*30.5, format='(i3)' )
   ENDFOR

; ct = 5 goes from black to white
   LOADCT, ct, NCOLORS = 255, /SILENT

; crunch in colors at top by dend = 30
   COLORBAR, NCOLORS =  nclr-dend, POSITION = gpos[0,*], CHARSIZE=1.2,       $
             DIVISIONS = ndiv, TICKNAMES = cbt, TITLE = prtitle + ' : Day of Year', BOTTOM=dstart

   alt  = data[0].altitude
   nlat = n_elements( data )
   xrng = Ag.vmrng

   PLOT, data[0].retvmr[*]*Ag.vmrscl, alt, YRANGE = Ag.altrng, POSITION = gpos[1,*], $
         /NODATA, YTITLE='Altitude [km]', CHARSIZE = 1.4, XTITLE=' Mixing Ratio for ' + Ag.smol + Ag.vmrunits,                    $
         XRANGE = xrng

; set colors so we have a value at the bottem - dstart (black)
   thiscolor = BYTSCL( [1, data[*].doy, 366], TOP = nclr-dend ) + dstart

   FOR i=0, nlat-1 DO BEGIN
       OPLOT, data[i].retvmr[*]*Ag.vmrscl, alt, COLOR = thiscolor[i+1] ; not using dstart value
       ;PRINT , lines[i].doy, thiscolor[i+1], '  ', lines[i].date
   ENDFOR

   RETURN, 0

END



; plot all profiles on a vmr vs alt plot color coded by doy but to plot altitude ---------------------

FUNCTION plotprf3, data, Ag, toPS, ppos, psiz, lthick,  prtitle, site, ct

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotPrf3 : plot profiles color coded by SZA...'

   !P.MULTI = 2
   gpos = FLTARR(2,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]   ; top
      gpos[1,*] = [0.05, 0.07, 0.98, 0.86]   ; bottem

   ENDIF ELSE BEGIN
      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.10, 0.95, 0.82]

      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], title='NCAR FTS Profile Retrieval 3', XPOS = ppos[0], YPOS = ppos[1]
   endelse

; define colorbar labels for profile plots
   ndiv   = 10
   dstart = 25
   dend   = 30
   nclr   = 255 - dstart - dend
   cbt    = strarr( ndiv +1 )
   minz   = min( data[*].sza )
   maxz   = max( data[*].sza )
   cdivs  = (maxz-minz)/ndiv

   xrng = Ag.vmrng ;[min(data[*].retvmr[*]*ag.vmrscl), max(data[*].retvmr[*]*ag.vmrscl)]
   alt  = data[0].altitude
   nlat = n_elements( data )

   ;print, dstart, nclr, dend, ndiv, minz, maxz, cdivs

   for i=0, ndiv do cbt[i] = string(  minz + i * cdivs, format='(f4.0)' )

   loadct, ct, ncolors = 255, /silent

   colorbar, ncolors =  nclr -dend, position = gpos[0,*], charsize=1.2,       $
             divisions = ndiv, ticknames = cbt, title = prtitle + ' : Solar Zenith Angle', bottom = dstart

   plot, data[0].retvmr[*]*ag.vmrscl, alt, yrange = ag.altrng, position = gpos[1,*], $
         /NODATA, YTITLE='Altitude [km]', CHARSIZE = 1.4,                  $
         XTITLE=' Mixing Ratio for ' + Ag.smol + Ag.vmrunits, XRANGE=xrng

   thiscolor = bytscl( data[*].sza, top = nclr-dend ) + dstart

   for i=0, nlat-1 do begin
       oplot, data[i].retvmr[*]*ag.vmrscl, alt, color = thiscolor[i]
   endfor

   return, 0

end




; plot all profiles on a vmr vs alt plot color coded by rms but to plot altitude ---------------------

FUNCTION plotprf4, data, Ag, toPS, ppos, psiz, lthick,  prtitle, site, ct, llog

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotPrf4 : plot profiles color coded by rms...'

   !P.MULTI = 2
   gpos = FLTARR(2,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]   ; top
      gpos[1,*] = [0.05, 0.07, 0.98, 0.86]   ; bottem

   ENDIF ELSE BEGIN
      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.10, 0.95, 0.82]

      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],    $
              title='NCAR FTS Profile Retrieval 4 & 5', XPOS = ppos[0], YPOS = ppos[1]
   endelse

   alt  = data[0].altitude
   nlat = n_elements( data )

; define colorbar labels for doy profile plots
   ndiv   = 10
   dstart = 25
   dend   = 30
   nclr   = 255 - dstart - dend
   cbt    = strarr( ndiv +1 )
   minz   = min( data[*].rms )
   maxz   = max( data[*].rms )
   cdivs  = (maxz-minz)/ndiv
   ;print, dstart, nclr, dend, ndiv, minz, maxz, cdivs

   for i=0, ndiv do cbt[i] = string(  minz + i * cdivs, format='(f4.2)' )

   loadct, ct, ncolors = 255, /silent

; crunch in colors at top by dend = 30
   colorbar, ncolors =  nclr-dend, position = gpos[0,*], charsize=1.2,       $
             divisions = ndiv, ticknames = cbt, title = prtitle + ' : Residual RMS', bottom = dstart

   if( llog ) then begin
      xrng = [min(data[*].retvmr[*]*ag.vmrscl), max(data[*].retvmr[*]*ag.vmrscl)]
      xrng = Ag.vmrng
		plot, data[0].retvmr[*]*ag.vmrscl, alt, yrange = ag.altrng, position = gpos[1,*], $
				/NODATA, YTITLE='Altitude [km]', CHARSIZE = 1.4,                  $
				XTITLE = ' Mixing Ratio for ' + Ag.smol + Ag.vmrunits, XRANGE = xrng
   endif else begin
      xrng = Ag.logrng
		PLOT, data[0].retvmr[*]*Ag.vmrscl, alt, YRANGE = Ag.altrng, POSITION = gpos[1,*], $
				/NODATA, YTITLE='Altitude [km]', CHARSIZE = 1.4, /xlog,                 $
				XTITLE=' Mixing Ratio for ' + Ag.smol + Ag.vmrunits,                    $
				xrange = xrng
   endelse

   thiscolor = bytscl( data[*].rms, top = nclr-dend ) + dstart

   for i=0, nlat-1 do begin
       oplot, data[i].retvmr[*]*ag.vmrscl, alt, color = thiscolor[i]
   endfor

   return, 0

end



; plot RMS vs SZA ---------------------------------------------------------------------------

FUNCTION plotchecks, data, Ag, toPS, ppos, psiz, lthick, ct, cbtitle

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  Plotchecks : plot SZA vs RMS/DOFS checks...'

   !P.MULTI = [0,0,2,0,0]

   gpos = FLTARR(2,4)

   IF toPS THEN BEGIN
   ;  ERASE ;                                       first plot so no erase
      gpos[0,*] = [0.05, 0.53, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.07, 0.98, 0.44]

   ENDIF ELSE BEGIN
      gpos[0,*] = [0.10, 0.52, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.10, 0.95, 0.46]
      ppos = ppos +  [ 20,  -20, 1 ]                  ; increments up w/ each plot
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], title='Plot checks: SZA, RMS and DOFS',      $
              XPOS = ppos[0], YPOS = ppos[1]
   ENDELSE

   nlat = n_elements(data )

   loadct, ct, /silent
   xr = [30.,90.]

; --- fit rms vs solar zenith angle
   plot, data[*].sza, data[*].rms, psym=3, xtit='SZA', ytit='RMS', charsize=1.5, xrange=xr, xstyle=1

   ux = [ -6, 0, 6,  0, -6 ]
   uy = [  0, 6, 0, -6,  0 ]

   usersym, ux, uy, /fill
   oplot,  data[*].sza,  data[*].rms, psym=8, symsize=0.2

; --- DOFS vs Solar Zenith Angle
   PLOT, data[*].sza,  data[*].dofs, psym=3, xtit='SZA', ytit='DOFS', charsize=1.5, xrange=xr, xstyle=1

   ux = [ -6, 0, 6,  0, -6 ]
   uy = [  0, 6, 0, -6,  0 ]

   usersym, ux, uy, /fill
   oplot,  data[*].sza,  data[*].dofs, psym=8, symsize=0.2


; --- Page 2
!P.MULTI = [0,0,2,0,0]

   gpos = FLTARR(2,4)

   IF toPS THEN BEGIN
   ;  ERASE ;                                       first plot so no erase
      gpos[0,*] = [0.05, 0.53, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.07, 0.98, 0.44]

   ENDIF ELSE BEGIN
      gpos[0,*] = [0.10, 0.52, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.10, 0.95, 0.46]
      ppos = ppos +  [ 20,  -20, 1 ]                  ; increments up w/ each plot
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], title='Plot checks: SZA, DOY, Column', XPOS = ppos[0], YPOS = ppos[1]
   ENDELSE

; --- Total Column vs Solar Zenith Angle
   PLOT,  data[*].sza,  data[*].rettc*Ag.colscl, psym=3, xtit='SZA', ytit='COLUMN', charsize=1.5, yrange=Ag.colrng, xrange=xr, xstyle=1
   ux = [ -6, 0, 6,  0, -6 ]
   uy = [  0, 6, 0, -6,  0 ]
   USERSYM, ux, uy, /FILL
   OPLOT, data[*].sza, data[*].rettc*Ag.colscl, PSYM=8, SYMSIZE=0.2

; --- DOY vs Solar Zenith Angle
   PLOT, data[*].doy, data[*].sza, psym=3, ytit='SZA', xtit='DOY', charsize=1.5, yrange=xr, xstyle=1
   ux = [ -6, 0, 6,  0, -6 ]
   uy = [  0, 6, 0, -6,  0 ]
   usersym, ux, uy, /fill
   oplot, data[*].doy, data[*].sza, psym=8, symsize=0.2

   return, 0

end

; plot main contour with sticks ---------------------------------------------------------------------------

FUNCTION plotcnt, data, Ag, toPS, ppos, psiz, lthick, xtitle, ct, xticks, cbtitle, xtickv


   if( not tops )then print, ''
   IF( NOT toPS )THEN PRINT, '  PlotCnt : plot profile sticks & columns...'

   !p.multi = 3
   gpos = fltarr(3,4)

   if tops then begin
      erase
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.42, 0.98, 0.86]
      gpos[2,*] = [0.05, 0.07, 0.98, 0.40]
   endif else begin
      ppos = ppos +  [ 20,  -20, 1 ]
      window, ppos[2], retain=2, xsize=psiz[0], ysize=psiz[1],    $
              title='NCAR FTS Profile Retrieval Time Series', XPOS = ppos[0], YPOS = ppos[1]
      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.42, 0.95, 0.82]
      gpos[2,*] = [0.10, 0.10, 0.95, 0.40]
   endelse

   alt  = data[0].altitude
   nlat = n_elements( data )
   scl  = 1.
   latrng = [ julday( 1, 1, min(data.year)), julday( 12, 31, max(data.year)) ]

   makejday, data, jday, yy

; get subset of alt / lat matrix that we plot for this molec
   ldex = indgen( nlat )
   cnt = nlat
   ;ldex = where( lines[*].jday gt latrng[0] and lines[*].jday lt latrng[1], cnt )
   ;print, ' ldex : ', ldex
   adex = where( alt ge ag.altpltrng[0] and alt le ag.altpltrng[1], nalt )
   ;ddex = where( lines[*].lat gt latfilerng[0] and lines[*].lat lt latfilerng[1], nlat )

   z = data[*].retvmr[adex] * ag.vmrscl

   ;help, z
   if( not tops )then begin
		PRINT, '    PlotCnt : Lines found in file                     : ', nlat, FORMAT='(a,i10)'
		PRINT, '    PlotCnt : Lines found julian day range            : ', cnt, FORMAT='(a,i10)'
		PRINT, '    PlotCnt : Number of altitudes                     : ', nalt, FORMAT='(a,i10)'
		print, '    plotcnt : min, max of scaled vmr matrix           : ', min( z ), max( z ), format='(a,2f10.3)'
	endif

   z = transpose(z)

; set up contours
   ndiv = 8
   nlev = (ndiv + 1) * 17
   dc = max(z)/scl - min(z) + 0.0*(max(z) - min(z))
   clevs = min(z)-0.0*min(z) + indgen( nlev ) * dc/(nlev-1)


   if( not tops )then begin
		PRINT, '    PlotCnt : Min, Max of contour levels              : ', MIN( clevs ), MAX( clevs ), FORMAT='(a,2f10.3)'
		PRINT, '    PlotCnt : Number of contour divisions in colorbar : ', ndiv, FORMAT='(a,i10)'
		PRINT, '    PlotCnt : Number of color levels in contour plot  : ', nlev, FORMAT='(a,i10)'
	ENDIF

; define contours names for color table ticks
   cbtics = strarr( ndiv + 1 )
   for i=0, ndiv do begin
     cbtics[i] = string( clevs[i*(nlev/ndiv)], format=Ag.ctfmt )
     ;PRINT, i, nlev/ndiv, nlev/ndiv*i, clevs[i*(nlev/ndiv)], '  ', cbtics[i], Ag.ctfmt
   endfor

; tell max and min out of range
   for i=0, nalt-1 do begin
      for j=0, cnt-1 do begin
          if z[j,i] lt min( clevs ) then print, 'plotcnt less : ', j, i, z[j,i]
          if z[j,i] gt max( clevs ) then print, 'plotcnt more : ', j, i, z[j,i]
          endfor
      endfor

   nlev   = 255
   dstart = 30
   dend   = 100
   loadct, ct, ncolors=nlev, /silent;nlev +30;, bottom=10

; colorbar at top
      colorbar, ncolors = nlev-dend, position = gpos[0,*], charsize=2.0,           $
                divisions = ndiv, ticknames = cbtics, title = cbtitle, bottom=dstart

; set up plot axis & scaling at middle
      contour, z, jday, alt[adex], position = gpos[1,*], yrange = ag.altrng, xrange = latrng,                              $
               /fill, xtitle = xtitle, ytitle = 'Altitude [km]', /clip, charsize = 2.1, xtickformat='label_date',                      $
               xstyle=1, xticks=xticks, xminor=12, ystyle=1, /nodata, xcharsize=0.001, xticklen=0.05, xtickv=xtickv

; plot profile sticks
      for i=0, cnt-1 do begin
         x = dblarr(cnt) + jday[ldex[i]]
         ;print, x, alt[adex], z[i,*]
         plots, x, alt[adex], thick=stickthick, noclip=0, clip=[latrng[0],ag.altrng[0],latrng[1],ag.altrng[1]],                   $
            color=bytscl(z[i,*], min=min(clevs), max=max(clevs), top=nlev-dend) + dstart
      endfor

; plot columns in bottom
      ytit = 'Total Column ' + Ag.smol + '!C!C x' + string( Ag.colscl, format='(g0.0)') + '[molec/cm!U2!N]'
      titl = ''
      PLOT, jday, data[*].rettc*Ag.colscl, POSITION = gpos[2,*],            $
            XSTYLE=1, XTICKS=xticks, XMINOR=12, XRANGE = latrng, XTICKLEN=0.05, YSTYLE=0, XTICKFORMAT='LABEL_DATE',  $
            YTITLE=ytit, YRANGE=Ag.colrng, /NODATA, XTITLE='!CTime [yr]', CHARSIZE=2.1, YTICKLEN=0.01, XTICKV=xtickv, /YNOZERO

      OPLOT, jday, data[*].rettc*Ag.colscl, PSYM=7, SYMSIZE=0.5

; plot column errors
      ;OPLOTERR, davg[0:nlat-1].jld, davg[0:nlat-1].avg*Ag.colscl, davg[0:nlat-1].std*Ag.colscl

; plot 3 month average curve
      ;PLOTS, span[1:5,1], avgs[1:5,0]*Ag.colscl, COLOR=20, thick=3

   RETURN, 0

END








;-------------------------------------------------------------------------------------------------------

FUNCTION usehf, davg, nobsday, ratio, nratio, mol, hfile

	COMMON COM, y1, y2, maxline

; find common days of this molec and HF and compute ratio
; using julday

   hfavg = DBLARR(maxline,4)
   ratio = DBLARR(maxline,4)

   dum0 = 0.0D    ; julian day
   dum1 = 0.0D    ; day average
   dum2 = 0.0D    ; std_dev
   dum3 = 0.0D    ; nobs
   date = ''

; read in the daily averages of HF from saved list
; julday, average, std_dev, nobs, dd/mm/yyyy
   n = 0
   PRINT,''
   PRINT, '  HFRatio : Opening hf file : ', hfile

   OPENR, lun1, hfile, /GET_LUN, ERROR = ioerr

   IF( ioerr NE 0 )THEN BEGIN
      PRINT, '   ERROR opening HF file : ', hfile
      n = 0
   ENDIF ELSE BEGIN
		WHILE( NOT EOF( lun1 )) DO BEGIN
			READF, lun1, dum0, dum1, dum2, dum3, date
			hfavg[n,*] = [ dum0, dum1, dum2, dum3 ]
			n = n +1
			ENDWHILE
		FREE_LUN, lun1
   ENDELSE
   PRINT, '  HFRatio : Found : ', n, ' days of HF daily average column in : ', hfile

	mm = 0l
	dd = 0l
	ll = 0l
   oldn = 0
   nratio = 0
   FOR i=0, nobsday-1 DO BEGIN
      FOR j=0, n-1 DO BEGIN
         IF( FLOOR( hfavg[j,0] ) EQ FLOOR( davg[i].jld )) THEN BEGIN
            ratio[nratio,0] = hfavg[j,0]
            ratio[nratio,1] = davg[i].avg / hfavg[j,1]
            ratio[nratio,2] = SQRT( davg[i].std^2 + hfavg[j,2]^2 )
            ratio[nratio,3] = hfavg[j,3]
            nratio = nratio +1
            CONTINUE
            ENDIF
      ENDFOR
      IF( oldn+1 NE nratio )THEN BEGIN
         CALDAT, davg[i].jld, mm, dd, yy
      	;PRINT, '  No match : ', davg[i].jld, mm, dd, yy, FORMAT='(a,i12,2x,2(i02,"/"),i4)'
      ENDIF
      oldn = nratio
   ENDFOR

   PRINT, '  HFRatio : Common hits : ', nratio
   ;PRINT, dex

; print out the ratios in a list
   OPENW, lun1, mol+'-ratio.txt', /GET_LUN
   FOR i=0, nratio-1 DO PRINTF, lun1, ratio[i,*], FORMAT='(f10.0, 2e13.4, i4)'

   FREE_LUN, lun1

	RETURN, 0

END

;-------------------------------------------------------------------------------------------------------

PRO makejday, data, jday, yy

; lines, nlat -  input struct & # of lines includes jday - output julian days
; yy output array of years

   nlat = n_elements( data )

   dd=intarr(nlat)
   mm=intarr(nlat)
   yy=intarr(nlat)
   hr=intarr(nlat)
   mn=intarr(nlat)
   sc=intarr(nlat)

   for i=0, nlat-1 do begin
       dd[i] = data[i].day
       mm[i] = data[i].month
       yy[i] = data[i].year

       hr[i] = fix( data[i].hrs )
       mins  = data[i].hrs - fix( data[i].hrs )
       mn[i] = fix( mins*60. )
       secs  = mins - mn[i]
       sc[i] = fix( secs*60. )
       ;print, imm, idd, iyy
   endfor

   jday = julday( mm, dd, yy, hr, mn, sc )
   dex = where( hr lt 12., cnt)

   ;print, '    date         time    mm dd  yy   hh  mn  ss  doy  julian_day  fit_rms   dofs   snr      column    col_err'
   ;for i=0, nlat-1 do begin
   ;  print, lines[i].date, lines[i].time, mm[i], dd[i], yy[i], hr[i], mn[i], sc[i], lines[i].doy, $
   ;         lines[i].jday, lines[i].rms, lines[i].dofs, lines[i].snr, $
   ;         lines[i].col, lines[i].cer, format='(2a11, 2i4, i5, 3i4, i5, f13.4, 2(f8.3), f8.1, e13.4, f6.2)'
   ;endfor

end



; plot main contour with sticks ---------------------------------------------------------------------------

FUNCTION plotrnd, lines, toPS, ppos, Ag, psiz, nlat, latrng, nalt, $
                   newrange, davg, xticks, span, ayr, ldex

   !P.MULTI = 0
   gpos = FLTARR(4)

   IF toPS THEN BEGIN
      ERASE
      gpos[*] = [0.05, 0.40, 0.98, 0.70]

   ENDIF ELSE BEGIN
      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],    $
              title='NCAR FTS Total Column Time Series',    $
              XPOS = ppos[0], YPOS = ppos[1]
      gpos[*] = [0.10, 0.40, 0.95, 0.70]

   ENDELSE


   xrange = [JULDAY( 1, 1, ayr[0]+2000 ), latrng[1]]
   n = ayr[1] - ayr[0] +1

      yr = Ag.colrng
      ;yr = [0,3] ;clono2
      ;yr = [0,33] ;hf

; plot columns in bottom
   ytit = 'Total Column ' + Ag.smol + '!C!C x' + string( Ag.colscl, format='(g0.0)') + '[molec/cm!U2!N]'
   titl = ''
   PLOT, davg[*].jld, davg[*].avg*Ag.colscl, POSITION = gpos[*],           $
         XSTYLE=1, XTICKS=n, XMINOR=12, $
         XRANGE = xrange, XTICKLEN=0.05, YSTYLE=1,XTICKFORMAT='LABEL_DATE',   $
         YTITLE=ytit, YRANGE=yr, /NODATA, XTITLE='!CTime [yr]',         $
         CHARSIZE=1.4, YTICKLEN=0.01

   FOR i=ayr[0], ayr[1] DO BEGIN

   ; find day avg in span
      dex = WHERE( davg[*].jld GE span[i,0] AND davg[*].jld LE span[i,2], count )
      OPLOT, davg[dex].jld, davg[dex].avg*Ag.colscl, PSYM=7, SYMSIZE=0.5

   ; plot column errors
      OPLOTERR, davg[dex].jld, davg[dex].avg*Ag.colscl, 1*davg[*].std*Ag.colscl

   ENDFOR

   RETURN, 0

END

;------------------------------------------------------------------------------------------------------

FUNCTION getpv, pvfile, yy, pv, pvd, npv, lines, nlat

   COMMON COM, y1, y2, maxline

   pv          = DBLARR(maxline,2)
   pvd         = LONARR(maxline)
	lines[*].pv = -1.

	; Read in PV
   buf = ''
   OPENR, pvlun, pvfile, /GET_LUN, ERROR=ioerr

   IF( ioerr NE 0 )THEN BEGIN
	   PRINT, '   ERROR OPENING PV FILE : ', PVFILE
	   PV[*] = 0.0d0
	   pv[*] = 0L
	   npv = 0
	ENDIF ELSE BEGIN

		j=0
		WHILE( NOT EOF( pvlun )) DO BEGIN

			READF, pvlun, buf
			subs = STRSPLIT( buf, /extract, count=count )
			;print, subs[0], strlen( subs[0])
			READS, subs[0], format='(i2,1x,i2,1x,i4)', imm, idd, iyy
			pvd[j] = JULDAY( imm, idd, iyy )
			pv[j,0] = subs[1]

			; Store PV in retrieval data structure
			dex = WHERE( LONG(lines[*].jday) EQ LONG(pvd[j]), cnt )
			IF( cnt GT 0 ) THEN BEGIN
				lines[dex].pv = pv[j,0]
			ENDIF

			;PRINT, subs[0], pvd[i], pv[i,0]
			j = j + 1

		ENDWHILE
		FREE_LUN, pvlun

	   npv = j

   ENDELSE

   PRINT, ''
   PRINT, '  GetPV : # of pv values : ',  npv
   IF( npv EQ 0 )THEN RETURN,1
   dex = WHERE( lines[0:nlat-1].pv EQ -1., cnt )
   IF( cnt GT 0 )THEN BEGIN
   	PRINT, 'Missing some PV days :'
   	PRINT, lines[dex].datd
   ENDIF

   RETURN, 0

END



; Plot partial columns in 3 panels ------------------------------------------------------------------

FUNCTION plot3v, lines, linpc, nlat, latrng, ldex, alt, toPS, ppos, psiz, lthick, ct, Ag, $
                 xticks, xtickv, mol, site

; plot daily average partial columns

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  Plot3V : plot 3 VMRs...'

   !P.MULTI = 3
   gpos = FLTARR(3,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.10, 0.98, 0.33]
      gpos[1,*] = [0.05, 0.40, 0.98, 0.63]
      gpos[2,*] = [0.05, 0.70, 0.98, 0.93]
      csz = 2.0

   ENDIF ELSE BEGIN
      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],        $
              title='NCAR FTS Mixing Ratio Retrieval Time Series',    $
              XPOS = ppos[0], YPOS = ppos[1]

      gpos[0,*] = [0.10, 0.10, 0.95, 0.33]
      gpos[1,*] = [0.10, 0.40, 0.95, 0.63]
      gpos[2,*] = [0.10, 0.70, 0.95, 0.93]
      csz = 2.0

   ENDELSE

   partc = DBLARR( nlat )
   pcrange = FLTARR(2,3)
   IF( site EQ 'ACF' )THEN BEGIN
	   pcrange = [[ 6.0, 14.0 ], [ 14.0, 19.0 ], [ 19.0, 40.0 ]]
   ENDIF ELSE BEGIN
		pcrange = [[ 0.0, 12.0 ], [ 12.0, 22.0 ], [ 22.0, 40.0 ]]
		pcrange = [[ 0.0, 10.0 ], [ 10.0, 19.0 ], [ 19.0, 30.0 ]]
		pcrange = [[ 0.0,  8.0 ], [  8.0, 16.0 ], [ 16.0, 28.0 ]]
   ENDELSE

   ytitle = Ag.smol + ' Mixing Ratio ' + '!C!C x' + Ag.vmrunits ;string( Ag.vmrscl, format='(g0.0)')
   ;yrange = [0., 10.] ;[0., 0.]

   FOR j=0, 2 DO BEGIN

      xcsz = 1
      IF( j NE 0 )THEN xcsz = 0.001

      title = 'Mixing Ratio for alt range: ' + STRING( pcrange[*,j], format='(f4.1, "-", f4.1)')
      IF( NOT toPS )THEN BEGIN
         PRINT, ''
         PRINT, '   ', title
      ENDIF

		; mean trop vmr per measurement
		xd = DBLARR( nlat )

		idx = where( alt GT pcrange[0,j] AND alt LE pcrange[1,j], cnt )
		;print, nlat
		FOR i=0, nlat -1 DO BEGIN
			x = TOTAL( linpc[i].vmr[idx] / lines[i].vmr[idx] ) ; sum airmass
			xd[i] = TOTAL( linpc[i].vmr[idx] ) / x
			;print, lines[i].datd
		ENDFOR

      PLOT, lines[0:nlat-1].jday, xd[*]*Ag.vmrscl, POSITION = gpos[j,*],              $
            XTICKFORMAT = 'LABEL_DATE',                                       $
            XSTYLE = 1, XTICKS = xticks, XMINOR = 12, YSTYLE = 1, XRANGE = latrng,     $
            YTITLE = ytitle, PSYM = 3, /NODATA, XTICKLEN = 0.05,     $
            CHARSIZE = csz, YTICKLEN = 0.01, YRANGE = Ag.vrngs[j,*], XCHARSIZE = xcsz, $
            TITLE = title, XTICKV=xtickv

      ux = [ -6, 0, 6,  0, -6 ]
      uy = [  0, 6, 0, -6,  0 ]

      USERSYM, ux, uy, /FILL
      OPLOT, lines[0:nlat-1].jday, xd[*]*Ag.vmrscl, PSYM=8, SYMSIZE=0.2

   ENDFOR

   RETURN, 0

END

; plot monthly average columns over all time ------------------------------------------------------

FUNCTION plotmonthly, mavg, nobmnth, toPS, ppos, psiz, Ag, xticks, cbtitle, xtickv, $
                      latrng, ct, lthick, pdes

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotMonthly : plot Total Columns vs time over all years...'

	COMMON COM, y1, y2, maxline

   !P.MULTI = 0
   gpos = FLTARR(3,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.42, 0.98, 0.86]
      gpos[2,*] = [0.05, 0.07, 0.98, 0.40]
   ENDIF ELSE BEGIN
      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],    $
              title='Monthly Average Total Columns',    $
              XPOS = ppos[0], YPOS = ppos[1]

      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.42, 0.95, 0.82]
      gpos[2,*] = [0.10, 0.10, 0.95, 0.40]

   ENDELSE

   LOADCT, ct, /SILENT

   dex = WHERE( mavg[0:nobmnth-1].jld NE 0., cnt )

	A = mavg[dex].jld
	B = mavg[dex].avg
	C = mavg[dex].std

   IF( SIZE( A, /DIMENSIONS) EQ 0 )THEN BEGIN
      XYOUTS, 0.5, 0.5, 'No Monthly Data to plot.', /NORMAL
      RETURN, 1
   ENDIF

   title = 'NDACC/NCAR FTS Monthly Mean Total Column for ' + Ag.smol

   PLOT, A, B*Ag.colscl, /NODATA, $
   		POSITION = gpos[1,*], TITLE=title, $
         XTICKFORMAT = 'LABEL_DATE',                                      $
         XSTYLE = 1, XTICKS=xticks, XMINOR=12, YSTYLE=1, XRANGE = latrng,    $
         YTITLE = 'Total Column ' + '!C!C x' + STRING( Ag.colscl, FORMAT='(g0.0)') + '[molec/cm!U2!N]', $
         XTICKLEN=0.05,     $
         CHARSIZE=1.4, YTICKLEN=0.01, YRANGE=Ag.avgcolrng, XTICKV=xtickv

	FOR i=0, cnt-1 DO BEGIN
		OPLOT, [A[i]-15., A[i]+15.], [B[i],      B[i]     ]*Ag.colscl
		OPLOT, [A[i],     A[i]    ], [B[i]-C[i], B[i]+C[i]]*Ag.colscl
	ENDFOR

	rc = ycycle( mavg, nobmnth, Ag, 1, toPS, span, D )

RETURN, 0 ; plotmonthly
END


; plot all troposphere mean vmr & SD  vs  doy  ----------------------------------------------------

FUNCTION plotdoyV, lines, linpc, alt, Ag, toPS, ppos, psiz, lthick, nlat, prtitle, ct

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotDOYV : plot mean troposphere VMR & SD vs DOY...'

   !P.MULTI = [0,0,2,0,0]

   gpos = FLTARR(2,4)

   IF toPS THEN BEGIN
   ;  ERASE ;                                       first plot so no erase
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.07, 0.98, 0.86]

   ENDIF ELSE BEGIN
      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.10, 0.95, 0.82]
      ppos = ppos +  [ 20,  -20, 1 ]                  ; increments up w/ each plot
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],    $
              title='PlotDOYV: Profile Retrieval Mean Troposphere VMR vs DOY',      $
              XPOS = ppos[0], YPOS = ppos[1]
   ENDELSE

   ; mean trop vmr per measurement
	xd = DBLARR( nlat )

	idx = WHERE( alt LE 8., cnt )
	for i=0, nlat -1 do begin
		x = total( linpc[i].vmr[idx] / lines[i].vmr[idx] ) ; sum airmass
		xd[i] = total( linpc[i].vmr[idx] ) / x
	endfor

   ; get average & SD of column for all DOY
   data = DBLARR(4,366)
   ndoy = 0
   FOR i=0, 366-1 DO BEGIN
      idx = WHERE( lines[*].doy EQ i, cnt )

      IF( cnt EQ 0 ) THEN CONTINUE

      ndoy = ndoy +1
      IF( cnt EQ 1 ) THEN BEGIN

         data[0,ndoy] = i
         data[1,ndoy] = 1
         data[2,ndoy] = xd[idx[0]]
         data[3,ndoy] = xd[idx[0]] * 0.05

      ENDIF ELSE BEGIN

         data[0,ndoy] = i
         data[1,ndoy] = cnt
         m = MOMENT( xd[idx], /DOUBLE )
         data[2,ndoy] = m[0]
         data[3,ndoy] = SQRT( m[1] )

      ENDELSE

   ENDFOR

   PLOT, data[0,0:ndoy], (data[2,0:ndoy]+data[3,0:ndoy])*Ag.vmrscl, YRANGE = Ag.avrng, $
         YTITLE = ' Mixing Ratio for:!C' + Ag.smol + '' +Ag.vmrunits, $
         CHARSIZE = 1.4, PSYM = 2, TITLE = 'Mean for Day of Year', $
         XTITLE = 'DAY OF YEAR', XRANGE = [0,365], XSTYLE=1, /NODATA, YSTYLE=1

   FOR i=0, ndoy DO BEGIN
		OPLOT, [data[0,i]-0.5,data[0,i]+0.5], [data[2,i],data[2,i]]*Ag.vmrscl
		OPLOT, [data[0,i],data[0,i]], [data[2,i]-data[3,i],data[2,i]+data[3,i]]*Ag.vmrscl
	ENDFOR

; second plot monthly average
   months = 12
	mdata  = DBLARR(4, months+1) ; added +1 to cope with December - not a problem at TAB, but important for MLO 5/2010 RB
	nmon   = 0
   FOR j = 1, months DO BEGIN

		idx = WHERE( FIX(STRMID(lines[*].date, 0, 2 )) EQ j, cnt )
		;PRINT, ' Month : ', j, ' No. of profiles : ', cnt

      IF( cnt EQ 0 ) THEN CONTINUE

      nmon = nmon +1
      IF( cnt EQ 1 ) THEN BEGIN

         mdata[0,nmon] = JULDAY( j, 15, 2005, 12, 0, 0 )  - JULDAY( 1, 1, 2005, 0, 0, 0 ) +1
         mdata[1,nmon] = 1
         mdata[2,nmon] = xd[idx[0]]
         mdata[3,nmon] = xd[idx[0]] * 0.2

      ENDIF ELSE BEGIN

         mdata[0,nmon] = JULDAY( j, 15, 2005, 12, 0, 0 )  - JULDAY( 1, 1, 2005, 0, 0, 0 ) +1
         mdata[1,nmon] = cnt
         m = MOMENT( xd[idx], /DOUBLE )
         mdata[2,nmon] = m[0]
         mdata[3,nmon] = SQRT( m[1] )

      ENDELSE

	;print, j, nmon, mdata[*,nmon]

	ENDFOR ; j

	PLOT, mdata[0,0:nmon], (mdata[2,0:nmon]+mdata[3,0:nmon])*Ag.vmrscl, YRANGE = Ag.avrng, $
		YTITLE = ' Mixing Ratio for:!C' + Ag.smol + ''+Ag.vmrunits, $
		CHARSIZE = 1.4, PSYM=2, /NODATA, TITLE = 'Mean for Month', $
		XTITLE = 'DAY OF YEAR', XRANGE = [0,365], XSTYLE=1, YSTYLE=1

   FOR i=0, nmon DO BEGIN

		OPLOT, [mdata[0,i]-15.,mdata[0,i]+15.], [mdata[2,i],mdata[2,i]]*Ag.vmrscl
		OPLOT, [mdata[0,i],mdata[0,i]], [mdata[2,i]-mdata[3,i],mdata[2,i]+mdata[3,i]]*Ag.vmrscl

	ENDFOR

   RETURN, 0

END


; plot all columns & SD  vs  doy  ------------------------------------------------------------------

FUNCTION plotdoyC, lines, alt, Ag, toPS, ppos, psiz, lthick, nlat, prtitle, ct

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotDOY : plot columns & SD vs DOY...'

   !P.MULTI = [0,0,2,0,0]

   gpos = FLTARR(2,4)

   IF toPS THEN BEGIN
   ;  ERASE ;                                       first plot so no erase
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.07, 0.98, 0.86]

   ENDIF ELSE BEGIN
      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.10, 0.95, 0.82]
      ppos = ppos +  [ 20,  -20, 1 ]                  ; increments up w/ each plot
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],    $
              title='NCAR FTS Profile Retrieval : Mean Total Column of DOY',      $
              XPOS = ppos[0], YPOS = ppos[1]
   ENDELSE

   ; get average & SD f column for all DOY
   data = DBLARR(4,366)
   ndoy = 0
   FOR i=0, 366-1 DO BEGIN
      idx = WHERE( lines[*].doy EQ i, cnt )

      IF( cnt EQ 0 ) THEN CONTINUE

      ndoy = ndoy +1
      IF( cnt EQ 1 ) THEN BEGIN

         data[0,ndoy] = i
         data[1,ndoy] = 1
         data[2,ndoy] = lines[idx[0]].col
         data[3,ndoy] = lines[idx[0]].col * 0.2

      ENDIF ELSE BEGIN

         data[0,ndoy] = i
         data[1,ndoy] = cnt
         m = MOMENT( lines[idx].col, /DOUBLE )
         data[2,ndoy] = m[0]
         data[3,ndoy] = SQRT( m[1] )

      ENDELSE

   ENDFOR

   PLOT, data[0,0:ndoy], data[2,0:ndoy]*Ag.colscl, YRANGE = Ag.avgcolrng, $; POSITION = gpos[1,*], $
         YTITLE = 'Total Column ' + '!C!C x' + string( Ag.colscl, format='(g0.0)') + '[molec/cm!U2!N]', $
         CHARSIZE = 1.4, PSYM=2, TITLE = 'Mean for Day of Year', $
         XTITLE = 'DAY OF YEAR', XRANGE = [0,365], XSTYLE=1, YSTYLE=1

; second plot monthly average
   months = 12
	mdata  = DBLARR(4, months+1) ; added +1 to cope with December - not a problem at TAB, but important for MLO 5/2010 RB
	nmon   = 0
   FOR j = 1, months DO BEGIN

		idx = WHERE( FIX(STRMID(lines[*].date, 0, 2 )) EQ j, cnt )
		PRINT, ' Month : ', j, ' No. of profiles : ', cnt, ' nmon: ', nmon

      IF( cnt EQ 0 ) THEN CONTINUE

      nmon = nmon +1
      IF( cnt EQ 1 ) THEN BEGIN

         mdata[0,nmon] = JULDAY( j, 15, 2005, 12, 0, 0 )  - JULDAY( 1, 1, 2005, 0, 0, 0 ) +1
         mdata[1,nmon] = 1
         mdata[2,nmon] = lines[idx[0]].col
         mdata[3,nmon] = lines[idx[0]].col * 0.2

      ENDIF ELSE BEGIN

         mdata[0,nmon] = JULDAY( j, 15, 2005, 12, 0, 0 )  - JULDAY( 1, 1, 2005, 0, 0, 0 ) +1
         mdata[1,nmon] = cnt
         m = MOMENT( lines[idx].col, /DOUBLE )
         mdata[2,nmon] = m[0]
         mdata[3,nmon] = SQRT( m[1] )

      ENDELSE

	;print, j, nmon, mdata[*,nmon]

	ENDFOR ; j

	PLOT, mdata[0,0:nmon], (mdata[2,0:nmon]+mdata[3,0:nmon])*Ag.colscl, YRANGE = Ag.avgcolrng, $
		YTITLE = 'Total Column ' + '!C!C x' + string( Ag.colscl, format='(g0.0)') + '[molec/cm!U2!N]', $
		CHARSIZE = 1.4, PSYM=2, /NODATA, TITLE = ' Mean for Month', $
		XTITLE = 'DAY OF YEAR', XRANGE = [0,365], XSTYLE=1, YSTYLE=1
   FOR i=0, nmon DO BEGIN

		OPLOT, [mdata[0,i]-15.,mdata[0,i]+15.], [mdata[2,i],mdata[2,i]]*Ag.colscl
		OPLOT, [mdata[0,i],mdata[0,i]], [mdata[2,i]-mdata[3,i],mdata[2,i]+mdata[3,i]]*Ag.colscl

	ENDFOR

   RETURN, 0

END



; Plot partial columns and anomilies in 2 panels -------------------------------------------------------

FUNCTION plotanom, linpc, nlat, latrng, ldex, alt, toPS, ppos, psiz, lthick, ct, Ag, $
                 xticks, xtickv, mol, pcavg, npcday, anomyr, ycrc, npcrange, site

   IF( NOT toPS ) THEN BEGIN
      PRINT, ''
      PRINT, ' PlotAnom : Two panels with cycle/trend fit'
   ENDIF

   !P.MULTI = 2
   gpos = FLTARR(3,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.10, 0.98, 0.45]
      gpos[1,*] = [0.05, 0.55, 0.98, 0.93]
      gpos[2,*] = [0.05, 0.70, 0.98, 0.93]
      csz = 1.0

   ENDIF ELSE BEGIN
      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],          $
              title='NCAR FTS Partial Column Retrieval & Fit Time Series',    $
              XPOS = ppos[0], YPOS = ppos[1]

      gpos[0,*] = [0.10, 0.10, 0.95, 0.45]
      gpos[1,*] = [0.10, 0.55, 0.95, 0.93]
      gpos[2,*] = [0.10, 0.70, 0.95, 0.93]
      csz = 1.0

   ENDELSE

   partc = DBLARR( nlat )
   pcrange = FLTARR(2,3)
   IF( site EQ 'ACF' )THEN BEGIN
	   pcrange = [[ 6.0, 14.0 ], [ 14.0, 19.0 ], [ 19.0, 40.0 ]]
   ENDIF ELSE BEGIN
		pcrange = [[ 0.0, 12.0 ], [ 12.0, 22.0 ], [ 22.0, 40.0 ]]
		pcrange = [[ 0.0, 10.0 ], [ 10.0, 19.0 ], [ 19.0, 30.0 ]]
		pcrange = [[ 0.0,  8.0 ], [  8.0, 16.0 ], [ 16.0, 28.0 ]]
   ENDELSE

   ytitle = 'Partial Column ' + '!C!C x' + string( Ag.colscl, format='(g0.0)') + '[molec/cm!U2!N]'

   j = npcrange

   ;IF( NOT toPS ) THEN BEGIN
      PRINT, ''
      PRINT, '   PlotAnom : Calling mkpcAvg...'
      mkpcdavg, linpc, nlat, ldex, alt, pcavg, npcday, mol, pcrange[0,j], pcrange[1,j], toPS, /noprint
   ;ENDIF
   IF( npcday LT 2 )THEN BEGIN
         XYOUTS, 0.5, 0.5, 'Not enough days to plot.', /NORMAL
      RETURN, 1
   ENDIF


   xcsz = 1
   ;j = 0
   ;IF( j NE 0 )THEN xcsz = 0.001

   ;print, 'anom  ',j, Ag.pcrng[j,*]

   title = 'Partial Column for alt range: ' + STRING( pcrange[*,j], format='(f4.1, "-", f4.1)')
   PLOT, pcavg.jld, pcavg.avg*Ag.colscl, POSITION = gpos[0,*],                			$
            XTICKFORMAT = 'LABEL_DATE',                                       			$
            XSTYLE = 1, XTICKS = xticks, XMINOR = 12, YSTYLE = 1, XRANGE = latrng,     $
            YTITLE = ytitle, PSYM = 3, /NODATA, XTICKLEN = 0.05,     						$
            CHARSIZE = csz, YTICKLEN = 0.01, YRANGE = Ag.pcrng[j,*], XCHARSIZE = csz, 	$
            TITLE = title, XTICKV=xtickv

   ux = [ -6, 0, 6,  0, -6 ]
   uy = [  0, 6, 0, -6,  0 ]

   USERSYM, ux, uy, /FILL
   OPLOT, pcavg[0:npcday-1].jld, pcavg[0:npcday-1].avg*Ag.colscl, PSYM=8, SYMSIZE=0.2

	PRINT, ''
	PRINT, '   PlotAnom : Calling ycycle...for alt range: ' + STRING( pcrange[*,j], format='(f4.1, "-", f4.1)')

   ycrc = ycycle( pcavg, npcday, Ag, 1, toPS, span, A )

   IF( ycrc NE 0 )THEN RETURN, 0

   ; plot differences
   CALDAT, span[0], mm, dd, yy
   j = 1
   jdoff = JULDAY( 1, 1, yy )

   aX = pcavg.jld - jdoff +1
   fit = [A[0] + A[1]*aX + A[2]*COS( 2.0*!PI*( A[3]/365*aX - A[4])) ]

   ;for i=0, npcday-1 do print, pcavg[i].dat, pcavg[i].jld, pcavg[i].avg, pcavg[i].std, fit[i]
   ;help, fit
   ;print, A

   data   =  pcavg[0:npcday-1].avg*Ag.colscl-fit
   mom    = MOMENT( data )

   yrange = [0,0]
   ytitle = 'Difference'
   title  = ' Partial Column - de-annual cycle fit'

   PLOT, pcavg[0:npcday-1].jld, data, POSITION = gpos[1,*],                				$
            XTICKFORMAT = 'LABEL_DATE',                                       			$
            XSTYLE = 1, XTICKS = xticks, XMINOR = 12, YSTYLE = 0, XRANGE = latrng,     $
            YTITLE = ytitle, PSYM = 3, /NODATA, XTICKLEN = 0.05,     						$
            CHARSIZE = csz, YTICKLEN = 0.01, YRANGE = yrange, XCHARSIZE = xcsz, 			$
            TITLE = title, XTICKV=xtickv

   ux = [ -6, 0, 6,  0, -6 ]
   uy = [  0, 6, 0, -6,  0 ]

   USERSYM, ux, uy, /FILL
   OPLOT, pcavg[0:npcday-1].jld, data, PSYM=8, SYMSIZE=0.2

   OPLOT, !X.CRANGE, [0.,0.], color=150

   RETURN, 0

END


;----------------------------------------------------------------------------

PRO mkpcdavg, linpc, nlat, ldex, alt, davg, nobsday, mol, pc1, pc2, toPS, noprint=noprint

COMMON COM, y1, y2, maxline

; if pc1 and pc2 equals 0 then total column
; otherwise use partial column from pc1 to pc2

; average all columns in in a day
; lines - struct with data
; davg - return averages & sdev & # of points in avg & julday
; see dailyavg function for da definition

   ;PRINT, pc1, pc2

   davg = REPLICATE( {da}, maxline )

   adex = WHERE( alt GE pc1 AND  alt LT pc2, count )
	;print, alt[adex]

   ; Sum all partial columns - partc has same indexing as linpc
   partc = DBLARR( nlat +1)
   FOR i=0, nlat-1 DO BEGIN
      partc[ldex[i]] = TOTAL( linpc[ldex[i]].vmr[adex], /DOUBLE )
      ;print, i, ldex[i]
   ENDFOR

	;print, y1, y2
;  loop over all days from 1 Oct y1 to 31 Dec y2
   nobsday = 0
   i = 0l
   FOR i = JULDAY( 1, 1, y1 ), JULDAY( 1, 1, y2 ) DO BEGIN
      ;print, i
      dex = WHERE( FLOOR(linpc[*].jday) EQ i, count )

      IF( count EQ 0 ) THEN CONTINUE

      IF( count EQ 1 ) THEN BEGIN

         davg[nobsday].jld = i
         davg[nobsday].nob = count
         davg[nobsday].avg = partc[dex[0]]
         davg[nobsday].std = partc[dex[0]] * 0.2 ;0.
         davg[nobsday].dat = linpc[dex[0]].date
         nobsday = nobsday +1

      ENDIF ELSE BEGIN

         davg[nobsday].jld = i
         davg[nobsday].nob = count
         m = MOMENT( partc[dex], /DOUBLE )
         davg[nobsday].avg = m[0]
         davg[nobsday].std = SQRT( m[1] )
         davg[nobsday].dat = linpc[dex[0]].date
         nobsday = nobsday +1

      ENDELSE

   ENDFOR

   IF( NOT toPS )THEN BEGIN

      PRINT,''
      PRINT, '  MakePCAvg : Number of Obs days :', nobsday

      ; print out the daily averages in a list
      filename = mol + STRING( pc1, pc2, FORMAT='("_",F04.1, "-", F04.1)' ) + 'pc.dat'
      OPENW, lun1, filename, /GET_LUN

      PRINTF, lun1, 'Partial Column from : ', pc1, ' to ', pc2
      PRINTF, lun1, '   Jul_Day   Column   Column_StdDev    #_Obs   Date'

      FOR i=0, nobsday-1 DO $
         PRINTF, lun1, davg[i].jld, davg[i].avg, davg[i].std, davg[i].nob, davg[i].dat, $
              FORMAT='(i10, 2e13.4, i4, 2x, a )'

      FREE_LUN, lun1

      ;PRINT, '   Partial Column from : ', pc1, ' to ', pc2
      ;PRINT,''
      ;PRINT, '    MAR       APR       MAY       JUN      JUL       AUG      SEP      OCT'

   ENDIF

   ; Create monthly averages
   IF(NOT KEYWORD_SET( noprint )) THEN BEGIN
   	IF( NOT toPS )THEN PRINT, 'Year MAR                   APR                   MAY                   JUN                   JUL                   AUG                   SEP                   OCT'
		i = 0L
		FOR i=y1, y2 DO BEGIN
			IF( NOT toPS )THEN PRINT, i, FORMAT='(i4,1x,$)'
			m=0L
			FOR m=3L, 10 DO BEGIN
				maxn = 31L
				IF( m EQ 9 )THEN maxn=30L
				IF( m EQ 4 )THEN maxn=30L
				IF( m EQ 6 )THEN maxn=30L

				dex = WHERE( linpc[*].jday GE JULDAY( m, 1, i ) AND linpc[*].jday LE JULDAY( m, maxn, i), cnt )

				IF( cnt EQ 0 ) THEN BEGIN
					mm = DBLARR(5)
				ENDIF ELSE IF ( cnt EQ 1 ) THEN BEGIN
					mm[0] = partc[dex]
					mm[1] = 0.
					ncol  = cnt
				ENDIF ELSE BEGIN
					mm = MOMENT( partc[dex], /DOUBLE )
					ncol = cnt
				ENDELSE

				IF( NOT toPS )THEN PRINT, mm[0], SQRT(mm[1]), cnt, FORMAT='(2e9.2,i4,$)'

			ENDFOR
			IF( NOT toPS )THEN PRINT, ''

		ENDFOR
	ENDIF
END



; plot all profiles on a vmr vs alt plot one month in one panel -----------------------------------------

FUNCTION plotprfM, lines, alt, Ag, toPS, ppos, psiz, lthick, nlat, prtitle, ct, nalt, months, site

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotPrfm : plot monthly mean profiles...'

   !P.MULTI = [4,2,2,0,0]
   gpos = FLTARR(2,4)

   ; Loop over 2 plot windows - 8 months for Thule
   IF( site EQ 'TAB' )THEN BEGIN
	   month = 2
	   npage = 1
	ENDIF ELSE BEGIN
	   month = 0
	   npage = 2
	ENDELSE

   xrange = Ag.mnthrng
   ;xrange = [MIN(lines[0:nlat-1].vmr[*]*Ag.vmrscl), MAX(lines[0:nlat-1].vmr[*]*Ag.vmrscl)]

   FOR i=0, npage DO BEGIN

      IF toPS THEN BEGIN
         ERASE

      ENDIF ELSE BEGIN

         ppos = ppos +  [ 20,  -20, 1 ]
         WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],    $
                 title='NCAR FTS Profile Retrieval Monthly Mean #' + STRING( i+1, FORMAT='(i2)'),     $
                 XPOS = ppos[0], YPOS = ppos[1]
      ENDELSE

      ; Loop over 4 plots per window
      FOR j=0, 3 DO BEGIN

         month = month +1
         ;PRINT, ' Month : ', month, ' No. of profiles : ',STRMID(lines[*].date, 0, month )
         idx = WHERE( FIX(STRMID(lines[*].date, 0, 2 )) EQ month, cnt )
         ;print, month, cnt
         ;IF( cnt LE 0 )THEN CONTINUE ;STOP, 'plotprfm error 1'
         IF( NOT toPS )THEN PRINT, '    Plotprfm : Month : ',  months[month-1], ' No. of profiles     : ', cnt

         v = DBLARR( 3, nalt )
         if( cnt LE 0 ) then begin
					v[0,*] = 0.
					v[1,*] = 0.
         endif else if( cnt GT 1 ) then begin
				FOR k=0, nalt-1 DO BEGIN
					r = MOMENT( lines[idx].vmr[k], sdev=sdev, /DOUBLE )
					v[0,k] = r[0]
					v[1,k] = sdev
				ENDFOR
			endif else begin
					v[0,*] = lines[idx].vmr[0:nalt-1]
					v[1,*] = 0.
			endelse
			      v[2,0] = cnt

         PLOT, v[0,*]*Ag.vmrscl, alt, YRANGE = Ag.altrng,  $
               YTITLE='Altitude [km]', CHARSIZE = 1.2,                  $
               XTITLE=' Mixing Ratio for ' + Ag.smol + Ag.vmrunits + '!Cfor ' + months[month-1] + ' n=' + string(v[2,0], format='(i3)'),   $
               XRANGE=xrange

         FOR k=0, nalt-1 DO BEGIN

            OPLOT,([-v[1,k], v[1,k]]+v[0,k])*Ag.vmrscl, [alt[k],alt[k]]

         ENDFOR ; k

      ENDFOR ; j

   ENDFOR ; i

   RETURN, 0

END


; Plot partial columns in 3 panels ------------------------------------------------------------------

FUNCTION plotpc, linpc, nlat, latrng, ldex, alt, toPS, ppos, psiz, lthick, ct, Ag, $
                 xticks, xtickv, mol, site

; plot daily average partial columns

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotPC : plot 3 partial columns...'

   !P.MULTI = 3
   gpos = FLTARR(3,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.10, 0.98, 0.33]
      gpos[1,*] = [0.05, 0.40, 0.98, 0.63]
      gpos[2,*] = [0.05, 0.70, 0.98, 0.93]
      csz = 2.0

   ENDIF ELSE BEGIN
      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],          $
              title='NCAR FTS Partial Column Retrieval Time Series',    $
              XPOS = ppos[0], YPOS = ppos[1]

      gpos[0,*] = [0.10, 0.10, 0.95, 0.33]
      gpos[1,*] = [0.10, 0.40, 0.95, 0.63]
      gpos[2,*] = [0.10, 0.70, 0.95, 0.93]
      csz = 2.0

   ENDELSE

   partc = DBLARR( nlat )
   pcrange = FLTARR(2,3)
   IF( site EQ 'ACF' )THEN BEGIN
	   pcrange = [[ 6.0, 14.0 ], [ 14.0, 19.0 ], [ 19.0, 40.0 ]]
   ENDIF ELSE BEGIN
		pcrange = [[ 0.0, 12.0 ], [ 12.0, 22.0 ], [ 22.0, 40.0 ]]
		pcrange = [[ 0.0, 10.0 ], [ 10.0, 19.0 ], [ 19.0, 30.0 ]]
		pcrange = [[ 0.0,  8.0 ], [  8.0, 16.0 ], [ 16.0, 28.0 ]]
   ENDELSE

   ytitle = Ag.smol + ' Partial Column ' + '!C!C x' + string( Ag.colscl, format='(g0.0)') + '[molec/cm!U2!N]'
   ;yrange = [0., 10.] ;[0., 0.]

   FOR j=0, 2 DO BEGIN

      xcsz = 1
      IF( j NE 0 )THEN xcsz = 0.001

      title = 'Partial Column for alt range: ' + STRING( pcrange[*,j], format='(f4.1, "-", f4.1)')
      IF( NOT toPS )THEN BEGIN
         PRINT, ''
         PRINT, '   ', title
      ENDIF

      mkpcdavg, linpc, nlat, ldex, alt, pcavg, npcday, mol, pcrange[0,j], pcrange[1,j], toPS

      PLOT, pcavg[0:npcday].jld, pcavg[0:npcday].avg*Ag.colscl, POSITION = gpos[j,*],              $
            XTICKFORMAT = 'LABEL_DATE',                                       $
            XSTYLE = 1, XTICKS = xticks, XMINOR = 12, YSTYLE = 1, XRANGE = latrng,     $
            YTITLE = ytitle, PSYM = 3, /NODATA, XTICKLEN = 0.05,     $
            CHARSIZE = csz, YTICKLEN = 0.01, YRANGE = Ag.pcrng[j,*], XCHARSIZE = xcsz, $
            TITLE = title, XTICKV=xtickv

      ux = [ -6, 0, 6,  0, -6 ]
      uy = [  0, 6, 0, -6,  0 ]

      USERSYM, ux, uy, /FILL
      OPLOT, pcavg[0:npcday].jld, pcavg[0:npcday].avg*Ag.colscl, PSYM=8, SYMSIZE=0.2

   ENDFOR

   RETURN, 0

END


; plot hf ratio with same X - axis  ---------------------------------------------------------------------------

FUNCTION plotratio, hfratio, nratio, latrng, toPS, ppos, psiz, lthick, ct, xticks, xtickv

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotRatio : plot ratio of total column with HF total column...'

   !P.MULTI = 0
   gpos = FLTARR(3,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.42, 0.98, 0.86]
      gpos[2,*] = [0.05, 0.07, 0.98, 0.40]
   ENDIF ELSE BEGIN
      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],    $
              title='Ratio with HF Day Average Total Column',     $
              XPOS = ppos[0], YPOS = ppos[1]

      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.42, 0.95, 0.82]
      gpos[2,*] = [0.10, 0.10, 0.95, 0.40]

   ENDELSE

   LOADCT, ct, /SILENT

   PLOT, hfratio[*,0], hfratio[*,1], POSITION = gpos[1,*],              $
         XTICKFORMAT='LABEL_DATE',                                      $
         XSTYLE=1, XTICKS=xticks, XMINOR=12, YSTYLE=0, XRANGE = latrng, $
         YTITLE='Ratio with HF', PSYM=3, /NODATA, XTICKLEN=0.05,        $
         CHARSIZE=1.4, YTICKLEN=0.01, YRANGE=[0,0], XTICKV=xtickv

   ux = [ -6, 0, 6,  0, -6 ]
   uy = [  0, 6, 0, -6,  0 ]

   USERSYM, ux, uy, /FILL
   OPLOT, hfratio[0:nratio-1,0], hfratio[0:nratio-1,1], PSYM=8, SYMSIZE=0.2

   RETURN, 0

END


; plot pv with same X - axis  ---------------------------------------------------------------------------

FUNCTION plotpv, pvd, pv, npv, latrng, toPS, ppos, psiz, lthick, ct, xticks, xtickv

   IF( NOT toPS )THEN PRINT, ''
   IF( NOT toPS )THEN PRINT, '  PlotPV : plot potential vorticity...'

   !P.MULTI = 0
   gpos = FLTARR(3,4)

   IF toPS THEN BEGIN
      ERASE
      gpos[0,*] = [0.05, 0.93, 0.98, 0.99]
      gpos[1,*] = [0.05, 0.42, 0.98, 0.86]
      gpos[2,*] = [0.05, 0.07, 0.98, 0.40]
   ENDIF ELSE BEGIN
      ppos = ppos +  [ 20,  -20, 1 ]
      WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],    $
              title='Potential Vorticity',    $
              XPOS = ppos[0], YPOS = ppos[1]

      gpos[0,*] = [0.10, 0.87, 0.95, 0.92]
      gpos[1,*] = [0.10, 0.42, 0.95, 0.82]
      gpos[2,*] = [0.10, 0.10, 0.95, 0.40]

   ENDELSE

   LOADCT, ct, /SILENT

   PLOT, pvd[0:npv-1], pv[0:npv-1]*1.0e6, POSITION = gpos[1,*],            $
         XTICKFORMAT='LABEL_DATE',                                      $
         XSTYLE=1, XTICKS=xticks, XMINOR=12, YSTYLE=1, XRANGE = latrng,    $
         YTITLE='EPV*10^6 PT=440K', PSYM=3, /NODATA, XTICKLEN=0.05,     $
         CHARSIZE=1.4, YTICKLEN=0.01, YRANGE=[10.,30], XTICKV=xtickv

   ux = [ -6, 0, 6,  0, -6 ]
   uy = [  0, 6, 0, -6,  0 ]

   USERSYM, ux, uy, /FILL
   OPLOT, pvd[0:npv-1], pv[0:npv-1]*1.0e6, PSYM=8, SYMSIZE=0.2

   RETURN, 0

END
