      MODULE DATAFILES

      USE PARAMS

      IMPLICIT NONE

      CHARACTER*(IFLNMSZ) :: TFILE(100), LINDIR
!
!      								 TFIL07, &      ! - OBSOLETE- PT INPUT
!                              TFIL08, &      ! PBPFILE - OUTPUT SPECTRA, FITS AND DIFFERENCES
!                              TFIL09, &      ! ISOTOPE INPUT FILE - OBSOLETE MIX
!                              TFIL10, &      ! SOLAR LINE DATA
!                              TFIL12, &      ! OBSOLETE - MASS PATH
!                              TFIL13, &      !
!                              TFIL14, &      ! INTERNAL TO LINEPARAM - CFGL FILE
!                              TFIL15, &      ! T15ASC SPECTRA INPUT
!                              TFIL16, &      ! DETAIL
!                              TFIL17, &      ! STATEVEC.MXF FINAL MIXING RATIOS
!                              TFIL18, &      ! STATEVEC
!                              TFIL19, &      ! SYNTHETIC SPECTRUM OUTPUT
!                              TFIL20, &      ! SUMMARY
!                              TFIL21, &      !
!                              TFIL22, &      ! STATEVEC.PRC FINAL PARTIAL COLUMNS
!                              TFIL23, &      ! EMPIRICAL MODULATION FUNCTION
!                              TFIL24, &      ! EMPIRICAL PHASE FUNCTION
!                              TFIL30, &      ! CHNSPEC.OUT1 - COMPUTE CHANNEL SPECTRUM
!                              TFIL31, &      ! STATEVEC.ST - SHORT OUTPUT
!                              TFIL40, &      ! CHNSPEC.OUT2 - COMPUTE CHANNEL SPECTRUM
!                              TFIL61, &      ! SA OUTPUT
!                              TFIL62, &      ! SAINV INPUT
!                              TFIL63, &      ! COMPLETE SA OUTPUT
!                              TFIL64, &      ! FULL SA INPUT
!                              TFIL66, &      ! K.OUT JACOBIAN, SA, SE, SAINV
!                              TFIL67, &      ! SE.OUT
!                              TFIL68, &      ! KT.OUT INVERSE JACOBIAN OUTPUT
!                              TFIL70, &      ! DETAIL.OPT - OE DETAIL OUTPUT
!                              TFIL71, &      ! STATION.LAYERS INPUT LEVELS AND MIDPOINTS
!                              TFIL72, &      ! ZPT + REFMOD INPUT VMR PROFILES
!                              TFIL73, &      ! RAYTRACE.OUT AKA TAPE6
!                              TFIL74, &      ! PRESSURE - TEMPERATURE
!                              TFIL75, &      ! MASS PATHS
!                              TFIL76, &      ! MIXING RATIOS
!                              TFIL77, &      ! LAYER BASED SA
!                              TFIL78, &      ! REYTRACE PUNCH OUTPUT
!                              TFIL81, &      ! AK OUTPUT
!                              TFIL82, &      ! MEASUREMENT ERROR OUTPUT
!                              TFIL83, &      ! SMOOTHING ERROR OUTPUT
!                              TFIL84, &      ! AK SMOOTHING ERROR OUTPUT
!                              TFIL85, &      ! AK EIGENVECTORS ERROR OUTPUT
!                              TFIL88, &      ! OUTPUT PROFILES FOR FIRST GAS IN TABLE FORM
!                              TFIL89, &      ! STATEVECTOR PARAMETERS BY ITERATION OUTPUT
!                              TFIL91, &      ! spectra by iteration
!                              LINDIR, &

      INTEGER :: NCHAR

      CONTAINS

!----------------------------------------------------------------------
      SUBROUTINE FILESETUP

!      INTEGER :: I

! --- SET DEFAULT FILENAMES

      TFILE(08) = 'pbpfile'

! --- ISOTOPE SEPARATION FILE
      TFILE(09) = 'isotope.input'

      TFILE(15) = 't15asc'

      TFILE(16) = 'detail'

! --- STATEVEC
      TFILE(18) = 'statevec'

! --- SET MIXOUTPUT FILENAME AS STATE VECTOR FILENAME + .MXF
      TFILE(17) = TRIM(TFILE(18))//'.mxf'

! --- SAVED SYNTHETIC SPECTRUM
      TFILE(19) = 'synspec.out'

! --- SUMMARY
      TFILE(20) = 'summary'

! --- SET PARTICAL COLUMN OUTPUT FILENAME AS STATE VECTOR FILENAME + .PRC
      TFILE(22) = TRIM(TFILE(18))//'.prc'

! --- EMPIRICAL MODULATION FUNCTION
      TFILE(23) = 'ils.dat'

! --- EMPIRICAL PHASE FUNCTION
      TFILE(24) = 'ils.dat'

! --- CHANNEL OUTPUT
      TFILE(30) = 'chnspec.data1'

      TFILE(40) = 'chnspec.data2'

! --- SET SHORT FILENAME AS SUMMARY FILENAME + .ST
      TFILE(31) = TRIM(TFILE(20))//'.st'

! --- DEFAULT FIRST RETRIEVAL GAS SA OUTPUT FILENAME
! --- OUTPUT DEPENDS ON NAME SA .NORM, .VMR, .PCOL
      TFILE(61) = 'Sa.norm'

! --- DEFAULT SAINV INPUT FILENAME
      TFILE(62) = 'Sainv.input'

! --- DEFAULT COMPLETE SA OUTPUT FILENAME
      TFILE(63) = 'Sa.complete'

! --- DEFAULT K,SE,SA MATRICES OUTPUT FILENAME
      TFILE(66) = 'K.out'

! --- SE OUTPUT
      TFILE(67) = 'Se.out'

! --- DEFAULT K TRANSPOSED FILENAME
      TFILE(68) =  'KT.out'

! ---  LEVENBERG-MARQUARDT DETAILS
      TFILE(70) = 'detail.opt'

! --- LAYERING SCHEME - OUTPUT FROM WACCM PROFILES
      TFILE(71) = 'station.layers'

! --- REFERENCE VMR PROFILES
      TFILE(72) = 'reference.prf'

! --- RAYTRACE DETAILED OUTPUT AKA TAPE6
      TFILE(73) = 'raytrace.out'

      TFILE(74) = 'raytrace.pt'
      TFILE(75) = 'raytrace.ms'
      TFILE(76) = 'raytrace.mix'
      TFILE(77) = 'raytrace.sa'
      TFILE(78) = 'raytrace.pnch'

! --- RESERVED FOR GASOUT NAME CHANGES - SEE FRWDMDL.F90
      !TFILE(80)

      TFILE(81) = 'AK.out'
      TFILE(82) = 'SM.out'
      TFILE(83) = 'SS.out'
      TFILE(84) = 'A-S.out'
      TFILE(85) = 'AEIGEN.out'

      TFILE(88) = 'PRFS.out'
      TFILE(89) = 'Parm.out'

      TFILE(91) = 'Spec.out'

      RETURN

      END SUBROUTINE FILESETUP


      SUBROUTINE FILEOPEN (INDEX, SW )

      INTEGER, INTENT(IN) :: INDEX, SW
      INTEGER             :: IOS

! --- OPEN NORMAL FILES 31, 18, 20, 73

      IF(( INDEX .LT. 1 ) .OR. ( INDEX .GT. 100 ))THEN
         PRINT *, 'DATAFILES: FILEOPEN: LUN INDEX : ', INDEX, '  OUT OF RANGE.'
         STOP 'ERROR'
      ENDIF

      SELECT CASE (SW)
         CASE (1)
! --- NEW FILE FOR OUTPUT
            OPEN(UNIT=INDEX, FILE=TFILE(INDEX), STATUS='UNKNOWN', IOSTAT=IOS, POSITION='ASIS')
            IF( IOS .NE. 0 )THEN
               WRITE(16,106) INDEX, TRIM(TFILE(INDEX)), IOS
               WRITE( 0,106) INDEX, TRIM(TFILE(INDEX)), IOS
               STOP 'FILEOPEN ERROR...SEE DETAIL FILE'
            ENDIF

         CASE( 2 )
! --- NEW FILE FOR OUTPUT - REPLACE
            OPEN(UNIT=INDEX, FILE=TFILE(INDEX), STATUS='REPLACE', IOSTAT=IOS, POSITION='ASIS')
            IF( IOS .NE. 0 )THEN
               WRITE(16,106) INDEX, TRIM(TFILE(INDEX)), IOS
               WRITE( 0,106) INDEX, TRIM(TFILE(INDEX)), IOS
               STOP 'FILEOPEN ERROR...SEE DETAIL FILE'
            ENDIF

         CASE( 3 )
! --- OLD FILE FOR INPUT
            OPEN(UNIT=INDEX, FILE=TFILE(INDEX), STATUS='OLD', IOSTAT=IOS, POSITION='ASIS')
            IF( IOS .NE. 0 )THEN
               WRITE(16,105) INDEX, TRIM(TFILE(INDEX)), IOS
               WRITE( 0,105) INDEX, TRIM(TFILE(INDEX)), IOS
               STOP 'FILEOPEN ERROR...SEE DETAIL FILE'
            ENDIF

         CASE DEFAULT
             PRINT *, 'DATAFILES: FILEOPEN: SWITCH, ', SW, '  OUT OF RANGE.'
             STOP 'ERROR'
       END SELECT


 105  FORMAT(/,' FILEOPEN: INPUT FILE OPEN ERROR-UNIT : ',I5, ' FILENAME: "',A,'"', ' IOSTAT: ', I5)
 106  FORMAT(/,' FILEOPEN: OUTPUT FILE OPEN ERROR-UNIT : ',I5, ' FILENAME: "',A,'"', ' IOSTAT: ', I5)


      END SUBROUTINE FILEOPEN


      SUBROUTINE FILECLOSE( INDEX, SW )

      INTEGER, INTENT(IN) :: INDEX, SW
      LOGICAL             :: FILOPEN = .FALSE.
      INTEGER             :: IOS

      IF(( INDEX .LT. 1 ) .OR. ( INDEX .GT. 100 ))THEN
         PRINT *, 'DATAFILES: FILECLOSE: LUN INDEX : ', INDEX, '  OUT OF RANGE.'
         STOP 'ERROR'
      ENDIF


      SELECT CASE( SW )
         CASE( 1 )
! --- OUTPUT FILE
            INQUIRE( UNIT=INDEX, OPENED=FILOPEN )
            IF( FILOPEN )CLOSE(UNIT=INDEX, IOSTAT=IOS)
            IF( IOS .NE. 0 )THEN
               WRITE(16,106) INDEX, TRIM(TFILE(INDEX)), IOS
               WRITE( 0,106) INDEX, TRIM(TFILE(INDEX)), IOS
               STOP 'FILECLOSE ERROR...SEE DETAIL FILE'
            ENDIF

         CASE( 2 )
! --- INPUT FILE
            INQUIRE( UNIT=INDEX, OPENED=FILOPEN )
            IF( FILOPEN )CLOSE(UNIT=INDEX, IOSTAT=IOS)
            IF( IOS .NE. 0 )THEN
               WRITE(16,105) INDEX, TRIM(TFILE(INDEX)), IOS
               WRITE( 0,105) INDEX, TRIM(TFILE(INDEX)), IOS
               STOP 'FILECLOSE ERROR...SEE DETAIL FILE'
            ENDIF


         CASE DEFAULT
             PRINT *, 'DATAFILES: FILECLOSE: SWITCH, ', SW, '  OUT OF RANGE.'
             STOP 'ERROR'
       END SELECT

 105  FORMAT(/,' FILECLOSE: INPUT FILE CLOSE ERROR-UNIT : ',I5, ' FILENAME: "',A,'"', ' IOSTAT: ', I5)
 106  FORMAT(/,' FILECLOSE: OUTPUT FILE CLOSE ERROR-UNIT : ',I5, ' FILENAME: "',A,'"', ' IOSTAT: ', I5)


      END SUBROUTINE FILECLOSE

      END MODULE DATAFILES
