module convert_old_data_files

use params
use bandparam
use retvparam
implicit none

contains

  subroutine convert_spec_data(spc_file, new_spc_file)
    implicit none

    character (len=*), intent(in) :: spc_file, new_spc_file
    !real(double), intent(in) :: lat
    character (len=255) :: header

    real(double) :: a, b, er
    real(double) :: nu, nu1, nu2, res
    integer :: num_e, iostat, n, m, l

    open(30, FILE=spc_file)
    open(31, FILE=new_spc_file)

    print *, '  ***inserting bogus values into ascii spectrum file. --- please change!'
    print *, '  ***inserting bogus astro_SZA, earth_radius, n_lat_deg e_lon_deg!'
    print *, '  ***inserting bogus yyyy mh dd hh mm seconds too!'

    ! this is wrong earth radius
    a = 6378.1370
    b = 6356.7523
    er = (a+b)/2.

    do m=1,nspec
       do l=1,nband
          read(30,'(a)',IOSTAT=iostat) header
          read(30, *) nu1, nu2, res, num_e
          write(31, '(f10.2, f10.2, 2f10.4)') dble(ispec(m))/100.0, er, 45.0, 0.0
          write(31, '(5I10, f10.2)') 2000, 6, 15, 12, 30, 30.0
          write(31,*) trim(header)
          write(31,'(f15.6,f15.6,e25.15,i10)') nu1, nu2, res, num_e
          do n=1,num_e
             read(30,*) nu
             write(31,'(e15.6)') nu
          end do
       end do
    end do
    close(30)
    close(31)

  end subroutine convert_spec_data
end module convert_old_data_files
