module binput_parse_4_0

  use params
  use retvparam
  use bandparam
  use lineparam
  use solar
  use channel
  use initialize
  use opt
  use datafiles
  use isotope
  use writeout

  implicit none;
  save

  character (len=255), dimension(5) :: keyword
  character (len=1023) :: value


contains

  subroutine read_file_section(keyword, value)

    implicit none

    character (len=*), dimension(*),intent(in) :: keyword
    character (len=*),intent(in) :: value

    select case(trim(adjustl(keyword(2))))
    case ('stalayers')
       tfile(71) = trim(adjustl(value))
!    case ('masspath')
!       tfile(07) = trim(adjustl(value))
!    case ('pt')
!       tfile(09) = trim(adjustl(value))
!    case ('mix')
!       tfile(12) = trim(adjustl(value))
    case ('spectrum')
       tfile(15) = trim(adjustl(value))
    case ('detail')
       tfile(16) = trim(adjustl(value))
    case ('pbpfile')
       tfile(08) = trim(adjustl(value))
    case ('statevec')
       tfile(18) = trim(adjustl(value))
    case ('eap_dat')
       tfile(23) = trim(adjustl(value))
    case ('ephs_dat')
       tfile(24) = trim(adjustl(value))
    case ('sa_matrix')
       tfile(62) = trim(adjustl(value))
    case ('isotope')
       tfile(09) = trim(adjustl(value))
    case ('summary')
       tfile(20) = trim(adjustl(value))
    case ('linelist')
       tfile(14) = trim(adjustl(value))
    case ('solarlines')
       tfile(10) = trim(adjustl(value))
    case ('refprofile')
       tfile(72) = trim(adjustl(value))
    end select
  end subroutine read_file_section


  subroutine read_gas_section(keyword, value)

    implicit none

    character (len=*), dimension(*),intent(in) :: keyword
    character (len=*),intent(in) :: value
    character (len=255) :: val
    integer pos, nr
    logical :: flag


    val = trim(adjustl(value))

    if (trim(keyword(2)).eq.'layers')then
           !print*,8
       read(value,*) nlayers
    end if
    !print *, 'nlayers read : ', nlayers

    if (len_trim(keyword(2)).eq.0) then
       nret = 0
       pos = index(adjustl(val),' ')
!       write(*,*) val, pos
       if (pos.eq.0) write(*,*) 'No gas given in binput?'
       do
          if (len_trim(val).eq.0) exit
          nret = nret + 1
          if (pos.gt.0) then
             gas(nret) = trim(adjustl(val(1:pos)))
          else
             gas(nret) = trim(adjustl(val(1:len_trim(val))))
             exit
          end if
          val = adjustl(val(pos+1:len(val)))
          pos = index(trim(adjustl(val)),' ')
       end do
    end if


    flag = .false.
    do nr=1,nret
       if (trim(adjustl(gas(nr))).eq.trim(adjustl(keyword(2)))) then
          flag = .true.
          exit
       end if
    end do
    if (.not.flag) then
       return
    end if

    select case (trim(adjustl(keyword(3))))
    case ('ifprf')
       !print*,1, nr
       read(value,*) ifprf(nr)
    case ('ifoff')
       !print*,7, nr
       read(value,*) ifoff(nr)
    case ('sigma')
       !print*,6, nr, ifprf(nr)
       if( ifprf(nr) )then
          read(value,*) sig(1:nlayers, nr)
       else
          read(value,*) colsf(nr), scolsf(nr)
       endif
    case ('zwid')
       !print*,5, nr
       !print *,trim(value)
       read(value,*) zwid(nr)
       !print *, junk, shape(zwid)
       !print *, zwid(nr), nr
    case ('zmin')
       !print*,4, nr
       read(value,*) zgmin(nr)
    case ('zmax')
       !print*,3
       read(value,*) zgmax(nr)
    case ('logstate')
       !print*,2
       read(value,*) log_statev(nr)
       if (log_statev(nr))then
          ilogretrieval(nr) = 1
       else
          ilogretrieval(nr) = 0
       end if
    end select

  end subroutine read_gas_section

  subroutine read_fw_section(keyword, value)

    implicit none
    character (len=*), dimension(*),intent(in) :: keyword
    character (len=*),intent(in) :: value

    integer pos
    character (len=1023) :: val

    select case (trim(adjustl(keyword(2))))
    case ('write_gasfiles')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) f_wrtgasfiles
       else
          select case (trim(adjustl(keyword(3))))
          case ('type')
             read(value,*) gasouttype
          end select
       end if
    case ('write_k')
       read(value,*) f_wrtk
    case ('ifiso')
       read(value,*) useiso
    case ('delnu')
       read(value,*) delnu
    case('lshapemodel')
       read(value,*) lshapemodel
    case('linemixing')
       if (len_trim(keyword(3)).eq.0) then
          read(value, *) use_lm
       else
          select case (trim(adjustl(keyword(3))))
          case('gas')
             val = adjustl(trim(value))
             nr_sdvgas  = 0
             pos = index(adjustl(val),' ')
             do
                if (len_trim(val).eq.0) exit
                nr_sdvgas = nr_sdvgas + 1
                if (pos.gt.0) then
                   read(val(1:pos),*) lm_gas(nr_lmgas)
                else
                   read(val(1:len_trim(adjustl(val))),*) lm_gas(nr_lmgas)
                   exit
                end if
                val = adjustl(val(pos+1:len(val)))
                pos = index(trim(adjustl(val)),' ')
             end do
          case default
             write(*,*) 'Parameter ', trim(adjustl(keyword(3))), 'not defined for fm.linemixing'
             write(16,*) 'Parameter ', trim(adjustl(keyword(3))), 'not defined for fm.linemixing'
          end select
       end if
    case('solar')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) ifco
       else
          select case (trim(adjustl(keyword(3))))
          case ('shift')
             read(value,*) cparm(4)
          end select
       end if
    case ('ifps')
       read(value,*) fps
    case ('ieap')
       read(value,*) ieap
    case ('neap')
       read(value,*) neap
    case ('iephs')
       read(value,*) iephs
    case ('neaphs')
       read(value,*) nephs
    case ('emission')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) emission
          if (emission) then
             iemission = 1
          else
             iemission = 0
          end if
       else
          select case (trim(adjustl(keyword(3))))
          case ('T_infinity')
             read(value,*) emission_t_back
          case ('object')
             read(value,*) emission_object
          case ('normalized')
             read(value,*) emission_norm
             if (emission_norm) then
                ienorm = 1
             else
                ienorm = 0
             end if
          end select
       end if
    case ('raytonly')
       read(value,*) raytonly
    end select

  end subroutine read_fw_section

  subroutine read_rt_section(keyword, value)
    implicit none

    character (len=*), dimension(*), intent(in) :: keyword
    character (len=*), intent(in) :: value

    character (len=255) :: tmpstr
    !integer :: nr
    logical :: fdiff, tflag

    if (len_trim(keyword(2)).eq.0) then
       read(value,*) retflg
    end if

    select case (trim(adjustl(keyword(2))))
    case ('temperature')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) iftemp
       else
          select case (trim(adjustl(keyword(3))))
          case ('sigma')
             read(value,*) tsigma(1:nlayers)
          end select
       end if
    case ('write_sa')
      read(value,*) f_wrtsa
    case ('lm')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) lm
          if (lm) then
             ilevenberg = 1
          else
             ilevenberg = 0
          end if
       else
          tmpstr = keyword(3)

          select case (trim(adjustl(keyword(3))))
          case('gamma_start')
             read(value,*) gamma_start
          case('stop')
             read(value,*) stop_criterion
          case('gamma_inc')
             read(value,*) gamma_inc
          case('gamma_dec')
             read(value,*) gamma_dec
          end select
       end if
    case ('convergence')
       read(value,*) convergence
    case ('tolerance')
       read(value,*) tol
    case ('max_iteration')
       read(value,*) itrmax
    case ('wshift')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) isparm
       else
          select case (trim(adjustl(keyword(3))))
          case ('apriori')
             read(value, *) wshft
          case ('sa')
             read(value, *) swshft
          end select
       end if
!    case ('offset')
!       if (len_trim(keyword(3)).eq.0) then
!          read(value,*) tflag
!          if (tflag) nback = 1
!       else
!          iphase = 1
!          select case (trim(adjustl(keyword(3))))
!          case ('apriori')
!             read(value, *) bckoff
!          case ('sa')
!             read(value, *) sbckoff
!          end select
!       end if
    case ('slope')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) tflag
          if (tflag) nback = 2
       else
          select case (trim(adjustl(keyword(3))))
          case ('apriori')
             read(value, *) bcksl
          case ('sa')
             read(value, *) sbcksl
          end select
       end if
    case ('curvature')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) tflag
          if (tflag) nback = 3
       else
          select case (trim(adjustl(keyword(3))))
          case ('apriori')
             read(value, *) bckcrv
          case ('sa')
             read(value, *) sbckcrv
          end select
       end if
    case ('solar')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) tflag
          if (tflag) icfix(4) = 1
       else
          select case (trim(adjustl(keyword(3))))
          case ('apriori')
             read(value,*) copar
          case ('sa')
             read(value,*) scopar
          case ('is_fix')
             read(value,*) sfix
          end select
       end if
    case ('phase')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) tflag
          if (tflag) iphase = 1
       else
          select case (trim(adjustl(keyword(3))))
          case ('apriori')
             read(value, *) phs
          case ('sa')
             read(value, *) sphs
          end select
       end if
    case ('eap')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) tflag
          if (tflag) irteap = 1
       else
          select case (trim(adjustl(keyword(3))))
          case ('apriori')
             read(value, *) eappar
          case ('sa')
             read(value, *) seappar
          end select
       end if
    case ('ephs')
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) tflag
          if (tflag) irtephs = 1
       else
          select case (trim(adjustl(keyword(3))))
          case ('apriori')
             read(value, *) ephspar
          case ('sa')
             read(value, *) sephspar
          end select
       end if
    case ('ifdiff')
       read(value, *) fdiff
       if (fdiff) then
          ifdiff = 1
       else
          ifdiff = 0
       end if
    end select


  end subroutine read_rt_section

  subroutine read_band_section(keyword, value)

    implicit none
    character (len=*), dimension(*),intent(in) :: keyword
    character (len=*),intent(in) :: value

    integer :: nr, nr_band, nr_band_2, nr_beam, pos
    integer :: nr_beams_2
    integer, dimension(maxbnd) :: nbeams, nbeam
    !integer :: iostat
    character (len=1023)  :: val
    logical :: flag


    if (len_trim(keyword(2)).eq.0) then
       val = adjustl(trim(value))
       nr_band = 0
       pos = index(adjustl(val),' ')
       do
          if (len_trim(val).eq.0) exit
          nband = nband + 1
          !print *, nband
          if (pos.gt.0) then
             read(val(1:pos),*) nbands(nband)
          else
             read(val(1:len_trim(adjustl(val))),*) nbands(nband)
             exit
          end if
          val = adjustl(val(pos+1:len(val)))
          pos = index(trim(adjustl(val)),' ')
       end do
       return
    else
       read(keyword(2),*) nr_band_2
    end if

    flag = .false.

    do nr = 1,nband
       if (nr_band_2.eq.nbands(nr)) then
          flag = .true.
          nr_band = nr
       end if
    end do

    if (.not.flag) return

    select case (trim(adjustl(keyword(3))))
    case ('tempretb')
       read(value,*) tretb (nr_band)
    case ('wavfac')
       read(value,*) wavfac(nr_band)
    case ('pmax')
       read(value,*) pmax(nr_band)
    case ('omega')
       read(value,*) omega(nr_band)
    case ('iap')
       read(value,*) iap(nr_band)
    case ('dn')
       read(value,*) dn(nr_band)
    case ('nu_start')
       read(value, *) wave3(nr_band)
    case ('nu_stop')
       read(value, *) wave4(nr_band)
    case ('snr')
       read(value,*) bsnr(nr_band)
    case ('gasb')
       val = value
       pos = index(adjustl(val),' ')
       if (pos.eq.0) write(*,*) 'No gas given in band ', nr_band, '?'
       nretb(nr_band) = 0
       do
          if (len_trim(val).eq.0) exit
          nretb(nr_band) = nretb(nr_band) + 1
          if (pos.gt.0) then
             gasb(nr_band,nretb(nr_band)) = trim(adjustl(val(1:pos)))
          else
             gasb(nr_band,nretb(nr_band)) = val(1:len_trim(adjustl(val)))
             exit
          end if
          val = adjustl(val(pos+1:len(val)))
          pos = index(trim(adjustl(val)),' ')
          !print *, 'pos ', pos
          !print *, 'nretb ', nretb(nr_band)
          !print *, 'nr_band ',nr_band
          !print *, 'gasb ', gasb(nr_band,nretb(nr_band))
       end do
    case ('zshift')
       if (len_trim(keyword(4)).eq.0) then
          read(value, *) izero(nr_band)
       else
          select case (trim(adjustl(keyword(4))))
          case ('apriori')
             read(value, *) zshift(nr_band,1)
          case ('szero')
             read(value, *) szero(nr_band)
          end select
       end if
    case ('beam')
      if (len_trim(keyword(4)).eq.0) then
         nbeam_of_band(nr_band) = 0
         nbeam(nband) = 0
         val = adjustl(trim(value))
         pos = index(adjustl(val),' ')
         do
            if (len_trim(val).eq.0) exit
            nbeam(nband) = nbeam(nband) + 1
            if (pos.gt.0) then
               read(val(1:pos),*) nbeams(nbeam(nband))
            else
               read(val(1:len_trim(adjustl(val))),*) nbeams(nbeam(nband))
               exit
            end if
            val = adjustl(val(pos+1:len(val)))
            pos = index(trim(adjustl(val)),' ')
         end do
         return
      else if (trim(adjustl(keyword(4))).eq.'model') then
         val = adjustl(trim(value))
         channel_model_of_band(nr_band) = val(1:2)
      else
         read(keyword(4),*) nr_beams_2
         flag = .false.

         do nr = 1,nbeam(nband)
            if (nr_beams_2.eq.nbeams(nr)) then
               flag = .true.
               nr_beam = nr
            end if
         end do

         if (.not.flag) return
         nbeam_of_band(nr_band) = nbeam_of_band(nr_band) + 1
         select case (trim(adjustl(keyword(5))))
         case ('apriori')
            read(value,*) cciparm(nr_band,nr_beam,:)
            chan_scale(nr_band,nr_beam,:) = 1.0
         case ('sa')
            read(value,*) schan_scale(nr_band,nr_beam,:)
            do nr=1,4
               if (schan_scale(nr_band,nr_beam,nr).gt.&
                    & tiny(schan_scale(nr_band,nr_beam,nr))) then
                  channel_ifix(nr_band,nr_beam,nr) = 1
               else
                  channel_ifix(nr_band,nr_beam,nr) = 0
               end if
            end do
            schan_scale(nr_band,nr_beam,1:3) = &
                 & schan_scale(nr_band,nr_beam,1:3) &
                 & / cciparm(nr_band,nr_beam,1:3)
         end select
      end if
   end select
 end subroutine read_band_section

  subroutine read_spectrum_section(keyword, value)

    implicit none
    character (len=*), dimension(*),intent(in) :: keyword
    character (len=*),intent(in) :: value
    real(8) :: snr

    integer :: nr_spec_2
    !integer :: num, error

    if (len_trim(keyword(2)).eq.0) then
       read(value,*) nspec
       return
    elseif (trim(adjustl(keyword(2))).eq.'snr') then
       if (len_trim(keyword(3)).eq.0) then
          read(value,*) snr
       elseif (trim(adjustl(keyword(3))).eq.'win') then
          read(keyword(4),*) nstnr
          select case (trim(adjustl(keyword(5))))
          case ('nu_start')
             read(value, *) wwv0(nstnr)
          case ('nu_stop')
             read(value, *) wwv1(nstnr)
          case ('snr')
             read(value, *) gstnr(nstnr)
          end select
       end if
    else
       read(keyword(2),*) nr_spec_2
    end if

  end subroutine read_spectrum_section

  subroutine read_detail_out_section(keyword, value)

    implicit none
    character (len=*), dimension(*),intent(in) :: keyword
    character (len=*),intent(in) :: value

    select case (trim(adjustl(keyword(2))))
    case ('spectrum_by_iteration')
       read(value, *) all_spec_out
    end select

  end subroutine read_detail_out_section
end module binput_parse_4_0
