module binput_4_0

! comment out write isoflag - read in from old but not used in new sfit4.ctl

  use params
  use binput_parse_4_0
  use retvparam
  use bandparam
  use lineparam
  use solar
  use channel
  use initialize
  use opt
  use writeout

  implicit none
  save
  integer, parameter :: bp_nr = 10

contains

subroutine read_binput(filename)

  character (len=*), intent(in) :: filename
  character (len=255), dimension(5) :: keyword
  character (len=1023) :: value
  integer :: file_stat, nr_keys, nr
  logical :: bp_exist

  inquire (file=filename, exist = bp_exist)
  if (.not.bp_exist) then
     write(*,*) 'file ', trim(filename), ' does not exist'
     STOP
  end if

  open(bp_nr, file=filename, status='old', iostat = file_stat)

  do
     call read_line_binput(keyword, nr_keys, value, file_stat)

     if ((file_stat.lt.0).and.(nr_keys.eq.0)) exit

     if (nr_keys.eq.0)then
        cycle
     end if

     select case (trim(adjustl(keyword(1))))
     case ('file')
        call read_file_section(keyword, value)
     case ('gas')
        call read_gas_section(keyword, value)
     case ('fw')
        call read_fw_section(keyword, value)
     case ('rt')
        call read_rt_section(keyword, value)
     case ('band')
        call read_band_section(keyword, value)
     case ('spectrum')
        call read_spectrum_section(keyword, value)
     case ('output')
        call read_output_section(keyword, value)
     end select

  end do

  do nr = 1,nband
     if ( mod(nbeam_of_band(nr),2).eq.1) then
        write(*,*) 'Error in beam parameters of band ', nr
     else
        nbeam_of_band(nr) = nbeam_of_band(nr) / 2
     end if
  end do

  close(bp_nr)

end subroutine read_binput

subroutine read_line_binput(keyword, nr_keyword, value, file_stat)

    implicit none

    character (len=*), dimension(5), intent(out) :: keyword
    character (len=*), intent(out) :: value
    integer, intent(out) :: file_stat
    integer, intent(out) :: nr_keyword

    character (len=1023) ::  line
    character (len=1023) :: line_complete
    character (len=255) :: kw
    integer pos,nr,error
    logical flag

    line_complete = ''
    flag = .false.
    file_stat = 0

    nr_keyword = 0

    value = ''


    do
       read (bp_nr, fmt='(a)', iostat=error) line
       if (error.lt.0) then
          file_stat = -1
          goto 1001
       end if
       ! replace tab  characters with blanks
       do nr=1,len_trim(line)
          if (line(nr:nr).eq.achar(9)) then
             line(nr:nr)=' '
          end if
       end do
       line = adjustl(line)
       pos = len_trim(line)

       ! remove comment (everything after #)
       pos=index(line,'#')
       if (pos.gt.0)  line(pos:) = ' '

       if (len(trim(line)).eq.0) then
          goto 1001
       end if
       if (line(1:1).eq.'#') then
          goto 1001
       end if
       if (line(1:1).eq.'.') then
          goto 1001
       end if
       pos=index(line,'=')
       if(flag.and.index(line,'=').gt.0) then
          backspace(bp_nr)
          goto 1001
       end if
       flag = .true.
       line_complete = trim(line_complete)//' '//trim(line)
    end do

1001 continue


    if (len_trim(line_complete).eq.0) then
       nr_keyword = 0
       return
    end if


    pos = index(line_complete, '=')
    value = trim(line_complete(pos+1:len_trim(line_complete)))

!    write(*,*) pos, len_trim(line_complete),line_complete
!    write(*,*) value

    kw = trim(line_complete(1:pos-1))
    pos = index(kw,'.');
    if (pos.eq.0) then
       nr = 0
       goto 1000
    end if
    do nr = 1,1000
       keyword(nr) = trim(kw(1:pos-1))
       kw = kw(pos+1:len(kw))
       pos = index(kw,'.')
       if (pos.eq.0) then
          goto 1000
       end if
    end do



1000 continue
    nr = nr + 1
    keyword(nr) = trim(kw)
    nr_keyword = nr
    keyword(nr+1:) = ''

  end subroutine read_line_binput

  subroutine write_sfit_ctl_400(binput_4_0)

    implicit none

    character (len=*), intent(in) :: binput_4_0

    integer :: nr, nr1, i, iphase
    integer :: retr_nr
    character(len=255), dimension(10) :: retr_params
    real(double), dimension(10) :: apriori, cov

    open(11, file=binput_4_0)

    write(11,*)
    write(11, *)'# General'
    write(11,*)

    write(11, 1010) 'file.stalayers','=', trim(tfile(71))
    write(11, 1010) 'file.refprofile','=', trim(tfile(72))
    write(11, 1010) 'file.spectrum','=', trim(tfile(15))
    write(11, 1010) 'file.eap_dat','=', trim(tfile(23))
    write(11, 1010) 'file.ephs_dat','=', trim(tfile(24))
    write(11, 1010) 'file.sa_matrix','=', trim(tfile(62))
    write(11, 1010) 'file.isotope','=', trim(tfile(21))
    write(11, 1010) 'file.solarlines','=', trim(tfile(11))
    write(11, 1010) 'file.linelist','=', trim(lindir)

    write(11,*)
    write(11,*)'# Definition for retrieval gases'
    write(11,*)

    write(11,1060) 'gas.layers', '=', nlayers
!    write(11,1110) 'gas.isoflag', '=', isoflag

    write(11,1010) 'gas', '=', (trim(gas(nr)), nr = 1,nret)
    do nr=1,nret
       write(11,1020) 'gas.', trim(gas(nr)), '.ifoff', '=', ifoff(nr)
       write(11,1030) 'gas.', trim(gas(nr)), '.zwid', '=', zwid(nr)
       write(11,1030) 'gas.', trim(gas(nr)), '.zmin', '=', zgmin(nr)
       write(11,1030) 'gas.', trim(gas(nr)), '.zmax', '=', zgmax(nr)
       write(11,1022) 'gas.', trim(gas(nr)), '.logstate', '=', log_statev(nr)
       if (ifprf(nr)) then
          write(11,1022) 'gas.', trim(gas(nr)), '.ifprf', '=', ifprf(nr)
          write(11,1040) 'gas.', trim(gas(nr)), '.sigma', '=', (sig(i,nr),i=1,nlayers)
       else
          write(11,1022) 'gas.', trim(gas(nr)), '.ifprf', '=', ifprf(nr)
          write(11,1040) 'gas.', trim(gas(nr)), '.sigma', '=', colsf(nr), scolsf(nr)
       end if
    end do

    write(11,*)
    write(11,*) '# Forward model parameters'
    write(11,*)

    write(11,1050) 'fw.delnu', '=', delnu
    write(11,1060) 'fw.lshapemodel', '=', lshapemodel
    write(11,1110) 'fw.solar', '=', ifco
    write(11,1050) 'fw.solar.shift', '=', cparm(4)
    write(11,1110) 'fw.ifps', '=',  fps
    write(11,1060) 'fw.ieap', '=', ieap
    write(11,1060) 'fw.neap', '=', neap
    write(11,1060) 'fw.iephs', '=', iephs
    write(11,1060) 'fw.nephs', '=', nephs
    write(11,1110) 'fw.emission', '=', emission
    write(11,1110) 'fw.ifiso', '=', useiso
    if (emission) then
       write(11,1050) 'fw.emission.T_infinity', '=', emission_t_back
       write(11,1010) 'fw.emission.object', '=', emission_object
       write(11,1110) 'fw.emission.normalized', '=', emission_norm
    end if
    write(11,1110) 'fw.write_k', '=', f_wrtk
    write(11,1110) 'fw.write_gasfiles', '=', f_wrtgasfiles
    if (f_wrtk) then
       write(11,1060) 'fw.write_gasfiles.type', '=', gasouttype
    end if
    write(11,*)
    write(11,*) '# Retrieval parameter'
    write(11,*)

    write(11,1110) 'rt', '=', retflg
    write(11,1110) 'rt.write_sa', '=', f_wrtsa
    write(11,1110) 'rt.lm', '=', lm
    if (lm) then
       write(11,1050) 'rt.lm.gamma_start', '=', gamma_start
       write(11,1050) 'rt.lm.gamma_dec', '=', gamma_dec
       write(11,1050) 'rt.lm.gamma_inc', '=', gamma_inc
       write(11,1050) 'rt.convergence', '=', stop_criterion
    else
       write(11,1050) 'rt.tolerance', '=', tol
    end if
    write(11,1060) 'rt.max_iteration', '=', itrmax

    retr_params = trim('')
    retr_nr = 0
    if ((isparm.gt.0).and.(isparm.lt.4)) then
       retr_params(1)=trim('wshift')
       retr_nr = retr_nr + 1
       apriori(retr_nr) = wshft
       cov(retr_nr) = swshft
    end if
!    write(11,1050) 'rt.wshift.apriori', '=', wshft
!    write(11,1050) 'rt.wshift.sa', '=', swshft

!    if (nback.ge.1.and.nback.lt.4) then
!       retr_nr = retr_nr + 1
!       retr_params(retr_nr) = trim('offset')
!       apriori(2) = backoff
!       cov(2) = sbackoff
!    end if
    if (nback.gt.1.and.nback.lt.4) then
       retr_nr = retr_nr + 1
       retr_params(retr_nr) = trim('slope')
       apriori(retr_nr) = bcksl
       cov(retr_nr) = sbcksl
    end if
    if (nback.eq.3) then
       retr_nr = retr_nr + 1
       retr_params(retr_nr) = trim('curvature')
       apriori(retr_nr) = bckcrv
       cov(retr_nr) = sbckcrv
    end if
    if (ifco) then
       retr_nr = retr_nr + 1
       retr_params(retr_nr) = trim('solar')
       apriori(retr_nr) = copar
       cov(retr_nr) = scopar
    end if
    if( ifphase ) iphase = 1
    if (iphase.eq.1) then
       retr_nr = retr_nr + 1
       retr_params(retr_nr) = trim('phase')
       apriori(retr_nr) = phs
       cov(retr_nr) = sphs
    end if
    if (irteap.eq.1) then
       retr_nr = retr_nr + 1
       retr_params(retr_nr) = trim('ext_apo')
       apriori(retr_nr) = eappar
       cov(retr_nr) = seappar
    end if
    if (irtephs.eq.1) then
       retr_nr = retr_nr + 1
       retr_params(retr_nr) = trim('ext_phase')
       apriori(retr_nr) = ephspar
       cov(retr_nr) = sephspar
    end if


    do nr=1,retr_nr
       ! cut out wshift
       if (adjustl(trim(retr_params(nr))).eq.'wshift') then
          write(11,1060) 'rt.wshift', '=', isparm
       else
          write(11,1035) 'rt.', trim(retr_params(nr)), '=', .true.
       end if
       write(11,1030) 'rt.', trim(retr_params(nr)), '.apriori', '=', apriori(nr)
       write(11,1030) 'rt.', trim(retr_params(nr)), '.sa', '=', cov(nr)
    end do

    if (ifco) then
       write(11,1110) 'rt.solar', '=', sfix
    end if

    if (ifdiff/=1) then
       write(11,1110) 'rt.ifdiff ', '=', .true.
    else
       write(11,1110) 'rt.ifdiff ', '=', .false.
    end if
    write(11,1110) 'rt.temperature', '=', .false.
    write(11,1110) 'rt.raytonly', '=', .false.

    write(11,*)
    write(11,*) '# Microwindows and their parameters'
    write(11,*)

    write(11,1065) 'band', '=', (nr, nr=1,nband)
    do nr = 1,nband
       write(11,1070) 'band.', nr, '.nu_start', '=', wave3(nr)
       write(11,1070) 'band.', nr, '.nu_stop', '=', wave4(nr)
       write(11,1080) 'band.', nr, '.zshift', '=', izero(nr)
       write(11,1100) 'band.', nr, '.zshift.apriori', '=', zshift(nr,1)
       write(11,1100) 'band.', nr, '.zshift.sa', '=', szero(nr)
       write(11,1080) 'band.', nr, '.beam', '=', nbeam_of_band(nr)
       write(11,1075) 'band.', nr, '.dn', '=', dn(nr)
       write(11,1070) 'band.', nr, '.wavfac', '=', wavfac(nr)
       write(11,1070) 'band.', nr, '.pmax', '=', pmax(nr)
       write(11,1070) 'band.', nr, '.omega', '=', omega(nr)
       write(11,1080) 'band.', nr, '.iap', '=', iap(nr)
       write(11,1070) 'band.', nr, '.snr', '=', snr
       if (nbeam_of_band(nr).gt.0) then
          write(11,1090) 'band.', nr, '.beam.model', '=', channel_model_of_band(nr)
          do nr1=1,nbeam_of_band(nr)
             write(11,1097) 'band.', nr, '.beam.', nr1, '.apriori', '=', cciparm(nr,nr1,1:4)
!             write(11,1098) 'band.', nr, '.beam.', nr1, '.retrieve', '=', channel_ifix(nr,nr1,1:4)
             write(11,1097) 'band.', nr, '.beam.', nr1, '.sa', '=', &
                  & schan_scale(nr,nr1,1:4)*cciparm(nr,nr1,1:4)
          end do
       end if
       write(11,1090) 'band.', nr, '.gasb', '=', (gasb(nr,nr1), nr1=1,nretb(nr))
    end do

    do nr=1,nstnr
       write(11,1070) 'spectrum.snr.win.', nr, &
            '.nu_start', '=', wwv0(nr)
       write(11,1070) 'spectrum.snr.win.', nr, &
            '.nu_stop', '=', wwv1(nr)
       write(11,1070) 'spectrum.snr.win.', nr, &
            '.snr', '=', gstnr(nr)
    end do

1010 format (1x, a, t30, a, 1x, 255(a,1x))
1020 format (1x,a,a,a,t30, a, 1x i15)
1022 format (1x,a,a,a,t30, a, 1x l15)
!1025 format (1x,a,i1,a,t30, a, 1x i15)
1030 format (1x,a, a, a, t30, a, 1x, f15.3)
1035 format (1x,a, a, t30, a, 1x, l15)
1040 format (1x,a, a, a, t30, a, 1x, 255(/, 5(f10.5)))
!1045 format (1x,a, a, a, t30, a, 1x, 255(/, 5(i10)))
1050 format (1x,a, t30, a, 1x, 100(f17.5));
1060 format (1x,a, t30, a, 1x, 100(i15));
1065 format (1x,a, t30, a, 1x, 100(i3))
10730, a, 1x, 100(i15));
1065 format (1x,a, t30, a, 1x, 100(i3))
10730, a, 1x, 100(i15));
1065 format (1x,a, t30, a, 1x, 100(i3))
10730, a, 1x, 100(i15));
1065 format (1x,a, t30, a, 1x, 100                                                                                                                                                                                                                                                                              