import read_from_file as rn
import matplotlib.dates as dt
import string
import numpy as np

class spectrum:
    
    def read_spectrum(self, filename, synspec=False):
        self.sza = []
        self.earth_rad = []
        self.latitude = []
        self.longitude = []
        self.meas_date = []
        self.comment = []
        self.nu_start = []
        self.nu_stop = []
        self.nu_res = []
        self.nr_nu = []
        self.nu = []
        self.spectrum=[]

        spdf = rn.read_from_file(filename)

        while 1:

            if not synspec:
                tmp = spdf.next(4)
                if spdf.stat() == -1:
                    break
                self.sza.append(tmp[0])
                self.earth_rad.append(tmp[1])
                self.latitude.append(tmp[2])
                self.longitude.append(tmp[3])

                tmp = spdf.next(6)
                year = tmp[0]
                month = tmp[1]
                day = tmp[2]
                hour = tmp[3]
                minute = tmp[4]
                second = tmp[5]
                self.meas_date.append(dt.date2num(dt.datetime.datetime(year,month,day,hour,minute,int(second))))
            
                spdf.nextline()

            self.comment.append(string.join(spdf.skipline(), ' '))
            
            tmp = spdf.next(4)
            if spdf.stat() == -1:
                break
            self.nu_start.append(tmp[0])
            self.nu_stop.append(tmp[1])
            self.nu_res.append(tmp[2])
            self.nr_nu.append(tmp[3])
            
            nu = []
            spectrum = []
            for n in range(0,self.nr_nu[-1]):
                nu.append(self.nu_start[-1] + n*self.nu_res[-1])
                spectrum.extend(spdf.next(1))
                
            self.nu.append(np.array(nu))
            self.spectrum.append(np.array(spectrum))

        del spdf

    def write_spectrum(self,filename):
        fid = open(filename, 'w')

        for nr in range(0,len(self.sza)):
            tmp = '%.2f %.2f %.2f %.2f' % (self.sza[nr], self.earth_rad[nr], self.latitude[nr], self.longitude[nr])
            fid.write(tmp+'\n')
        
            fid.write(dt.num2date(self.meas_date[nr]).strftime('%Y %d %d %H %M %S')+'\n')
            fid.write(self.comment[nr]+'\n')

            fid.write('%.10f %.10f %.10f %d \n'% 
                      (self.nu_start[nr], self.nu_stop[nr], self.nu_res[nr], self.nr_nu[nr]))

            for n in range(0,self.nr_nu[nr]):
                fid.write('%.6f\n'%self.spectrum[nr][n])

        fid.close()
