import numpy as np
import read_statevec as stv
import read_from_file as rn
import pdb
import os
import string


class reference_prf:
    def __init__(self):
        pass
    
    def split_reference_prf(self, reffile, refdir):

        self.read_reference_prf(reffile)
        self.write_reference_split(refdir)

    def write_reference_split(self, refdir):
        
        for n in range(1,self.nr_gas):
            sname = '%02d_%s'%(self.gas_nr[n-1],self.gasname[n-1])
            spec_dir = os.path.join(refdir,sname)
            os.path.isdir(refdir) or os.makedirs(refdir)
            np.savetxt(spec_dir,np.vstack((self.z,self.vmr[n-1,:])).transpose())

    def read_reference_split(self,refdir,z):
        # Reads numbered and named VMRs from directory refdir and interpolated the values 
        # to a given altitude grid z

        files = os.listdir(refdir)
        files.sort()

        self.nr_gas = len(files)
        self.nr_layers = z.size
        self.nr_gas=np.zeros(self.nr_gas)
        self.gasname = []
        self.vmr = np.zeros((self.nr_gas, self.nr_layers))

        for file in files:
            if os.path.isdir(file):
                continue
            t = np.loadtxt(file)
            nr_gas = string.atoi(file[0:2])
            self.nr_gas[nr_gas] = nr_gas
            self.gasname.extend(file[3:5])
            self.vmr[nr_gas,:] = np.interp(t[:,0], t[:,1], z)

    def insert_vmr(self, prffile, gas_nr, gas_name, note):
        # reads the two column profile (z,vmr) from prffile, interpolates 
        # it to the altitude grid contained in self.z and inserts gas_nr, gas_name, notes and vmr in self

        t = np.loadtxt(prffile)
        vmr = np.interp(self.z[::-1],t[::-1,0], t[::-1,1])
        self.vmr[gas_nr-1,:] = vmr[::-1]
        self.gasname[gas_nr-1]=gas_name
        self.notes[gas_nr-1] = note

    def insert_statevec(self, stvfile):
        x = stv.stv(stvfile)
        
        for n in range(0,len(x.gas)):
            ind = self.gasname.index(x.gas[n])
            vmr = np.interp(self.z[::-1],np.array(x.Z[::-1]), np.array(x.rt_vmr[n][::-1]))
            self.vmr[ind,:] = vmr[::-1]



    def read_reference_prf(self, reffile):
        reff = rn.read_from_file(reffile)
        tmp_nr = reff.next(1).pop(0)
        nr_layers = reff.next(1).pop(0)
        self.nr_layers = nr_layers
        nr_gas = reff.next(1).pop(0)
        self.nr_gas = nr_gas
        reff.skipline()
        self.z = np.array(reff.next(nr_layers))
        reff.skipline()
        self.p = np.array(reff.next(nr_layers))
        reff.skipline()
        self.t = np.array(reff.next(nr_layers))
        
        self.gas_nr = np.zeros(nr_gas)
        self.gasname = []
        self.notes =[]
        self.vmr = np.zeros((nr_gas, nr_layers))
        
        for n in range(0,nr_gas):
            #        pdb.set_trace()
            self.gas_nr[n] = reff.next(1).pop(0)
            self.gasname.extend(reff.next(1))
            self.notes.extend(reff.get_reminder_of_line())
            self.vmr[n,0:nr_layers] = np.array(reff.next(nr_layers))
            reff.skip_reminder_of_line()

        del reff
        
    
    def write_reference_prf(self, prffile):
        
        fid = open(prffile, 'w')
        line = '%5d%6d%6d\n' % (1,self.nr_layers,self.nr_gas)
        fid.write(line)
        line = '    ALTITUDE\n'
        fid.write(line)
        for n in range(0,self.nr_layers,5):
            line = string.join(map (lambda x:'%10.3e,'%x, self.z[n:np.min((n+5,self.nr_layers))]))
            fid.write(' '+line+'\n')
        line = '    PRESSURE\n'
        fid.write(line)
        for n in range(0,self.nr_layers,5):
            line = string.join(map (lambda x:'%10.3e,'%x, self.p[n:np.min((n+5,self.nr_layers))]))
            fid.write(' '+line+'\n')
        line = '    TEMPERATURE\n'
        fid.write(line)
        for n in range(0,self.nr_layers,5):
            line = string.join(map (lambda x:'%10.3e,'%x, self.t[n:np.min((n+5,self.nr_layers))]))
            fid.write(' '+line+'\n')

        for gas in range(0,self.nr_gas):
            line = '%5d%8s %s' %(self.gas_nr[gas],self.gasname[gas],self.notes[gas])
            fid.write(line+'\n')
            for n in range(0,self.nr_layers,5):
                line = string.join(map (lambda x:'%10.3e,'%x, 
                                        self.vmr[gas,n:np.min((n+5,self.nr_layers))]))
                fid.write(' '+line+'\n')


        fid.close()
