import numpy as np
import read_from_file as rn
import pdb

def read_reference_prf(reffile):
    reff = rn.read_from_file(reffile)
    tmp_nr = reff.next(1).pop(0)
    nr_layers = reff.next(1).pop(0)
    nr_gas = reff.next(1).pop(0)
    reff.skipline()
    z = np.array(reff.next(nr_layers))
    reff.skipline()
    p = np.array(reff.next(nr_layers))
    reff.skipline()
    t = np.array(reff.next(nr_layers))

    gas_nr = np.zeros(nr_gas)
    gasname = []
    vmr = np.zeros((nr_gas, nr_layers))

    for n in range(1,nr_gas):
#        pdb.set_trace()
        gas_nr[n-1] = reff.next(1).pop(0)
        gasname.append(reff.next(1))
        reff.skip_reminder_of_line()
        vmr[n-1,0:nr_layers] = np.array(reff.next(nr_layers))

    return(z,p,t,gas_nr, gasname, vmr)
        
    

