import re
import read_from_file as rn
import pdb
import numpy as np

class pbp:

    def __init__(self, filename):
        # reads a pbpfile written by sfit4 v 003.82

        pbpf = rn.read_from_file(filename)
        nr_mw = int(pbpf.next(1).pop(0))
        self.sza = []
        self.mw_res = []
        self.mw_nr = []
        self.mw_start = []
        self.mw_stop = []
        self.obs = []
        self.clc = []
        self.dif = []
        self.nu = []
        for mw in range(0,nr_mw):
            pbpf.skipline()
            self.sza.append(pbpf.next(1).pop(0)/1000)
            self.mw_res.extend(pbpf.next(1))
            self.mw_nr.append(int(pbpf.next(1).pop(0)))
            self.mw_start.extend(pbpf.next(1))
            self.mw_stop.extend(pbpf.next(1))
            pbpf.next(1)

            self.obs.append([])
            self.clc.append([])
            self.dif.append([])
            self.nu.append([])

            mwnr,mwres = divmod(self.mw_nr[mw],12)
            for mw_nr in range(0,mwnr):
                pbpf.next(1)
                tmp = pbpf.next(36)
                self.obs[mw].extend(tmp[0:12])
                self.clc[mw].extend(tmp[12:24])
                self.dif[mw].extend(tmp[24:])
            
            if mwres > 0:

                pbpf.next(1)
                tmp = pbpf.next(mwres*3)
                self.obs[mw].extend(tmp[0:mwres])
                self.clc[mw].extend(tmp[mwres:2*mwres])
                self.dif[mw].extend(tmp[2*mwres:3*mwres])

            self.nu[mw] = np.array(range(0, self.mw_nr[mw])) * self.mw_res[mw] + self.mw_start[mw]            

        del(pbpf)

