import numpy as np
import tables as h5
import collections as cll

# here to make pickle work
prf = cll.namedtuple('prf', ['date',
                             'vmr', 
                             'vmr_apriori',
                             'vmr_sigma',
                             'Z'])


def read_hdf(hdffiles):
#Create list of hdf files by, e.g.
# import re, os
# pat = re.compile(r".*\.h5")
# dirlist = filter(pat.match, os.listdir("."))


    p = []

    for filename in hdffiles:
        print filename
        f = h5.openFile(filename);

        # Add datenum of 2000,1,1
        date = f.root.DATETIME[:] + 730120.0
        for node in f.root:
            if node.name == 'ALTITUDE':
                Z = node[:]
            if node.name == 'O3.MIXING.RATIO_ABSORPTION.SOLAR': 
                rt_vmr = node[:]
            if node.name == 'O3.MIXING.RATIO_ABSORPTION.SOLAR_APRIORI': 
                ap_vmr = node[:]
            if node.name == 'O3.MIXING.RATIO_ABSORPTION.SOLAR_APRIORI': 
                sigma_vmr = node[:]
            if node.name == 'O3.MIXING.RATIO_ABSORPTION.SOLAR_UNCERTAINTY.RANDOM':
                sigma_vmr = node[:]

        for n in range(0,len(date)):
            p.append(prf(date[n],rt_vmr[n,:],ap_vmr[n,:],sigma_vmr[n,:],Z))


        f.close()

    return(p)
