import read_pbpfile as pbp
import read_profile as prf
import read_ak as ak

import numpy as np
import numpy.linalg as la
import matplotlib.pyplot as plt
import matplotlib.ticker as tkr

s = pbp.pbp('pbpfile')
Z,ZBAR,ap_vmr,rt_vmr,sigma_vmr,ap_col,rt_col = prf.read_prf('PRFS.out')
avk = ak.read_ak('AK.out')

fig1 = plt.figure(1)
fig1.clf()
nr_s = len(s.nu)
nr_sx = int(np.ceil(np.sqrt(nr_s)))
nr_sy = int(np.ceil(float(nr_s)/nr_sx))
nr = 0
for n in range(0,nr_sx):
    for m in range(0,nr_sy):
        ax = plt.subplot(nr_sy, nr_sx, nr+1)
        plt.plot(s.nu[nr], s.obs[nr])
        plt.plot(s.nu[nr], s.clc[nr])
        ax2 = ax.twinx()
        plt.plot(s.nu[nr], np.array(s.dif[nr]))
        ax.xaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
        print 'SNR in Band '+str(nr)+': ', 1/np.std(s.dif[nr])
        nr = nr + 1
        if nr >= nr_s:
            break
    if nr >= nr_s:
        break

fig1.set_size_inches(5,5,forward=True)
fig1.show()

fig2 = plt.figure(2)
fig2.clf()

fig2.set_size_inches(1,1,forward=True)
plt.plot(rt_vmr, Z)
plt.plot(ap_vmr, Z)
fig2.show()

fig3 = plt.figure(3)
fig3.clf()
fig3.set_size_inches(1,1,forward=True)
plt.plot(avk.transpose(), Z)
fig3.show()

#ap = np.diag(ap_col)
ap = np.diag(rt_vmr)
ak_col = np.dot(np.dot(ap,avk),la.inv(ap))

fig4 = plt.figure(4)
fig4.clf()
fig4.set_size_inches(1,1,forward=True)
plt.plot(sum(ak_col,0),Z)

fig4.show()
