import numpy as np
import matplotlib.dates as dt
import read_statevec, read_pbpfile, read_misc, read_detfile
import os, string
import pdb


class sfit4_results:
    def __init__(self, direc):
        dirs = os.listdir(direc)
        df = dt.strpdate2num('%Y%m%d%H%M%S')
        self.statefile = []
        self.pbpfile = []
        self.miscfile = []
        self.detfile = []
        dnum = []
        sza = []
        for dd in dirs:
            statefile = string.join([direc, '/', dd, '/', 'statevec'], '')
            if os.path.isfile(statefile):
                self.statefile.append(statefile)
            else:
                continue
            pbpfile = string.join([direc, '/', dd, '/', 'pbpfile'], '')
            if os.path.isfile(pbpfile):
                self.pbpfile.append(pbpfile)
            else:
                continue
            detfile = string.join([direc, '/', dd, '/', 'detail'], '')
            if os.path.isfile(detfile):
                self.detfile.append(detfile)
            else:
                continue
            miscfile = string.join([direc, '/', dd, '/', 'misc.out'], '')
            if os.path.isfile(miscfile):
                self.miscfile.append(miscfile)
                mt,dur,sz = read_misc.read_misc(miscfile)
                sza.append(float(sz[0]))
                self.sza = np.array(sza)
            else:
                continue
            # sometimes seconds is 60. Bug in run_batch_sfit4
            if dd[-2:] == '60':
                dd = dd[0:-2] + '59'
            dnum.append(df(dd))
        self.dnum = np.array(dnum)

    def get_columns(self):
        
        col = []
        
        
        for stf in self.statefile:
            stv = read_statevec.stv(stf)
            col.append(stv.rt_col[0])
        self.col = np.array(col)


    def get_profiles(self):
        vmr = []

        for stf in self.statefile:
            stv = read_statevec.stv(stf)
#            pdb.set_trace()
            vmr.append(stv.rt_vmr[0])
        self.vmr = np.array(vmr)

    def get_snr(self):
        
        snr = []
        snr_theo = []
        
        for detf in self.detfile:
            det = read_detfile.read_det_sfit4(detf)
            if det==-1:
                snr.append(-1)
                snr_theo.append(-1)
            else:
                snr.append(det['snr'])
                snr_theo.append(det['snr_theo'])
            
        self.snr = np.array(snr)
        self.snr_theo = np.array(snr_theo)
