lsfit4 = 1
load_sfit4 = 1
loof = 1
load_loof = 1
lvav = 0
load_lvav=0

#co2_direc = '/data/allsfit_sfit4/spit_sun_co2_ingaas'
#o2_direc = '/data/allsfit_sfit4/spit_sun_o2_ingaas'

#co2_direc = '/ftirrd03/mathias/spit_sun_co2_ingaas'
#o2_direc = '/ftirrd03/mathias/spit_sun_o2_ingaas'
co2_file = '/ftirrd03/mathias/bia_sun_co2_ingaas/bia_sun_co2_ingaas.h5'
o2_file = '/ftirrd03/mathias/bia_sun_o2_ingaas/bia_sun_o2_ingaas.h5'
#co2_file = '/ftirrd03/mathias/bia_sun_co2_ingaas_profile/bia_sun_co2_ingaas_profile.h5'
#co2_file = '/ftirrd03/mathias/bia_sun_co2_ingaas_gfitvmr/bia_sun_co2_ingaas_gfitvmr.h5'
#o2_file = '/ftirrd03/mathias/bia_sun_o2_ingaas_gfitvmr/bia_sun_o2_ingaas_gfitvmr.h5'


gfit_oof_file='/home/mathias/sfit4_co2/bia_2009-201111.vav.ada.aia.gaa.oof'
gfit_vav_file='/home/mathias/sfit4_co2/bia_2009-201111.vav'
#gfit_file='/home/mathias/sfit4_co2/ny2005-201205_co2.txt'
#gfit_file = '/data/allsfit_sfit4/spit_sun_co2_ingaas/ny2011_co2.txt'

import sys
sys.path.append('/home/mathias/sfit4-python')

import numpy as np
import get_sfit4_results as gsr
import scipy as sc
import matplotlib.dates as dates
import calendar
import matplotlib.pyplot as plt
import matplotlib.ticker  as tkr
import tables as h5

if lsfit4 and load_sfit4: 
    co2h5 = h5.File(co2_file)
    o2h5 = h5.File(o2_file)
    co2_dnum = co2h5.root.mdate[:]
    o2_dnum = o2h5.root.mdate[:]
    co2_col = co2h5.root.col_rt[:]
    o2_col = o2h5.root.col_rt[:]
    co2_snr = co2h5.root.snr_clc[:]
    o2_snr = o2h5.root.snr_clc[:]
    co2_snrt = co2h5.root.snr_the[:]
    o2_snrt = o2h5.root.snr_the[:]
    co2_sza = np.double(co2h5.root.sza[:])
#    co2_sza = np.double(co2h5.root.sza[:]).transpose()[0]
    co2h5.close()
    o2h5.close()


if loof and load_loof:
    print 'Load GFIT XCO2 data from: ' + gfit_oof_file
    gfit = np.recfromtxt(gfit_oof_file, skip_header=300, names=True)
    years = np.array(map(lambda x: calendar.timegm((int(x),1,0,0,0,0)), gfit.year))
    gfit_date = dates.epoch2num(years + np.floor(gfit.day)*86400 + gfit.hour*3600)

    gfit_xco2 = gfit.xco2ppm/1e6
    print 'done'

if lvav and load_lvav:
    print 'Load GFIT XCO2 data from: ' + gfit_vav_file
    gfit = np.recfromtxt(gfit_vav_file, skip_header=7, names=True)
    years = np.array(map(lambda x: calendar.timegm((int(x),1,0,0,0,0)), gfit.year))
    gfit_date = dates.epoch2num(years + np.floor(gfit.day)*86400 + gfit.hour*3600)
    gfit_co2 = gfit.co2
    gfit_o2 = gfit.o2
    print 'done'

ind = []
ind_co2 = []
ind_o2 = []
xco2_date = []
nr = 0

#for dd in p_co2.dnum:
for dd in co2_dnum:
    ind = ((dd == o2_dnum).nonzero()[0])
    if ind.size == 1:
        if o2_snr[ind[0]] > 20 and co2_snr[nr] > 180: 
            ind_o2.append(ind[0])
            ind_co2.append(nr)
            xco2_date.append(dd)
    nr = nr+1

beta = 0.0065
col_co2 = co2_col[ind_co2]
sza = co2_sza[ind_co2]
S = np.power((sza + 13)/(90+13),3) - np.power((45 + 13)/(90+13),3)
col_o2 = o2_col[ind_o2]
col_xco2 = col_co2/col_o2*0.2095 / 0.989 / (1+beta*S)
xco2_date = np.array(xco2_date)

#average over a day


dd_sfit4_daily = np.unique(np.floor(xco2_date))
col_sfit4_daily = []
for ndd in dd_sfit4_daily:
    inds = (abs(np.floor(xco2_date) - ndd)<1).nonzero()[0]
    col_sfit4_daily.append(np.mean(col_xco2[inds]))

dd_sfit4_daily = np.array(dd_sfit4_daily).copy()
col_sfit4_daily = np.array(col_sfit4_daily).copy()

if loof:
    dd_gfit_daily = np.unique(np.floor(gfit_date))
    col_gfit_daily = []
    sza_gfit_daily = []
    for ndd in dd_gfit_daily:
        inds = (abs(np.floor(gfit_date) - ndd)<1).nonzero()[0]
        col_gfit_daily.append(np.mean(gfit_xco2[inds]))
#    sza_gfit_daily.append(np.mean(gfit.ASZA[inds]))
    dd_gfit_daily = np.array(dd_gfit_daily).copy()
    col_gfit_daily = np.array(col_gfit_daily).copy()
        

f1 = plt.figure(1)
f1.clf()
ax = plt.subplot(111)
plt.plot_date(dd_sfit4_daily, col_sfit4_daily, 'o')
if loof:
    plt.plot_date(dd_gfit_daily, col_gfit_daily, 'gx')
ax.yaxis.set_major_formatter(tkr.FuncFormatter(lambda x, pos: ('%.1f')%(x*1e6)))
#ax.yaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
#plt.gca().set_yticklabels(plt.gca().get_yticks()*1e6)
plt.title('Daily avarage xco2 data');
f1.show()


f2 = plt.figure(2)
f2.clf()
ax = plt.subplot(111)
if loof:
    plt.plot_date(gfit_date, gfit_xco2, 'x')
plt.plot_date(xco2_date, col_xco2, 'go')
ax.yaxis.set_major_formatter(tkr.FuncFormatter(lambda x, pos: ('%.1f')%(x*1e6)))
#ax.yaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
#plt.gca().set_yticklabels(plt.gca().get_yticks()*1e6)
plt.title('All xco2 data');
f2.show()

f3 = plt.figure(3)
f3.clf()
ax = plt.subplot(111)
if lvav:
    plt.plot_date(gfit_date, gfit_o2 , 'x')
plt.plot_date(xco2_date, col_o2, 'go')
ax.yaxis.set_major_formatter(tkr.FuncFormatter(lambda x, pos: ('%.1e')%(x)))
#ax.yaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
#plt.gca().set_yticklabels(plt.gca().get_yticks()*1e6)
plt.title('O2 data');
f3.show()

f4 = plt.figure(4)
f4.clf()
ax = plt.subplot(111)
if lvav:
    plt.plot_date(gfit_date, gfit_co2 , 'x')
plt.plot_date(xco2_date, col_co2, 'go')
ax.yaxis.set_major_formatter(tkr.FuncFormatter(lambda x, pos: ('%.1e')%(x)))
#ax.yaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
#plt.gca().set_yticklabels(plt.gca().get_yticks()*1e6)
plt.title('CO2 data');
f4.show()

f5 = plt.figure(5)
f5.clf()
if loof:
    col_sfit4_gfit_daily = []
    col_gfit_sfit4_daily = []
    dd_sfit4_gfit_daily = []
    nr = 0
    for ndd in dd_sfit4_daily:
        inds = (abs(np.floor(dd_gfit_daily) - ndd)<1).nonzero()[0]
        if len(inds) > 0:
            col_sfit4_gfit_daily.append(col_sfit4_daily[nr])
            col_gfit_sfit4_daily.append(col_gfit_daily[inds[0]])
            dd_sfit4_gfit_daily.append(ndd)
            nr = nr+1

    col_sfit4_gfit_daily = np.array(col_sfit4_gfit_daily).copy()
    col_gfit_sfit4_daily = np.array(col_gfit_sfit4_daily).copy()
    ax = plt.subplot(111)
    plt.plot_date(dd_sfit4_gfit_daily, col_sfit4_gfit_daily - col_gfit_sfit4_daily, 'x')
    ax.xaxis.set_major_formatter(tkr.FuncFormatter(lambda x, pos: ('%.1e')%(x)))
    ax.yaxis.set_major_formatter(tkr.FuncFormatter(lambda x, pos: ('%.1e')%(x)))

f5.show()
