# Example of how to show all spectra 
# A pbpfile isa expected
# call from the directory containing pbpfile using
# execfile ('<DIR>/show_all_spectra.py')
# DIR is the directory which contains show_all_spectra.py

import sys
sys.path.append('/home/mathias/sfit4-python/')
import read_pbpfile as pbp
import matplotlib.pyplot as plt
import matplotlib.ticker as tkr

s = pbp.pbp('pbpfile')

fig = []
for n in range(0,len(s.nu)):
    fig.append(plt.figure())
    ax1 = plt.subplot(211)
    ax1.xaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
    ax1.yaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
    plt.plot(s.nu[n], s.obs[n])
    plt.plot(s.nu[n], s.clc[n])
    ax2 = plt.subplot(212)
    ax2.xaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
    ax2.yaxis.set_major_formatter(tkr.ScalarFormatter(useOffset=False))
    plt.plot(s.nu[n], s.dif[n])
    fig[n].show()

