import sys
sys.path.append('/home/mathias/sfit4-python')

import os, string, pdb
import tables.netcdf3 as netcdf
import numpy as np
import read_misc
import read_statevec
import read_detfile
import matplotlib.dates as dt

class Misc(hdf5.IsDescription):
    spectrum_file = hdf5.StringCol(21)   # 21-character String
    sza  = hdf5.Float32Col() 
    mtime    = hdf5.Float32Col()
    duration = hdf5.Float32Col()


filename = 'tmp.h5'
file = NetCDF.NetCDFFile('test.cdf', 'w')

dirs = os.listdir(direc)
df = dt.strpdate2num('%Y%m%d%H%M%S')
statefile = []
pbpfile = []
miscfile = []
detfile = []
dnum = []
sza = []


file.createDimension('mdate', None)
file.createDimension('sza', None)
file.createDimension('duration', None)
file.createDimension('col', None)

mdate = file.createVariable('mdate','d',('mdate',))
sza = file.createVariable('sza','e',('sza',))
duration = file.createVariable('duration','f',('duration',))
column = file.createVariable('col','g',('col',))

for dd in dirs:
    miscfile = string.join([direc, '/', dd, '/', 'misc.out'], '')
    if not os.path.isfile(miscfile):
        continue
    statefile = string.join([direc, '/', dd, '/', 'statevec'], '')
    if not os.path.isfile(statefile):
        continue
    detfile = string.join([direc, '/', dd, '/', 'detail'], '')
    if not os.path.isfile(detfile):
        continue


    mt,dur,sz = read_misc.read_misc(miscfile)
    mdate.row['mdate'] = dt.epoch2num(mt[0]);
    mdate.row.append()
    duration.row['duration'] = float(dur[0])
    duration.row.append()
    sza.row['sza'] = float(sz[0])
    sza.row.append()

    stv = read_statevec.stv(statefile)
    col.row['rt'] = stv.rt_col[0]
    col.row['apriori'] = stv.ap_col[0]
    col.row.append()

    vmr.row['rt'] = np.array(stv.rt_vmr[0]).transpose()
    vmr.row.append()

    det = read_detfile.read_det_sfit4(detfile)
    if det==-1:
        snr.row['clc'] = -1
        snr.row['the'] = -1
    else:
        snr.row['clc'] = mean(det['snr'])
        snr.row['the'] = mean(det['snr_theo'])
    snr.row.append()

h5file.close()
