import sys
sys.path.append('/home/mathias/sfit4-python')

import os, string, pdb
import tables as hdf5
import numpy as np
import read_misc
import read_statevec
import read_detfile
import read_ak
import read_pbpfile 
import matplotlib.dates as dt

filename = 'tmp.h5'
direc = '.'
h5file = hdf5.openFile(filename, mode = "w", title = "sfit4 results")

dirs = os.listdir(direc)
df = dt.strpdate2num('%Y%m%d%H%M%S')
statefile_list = []
pbpfile_list = []
miscfile_list = []
detfile_list = []
akfile_list = []
pbpfile_list = []
dnum = []
sza = []
dur = []
spectra = []
col_rt = []
col_ap = []
vmr_rt = []
vmr_ap = []
snr_clc = []
snr_the = []

nr_entries = len(dirs)

print 'Find files...'
mdate = []
for dd in dirs:
    miscfile = string.join([direc, '/', dd, '/', 'misc.out'], '')
    if not os.path.isfile(miscfile):
        continue
    miscfile_list.append(miscfile)
    statefile = string.join([direc, '/', dd, '/', 'statevec'], '')
    if not os.path.isfile(statefile):
        continue
    statefile_list.append(statefile)
    detfile = string.join([direc, '/', dd, '/', 'detail'], '')
    if not os.path.isfile(detfile):
        continue
    detfile_list.append(detfile)
    akfile = string.join([direc, '/', dd, '/', 'AK.out'], '')
    if not os.path.isfile(akfile):
        continue
    akfile_list.append(akfile)
    pbpfile = string.join([direc, '/', dd, '/', 'pbpfile'], '')
    if not os.path.isfile(pbpfile):
        continue
    pbpfile_list.append(pbpfile)

    mt,du,sz,spectrum = read_misc.read_misc(miscfile)
    mdate.append(dt.epoch2num(mt[0]))
    sza.append(np.double(sz[0]))
    dur.append(np.double(du[0]))
    spectra.append(spectrum)

    det = read_detfile.read_det_sfit4(detfile)
    if det==-1:
        snr_clc.append(-1)
        snr_the.append(-1)
    else:
        snr_clc.append(np.mean(det['snr']))
        snr_the.append(np.mean(det['snr_theo']))

h5file.createArray("/", 'directories', dirs, "Measurement date and time")
h5file.createArray("/", 'spectra', spectra, "Filename of Spectrum")
h5file.createArray("/", 'mdate', np.array(mdate), "Measurement date and time")
h5file.createArray("/", 'sza', np.array(sza), "Solar zenith angle")
h5file.createArray("/", 'dur', np.array(dur), "Duration of measurement")
h5file.createArray("/", 'snr_clc', np.array(snr_clc), "Calculated SNR")
h5file.createArray("/", 'snr_the', np.array(snr_the), "Theoretically possible SNR")

 
print 'Load statevector files ... '
nr_stv = 0
flag_h2o = False
for statefile in statefile_list:
    stv = read_statevec.stv(statefile)
    col_rt.append(stv.rt_col[0])
    col_ap.append(stv.ap_col[0])
    if nr_stv == 0:
        len_vmr = len(stv.rt_vmr[0])
        vmr_rt = h5file.createEArray("/", 'vmr_rt', hdf5.Float32Atom(), (len_vmr,0), title="Retrieved VMR", expectedrows=nr_entries)
        vmr_ap = h5file.createEArray("/", 'vmr_ap', hdf5.Float32Atom(), (len_vmr,0), title="Apriori VMR", expectedrows=nr_entries)
        nr_stv = 1
    vmr_rt.append(np.reshape(np.array(stv.rt_vmr[0]),(len_vmr,1)))
    vmr_ap.append(np.reshape(np.array(stv.ap_vmr[0]),(len_vmr,1)))

    nr_h2o = stv.gas.count('H2O') and stv.gas.index('H2O') + 1
    if nr_h2o:
        flag_h2o = True
        col_rt.append(stv.rt_h2o_col[0])
        col_ap.append(stv.ap_h2o_col[0])
        


h5file.createArray("/", 'col_rt', np.array(col_rt), "Retrieved column")
h5file.createArray("/", 'col_ap', np.array(col_ap), "A prior column")

if flag_h2o:
    h5file.createArray("/", 'col_h2o_rt', np.array(col_h2o_rt), "Retrieved H2O column")
    h5file.createArray("/", 'col_h2o_ap', np.array(col_h2o_ap), "A prior H2O column")


print 'load AVK matrices ... '

nr_ak = 0
never_ak = 0
if never_ak == 0:
    for akfile in akfile_list:
        b = read_ak.read_ak(akfile)
        if type(b) == int and b == -1:
            never_ak = 1
	    break									
        else:
            if nr_ak == 0:
                len_ak = b.shape[0]
                ak = h5file.createEArray("/", 'avk', hdf5.Float32Atom(), (len_ak,len_ak,0), title="AVK matrices", expectedrows=nr_entries)
                nr_ak = 1
        ak.append(np.reshape(b,(len_ak,len_ak,1)))


# print 'Load spectra ...' 
# pbp_mw = h5file.createVLArray("/", 'pbp_mw', hdf5.Float32Atom(), "Index of the start of each MW")
# pbp_clc = h5file.createVLArray("/", 'pbp_clc', hdf5.Float32Atom(), "PBP Spectra of the final iteration")
# pbp_obs = h5file.createVLArray("/", 'pbp_obs', hdf5.Float32Atom(), "PBP Spectra of the Observation")
# pbp_nu = h5file.createVLArray("/", 'pbp_nu', hdf5.Float32Atom(), "Frequency grid")
 
# for pbpfile in pbpfile_list:
#     b = read_pbpfile.pbp(pbpfile)
#     nu = np.hstack((b.nu[:]))
#     clc = np.hstack((b.clc[:]))
#     obs = np.hstack((b.obs[:]))
#     mw = [0]
#     for n in range(1,len(b.nu)):
#         mw.append(b.nu[n].shape[0]+mw[n-1])
#     pbp_mw.append(np.array(mw))
#     pbp_nu.append(nu)
#     pbp_clc.append(clc)
#     pbp_obs.append(obs)

    
h5file.close()
