import matplotlib.pyplot as plt
import numpy as np
import spectrum as rs
import read_statevec as stv
import sfit4_ctl as sfit4
import AVK
import os
import scipy.constants as co
import pdb

pert_sza = 0.01
delta_sza = 0.2

ctl = sfit4.sfit4_ctl()
ctl.read_ctl_file('sfit4.ctl')
ctl.replace_in_file('sfit4.ctl', 'rt', 'F')
os.system('../sfit4')
K1 = AVK.Kout('K.out')
asp1 = rs.spectrum()
asp1.read_spectrum('synspec.out',synspec=True)
sp = rs.spectrum()
sp.read_spectrum('spectrum')
x = stv.stv('statevec')
for n in range(0,len(sp.sza)):
    sp.sza[n] += pert_sza
sp.write_spectrum('s_perturbed')
ctl.replace_in_file('sfit4.ctl', 'file.spectrum', 's_perturbed')
os.system('../sfit4')
asp2 = rs.spectrum()
asp2.read_spectrum('synspec.out', synspec=True)


K = np.matrix(K1.K).copy()
sdif = (np.matrix(np.hstack(asp2.spectrum[:])).T - np.matrix(np.hstack(asp1.spectrum[:])).T)/(pert_sza)

K = np.hstack((K, sdif))
# Sainv2 = np.hstack((K1.SaInv, np.zeros((K1.SaInv.shape[0],1))))
# Sainv2 = np.vstack((Sainv2, np.zeros((1,Sainv2.shape[1]))))
# Sainv2[-1,-1] = 1.0
# KSe = np.dot(K.T,K1.SeInv)
# SaKSK = Sainv2 + np.dot(KSe,K)
# D = np.linalg.solve(SaKSK,KSe)
K1.Dout()
K1.AVK()
A_sza = np.dot(K1.D,K)

S_sza = np.zeros((64,64))
S_sza[-1,-1] = delta_sza**2
S = np.dot(A_sza, np.dot(S_sza, A_sza.T))

apriori = np.array(x.ap_vmr[0])

S = np.dot(np.dot(np.diag(apriori),S[K1.x_start:K1.x_stop,K1.x_start:K1.x_stop]),np.diag(apriori))

#Ax_sza = A_sza[K1.x_start:K1.x_stop+1,K1.x_start:K1.x_stop+1]
#Avmr_sza = np.dot(np.diag(apriori),Ax_sza)


f1 = plt.figure(1)
f1.clf()
ax1 = plt.subplot(111)
plt.plot(x.Z, x.ap_vmr[0])
plt.plot(x.Z, x.ap_vmr[0]+np.sqrt(np.diag(S)))
plt.plot(x.Z, x.ap_vmr[0]-np.sqrt(np.diag(S)))
ax2 = ax1.twinx()
plt.plot(x.Z, 2*np.sqrt(np.diag(S)))
f1.show()

z = np.array(x.Z)
z = np.hstack((z, 0.225))
diffZ = np.abs(np.diff(z)*1000)

mass = np.array(x.P)*100/(np.array(x.T)*co.Boltzmann)
dcol = '%g' % np.sum(np.sqrt(np.diag(S))*mass*diffZ/10000)
print dcol
