import numpy as np
import sfit4_ctl as sfit4
import AVK 
import os, shutil
import read_statevec as stv
import reference_prf as rp
#shutil.copy('sfit4.ctl','sfit4.ctl.orig')

ctl = sfit4.sfit4_ctl()
ctl.read_ctl_file('sfit4.ctl')
ctl.replace_in_file('sfit4.ctl', 'rt', 'T')
ctl.replace_in_file('sfit4.ctl', 'fw.write_k', 'T')
ctl.replace_in_file('sfit4.ctl', 'rt.slope', 'F')
ctl.replace_in_file('sfit4.ctl', 'rt.curvature', 'F')
ctl.replace_in_file('sfit4.ctl', 'rt.phase', 'F')
ctl.replace_in_file('sfit4.ctl', 'rt.solar', 'F')
ctl.replace_in_file('sfit4.ctl', 'rt.ifdiff', 'T')

os.system('../sfit4')
prf = rp.reference_prf()
prf.read_reference_prf('reference.prf')
prf.insert_statevec('statevec')
#prf.write_reference_prf('reference.prf')

K = AVK.Kout('K.out')

ctl.replace_in_file('sfit4.ctl', 'rt', 'F')
if not ctl.value.has_key('rt.slope') or ctl.value['rt.slope'] == 'F':
    ctl.replace_in_file('sfit4.ctl', 'rt.slope', 'T')
if not ctl.value.has_key('rt.curvature') or ctl.value['rt.curvature'] == 'F':
    ctl.replace_in_file('sfit4.ctl', 'rt.curvature', 'T')
if not ctl.value.has_key('rt.phase') or ctl.value['rt.phase'] == 'F':
    ctl.replace_in_file('sfit4.ctl', 'rt.phase', 'T')
if not ctl.value.has_key('rt.solar') or ctl.value['rt.solar'] == 'F':
    ctl.replace_in_file('sfit4.ctl', 'rt.solar', 'T')
if not ctl.value.has_key('rt.ifdiff') or ctl.value['rt.ifdiff'] == 'F':
    ctl.replace_in_file('sfit4.ctl', 'rt.ifdiff', 'F')

os.system('../sfit4')


shutil.copy('sfit4.ctl','sfit4.ctl.error')
#shutil.copy('sfit4.ctl.orig','sfit4.ctl')

K2 = AVK.Kout('K.out')
K.Dout()

AK = np.dot(K.D,K2.K)

Se = np.zeros((K2.n,K2.n))

x = stv.stv('statevec')
apriori = np.array(x.ap_vmr[0])

f1 = plt.figure(1)
f1.clf()

xd = [[0, 1, 2, 3, 4, 5, 6, 7, 8],
      [0.1,0.1,0.1,0.1,0.1,0.1,1e-6,1e-6,1e-6]]

s = {}
for ind in range(0,6):
    Se = np.zeros_like(ak.AK)
    Se[xd[0][ind],xd[0][ind]] = xd[1][ind]*xd[1][ind]
    e1 = np.dot(ak.AK,np.dot(Se,ak.AK.transpose())).copy()
    e1 = e1[17:17+41,17:17+41].copy()
    e1 = np.dot(np.dot(np.diag(apriori),e1),np.diag(apriori)).copy()
    s[ind] = np.sqrt(np.diag(e1))
    plt.plot(x.Z, s[ind])


f1.show()
