function readstat, sts, file

; read in statevec file --------------------------------------------------------------------

	openr, lun, file, /get_lun, error=ioerr
	if( ioerr ne 0 ) then begin
		printf, -2, !err_string
		return, 1
	endif

	dum = ''
	readf, lun, nlev, dum
	iftemp = 1
print,dum
	if( strtrim(dum,2) NE 'T' )then begin
   	free_lun, lun
      openr, lun, file, /get_lun, error=ioerr
      if( ioerr ne 0 ) then begin
         printf, -2, !err_string
         return, 1
      endif
   	readf, lun, nlev
   	iftemp = 0
   endif
print , iftemp
	z = fltarr(nlev) & p = z & t = z & vmr = z & tr = z

	readf, lun, dum & readf, lun, z
	readf, lun, dum & readf, lun, p
	readf, lun, dum & readf, lun, t
   if( iftemp )then begin
      readf, lun, dum & readf, lun, tr
   endif

	readf, lun, dum & readf, lun, ngas

	sts = {									      $
		nlev	: 0,						         $
		ngas	: 0, 						         $
		iftm  : 0,                          $
		z		: fltarr( nlev ),			      $
		p		: fltarr( nlev ),			      $
		t		: fltarr( nlev ),			      $
		tr		: fltarr( nlev ),			      $
		col	: fltarr( 2, ngas ),		      $
		vmr	: fltarr( 2, ngas, nlev ),	   $
		gas	: strarr( 2, ngas )			   $
		}

	sts.iftm = iftemp
	sts.nlev = nlev
	sts.ngas = ngas
	sts.z  = reverse( z )
	sts.p  = reverse( p )
	sts.t  = reverse( t )
	sts.tr = reverse( tr )

	col = 0.0
	name = ''

	for i = 0, ngas-1 do begin
		for j = 0, 1 do begin

			readf, lun, dum & readf, lun, name & readf, lun, col
			readf, lun, vmr

			sts.gas[j, i] = strtrim( name, 2 )
			sts.col[j, i] = col
			sts.vmr[j, i, *] = reverse( vmr )

		endfor
	endfor

	free_lun, lun
	return, 0

end


