FUNCTION readprfs, prf, file, n

; Read in profiles file --------------------------------------------------------------------

	OPENR, lun, file, /GET_LUN, ERROR=ioerr 
	IF( ioerr NE 0 ) THEN BEGIN
		PRINTF, -2, !ERR_STRING
		RETURN, 1
	ENDIF

	dums = ''
	READF, lun, dums

	prf = {						$
		nlev	: n,			   $
		zbnd	: DBLARR( n ),	$
		zbar	: DBLARR( n ),	$
		avmr	: DBLARR( n ),	$
		rvmr	: DBLARR( n ),	$
		sigv	: DBLARR( n ),	$
		acol	: DBLARR( n ),	$
		rcol	: DBLARR( n ),	$
		var	: DBLARR( n )	$
	}

	mat = DBLARR( 8, n )
	READF, lun, mat	
	mat = REVERSE( mat, 2 )

	FOR i = 0, n -1 DO BEGIN
		prf.zbnd[i] = mat[0,i]
		prf.zbar[i] = mat[1,i]
		prf.avmr[i] = mat[2,i]
		prf.rvmr[i] = mat[3,i]
		prf.sigv[i] = mat[4,i]
		prf.acol[i] = mat[5,i]
		prf.rcol[i] = mat[6,i]
		prf.var[i]  = mat[7,i]
	ENDFOR
	
    FREE_LUN, lun
	RETURN, 0

END
