PRO oex, site=site, PS=PS, NSM=NSM, FTYPE=FTYPE, ThickLines=ThickLines

; idl script to plot sfit2 output
; originally scripted in matlab now converted to idl
;adapted 18/3/2010 to add in total column amount from retrieval RB

	PRINT, ' Usage : oex, site="mlo | tab | acf", /ps, /nsm, /thick, ftype= "B" | "L"'

	IF( NOT KEYWORD_SET( ThickLines )) THEN BEGIN
		PRINT, '  Main : keyword ThickLines  not set.'
		PRINT, '  Main : setting default ThickLines=0 -> use thin lines.'
		ThickLines = 0  		 ;  0 means thin lines, 1 means thick lines
	ENDIF

	IF( NOT KEYWORD_SET( FTYPE )) THEN BEGIN
		PRINT, '  Main : keyword FTYPE not set.'
		PRINT, '  Main : setting default FTYPE=B -> use Big Endian for Mac.'
		FTYPE = 'B'
	ENDIF

	IF( NOT KEYWORD_SET( NSM )) THEN BEGIN
		PRINT, '  Main : keyword NSM not set.'
		PRINT, '  Main : setting default NSM=0 -> plot smoothing error figure.'
		NSM = 0
	ENDIF

	IF( NOT KEYWORD_SET( PS )) THEN BEGIN
		PRINT, '  Main : keyword PS not set.'
		PRINT, '  Main : setting default PS=0 -> do not create ps output.'
		PS = 0
	ENDIF

	; ppos running position & id of last plot on screen
	ppos = INTARR(3)
	ppos = [ 10, 380, 0 ]			; work - double screens
	;ppos = [ 10, 1300, 0 ]
	;ppos = [ 10, 100, 0 ]
	; plot size on screen, PS is a page

	psiz = INTARR(2)
	psiz = [ 600, 465 ]

	FORWARD_FUNCTION readpbp, readnxn, readstat, readaevc, readkmf, readprfs
	FORWARD_FUNCTION plotpbp, plotprfs, plotak, plotaegv, blockplot, plotk, covarplot, plotbnr
	FORWARD_FUNCTION Exponent

	encap = 0
	;plottop = 60.0 -normal
	plottop = 120 ; bec's test

; Set up file names from LAPACK version sfit2 run
	setfilenames, pbpfile, stfile, akfile, kfile, smfile, ssfile, aefile, ptfile, shfile, prfile

; Read in pbpfile
	rc = 0
	rc = readpbp( pbp, pbpfile )

	IF( rc NE 0 ) THEN BEGIN
		PRINTF, -2,'Could not read pbp file: ', pbpfile
		RETURN
		STOP
	ENDIF

; Read in Smoothing Error file
	rc = 0
	rc = readnxn( sserr, ssfile )

	IF( rc NE 0 ) THEN BEGIN
		PRINTF, -2,'Could not read ss file: ', ssfile
		STOP
	ENDIF

; Read in Measuerment Error file
	rc = 0
	rc = readnxn( smerr, smfile )

	IF( rc NE 0 ) THEN BEGIN
		PRINTF, -2,'Could not read sm file: ', smfile
		STOP
	ENDIF

; Read in Statevector file
	rc = 0
	rc = readstat( stat, stfile )

	IF( rc NE 0 ) THEN BEGIN
		PRINTF, -2,'Could not read st file: ', stfile
		STOP
	ENDIF

	ucmol = STRUPCASE( stat.gas[0,0] )
	usite = STRUPCASE( site)
   usemol, usite, ucmol, A

; Read in Averaging kernels file
	rc = 0
	rc = readnxn( ak, akfile )

	IF( rc NE 0 ) THEN BEGIN
		PRINTF, -2,'Could not read ak file: ', akfile
		STOP
	ENDIF

; Read in Averging Kernel Eigenvectors file
	rc = 0
	aevcrc = readaevc( aegv, aefile )
	;HELP, aegv
	IF( aevcrc NE 0 ) THEN BEGIN
		PRINTF, -2,'Could not read averaging kernel eiganvector file: ', aefile
	ENDIF

; Read in profiles file
	rc = 0
	rc = readprfs( prfs, prfile, stat.nlev )
	;HELP, prfs
	IF( rc NE 0 ) THEN BEGIN
		PRINTF, -2,'Could not read profiles file: ', prfile
		STOP
	ENDIF

; Read in K matrix file
	rc = 0
	rc = readkmf( kmf, kfile )
	;HELP, kmf
	IF( rc NE 0 ) THEN BEGIN
		PRINTF, -2,'Could not read K file: ', kfile
		STOP
	ENDIF

; Read in summary.st file for header info
	summary = STRARR( 10 )
	OPENR, lun, shfile, /GET_LUN, ERROR=ioerr
	IF( ioerr NE 0 ) THEN BEGIN
		PRINTF, -2, !ERR_STRING
		STOP
	ENDIF

	dumstr = ''
	PRINT, ' Short Summary :', FORMAT='(/,a)'
	nsum = 0
	WHILE( NOT EOF( lun )) DO BEGIN
		READF, lun, dumstr
		nsum++
		summary[nsum-1] = dumstr
		PRINT, nsum, summary[nsum-1], FORMAT='(i2,2x,a)'
	ENDWHILE
	FREE_LUN, lun
	PRINT, ''

	; 0 = X, 1 = PS
	FOR toPS = 0 , PS DO BEGIN

		thick = 1.0
		IF toPS THEN BEGIN ;1
			SET_PLOT, 'PS'
			psfile = 'oex.ps'
			PRINT, 'Saving ps file to : ', psfile
			DEVICE, /COLOR, /LANDSCAPE, $
			FILENAME = psfile, ENCAPSULATED = encap, BITS=8
			; full page PS

	      IF ThickLines THEN thick=3.5
			!P.CHARSIZE = 1
			!P.CHARTHICK = 4.0
			!X.THICK = thick
			!Y.THICK = thick
			stickthick = 8
			charsize = 2.
			lthick = thick
			fillcolor = 170
			tek = 0 ; black

		ENDIF ELSE BEGIN
			SET_PLOT,'X'
			DEVICE, DECOMPOSE = 0 ; allow for terminals with > 256 color

			IF ThickLines THEN thick=2.0
			!P.CHARSIZE = 1
			!P.CHARTHICK = 1
			!P.THICK = thick
			!X.THICK = thick
			!Y.THICK = thick
			stickthick = 1
			charsize = 1.5
			lthick = thick
			fillcolor = 0
			tek = 1 ; white

		ENDELSE

		; plot spectra
		rc = plotpbp( pbp, toPS, ppos, psiz, tek, lthick, summary, nsum, A.smol )

		; plot Smooth & Measurement error, profiles
		rc = plotprfs( sserr, smerr, stat, kmf, toPS, ppos, psiz, A.vmrscl, A.vmrunits, $
				tek, lthick, plottop, rms, vmrng )

		; plot averaging kernels
		rc = plotak( ak, stat, toPS, ppos, psiz, tek, lthick, plottop, usite, auc, prfs )

		; plot eigenvectors
		IF( aevcrc EQ 0 ) THEN BEGIN
			rc = plotaegv( aegv, stat, toPS, ppos, psiz, tek, lthick, plottop )
      ENDIF

		; 2d block plot plot Sa
		nlev = kmf.nlev
		ismx = kmf.ismx
		mat  = REVERSE( REVERSE( kmf.sa[ ismx:ismx+nlev-1, ismx:ismx+nlev-1 ], 1), 2)
		;rc = blockplot( mat, prfs, toPS, ppos, psiz, stickthick, 'Sa Covariance' )
		rc = covarplot( mat, prfs, toPS, ppos, psiz, stickthick, 'Sa Covariance', plottop )

		; 2d block plot plot Sm
		;rc = blockplot( smerr.mat, prfs, toPS, ppos, psiz, stickthick, 'Measurement Error' )
		rc = covarplot( smerr.mat, prfs, toPS, ppos, psiz, stickthick, 'Measurement Error', plottop )

		; 2d block plot plot Ss
		;rc = blockplot( sserr.mat, prfs, toPS, ppos, psiz, stickthick, 'Smoothing Error' )
		IF( NOT KEYWORD_SET( NSM )) THEN $
		    rc = covarplot( sserr.mat, prfs, toPS, ppos, psiz, stickthick, 'Smoothing Error', plottop )

		; 2d countour of K matrix
		rc = plotk( kmf, prfs, pbp, toPS, ppos, psiz, stickthick, plottop )

		; plot bnr file
		rc = plotbnr( pbp, toPS, ppos, psiz, stickthick, plottop, ftype )

		IF( toPS ) THEN DEVICE, /CLOSE_FILE

	ENDFOR ; toPS

	muncert = TOTAL( prfs.sigv[*]/prfs.rvmr[*] ) *100. / prfs.nlev
	PRINT, ' idx   zbar    apr_vmr   ret_vmr   vmr_sig   vmr_sig%  pc_var pc_var_mashup, AUC'
	FOR i=0, prfs.nlev-1 DO BEGIN
		PRINT, i, prfs.zbar[i], prfs.avmr[i], prfs.rvmr[i], prfs.sigv[i], $
			prfs.sigv[i]/prfs.rvmr[i]*100., prfs.var[i]*100., $
			100.+(prfs.sigv[i]/prfs.rvmr[i]-prfs.var[i])*100., auc[i], $
			FORMAT='(i2,2x,f5.1,3e12.4,3(f8.2,"%"), f10.4)'
	ENDFOR

	PRINT,''
	PRINT, ' Mean VMR uncertainty  : ', muncert, FORMAT='(a, f7.2, "%" )'
	PRINT, ' RMS Measurement error : ', rms*100, FORMAT='(a, f7.2, "%" )'

	PRINT,''
	FOR i=0, nsum-1 DO PRINT, i, summary[i], FORMAT='(i2,2x,a)'


	PRINT, ' OEX .DONE.', FORMAT='(/,a,/)'

END



; Plot bnr --------------------------------------------------------------------------

FUNCTION plotbnr, pbp, toPS, ppos, psiz, stickthick, plottop, ftype

	;ftype = 'B'
	file = 'temp.bnr.00'

	PRINT, 'bnr file type : ', ftype

	IF( ftype EQ 'L' ) THEN 			$
		OPENR, sftlun, file, /GET_LUN ,/F77_UNFORMATTED, /SWAP_ENDIAN, ERROR=ioerr	$
	ELSE IF( ftype EQ 'C' ) THEN 		$
		OPENR, sftlun, file, /GET_LUN, ERROR=ioerr 		$
	ELSE					$
		OPENR, sftlun, file, /GET_LUN ,/F77_UNFORMATTED, ERROR=ioerr

	IF( ioerr NE 0 ) THEN BEGIN
		PRINTF, -2, !ERR_STRING
		RETURN, 1
	ENDIF

	header = string(replicate(32b,80))
	READU, sftlun, header
	header = STRTRIM( header, 2 )
	PRINT, ' BNR File header:'
	PRINT, header
	PRINT, ''

	wlo=0D & whi=0D & spa=0D & npp=0L

	READU,sftlun,wlo,whi,spa,npp
	;print, wlo, whi, spa, npp

	arr=FLTARR(npp)
	READU, sftlun, arr
	FREE_LUN, sftlun

	xar = FLOAT( wlo + spa*FINDGEN(npp) )

	cbpos = FLTARR(4)
	ctpos = FLTARR(4)

	TEK_COLOR
	; set up windows
	IF toPS THEN BEGIN

		ERASE
		ctpos = [0.12, 0.10, 0.93, 0.83]
		xcharsz = 1.0
		ycharsz = 1.0

	ENDIF ELSE BEGIN

		ppos = ppos + [ 20, -20, 1 ]
		WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], 	$
			title= STRING( 'Plot ', ppos[2], FORMAT='(a,i02)') + ' : Spectra Region' ,  $
			XPOS = ppos[0], YPOS = ppos[1]
		;!P.CHARSIZE = 1.2
		DEVICE, DECOMPOSE = 0  ; allow for terminals with > 256 color
		ctpos = [0.10, 0.15, 0.92, 0.80]
		xcharsz = 1.
		ycharsz = 1.
		!P.CHARSIZE = 1

	ENDELSE

	minnu = MIN( pbp[*].nulo )
	maxnu = MAX( pbp[*].nuhi )

	buffer = 10
	xr = [ minnu -buffer, maxnu +buffer ]

	ix = LINDGEN(npp)
	yr = [ 0, max(arr(ix))+0.1*max(arr(ix)) ]
	yr = [0,0]

	q1 = MIN( arr )
	q3 = MAX( arr )
	qx = WHERE( arr LT 0.0, qc )
	IF( qc GT 0 ) THEN BEGIN
		q2 = MEAN( arr[qx] )
		xt = STRING( '!C', q3,' to ', q1, ' # neg : ', qc, ' mean : ', q2, -q1/q3*100, '%', $
			FORMAT = '(a, f7.4, a, f8.5, a, i6, a, f8.5, f6.2, a1 )' )
	ENDIF ELSE BEGIN
		xt = STRING( '!Cmax : ', q3,' min : ', q1, $
			FORMAT = '(a, f8.5, a, f8.5)' )
	ENDELSE

	PLOT, xar(ix), arr(ix), LINESTYLE = 0,				$
		XTITLE ='Wavenumber [cm-1]' + xt, 				$
		YTITLE ='Transmission',  						$
		YRANGE = yr, XRANGE = xr, TITLE =header, 		$
		XTICKFORMAT ='(f7.2)', 	YTICKFORMAT ='(f5.2)',	$
		XSTYLE = 1, YSTYLE = 0, POSITION = ctpos, 		$
		XCHARSIZE = xcharsz, YCHARSIZE = ycharsz

	OPLOT, !X.crange, [0,0], COLOR = 2, THICK = 2. ; red

	FOR i=0, pbp[0].nfit-1 DO BEGIN

		OPLOT, [ pbp[i].nulo, pbp[i].nulo ], !Y.CRANGE, COLOR= i +3, THICK = 2.
		OPLOT, [ pbp[i].nuhi, pbp[i].nuhi ], !Y.CRANGE, COLOR= i +3, THICK = 2.

	ENDFOR

	RETURN, 0
END


; Contour plot Sa ------------------------------------------------------------------

FUNCTION covarplot, mat, prfs, toPS, ppos, psiz, stickthick, title, plottop

	!P.MULTI = [2]

	cbpos = FLTARR(4)
	ctpos = FLTARR(4)

	; set up windows
	IF toPS THEN BEGIN

		cbpos = [0.20, 0.91, 0.80, 0.96]	; PS
		ctpos = [0.20, 0.10, 0.80, 0.81]
		ERASE

	ENDIF ELSE BEGIN

		cbpos = [0.20, 0.87, 0.90, 0.92]	; X
		ctpos = [0.25, 0.10, 0.85, 0.80]
		ppos = ppos +  [ 20,  -20, 1 ]
		WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], 	$
			title= STRING( 'Plot ', ppos[2], FORMAT='(a,i02)') + ' : ' + title,  $
			XPOS = ppos[0], YPOS = ppos[1]
		!P.CHARSIZE = 1.2
		DEVICE, DECOMPOSE = 0  ; allow for terminals with > 256 color
      chsiz = 1
	ENDELSE

	IF( toPS ) THEN PRINT, ' CovarPlot : ', title

	nlev = prfs.nlev
	z    = prfs.zbar
	bnd  = [ prfs.zbnd, 80.0 ]

	div = 0
	WHILE( MAX( mat ) GT 10. ) DO BEGIN
		div = div -1
		mat = mat / 10.
	ENDWHILE

	WHILE( MAX( mat ) LT 1. ) DO BEGIN
      div = div +1
		mat = mat * 10.
	ENDWHILE

	; set up contours
	ndiv = 7
	nclr = 200
	scal = 1.0
	span = MAX(mat)/scal - MIN(mat) + 0.0*(MAX(mat) - MIN(mat))
	clvs = MIN(mat) - 0.0*span + INDGEN( nclr+1 ) * span/(nclr -1)

	IF( NOT toPS ) THEN PRINT, ' Min, Max of contour levels              : ', MIN( clvs ), MAX( clvs )
	IF( not toPS ) THEN PRINT, ' Number of contour divisions in colorbar : ', ndiv
	IF( not toPS ) THEN PRINT, ' Number of color levels in contour plot  : ', nclr

	; define contours names for color table ticks
	cbtics = STRARR( ndiv + 1 )
	FOR i = 0, ndiv DO BEGIN
		cbtics[i] = STRING( clvs[i*(nclr/ndiv)], FORMAT = '(f7.3)' )
		;PRINT, i, nclr/ndiv, nclr/ndiv*i, clvs[i*(nclr/ndiv)], cbtics[i]
	END

	; tell max and min out of range
	FOR i=0, nlev-1 do begin
		FOR j=0, nlev-1 do begin
			IF mat[j,i] LT MIN( clvs ) THEN PRINT, 'less : ', j, i, mat[j,i]
			IF mat[j,i] GT MAX( clvs ) THEN PRINT, 'more : ', j, i, mat[j,i]
		END
	END

; CONTOUR - set up the plot window
	; colorbar at top

	LOADCT, 5, NCOLORS = nclr+40, /SILENT;, BOTTOM = 10

	cbtitle = title + ' [x10!E' + STRING( div, FORMAT='(i+2)' ) + '!N]'
	COLORBAR, NCOLORS = nclr, POSITION = cbpos, CHARSIZE = chsiz,		$
		DIVISIONS = ndiv, TICKNAMES = cbtics, TITLE = cbtitle, BOTTOM=00

	CONTOUR, mat, z, z, POSITION = ctpos, NLEVELS = nclr,				$
		YRANGE = [0.0, plottop], XRANGE = [0.0, plottop],				$
		;C_COLORS = INDGEN(nclr)+00,									$
		CHARSIZE = chsiz, /FILL, YTICKLEN = -0.02, XTICKLEN = -0.02, 		$
		YTITLE = 'Altitude [km]', XTITLE = 'Altitude [km]'

	;print,''
	;print, mat[indgen(40),indgen(40)]
	RETURN, 0

END

; Contour plot K Matrix ------------------------------------------------------------------

FUNCTION plotk, kmf, prfs, pbp, toPS, ppos, psiz, stickthick, plottop

	nfit = pbp[0].nfit
	!P.MULTI = [nfit+1,nfit,nfit,0,0]

	cbpos = FLTARR(4)
	ctpos = FLTARR(4)

	; set up windows
	IF toPS THEN BEGIN

		ERASE
		cbpos = [0.20, 0.92, 0.80, 0.97]	; PS
		ctpos = [0.12, 0.10, 0.93, 0.83]
		ftpos = [ .00, .04, 0.08 ]
		xcharsz = 1.3
		ycharsz = 1.8

	ENDIF ELSE BEGIN

		ppos = ppos +  [ 20,  -20, 1 ]
		WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1],	$
			title= STRING( 'Plot ', ppos[2], FORMAT='(a,i02)') + ' : K Matrix',	$
			XPOS = ppos[0], YPOS = ppos[1]
		;!P.CHARSIZE = 1.2
		DEVICE, DECOMPOSE = 0  ; allow for terminals with > 256 color
		cbpos = [0.20, 0.87, 0.90, 0.92]	; X
		ctpos = [0.10, 0.10, 0.95, 0.80]
		ftpos = [0.02, 0.05, 0.08 ]
		xcharsz = 1.3
		ycharsz = 1.3

	ENDELSE

	nlev = kmf.nlev
	ismx = kmf.ismx
	npts = kmf.npts
	mat  = -REVERSE( kmf.kmat[ 0:npts-1, ismx:ismx+nlev-1 ], 2); *1000.0

	title = ' Jacobian Matrix : ' + STRING( nlev, npts, FORMAT='( i2,"x",i5 )' )
;	mat = kmf.kmat *1000.0

	div = 0
	WHILE( MAX( mat ) GT 10. ) DO BEGIN
		div = div -1
		mat = mat / 10.
	ENDWHILE

	WHILE( MAX( mat ) LT 1. ) DO BEGIN
		div = div +1
		mat = mat * 10.
	ENDWHILE

	z = prfs.zbar

	; set up contours
	ndiv = 7
	nclr = 240
	scal = 1.0
	span = MAX(mat)/scal - MIN(mat) + 0.0*(MAX(mat) - MIN(mat))
	clvs = MIN(mat) - 0.0*span + INDGEN( nclr +1 ) * span/(nclr -1)

	IF( NOT toPS ) THEN PRINT, ' Min, Max of contour levels             : ', MIN( clvs ), MAX( clvs )
	IF( NOT toPS ) THEN PRINT, ' Number of contour divisions in colorbar : ', ndiv
	IF( NOT toPS ) THEN PRINT, ' Number of color levels in contour plot  : ', nclr

	; define contours names for color table ticks
	cbtics = STRARR( ndiv + 1 )
	FOR i = 0, ndiv DO BEGIN
		cbtics[i] = STRING( clvs[i*(nclr/ndiv)], FORMAT = '(f7.3)' )
		;PRINT, i, nclr/ndiv, nclr/ndiv*i, clvs[i*(nclr/ndiv)], cbtics[i]
	END

	; tell max and min out of range
	FOR i=0, nlev-1 do begin
		FOR j=0, nlev-1 do begin
			IF mat[j,i] LT MIN( clvs ) THEN PRINT, 'less : ', j, i, mat[j,i]
			IF mat[j,i] GT MAX( clvs ) THEN PRINT, 'more : ', j, i, mat[j,i]
		END
	END

; CONTOUR - set up the plot window
	; colorbar at top

	LOADCT, 5, NCOLORS = nclr, /SILENT ;, BOTTOM=20
	cbtitle = title + ' [x10!E' + STRING( div, FORMAT='(i+2)' ) + '!N]'
	COLORBAR, NCOLORS = nclr-40, POSITION = cbpos, CHARSIZE=1.5,	$
		DIVISIONS = ndiv, TICKNAMES = cbtics, TITLE = cbtitle

	offset = 0
	pointoff = 0
	pwidth = ctpos[2] - ctpos[0]
	thispos = FLTARR(4)
	thistic = FLTARR(8)

	;Tick step size for major ticks. ie 1 = every wavenumber
	tick_interval = 1
	minor = 10

	FOR kk = 0, nfit-1 DO BEGIN

		thispos = ctpos
		pratio = FLOAT( pbp[kk].npt ) / FLOAT( npts	)

		pw = pratio * pwidth

		thispos[0] = ctpos[0] + offset
		thispos[2] = ctpos[0] + offset + pw
		offset = offset + pw

		IF( kk EQ 0 ) THEN BEGIN
			thispos[2] = thispos[2] - 0.01
		ENDIF ELSE IF( kk EQ nfit -1 ) THEN BEGIN
			thispos[0] = thispos[0] + 0.01
		ENDIF ELSE BEGIN
			thispos[2] = thispos[2] - 0.0005
			thispos[0] = thispos[0] + 0.0005
		ENDELSE

		npt      = pbp[kk].npt
		x        = pbp[kk].wnu[0:npt-1]
		thismat   = mat[ pointoff:pointoff+npt-1, * ]
		pointoff  = pointoff + npt

      nulo = pbp[kk].nulo
      nuhi = pbp[kk].nuhi
      IF( NOT toPS ) THEN PRINT, ' wv # range : ', kk, nulo, nuhi, pw

      leftmost_tick = floor(nulo / tick_interval)*tick_interval + tick_interval
      rightmost_tick = floor(nuhi / tick_interval)*tick_interval

      num_ticks = (rightmost_tick - leftmost_tick) / tick_interval + 1
      if (not toPS) then begin
         print, 'number of major ticks: ',num_ticks
         if (num_ticks eq 1) then begin
            print, 'Warning: only 1 major tick for interval, no minor tick marks will show'
         endif
         if (num_ticks eq 0) then begin
            print, 'Warning: no major ticks for interval, no major or minor tick marks will show'
         endif
      endif

      ;Set character size along y-axis to have characters only for left-most plot
      ys = 0
      IF( kk eq 0 ) THEN BEGIN
      ys = ycharsz
      ENDIF ELSE BEGIN
      ys = 0.0001;Small enough to suppress characters showing up
      ;If set to 0, IDL scales to a small, but visible size
      ENDELSE

      CONTOUR, thismat, x, z, POSITION = thispos, NLEVELS = nclr-40,$
         YRANGE = [0.0, plottop], /FILL,$
         CHARSIZE = charsz, YTICKLEN = -0.02, XTICKLEN = -0.02,$
         YTITLE = 'Altitude [km]', xtitle = '', XCHARSIZE = xcharsz,$
         YCHARSIZE = ys,$
         XRANGE = [nulo,nuhi],$
         XSTYLE = 1,$
         XTICKINTERVAL = tick_interval,$
         XMINOR = minor

	ENDFOR

	xtitl = 'Wavenumber [cm!E-1!N]'
	XYOUTS, 0.5, ftpos[0], xtitl, /NORMAL, CHARSIZE=1.2, ALIGNMENT = 0.5

	RETURN, 0

END

; Contour plot Sa ------------------------------------------------------------------

FUNCTION blockplot, mat, prfs, toPS, ppos, psiz, stickthick, title

	!P.MULTI = [2]

	cbpos = FLTARR(4)
	ctpos = FLTARR(4)

	; set up windows
	IF toPS THEN BEGIN

		cbpos = [0.20, 0.91, 0.80, 0.97]	; PS
		ctpos = [0.20, 0.10, 0.80, 0.81]
		ERASE
		sp = 0.1

	ENDIF ELSE BEGIN

		cbpos = [0.20, 0.87, 0.90, 0.92]	; X
		ctpos = [0.25, 0.10, 0.85, 0.80]
		sp = 0.1
		ppos = ppos +  [ 20,  -20, 1 ]
		WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], 	$
			title= STRING( 'Plot ', ppos[2], FORMAT='(a,i02)') + ' : ' + title,  $
			XPOS = ppos[0], YPOS = ppos[1]
		!P.CHARSIZE = 1.2
		DEVICE, DECOMPOSE = 0  ; allow for terminals with > 256 color

	ENDELSE

	IF( toPS ) THEN PRINT, ' blockplot : ', title

	nlev = prfs.nlev
	z    = prfs.zbar
	bnd  = [ prfs.zbnd, 80.0 ]

	div = 0
	WHILE( MAX( mat ) GT 10. ) DO BEGIN
		div = div -1
		mat = mat * 10
	ENDWHILE

	WHILE( MAX( mat ) LT 1. ) DO BEGIN
		div = div +1
		mat = mat * 10
	ENDWHILE


	; set up contours
	ndiv = 7
	nclr = 240
	scal = 1.0
	span = MAX(mat)/scal - MIN(mat) + 0.0*(MAX(mat) - MIN(mat))
	clvs = MIN(mat) - 0.0*span + INDGEN( nclr+1 ) * span/(nclr -1)

	IF( NOT toPS ) THEN PRINT, ' Min, Max of contour levels             : ', MIN( clvs ), MAX( clvs )
	IF( NOT toPS ) THEN PRINT, ' Number of contour divisions in colorbar : ', ndiv
	IF( NOT toPS ) THEN PRINT, ' Number of color levels in contour plot  : ', nclr

	; define contours names for color table ticks
	cbtics = STRARR( ndiv + 1 )
	FOR i = 0, ndiv DO BEGIN
		cbtics[i] = STRING( clvs[i*(nclr/ndiv)], FORMAT = '(f7.3)' )
		;PRINT, i, nclr/ndiv, nclr/ndiv*i, clvs[i*(nclr/ndiv)], cbtics[i]
	END

	; tell max and min out of range
	FOR i=0, nlev-1 do begin
		FOR j=0, nlev-1 do begin
			IF mat[j,i] LT MIN( clvs ) THEN PRINT, 'less : ', j, i, mat[j,i]
			IF mat[j,i] GT MAX( clvs ) THEN PRINT, 'more : ', j, i, mat[j,i]
		END
	END

; CONTOUR - set up the plot window
	; colorbar at top

	LOADCT, 5, NCOLORS = nclr, /SILENT
	cbtitle = title + ' [x10!E' + STRING( div, FORMAT='(i+2)' ) + '!N]'
	COLORBAR, NCOLORS = nclr-40, POSITION = cbpos, CHARSIZE=2.8,		$
			DIVISIONS = ndiv, TICKNAMES = cbtics, TITLE = cbtitle

	CONTOUR, mat, z, z, POSITION = ctpos,								$
		YRANGE = [0.0,80.], XRANGE = [0.0,80.],							$
		CHARSIZE = 3.0, /NODATA, YTICKLEN = 0.04, XTICKLEN = 0.04, 		$
		YTITLE = 'Altitude [km]', XTITLE = 'Altitude [km]'

; plot color blocks width of layer boundries sticks

	pbnd       = bnd
	pbnd[0]    = z[0]
	pbnd[nlev] = z[nlev-1]
	FOR i = 0, nlev-1 DO BEGIN
		span = (bnd[i+1] - bnd[i])
		ns = FIX( span / sp )
			FOR j = 0, ns-1 DO BEGIN
			X = DBLARR(nlev+1) + bnd[i] + (bnd[i+1] - bnd[i])/ns *j
			q = REFORM( mat[i,*] )
			PLOTS, X, bnd, THICK = stickthick,				$
				COLOR=BYTSCL( [ 0, q ], TOP = nclr-40 ),	$
				NOCLIP = 0, CLIP=[ pbnd[i], pbnd[0], pbnd[i+1], pbnd[nlev] ]

		ENDFOR
	ENDFOR

	RETURN, 0

END


; Plot averaging kernel eiganvectors --------------------------------------------------------------------

FUNCTION plotaegv, aegv, stat, toPS, ppos, psiz, tek, lthick, plottop

	!P.MULTI = [ 0, 3, 2, 0, 0 ]

	; set up windows
	IF toPS THEN BEGIN

		ERASE
	ENDIF ELSE BEGIN

		ppos = ppos +  [ 20,  -20, 1 ]
		WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], 	$
			title= STRING( 'Plot ', ppos[2], FORMAT='(a,i02)') + ' : Averging Kernel Eigenvectors',  $
			XPOS = ppos[0], YPOS = ppos[1]
		!P.CHARSIZE = 1.2
	ENDELSE

	nlev  = stat.nlev
	z     = stat.z
	egval =  REVERSE( SORT( aegv.rlevl ))

	TEK_COLOR
	FOR i = 0, 5 DO BEGIN

		; plot 6 averaging kernel Eigenvectors
		PLOT, aegv.mat[ egval[i], *], z, YRANGE=[0.0,plottop], XRANGE=[-1.,1.],		$
			YTITLE = 'Altitude [km]', YTICKLEN = 0.06, XTICKLEN = 0.03,				$
			TITLE = 'Eigenvector #  ' + STRING( i+1, FORMAT='(i1)'),				$
			XTITLE = 'E-Value : ' + STRING( aegv.rlevl[egval[i]], FORMAT='( f8.5 )'),	$
			CHARSIZE = 1.8, /NODATA
		OPLOT, aegv.mat[ egval[i], *], z, COLOR = 3, THICK = lthick

	ENDFOR

	RETURN, 0

END



; Plot averaging kernels --------------------------------------------------------------------

FUNCTION plotak, ak, stat, toPS, ppos, psiz, tek, lthick, plottop, site, auc, prfs

	!P.MULTI = [ 0, 2, 1 ]

	yrng = [0.,plottop]
   nlev = prfs.nlev
   v = prfs.avmr     ; not rvmr!
   z = prfs.zbar

   ; scale apriori relative kernel for vmrs
   mat = dblarr(nlev,nlev)
   for i=0, nlev-1 do begin
      for j=0, nlev-1 do mat[i,j] = ak.mat[i,j] *v[i]/v[j]
   endfor

	; set up windows
	IF toPS THEN BEGIN
		ERASE
		!P.CHARSIZE = 1.6
	ENDIF ELSE BEGIN
		ppos = ppos + [ 20, -20, 1 ]
		WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], 	$
			title= STRING( 'Plot ', ppos[2], FORMAT='(a,i02)') + ' : Averging Kernels',  $
			XPOS = ppos[0], YPOS = ppos[1]
		!P.CHARSIZE = 1.2
	ENDELSE

	omx = MAX( mat, MIN=omn )
	cmx = MAX( mat, MIN=cmn )
	IF (omx GT cmx) THEN BEGIN
		mx = omx
	ENDIF ELSE BEGIN
		mx = cmx
	ENDELSE
	IF (omn LT cmn) THEN BEGIN
		mn = omn
	ENDIF ELSE BEGIN
		mn = cmn
	ENDELSE

	TEK_COLOR
	; plot all averaging kernels on left
	PLOT, mat[0,*], z, /NODATA, $
	   YRANGE = yrng,	$
		YTITLE = 'Altitude [km]', $
		YTICKLEN = 0.06, $
		XTICKLEN = 0.03,		$
		TITLE = 'All Averging Kernels', $
		XTITLE = 'Fractional Value',	$
		XTICKS=4, $
		XRANGE=[mn,mx]

   xr = !X.Crange
   yr = !Y.Crange

	cc = 1
	FOR i = 0, nlev-1, 2 DO BEGIN
		cc = cc + 1 mod 32
		; 0,1 are black and white, resp, which we want to skip
		IF( cc eq 0 )THEN cc = 2
		; Switching kernels to rows - second index
		OPLOT, mat[i,*], z, COLOR = cc, THICK = lthick
	   XYOUTS, xr[0], z[i], STRING(z[i],FORMAT='(i2)'), COLOR=cc, NOCLIP=0
	ENDFOR

	; sum several kernels
	; from ground - IRWG
	IF( site NE 'ACF' ) THEN BEGIN
		PRINT, '!!!! Plotting Ground-based Summed Kernels!!!!'
		bnds  = [ [0, 8], [8, 17], [17, 26], [26, 40], [0, 120], [0,5], [0,8], [0,11] ]
		bname = [ ' 0- 8km', ' 8-17km', '17-26km', '26-40km', ' 0-120km', 'Prior Cont', ' 0-5km', ' 0-8km',' 0-11km' ]
		nband = 8
	ENDIF ELSE BEGIN
	; Aircraft
		PRINT, '!!!! Plotting Aircraft Summed Kernels!!!!'
		bnds  = [ [10, 13], [13, 18], [18, 26], [26, 40], [10, 80] ]
		bname = [ '10-13km', '13-18km', '18-26km', '26-40km', '10-80km', 'Prior Cont' ]
		nband = 5
	ENDELSE
	bpos  = [ [0.84, 0.90], [0.84, 0.86], [0.84, 0.82], [0.84, 0.78], [0.84, 0.74], [0.84, 0.70]];, [0.84, 0.66]];!added [0.84, 0.66] RB 4/8/10

	; plot summed averaging kernels on right
	PLOT, TOTAL( mat, 1 ), z, /NODATA, YRANGE=yrng, XRANGE = [-0.5, 2.0], $
		YTITLE = 'Altitude [km]', YTICKLEN = 0.06, XTICKLEN = 0.03, $
		TITLE = 'Summed Partial Kernels', XTITLE = 'Fractional Value'

	smaks = DBLARR( nlev, nband )

	FOR i = 0, nband-1 DO BEGIN
		ids        = WHERE(( z GE bnds[0,i] ) AND ( z LT bnds[1,i] ), cnt )
      if( cnt lt 1 )then continue
		smak = TOTAL( mat[ ids, * ], 1 )
		smaks[ *, i ] = smak

		IF( i GT 4 )THEN CONTINUE

		OPLOT, smaks[ *, i ], z, COLOR = i+2, THICK = lthick
		XYOUTS, bpos[0,i], bpos[1,i], bname[i], /NORMAL, COLOR = i+2, CHARSIZE=1.4

	ENDFOR

	OPLOT, [0.0,0.0], [0.0,80.0], COLOR = tek

	; Compute 'area under curve for AK's as apriori contribution
	auc = DBLARR( nlev )
   FOR i=0, nlev-1 DO auc[i] = total( mat[*,i], /DOUBLE )
	cc = 12	; Purple
	XYOUTS, bpos[0,5], bpos[1,5], bname[5], /NORMAL, COLOR = cc, CHARSIZE=1.4
   OPLOT, 1.-auc, z, color=cc, thick=lthick, linestyle=1

	; Printout summed kernels
	IF( toPS )THEN BEGIN
		OPENW, lun, 'partkrnl.dat', /GET_LUN
		PRINTF, lun, 'Alt[km]', bname, FORMAT='(10A13)'
		FOR i=0, nlev-1 DO PRINTF, lun, z[i], smaks[i, 0:4], 1.-auc[i],smaks[i, 5:7], FORMAT='(F8.2, 10F14.6)'
		FREE_LUN, lun
		pre_k = smak[0]
		FOR i=1, cnt-1 DO BEGIN
			IF( pre_k GE 0.5 AND i EQ 1 ) THEN PRINT, 'Min alt TCAK GT 0.5 : ', z[ids[0]]
			IF( pre_k LT 0.5 AND smak[ids[i]] GE 0.5 ) THEN PRINT, 'Min alt TCAK GT 0.5 : ', z[ids[i-1]]
			IF( pre_k GE 0.5 AND smak[ids[i]] LT 0.5 ) THEN PRINT, 'Max alt TCAK GT 0.5 : ', z[ids[i-1]]
			pre_k = smak[ids[i]]
		ENDFOR
	ENDIF

	RETURN, 0
END


; Plot Smooth & Measurement error, profiles --------------------------------------------------------------------
FUNCTION plotprfs, sserr, smerr, stat, kmf, toPS, ppos, psiz, vmrscl, vmrunits, $
				tek, lthick, plottop, rms, vmrng

	!P.MULTI = [ 0, 3, 1 ]

	nlev  = smerr.n
	z     = stat.z
	sqrsm = DBLARR( nlev )
	sqrss = sqrsm

	diag = INDGEN( nlev )

	layr = DBLARR(nlev)
	FOR i=0, nlev-2 DO layr[i] = ( z[i+1] - z[i] ) ;*1.0e5
	layr[nlev-1] = ( 80. - z[nlev-1] )

	sqrsm = SQRT( smerr.mat[ diag, diag ] )
	sqrss = SQRT( sserr.mat[ diag, diag ] )

	npar = kmf.npar
	npts = kmf.npts
	nlev = kmf.nlev
	ismx = kmf.ismx

	sa   = REVERSE( REVERSE( kmf.sa[ ismx:ismx+nlev-1, ismx:ismx+nlev-1 ], 1), 2)
	shat = REVERSE( REVERSE( kmf.shat[ ismx:ismx+nlev-1, ismx:ismx+nlev-1 ], 1), 2)

	sqrsa = SQRT( sa[ diag, diag ] )
	sqrsh = SQRT( shat[ diag, diag ] )
	;print, sqrsa


	; set up windows
	IF toPS THEN BEGIN

		ERASE
		!P.CHARSIZE = 1.6
	ENDIF ELSE BEGIN

		ppos = ppos +  [ 20,  -20, 1 ]
		WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], 	$
			title= STRING( 'Plot ', ppos[2], FORMAT='(a,i02)') + ' : Error Diagonals & VMRs',  $
			XPOS = ppos[0], YPOS = ppos[1]
		!P.CHARSIZE = 1.6

	ENDELSE

	dex = WHERE( z LE plottop )
	mx = MAX( [ sqrsm[dex], sqrss[dex], sqrsa[dex]*layr, sqrsh[dex]], MIN=mn )
	print, mx, mn

	IF( toPS ) THEN BEGIN
		PRINT, '  i   alt     Sm        Ss       Sa       Shat'
		FOR i=0, nlev-1 DO PRINT, i, z[i], sqrsm[i], sqrss[i], sqrsa[i], sqrsh[i], $
								FORMAT='(i4, f6.2, 4f9.5)'
	ENDIF

	rms = SQRT( TOTAL( sqrsm*sqrsm )/nlev)
	PRINT, ' RMS Measurement error : ', rms*100, FORMAT='(a, f7.2, "%" )'

	; plot uncertainty diagonals
	PLOT, sqrsm, z, /NODATA, YRANGE=[0.0, plottop], $
		YTITLE = 'Altitude [km]', YTICKLEN = 0.06, XTICKLEN = 0.03, $
		TITLE = 'Uncertainty Diagonals', XTITLE = 'Fractional Value', $
		XRANGE = [ mn, mx ], XTICKFORMAT = 'exponent', XSTYLE=0,CHARSIZE=1.5 ;/XLOG

	OPLOT, sqrsm, z, COLOR = 2, THICK = lthick
	OPLOT, sqrss, z, COLOR = 3, THICK = lthick
	OPLOT, sqrsa*layr, z, COLOR = 4, THICK = lthick
	OPLOT, sqrsh, z, COLOR = 5, THICK = lthick

	XYOUTS, 0.34, 0.50, 'Measure', /NORMAL, COLOR = 2, CHARSIZE=1.5, $
		ORIENTATION = 90
	XYOUTS, 0.34, 0.30, 'Smooth', /NORMAL, COLOR = 3, CHARSIZE=1.5, $
		ORIENTATION = 90
	XYOUTS, 0.34, 0.10, 'A-priori', /NORMAL, COLOR = 4, CHARSIZE=1.5, $
		ORIENTATION = 90
	XYOUTS, 0.34, 0.70, 'Total', /NORMAL, COLOR = 5, CHARSIZE=1.5, $
		ORIENTATION = 90

	; calculate ymin and ymax for profiles plot

	dex = where(z LE plottop, cnt)
	if( cnt EQ 0 )then stop, 'plotprf & z & plottop'
	avmr = stat.vmr[0,0,dex] * vmrscl
	vmr = stat.vmr[1,0,dex] * vmrscl

	omx = MAX( vmr, MIN=omn )
	cmx = MAX( avmr, MIN=cmn )
	IF (omx GT cmx) THEN BEGIN
		mx = omx
	ENDIF ELSE BEGIN
		mx = cmx
	ENDELSE
	IF (omn LT cmn) THEN BEGIN
		mn = omn
	ENDIF ELSE BEGIN
		mn = cmn
	ENDELSE

	; plot vmrs log
	PLOT, vmr, z[dex], /XLOG, /NODATA, YRANGE=[0.0, plottop], XRANGE=[mn,mx], $
		YTITLE = 'Altitude [km]', YTICKLEN = 0.06, XTICKLEN = 0.03, 	$
		XTITLE = 'Mixing Ratio for ' + stat.gas[0] + ' ' + vmrunits, $
		TITLE = 'Mixing Ratio', XTICKFORMAT = 'exponent',CHARSIZE=1.5

	OPLOT, vmr, z[dex], COLOR = 2, THICK = lthick
	OPLOT, avmr, z[dex], COLOR = 3, THICK = lthick

	XYOUTS, 0.67, 0.55, 'Retrieved VMR', /NORMAL, COLOR = 2, CHARSIZE=1.5, $
		ORIENTATION = 90
	XYOUTS, 0.67, 0.25, 'A Priori VMR', /NORMAL, COLOR = 3, CHARSIZE=1.5, $
		ORIENTATION = 90

	; plot vmrs linear
	PLOT, vmr, z[dex], /NODATA, YRANGE=[0.0, plottop], XRANGE=[mn,mx], $
		YTITLE = 'Altitude [km]', YTICKLEN = 0.06, XTICKLEN = 0.03, 	$
		XTITLE = 'Mixing Ratio for ' + stat.gas[0] + ' ' + vmrunits, $
		TITLE = 'Mixing Ratio' ;, XTICKFORMAT = 'exponent'

	OPLOT, vmr, z[dex], COLOR = 2, THICK = lthick
	OPLOT, avmr, z[dex], COLOR = 3, THICK = lthick

	;XYOUTS, 0.67, 0.55, 'Retrieved VMR', /NORMAL, COLOR = 2, CHARSIZE=1.7, $
	;	ORIENTATION = 90
	;XYOUTS, 0.67, 0.25, 'A Priori VMR', /NORMAL, COLOR = 3, CHARSIZE=1.7, $
	;	ORIENTATION = 90

	RETURN, 0



END


; Plot spectra --------------------------------------------------------------------

FUNCTION plotpbp, pbp, toPS, ppos, psiz, tek, lthick, summary, nsum, smol

	!P.MULTI = 2

	dfpos = FLTARR(4)
	sppos = FLTARR(4)
	ftpos = FLTARR(5); changed from 3 RB

	nfit = pbp[0].nfit

	TEK_COLOR
	FOR kk = 0, nfit-1 DO BEGIN

		; set up windows
		IF toPS THEN BEGIN

			dfpos = [0.12, 0.80, 0.93, 0.97]	; PS
			sppos = [0.12, 0.20, 0.93, 0.74]
;			ftpos = [ .00, .04, 0.08 ];RB
			ftpos = [0.00, .02, .04, .06, 0.08]
			hdpos = .76
			IF( kk NE 0 ) THEN ERASE

		ENDIF ELSE BEGIN

			dfpos[*] = [0.15, 0.78, 0.95, 0.95]	; X
			sppos[*] = [0.15, 0.20, 0.95, 0.72]
			;ftpos[*] = [ .02, .05, 0.08 ]; RB
			ftpos[*] = [ .00, .02, 0.04, 0.06, 0.08]
			hdpos = 0.74
			ppos = ppos + [ 20, -20, 1 ]

			WINDOW, ppos[2], RETAIN=2, XSIZE=psiz[0], YSIZE=psiz[1], 	$
				title = STRING( 'Plot ', ppos[2], $
				FORMAT = '(a,i02)') + ' : Spectral Fit : ' + string( kk+1, nfit, format='(i02,"/",i02)' ), $
				XPOS = ppos[0], YPOS = ppos[1]

		ENDELSE

		npt1 = pbp[kk].npt -1

		; set diff range
		mx = MAX( pbp[kk].difspc[0:npt1], MIN=mn )
		IF( ABS(mn) GT ABS(mx) ) THEN mx = mn
		!y.range = [ -ABS(mx), ABS(mx) ]

		titl = 'NCAR FTS Retrieval : ' + smol
		; plot difference on top
		PLOT, pbp[kk].wnu[0:npt1], pbp[kk].difspc[0:npt1],  	$
			POSITION = dfpos, YTICKS = 4, TITLE = titl,			$
			/NODATA, YTITLE='Difference', CHARSIZE = 1.4, 		$
			XTICKNAME = REPLICATE(' ',30), XTICKLEN = 0.08 ;	$
			;XTITLE = 'Wavenumber [cm!E-1!N]'

		OPLOT, !X.CRANGE, [0.0,0.0], COLOR = tek, THICK = lthick/2
		OPLOT, pbp[kk].wnu[0:npt1], pbp[kk].difspc[0:npt1], COLOR = 4, $
		THICK = lthick

		; calculate ymin and ymax for transmission plot
		omx = MAX( pbp[kk].obsspc[0:npt1], MIN=omn )
		cmx = MAX( pbp[kk].synspc[0:npt1], MIN=cmn )

		IF( omx GT cmx ) THEN BEGIN
			mx = omx
		ENDIF ELSE BEGIN
			mx = cmx
		ENDELSE

		IF( omn LT cmn ) THEN BEGIN
			mn = omn
		ENDIF ELSE BEGIN
			mn = cmn
		ENDELSE

		; set range and ticks on ordinate
		ymn = 5
		IF( mn GT 0.8 ) THEN mn = 0.8
		IF( mn EQ 0.8 ) THEN ymn = 2
		IF( mn LT 0.8 AND mn GE .4) THEN mn = 0.4
		IF( mn EQ 0.4 ) THEN ymn = 3
		;IF( mn LT 0.4 AND mn GE .2) THEN mn = 0.2
		IF( mn EQ 0.2 ) THEN ymn = 4
		IF( mn LT 0.2 ) THEN mn = 0.0
		IF( mn EQ 0.0 ) THEN ymn = 5
		IF( mx GT 1.0 ) THEN mx = 1.0

		!Y.RANGE=[mn,mx]
		;print, !y.range

		; plot spectra
		PLOT, pbp[kk].wnu[0:npt1], pbp[kk].obsspc[0:npt1],    $
			POSITION = sppos, YTICKS = 4,						$
			/NODATA, YTITLE='Transmission', CHARSIZE = 1.4, 	$
			XTICKLEN = 0.06, YSTYLE = 1, YMINOR = ymn,			$
			XTITLE = 'Wavenumber [cm!E-1!N]'

		IF( !Y.CRANGE[0] LT 0.0 ) THEN OPLOT, !X.CRANGE, [0.0,0.0], COLOR = tek

		OPLOT, pbp[kk].wnu[0:npt1], pbp[kk].obsspc[0:npt1], $
			COLOR = 3, THICK = lthick, /NOCLIP

		OPLOT, pbp[kk].wnu[0:npt1], pbp[kk].synspc[0:npt1], $
			COLOR = 2, THICK = lthick, /NOCLIP

		;legend = STRING( 'Observed', 'Fitted', 'Difference', FORMAT='(3a14)' )
		;print, legend
		XYOUTS, 0.12, hdpos, 'Observed', /NORMAL, COLOR = 3, CHARSIZE=1.7
		XYOUTS, 0.30, hdpos, 'Calculated', /NORMAL, COLOR = 2, CHARSIZE=1.7
		XYOUTS, 0.50, hdpos, 'Difference', /NORMAL, COLOR = 4, CHARSIZE=1.7

cz = 1.0
	   XYOUTS, 0.5, ftpos[0], summary[3], /NORMAL, CHARSIZE=cz, ALIGNMENT = 0.5
      XYOUTS, 0.5, ftpos[1], summary[2], /NORMAL, CHARSIZE=cz, ALIGNMENT = 0.5
  	   XYOUTS, 0.5, ftpos[2], summary[4], /NORMAL, CHARSIZE=cz, ALIGNMENT = 0.5
		XYOUTS, 0.5, ftpos[3], summary[1], /NORMAL, CHARSIZE=cz, ALIGNMENT = 0.5
		XYOUTS, 0.5, ftpos[4], summary[nsum-1], /NORMAL, CHARSIZE=cz, ALIGNMENT = 0.5
		;XYOUTS, 0.5, ftpos[2], summary[nsum-1], /NORMAL, CHARSIZE=1.2, ALIGNMENT = 0.5

	ENDFOR

	RETURN, 0

END


; Read in statevec file --------------------------------------------------------------------

FUNCTION readstat, sts, file

	OPENR, lun, file, /GET_LUN, ERROR=ioerr
	IF( ioerr NE 0 ) THEN BEGIN
		PRINTF, -2, !ERR_STRING
		RETURN, 1
	ENDIF

	dum = ''
	READF, lun, nlev
	z = FLTARR(nlev) & p = z & t = z & vmr = z

	READF, lun, dum & READF, lun, z
	READF, lun, dum & READF, lun, p
	READF, lun, dum & READF, lun, t
	READF, lun, dum & READF, lun, ngas

	sts = {									$
		nlev	: 0,						$
		ngas	: 0, 						$
		z		: FLTARR( nlev ),			$
		p		: FLTARR( nlev ),			$
		t		: FLTARR( nlev ),			$
		col		: FLTARR( 2, ngas ),		$
		vmr		: FLTARR( 2, ngas, nlev ),	$
		gas		: STRARR( 2, ngas )			$
		}

	sts.nlev = nlev
	sts.ngas = ngas
	sts.z = REVERSE( z )
	sts.p = REVERSE( p )
	sts.t = REVERSE( t )

	col = 0.0
	name = ''

	FOR i = 0, ngas-1 DO BEGIN
		FOR j = 0, 1 DO BEGIN

			READF, lun, dum & READF, lun, name & READF, lun, col
			READF, lun, vmr

			sts.gas[j, i] = STRTRIM( name, 2 )
			sts.col[j, i] = col
			sts.vmr[j, i, *] = REVERSE( vmr )

		ENDFOR
	ENDFOR

	FREE_LUN, lun
	RETURN, 0

END


; Read in n by n file --------------------------------------------------------------------
;  such as SM.out an SS.out

FUNCTION readnxn, nxn, file

	OPENR, lun, file, /GET_LUN, ERROR=ioerr
	IF( ioerr NE 0 ) THEN BEGIN
		PRINTF, -2, !ERR_STRING
		RETURN, 1
	ENDIF

	n = 0
	READF, lun, n
	;print, ' readnxn, n : ', n
	mat = DBLARR( n, n )
	READF, lun, mat
	; flip both ways to get low to high in altitude
	mat = TRANSPOSE( REVERSE( REVERSE( mat, 1 ), 2 ))
	;mat = TRANSPOSE( mat )
	;print, mat[ 0:2, 0:2]

	nxn = {						$
		n	: 0,				$
		mat	: DBLARR( n, n )	$
	}

	nxn.n = n
	nxn.mat = mat

	mat = 0

	FREE_LUN, lun
	RETURN, 0
END



; Read in pbpfile --------------------------------------------------------------------

FUNCTION readpbp, pbp, file

	maxpts = 262144L

	OPENR, lun, file, /GET_LUN, ERROR=ioerr
	IF( ioerr NE 0 ) THEN BEGIN
	PRINTF, -2, !ERR_STRING
	RETURN, 1
	ENDIF

	pbpstruct = { 					$
		nfit    : 0,				$
		zang    : 0,				$
		dnu     : 0.0d,				$
		npt     : 0L,				$
		nulo    : 0.0d,				$
		nuhi    : 0.0d,				$
		gndalt  : 0.0,				$
		wnu     : DBLARR(maxpts),	$
		obsspc  : FLTARR(maxpts),	$
		synspc  : FLTARR(maxpts),	$
		difspc  : FLTARR(maxpts) 	$
	}

	vec  = FLTARR( 12 )
	lvec = FLTARR( 13 )
	string1  = ''
	zang     = 0
	npt      = 0L
	dnu      = 0.0d
	nulo     = 0.0d
	nuhi     = 0.0d
	gndalt   = 0.0d
	nfits    = 0

	READF, lun, nfits
	pbp = REPLICATE( pbpstruct, nfits )
	pbp[0].nfit = nfits

	waverange= FLTARR(2)
	npt=0L


	FOR kk = 0, nfits-1 DO BEGIN
		READF, lun, zang, dnu, npt, nulo, nuhi, gndalt
		IF( npt GT maxpts ) THEN BEGIN
			PRINT, 'Spectral points in pbpfile: ', npt, ' is greater than size allocated: ', maxpts
			STOP
		ENDIF

		;PRINT, npt

		pbp[kk].zang   = zang
		pbp[kk].dnu    = dnu
		pbp[kk].npt    = npt
		pbp[kk].nulo   = nulo
		pbp[kk].nuhi   = nuhi
		pbp[kk].gndalt = gndalt

		;HELP, pbp[kk].npt
		;HELP, npt
		nu  = FLTARR( npt )
		obs = FLTARR( npt )
		clc = FLTARR( npt )
		dif = FLTARR( npt )
		;HELP, obs

		rpt = FIX( npt/12 )
		rem = npt - rpt * 12
		nu( 0:npt-1 ) = FINDGEN( npt ) * dnu + nulo

		i = 0l
		j = 0l
		FOR i=0, rpt-1 DO BEGIN
			READF, lun, lvec
			FOR j=0,11 DO obs(i*12+j) = lvec(j+1)
			READF, lun, vec
			FOR j=0,11 DO clc(i*12+j) = vec(j)
			READF, lun, vec
			FOR j=0,11 DO dif(i*12+j) = vec(j)
		ENDFOR

		IF( rem gt 0 ) THEN BEGIN
			lrvec = FLTARR( rem+1 )
			rvec = FLTARR( rem )
			READF, lun, lrvec
			FOR j=0,rem-1 DO obs((rpt)*12+j) = lrvec(j+1)
			READF, lun, rvec
			FOR j=0,rem-1 DO clc((rpt)*12+j) = rvec(j)
			READF, lun, rvec
			FOR j=0,rem-1 DO dif((rpt)*12+j) = rvec(j)
		ENDIF

		pbp[kk].wnu[0:npt-1]    = nu
		pbp[kk].obsspc[0:npt-1] = obs
		pbp[kk].synspc[0:npt-1] = clc
		pbp[kk].difspc[0:npt-1] = dif ;* 100

	ENDFOR

	FREE_LUN, lun
	RETURN, 0

END


; Read in profiles file --------------------------------------------------------------------

FUNCTION readprfs, prf, file, n

	OPENR, lun, file, /GET_LUN, ERROR=ioerr
	IF( ioerr NE 0 ) THEN BEGIN
		PRINTF, -2, !ERR_STRING
		RETURN, 1
	ENDIF

	dums = ''
	READF, lun, dums

	prf = {						$
		nlev	: n,			   $
		zbnd	: DBLARR( n ),	$
		zbar	: DBLARR( n ),	$
		avmr	: DBLARR( n ),	$
		rvmr	: DBLARR( n ),	$
		sigv	: DBLARR( n ),	$
		acol	: DBLARR( n ),	$
		rcol	: DBLARR( n ),	$
		var	: DBLARR( n )	$
	}

	mat = DBLARR( 8, n )
	READF, lun, mat
	mat = REVERSE( mat, 2 )

	FOR i = 0, n -1 DO BEGIN
		prf.zbnd[i] = mat[0,i]
		prf.zbar[i] = mat[1,i]
		prf.avmr[i] = mat[2,i]
		prf.rvmr[i] = mat[3,i]
		prf.sigv[i] = mat[4,i]
		prf.acol[i] = mat[5,i]
		prf.rcol[i] = mat[6,i]
		prf.var[i]  = mat[7,i]
	ENDFOR

    FREE_LUN, lun
	RETURN, 0

END


; Read in Eiganvectors file --------------------------------------------------------------------

FUNCTION readaevc, aev, file

	OPENR, lun, file, /GET_LUN, ERROR=ioerr
	IF( ioerr NE 0 ) THEN BEGIN
		PRINTF, -2, !ERR_STRING
		RETURN, 1
	ENDIF

	n = 0
	READF, lun, n
	PRINT, ' readaevc, n : ', n

	aev = {							$
		n		: 0,					$
		rlevl	: DBLARR( n ),		$
		imevl	: DBLARR( n ),		$
		mat	: DBLARR( n, n )	$
	}

	aev.n = n

	vec = DBLARR( n )
	mat = DBLARR( n, n )

	READF, lun, vec
	aev.rlevl = vec

	READF, lun, vec
	aev.imevl = vec

	READF, lun, mat
	aev.mat = mat

	mat = 0

	FREE_LUN, lun
	RETURN, 0

END


; Read in K matrix file --------------------------------------------------------------------

FUNCTION readkmf, kmf, file

	OPENR, lun, file, /GET_LUN, ERROR=ioerr
	IF( ioerr NE 0 ) THEN BEGIN
		PRINTF, -2, !ERR_STRING
		RETURN, 1
	ENDIF

	dums = ''
	npts = 0L		; number of spectral points
	npar = 0		; number of parameters
	ismx = 0		; last pt before mixing ratios
	nlev = 0		; same number of levels

	READF, lun, dums
	READF, lun, npts, npar, ismx, nlev
	;PRINT, npts, npar, ismx, nlev

	kmf = {		 						   $
		npts    : npts,					$
		npar    : npar,					$
		ismx    : ismx,					$
		nlev    : nlev,					$
		kmat    : DBLARR( npts, npar ),	$
		seinv   : DBLARR( npts ),		   $
		sainv   : DBLARR( npar, npar ),	$
		sa      : DBLARR( npar, npar ),	$
		shat    : DBLARR( npar, npar )	$
	}

	; K
	mat = DBLARR( npts, npar )
	READF, lun, mat
	;print, max(mat), min(mat)
	kmf.kmat = mat

	; seinv
	READF, lun, dums
	mat = DBLARR( npts )
	READF, lun, mat
	kmf.seinv = mat

	; sainv
	READF, lun, dums
	mat = DBLARR( npar, npar )
	READF, lun, mat
   kmf.sainv = mat

	; sa
	READF, lun, dums
	mat = DBLARR( npar, npar )
	READF, lun, mat;, format='(3844e26.0)'
	kmf.sa = mat
	;PRINT, kmf.sa[0:3,0:3]

	; shat
	READF, lun, dums
	mat = DBLARR( npar, npar )
	READF, lun, mat
	kmf.shat = mat

	FREE_LUN, lun
	RETURN, 0

END


; Set file names  --------------------------------------------------------------------

PRO setfilenames, pbfile, stfile, akfile, kfile, smfile, ssfile, aefile, ptfile, shfile, prfile

; spectra, fit & difference 	: pbpfile
pbfile = 'pbpfile';

; profile & apriori				: statevec
stfile = 'statevec';

; averaging kernels				: AK.out
akfile = 'AK.out'

; Jacobian						: k.out
kfile  = 'K.out';

; smoothing error				: SS.out
ssfile = 'SS.out';

; measurement error				: SM.out
smfile = 'SM.out';

; eiganvectors					: AEIGEN.out
aefile = 'AEIGEN.out';

; pressure-temperature 			; fasc.pt
ptfile = 'fasc.pt'

; comments						; summary.st
shfile = 'summary.st';

; profiles - nostly need Z boundries						; summary.st
prfile = 'PRFS.out';

;PRINT, pbfile, stfile, akfile, kfile, smfile, ssfile, aefile, ptfile, shfile

msfile = 'fasc.ms'
mxfile = 'fasc.mx'
cifile = 'cinput';
asfile = 'A-S.out';

END




	;STOP
		;	color table 5				TEK_COLOR
		; color on screen,   on ps 		on screen		on PS
		;  	0		black 				0				1
		;	50		blue				4				4
		;  	80		purple				6				6
		;  	100		red					2				2
		;  	150 	yellow
		;	200		orange
		;	230		pale yellow
		;	180		yellow green
		;  	255		white				1				0
		;			green				3				3
		;  			teal				5				5


FUNCTION Exponent, axis, index, number

	; A special case.
	IF number EQ 0 THEN RETURN, '0'

	; Assuming multiples of 10 with format.
	ex = String(number, Format='(e8.0)')
	pt = StrPos(ex, '.')

	first = StrMid(ex, 0, pt)
	sign = StrMid(ex, pt+2, 1)
	thisExponent = StrMid(ex, pt+3)

	;print, number, ex, first
	;help, first, sign

	; Shave off leading zero in exponent
	WHILE StrMid(thisExponent, 0, 1) EQ '0' DO thisExponent = StrMid(thisExponent, 1)

	; Fix for sign and missing zero problem.
	IF (Long(thisExponent) EQ 0) THEN BEGIN
		sign = ''
		thisExponent = '0'
	ENDIF

	; Make the exponent a superscript.
	IF sign EQ '-' THEN BEGIN

	IF( STRTRIM(first,2) EQ '1' ) THEN BEGIN
		RETURN, '10!U' + sign + thisExponent + '!N'
	ENDIF ELSE BEGIN
		RETURN, first + 'x10!U' + sign + thisExponent + '!N'
	ENDELSE

	ENDIF ELSE BEGIN
	IF STRTRIM(first,2) EQ '1' THEN BEGIN
		IF STRTRIM(thisExponent,2) EQ '0' THEN RETURN, '1'
		IF STRTRIM(thisExponent,2) EQ '1' THEN RETURN, '10'
		RETURN, '10!U' + thisExponent + '!N'
		ENDIF ELSE BEGIN
			RETURN, first + 'x10!U' + thisExponent + '!N'
		ENDELSE
	ENDELSE


	END