program prepspec

use spec

implicit none 


character(len=80):: bnrfile, ratfile, buffer 
real (kind=8)    :: opd, wlim1, wlim2, obs_lat, obs_lon, obs_alt, tag
integer (kind=4) :: nspec, j, n, obs_yy, obs_mm, obs_dd, obs_hh, obs_nn, obs_ss, nzero, rflag
		 
 ! lun 8  - cinput
 ! lun 20 - t15asc
 ! lun 7  - input bnr file
 ! lun 9  - ratio file
 ! lun 15 - output bnr file newratio.ispec             
		 		 
open (unit=8, file='prepspec.inp', status='old', err=668)    
call gonext(8, buffer)
read (buffer,*) obs_lat
call gonext(8, buffer)
read (buffer,*) obs_lon
call gonext(8, buffer)
read (buffer,*) obs_alt
call gonext(8, buffer)
read (buffer,*) nspec

! open output file
open(unit=20, file='t15asc', status='unknown', err=555) 

! loop over # of spectra
do j=1, nspec

	call gonext(8, buffer)
	read(buffer,'(a80)') bnrfile
	call gonext(8, buffer)
	read(buffer,*) wlim1, wlim2, opd, nzero, rflag
	call gonext(8, buffer)
	read(buffer,*) obs_yy, obs_mm, obs_dd, obs_hh, obs_nn, obs_ss
	if( rflag .eq. 1) then 
		call gonext(8, buffer)
		read(buffer,'(a80)') ratfile
	endif
	
	print *, " Opening bnr for input : ", bnrfile(1:len_trim(bnrfile))
	open(unit=7, file=bnrfile(1:len_trim(bnrfile)), form='unformatted', status='old', err=666)
  	
  	if( rflag .eq. 1) then 
		print *, ' Opening ratio file : ', ratfile(1:len_trim(ratfile))
		open(unit=9, file=ratfile(1:len_trim(ratfile)), form='unformatted', status='old', err=666)
	endif
	
	! tag this block in the t15 file with date/time
	tag = obs_dd + 100*obs_mm + 10000*obs_yy + ((obs_ss/60. + obs_nn)/60. + obs_hh)/24.
	write(20,104) tag
	
	call kpno( opd, wlim1-.1, wlim2+.1, nzero, rflag ) 

	close(7)
	
	close(9)
	
enddo                                                                         

close(20) 	! t15asc file
close(7) 	! data bnr file
close(8)		! input ascii file
close(9)	   ! ratio bnr file

print *,''                                                                  
stop 'prepspec .done.' 
                                                                        

! 1001 format( a ) 
!  101 format(a1) 
!1002 format( * )                                                       
!  102 format(4i5,a20) 
  103 format( 2(a, i3), 2f12.4) 
  104 format( f16.5 )
!  208 format(2f10.5) 
!  209 format(f5.0) 
!  212 format(2i5) 
!  500 format(a6) 
  555 write ( *, 556) 
  556 format(' t15asc error from specasc5') 
      stop 'specasc5' 
  666 write ( *, 667) 
  667 format(' abort-binary file open error called from specasc5') 
      stop 'specasc5' 
  668 write(*,669) 
  669 format(' abort-cinput file open error called from specasc5') 
      stop 'specasc5' 

! 1002 format(8f10.3) 

! 1008 format(f10.3,7i5) 
      stop 'prepspec' 
      end program prepspec                           

!--------------------------------------------------------------------------------------------
subroutine gonext(ifile, buffer)

implicit none
integer,intent(in) :: ifile
character(80),intent(out) :: buffer

buffer(1:1) = '#'
do while (buffer(1:1) .eq. '#')
    read(ifile,'(a80)') buffer
    !print *, buffer 
end do

end subroutine gonext
