program prepspec

! simple program to prepare the ascii spectral file that sfit4 expects
! reads ascii input file "prepspec.inp"
! in that are names of binary spectra files and spectral window regions
! output is the 't15asc' file for tan sfit4 run.

! the work is done by spec.f90:
! each binary file is read & the window extracted, the spectral resolution is
! diminished and zero filled if requested, the spectra may be ratioed with
! a low resolution spectra if requested.

! parts previously developed by C.P.Rinsland, A.Goldman, P.Manning, F.Hase

use spec

implicit none

character(len=80) :: bnrfile, ratfile, buffer
real          (8) :: opd, wlim1, wlim2, obs_lat, obs_lon, obs_alt, roe !, tag
integer       (4) :: nspec, j !, n, obs_yy, obs_mm, obs_dd, obs_hh, obs_nn, obs_ss
integer       (4) :: nterp, rflag

! lun 8  - input file - prepspec.inp
! lun 20 - output file - t15asc
! lun 7  - input bnr file
! lun 9  - ratio file (in bnr format)
! lun 15 - output bnr file newratio.ispec (last block only)

open (unit=8, file='prepspec.input', status='old', err=668)
call gonext(8, buffer)
read (buffer,*) obs_lat
call gonext(8, buffer)
read (buffer,*) obs_lon
call gonext(8, buffer)
read (buffer,*) obs_alt
call gonext(8, buffer)
read (buffer,*) nspec

! open output file
open(unit=20, file='t15asc.4', status='unknown', err=555)

! loop over (# of spectra) x (# of windows)
do j=1, nspec

   call gonext(8, buffer)
   read(buffer,'(a80)') bnrfile
   call gonext(8, buffer)
   read(buffer,*) wlim1, wlim2, opd, roe, nterp, rflag

   ! each t15asc block requires radius of earth, solar zenith angle, lat, lon,
   ! date and time
   ! ckopus.c puts most of this in the bnr header except lat, lon and roe
   ! hence these are given here in prepspec.inp

   !call gonext(8, buffer)
   !read(buffer,*) obs_yy, obs_mm, obs_dd, obs_hh, obs_nn, obs_ss

   if( rflag .eq. 1) then
      call gonext(8, buffer)
      read(buffer,'(a80)') ratfile
   endif

   print *, " Opening bnr for input : ", bnrfile(1:len_trim(bnrfile))
   open(unit=7, file=bnrfile(1:len_trim(bnrfile)), form='unformatted', status='old', err=666)

   if( rflag .eq. 1) then
      print *, ' Opening ratio file : ', ratfile(1:len_trim(ratfile))
      open(unit=9, file=ratfile(1:len_trim(ratfile)), form='unformatted', status='old', err=666)
   endif

   call kpno( opd, wlim1-.1, wlim2+.1, roe, obs_lat, obs_lon, nterp, rflag )

   close(7)
   close(9)

enddo

close(20)   ! t15asc file
close(7)    ! data bnr file
close(8)    ! input ascii file
close(9)    ! ratio bnr file

print *,''
stop 'prepspec .done.'


! 1001 format( a )
!  101 format(a1)
!1002 format( * )
!  102 format(4i5,a20)
!  103 format( 2(a, i3), 2f12.4)
!  104 format( f16.5 )
!  208 format(2f10.5)
!  209 format(f5.0)
!  212 format(2i5)
!  500 format(a6)
  555 write ( *, 556)
  556 format(' t15asc error from prepspec')
      stop 'prepspec'
  666 write ( *, 667)
  667 format(' abort-binary file open error called from prepspec')
      stop 'prepspec'
  668 write(*,669)
  669 format(' abort-input file open error called from prepspec')
      stop 'prepspec'

! 1002 format(8f10.3)

! 1008 format(f10.3,7i5)
      stop 'prepspec'
      end program prepspec


!--------------------------------------------------------------------------------------------
subroutine gonext(ifile, buffer)

implicit none
integer,intent(in) :: ifile
character(80),intent(out) :: buffer

buffer(1:1) = '#'
do while (buffer(1:1) .eq. '#')
    read(ifile,'(a80)') buffer
    !print *, buffer
end do

end subroutine gonext

