// Define structures for the date and time.
// All dates and times used in this program are UTC.

struct zat {
    double frac;
    int mday;
    int hour;
    int minute;
    double second;
    double zenith;
    double azimuth;
    };

struct utc_date {
    int year;
    int month;
    int day;
    int doy;				// day of year
    };

struct utc_time {
    double   frac;          // fractional day
    int      mday;          // minute of day
    long int sday;          // second of day
    int      hour;
    int      minute;
    double   second;        // Allow for fractions of a second.
    };

struct coord {
	double jd;		// julian day
	double ra;		// solar right ascension
	double dec;		// solar declination
	double az;		// solar azimuth West of South
	double zen;		// solar zenith angle
	double roe;		// geodetic earth radius
	double lat;    // obs latitude N dec deg
	double lon;    // obs longitude W dec deg
	double alt;    // obs altitude masl
	};

// Exported functions
void az_and_zen( struct utc_date *d, struct utc_time *t, double n_lat, double w_lon, struct coord *res );

void rad_of_earth( double n_lat, double w_lon, struct coord *r );

int days_in_month(int month,int year);

void adjust_date_time( struct utc_date *c_date, struct utc_time *c_time, long int adjustment);

int months( char * mon );

double jul_date( struct utc_date *d, struct utc_time *t );

int date_jul( double jd, struct utc_date *d, struct utc_time *t );