// physical and numerical constants for C-program development

/*
! Numerical Constants
! Phys. Today Aug 2001
*/

#define PI       3.14159265358979300
#define SCHMIT   2.686777500e+19
#define ALOGSQ   0.832554611157697800
#define PISQ     1.77245385090839500
#define RFACTOR  3.58116529200
#define RCONST2  1.438775200
#define STDTEMP  296.000

#define DEFx 0
#define TABx 1
#define MLOx 2
#define FL0x 3
#define SGPx 4
#define PKFx 5
#define MSAx 6
#define KPKx 7
#define TMKx 8


struct loc {
   double n_lat;
   double w_lon;
   double altud;     // masl
   int utc_offs;     // utc time offset in hours
   int sec_offs;     // time offset in seconds
   };

struct loc setsite( int siteid  );

struct loc setmysite( char* sitetag  );

//char mon[][4] = { "n", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
//                       "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };
