// constant.c

#include <stdlib.h>
#include <stdio.h>

#include"constant.h"


struct loc setmysite( char* sitetag  ) {

   struct loc site;

   if( ! strncmp( sitetag, "MLO", 3 )) site = setsite( MLOx );
   if( ! strncmp( sitetag, "TAB", 3 )) site = setsite( TABx );
   if( ! strncmp( sitetag, "FL0", 3 )) site = setsite( FL0x );
   if( ! strncmp( sitetag, "MSA", 3 )) site = setsite( MSAx );
   if( ! strncmp( sitetag, "KPK", 3 )) site = setsite( KPKx );
   if( ! strncmp( sitetag, "PKF", 3 )) site = setsite( PKFx );
   if( ! strncmp( sitetag, "SGP", 3 )) site = setsite( SGPx );
   if( ! strncmp( sitetag, "TMK", 3 )) site = setsite( TMKx );

   if( ! strncmp( sitetag, "mlo", 3 )) site = setsite( MLOx );
   if( ! strncmp( sitetag, "tab", 3 )) site = setsite( TABx );
   if( ! strncmp( sitetag, "fl0", 3 )) site = setsite( FL0x );
   if( ! strncmp( sitetag, "msa", 3 )) site = setsite( MSAx );
   if( ! strncmp( sitetag, "kpk", 3 )) site = setsite( KPKx );
   if( ! strncmp( sitetag, "pkf", 3 )) site = setsite( PKFx );
   if( ! strncmp( sitetag, "sgp", 3 )) site = setsite( SGPx );
   if( ! strncmp( sitetag, "tmk", 3 )) site = setsite( TMKx );

   return( site);

}


struct loc setsite( int siteid  ) {

   struct loc myloc;

   myloc.n_lat = 0.0;
   myloc.w_lon = 0.0;
   myloc.altud = 0.0;
   myloc.utc_offs = 0;
   myloc.sec_offs = 0;

   switch( siteid ) {

      case DEFx :
         myloc.n_lat = 0.0;
         myloc.w_lon = 0.0;
         myloc.altud = 0.0;
         myloc.utc_offs = 0;
         myloc.sec_offs = 0;
      break;
      case MSAx :
         myloc.n_lat = 0.0;
         myloc.w_lon = 0.0;
         myloc.altud = 0.0;
         myloc.utc_offs = 0;
         myloc.sec_offs = 0;
      case MLOx :
         myloc.n_lat =  19.54;
         myloc.w_lon = 155.57;
         myloc.altud = 3396.0;
         myloc.utc_offs = -10;
         myloc.sec_offs = 0;
      break;
      case TABx :
         myloc.n_lat = 76.516;
         myloc.w_lon = 68.768;
         myloc.altud =  225.0;
         myloc.utc_offs = -4;
         myloc.sec_offs = 0;
      break;
      case FL0x :
         myloc.n_lat =  40.038;
         myloc.w_lon =  105.24;
         myloc.altud = 1612.0;
         myloc.utc_offs = -7;
         myloc.sec_offs = 0;
      break;
      case SGPx :
         myloc.n_lat =   36.604;
         myloc.w_lon =   97.486;
         myloc.altud =  320.0;
         myloc.utc_offs = -6;
         myloc.sec_offs = 0;
      break;
      case PKFx :
         myloc.n_lat =   65.12;
         myloc.w_lon =  147.43;
         myloc.altud =  610.0;
         myloc.utc_offs = -9;
         myloc.sec_offs = 0;
      break;
      case KPKx:
         myloc.n_lat =   31.96;
         myloc.w_lon =  111.59;
         myloc.altud =  2060.0;
         myloc.utc_offs = -7;
         myloc.sec_offs = 0;
      break;
      case TMKx:
         myloc.n_lat =   56.97576;              // 56 58'32.74'' C
         myloc.w_lon =  274.9537;               // 85 02'46.63'' B
         myloc.altud =  106.0;                  // ~106 m
         myloc.utc_offs = +7;
         myloc.sec_offs = 0;
      break;
      default :
         printf( " setsite: Bad site name id out of range : %d\n", siteid );
         return( myloc );
   }

   return( myloc );

}



// 37
// Eureka              80.05     273.58     610.
// Ny_Alesund          78.9      11.9       20.
// Thule               76.53     291.26     225.
// Kiruna              67.84     20.41      420.
// Sodankyla           67.       27.        180
// Poker_Flat          65.12     212.57     610.
// Harestua            60.20     10.80      596.
// Bialystok           53.231    23.025     183.
// Bremen              53.1      8.9        27.
// Karlsruhe           49.09     8.43       110.
// Orlans              47.965    2.113      132.
// Garmisch            47.476    11.063     745.
// Zugspitze           47.42     10.98      2964.
// Jungfraujoch        46.55     7.98       3580.
// Park_Falls          45.945    269.727    442.
// Moshiri             44.4      142.3      200.
// Egbert              44.217    280.233    251.
// Rikubetsu           43.5      143.8      200.
// Toronto             43.66     280.60     174.
// Boulder             40.038    254.76     1612.
// Barcroft            37.58     241.76     3793.
// Lamont              36.604    262.514    320.
// Tsukuba             36.05     140.12     31.
// Table_Mtn           34.4      242.3      2300.
// Kitt_Peak           31.96     111.59     2060.
// Izana               28.30     343.52     2370.
// Mauna_Loa           19.54     204.43     3396.
// Addis_Ababa         8.983     38.80      2444.
// Paramaribo          5.81      304.79     7.
// Ascension           -7.56     14.25      20.
// Darwin              -12.424   130.89     20.
// Reunion_Maido       -21.067   55.38      2203.
// Reunion_St_Denis    -20.90    55.483     50.
// Wollongong          -34.4061   150.8793  30.
// Lauder              -45.05    169.67     370.
// Syowa_Station       -69       39.59      10.
// Arrival_Heights     -78.83    166.66     200.
//
// Station             North     East       masl
