
PRO gui_align54
  ;***** NOTE: PLEASE FEEL FREE TO ALTER AND MODIFY THIS CODE. ******
  ;DS May 06
  ;Update software to read align version 5.4 output.
  ;plot ILS RE and IMAG components.
  ;DS Jan 06
  ;Update software to give to frank: gui_align5.2 version..
  ;DS Nov 2003
  ;Gui around align51.exe, alters a few some parameters in align51.exe input file
  ;NOTE:
  ;Some paramters remain fixed and not altered such as:
  ;Input aperture shape :FIXED as circular
  ;self apodization
  ;single or double sided interferogram
  ;Vignetting
  ;Lateral positions of movable retroreflector:
  ; a single value for displacment in each dimension: y,z
  ; these displacement values remain constant for all displacement points
  ;Hene reference laser wavemunber
  ;ILS gridpoint specifications

  ;Other parameters can be altered via GUI

  ;Program SETUP
  ;a directory in guialign54.pro directory called ./ergsalig
  ;a master '.inp' file called master_align5.inp
  ;align54.exe in same directory as gui_align54.pro

  ;Main Program

  ;load colour table
  LOADCT,3

  ;read in paramters for the master .inp file
  readaligninp,alignout

  ;set GUI widget parameter
  fmax = 1.5*alignout.fov

  ;set scroll bar dimensions
  screendims = GET_SCREEN_SIZE(RESOLUTION= screenres)
  yscrollsize = 950
  IF screendims(1) LT 1024.0 THEN BEGIN
   yscrollsize = screendims(1)*0.9
  ENDIF

  ;initialise GUI widgets
  main = widget_base (title='GUI_ALIGN54', /row,units = 0,ysize=950,y_scroll_size = yscrollsize)
  cntl = widget_base (main, /column)
  ;actions
  btn =  widget_button (cntl, uvalue='GO', value='RUN ALIGN54',/frame)
  btn1 = widget_button (cntl, uvalue='QUIT', value='QUIT',/frame)

  ;interferometer/fft setup
  sld =  widget_slider (cntl, title='OPDMAX (cm)', min=0.0, max=260.0,scroll = 1,/DRAG, value=alignout.opdmax, uvalue='opdmax')
  sld1 = widget_slider (cntl, title='WVNR (cm-1)', min=0, max=20000, value=alignout.wvnr, uvalue='wvnr')
  sld7 = cw_fslider (cntl, title='circular FOV (rad)', min=0, max=1.5*fmax, value=alignout.fov, uvalue='fov')
  sld8 = cw_fslider (cntl, title='circular FOV SMEAR (rad)', min= 0, max=fmax, value=alignout.smear, uvalue='smear')
  sld10 = widget_slider (cntl, title='Apodization function', min= 1, max=8, value=alignout.apodtype, uvalue='apod')

  ;misalignment
  sld3 = cw_fslider(cntl, title='decentre FOV,Y (rad)', min=-fmax, max=fmax, value=alignout.fovy, uvalue='fovy')
  sld4 = cw_fslider (cntl, title='decentre FOV,Z (rad)', min=-fmax, max=fmax, value=alignout.fovz, uvalue='fovz')
  sld5 = cw_fslider (cntl, title='decentre LAS,Y (rad)', min=-fmax, max=fmax, value=alignout.lasy, uvalue='lasy')
  sld6 = cw_fslider (cntl, title='decentre LAS,Z (rad)', min=-fmax, max=fmax, value=alignout.lasz, uvalue='lasz')
  sld11 = cw_fslider (cntl, title='cube displacment Y (cm)', min=-2, max=2, value=alignout.laty, uvalue='laty')
  sld12 = cw_fslider (cntl, title='cube displacment Z (cm)', min=-2, max=2, value=alignout.latz, uvalue='latz')


  ;computation and plotting
  sld2 = cw_fslider (cntl, title='ACCURACY', min=0, max=2, value=alignout.accuracy, uvalue='accuracy')
  sld9 = cw_fslider (cntl, title='SKETCHOPD', min=0, max=1, value=alignout.sketchopd, uvalue='sketchopd')

  ;draw GUI and widgets
  draw = widget_draw (main, uvalue='draw', /button,xsize = 736,ysize =900,retain = 2 )   ; graphics pane
  widget_control, main, /realize                                  ; create the widgets
  widget_control, main, set_uvalue = alignout

  ;execute event manager
  xmanager, 'gui_align54', main                                    ; wait for events

END

;****************************************************************************

PRO gui_align54_event, ev                                          ; event handler
  widget_control, ev.id, get_uvalue = uvalue
  CASE uvalue OF
  ; choose case
  ;'GO' :create align5.inp and execute align54.exe,
  ;      plot haidinger fringes and other parameters
   'GO'  : begin
            widget_control,ev.top ,get_uvalue = s
            result = ''
           ; print,s
            writealigninp,s
            cd,current = workingdir
            command = workingdir + '\align54.exe'
            xyouts,0.3,0.7,'Running align54.exe.....',/normal,charsize =1.2
            spawn, command,result,err
            xyouts,0.3,0.65,'Processing align54.exe output...',/normal,charsize =1.2
            fringeload
          end
   'QUIT': widget_control, ev.top, /destroy
   'opdmax'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            ;print,s
            s.opdmax = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'wvnr'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.wvnr = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'accuracy'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.accuracy = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'fovy'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.fovy = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'fovz'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.fovz = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'lasy'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.lasy = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'lasz'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.lasz = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'fov'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.fov = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'smear'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.smear = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'sketchopd'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.sketchopd = ev.value
            widget_control, ev.top ,set_uvalue = s
           END
   'apod'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.apodtype = FIX(ev.value)
            widget_control, ev.top ,set_uvalue = s
           END
   'laty'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.laty = FIX(ev.value)
            widget_control, ev.top ,set_uvalue = s
           END
   'latz'   : BEGIN
            widget_control,ev.top ,get_uvalue = s
            s.latz = FIX(ev.value)
            widget_control, ev.top ,set_uvalue = s
           END
  END
END

;***********************************************************


;********************************************************88
PRO fringeload
;loads up the file format of sketcha.dat, the output from the program
;align51

;-Open and read, find number of elements per line, put into an array and
; read until EOF

;-Initialise
CLOSE,/ALL
linestr = ''
dum =''
opd = 0.0d
CD,current = workingdir
p1 = [0.07,0.56,0.47,0.95]
p2 = [0.57,0.56,0.90,0.95]
p3 = [0.07,0.06,0.39,0.44]
p4 = [0.57,0.061,0.89,0.44]

;open and read sketcha
OPENR,1,workingdir+'\ergsalig\sketcha.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening sketcha.dat'
READF,1,dum, opd
READF,1,linestr
;-find how many elements in line string
linedata = STRSPLIT(linestr,/EXTRACT)
linelen = size(linedata)
fgridtot = FLOAT(linedata)
fgrid = dblarr(linelen(1))

;Loop until EOF is found:
WHILE NOT EOF(1) DO BEGIN
 READF, 1, fgrid
 fgridtot = [[fgridtot],[fgrid]]
ENDWHILE
CLOSE,/ALL

;open and read in modulat.dat file
modfile = dblarr(3)
modfiletot = dblarr(3)
OPENR,1,workingdir+'\ergsalig\modulat.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening modulat.dat'
READF,1,modfiletot
WHILE NOT EOF(1) DO BEGIN
 READF, 1, modfile
 modfiletot = [[modfiletot],[modfile]]
ENDWHILE
CLOSE,/ALL

;open and read in ils.dat file
ilsfile = dblarr(3)
ilsfiletot = dblarr(3)
OPENR,1,workingdir+'\ergsalig\ils.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening ils.dat'
READF,1,ilsfiletot
WHILE NOT EOF(1) DO BEGIN
 READF, 1, ilsfile
 ilsfiletot = [[ilsfiletot],[ilsfile]]
ENDWHILE
CLOSE,/ALL

;open and read in cifg.dat file
cifgfile = dblarr(5)
cifgfiletot = dblarr(5)
OPENR,1,workingdir+'\ergsalig\cifg.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening cifg.dat'
READF,1,cifgfiletot
WHILE NOT EOF(1) DO BEGIN
 READF, 1, cifgfile
 cifgfiletot = [[cifgfiletot],[cifgfile]]
ENDWHILE
CLOSE,/ALL

;-plot fgridtot
;!X.THICK = 1.5
;!Y.THICK =1.5
;!P.CHARSIZE = 1.2
;!P.CHARTHICK = 1.3
;!P.THICK = 1.5
!P.MULTI = [0,2,2]
!P.POSITION = p1
CONTOUR,fgridtot, XSTYLE =1, YSTYLE = 1,/ISOTROPIC,NLEVELS=32,/FILL,title = 'Haidinger fringes'

maxval = max(ilsfiletot(1,*),maxplc)
xdps = 100

;plot ILS
!P.POSITION = p2
PLOT,ilsfiletot(0,(maxplc - xdps):(maxplc + xdps)),ilsfiletot(1,(maxplc - xdps):(maxplc + xdps)),$
     ytitle = '[REAL] Abitrary units',title = 'ILS', xtitle = 'Wavenumber [cm-1]'
y1max = MAX(ilsfiletot(2,*))
y1min = MIN(ilsfiletot(2,*))
axis,yaxis=1,yrange = [y1min,y1max],ystyle=1,/SAVE, YTITLE = '[IMAG] [rad]'
oplot,ilsfiletot(0,*),ilsfiletot(2,*),linestyle = 1

;plot Modulation efficiency
!P.POSITION = p3
PLOT,modfiletot(0,*),modfiletot(1,*),title = 'Apodization Function',xtitle = 'OPD [cm]',$
     ytitle = 'Modulation efficiency',ystyle = 8
y1max = MAX(modfiletot(2,*))
y1min = MIN(modfiletot(2,*))
axis,yaxis=1,yrange = [y1min,y1max],ystyle=1,/SAVE, YTITLE = 'Phase [rad]'
oplot,modfiletot(0,*),modfiletot(2,*),linestyle = 1

;plot CFIG function
!P.POSITION = p4
;find zpd
zpdind = 0
zpdind = where(cifgfiletot(0,*) EQ 0)

PLOT,cifgfiletot(0,zpdind(0):*),cifgfiletot(1,zpdind(0):*),ytitle = 'REAL, modulation',title = 'CIFG',$
     xtitle = 'OPD [cm]',ystyle =8
y2max = MAX(cifgfiletot(2,zpdind(0):*))
y2min = MIN(cifgfiletot(2,zpdind(0):*))
axis,yaxis=1,yrange = [y2min,y2max],ystyle=1,/SAVE, YTITLE = 'Phase [rad]'
oplot,cifgfiletot(0,zpdind(0):*),cifgfiletot(2,zpdind(0):*),linestyle = 1

END
;*******************************************************8
PRO readaligninp,alignout
;reads into align.inp file variables and puts the wanted
; ones into a structure. structure is then read out.
CLOSE,/ALL
linestring = ''
lineval = 0.0
strnum = 0
alignout = {opdmax:0.0 , wvnr:0.0 ,$                      ;input block 1
            accuracy:0.0, fovy:0.0 , fovz:0.0,lasy :0.0,$ ;input block 2
            lasz:0.0,fov:0.0, smear:0.0,$
            laty:0.0,latz:0.0,$                             ;input block 4
            sketchopd:0.0,$                               ;input block 5
            apodtype:0}                                   ;inputblock 6

CD,current = workingdir
OPENR,1,workingdir+'\master_align5.inp',ERROR = ioerr
IF ioerr NE 0 THEN STOP
WHILE (NOT EOF(1)) DO BEGIN
 READF,1,linestring
 strval = STRMID(linestring,0,1)
 IF (strval EQ '$') THEN BEGIN
  strnum = strnum + 1
  CASE strnum OF
   1:BEGIN
      READF,1,linestring
      READF,1,lineval
      alignout.opdmax = lineval
      READF,1,lineval
      alignout.wvnr = lineval
      FOR i=1,3 DO READF,1,linestring
     END
   2:BEGIN
      READF,1,lineval
      alignout.accuracy = lineval
      READF,1,linestring
      vals = STRSPLIT(linestring,',',/EXTRACT)
      alignout.fovy = vals(0)
      alignout.fovz = vals(1)
      READF,1,linestring
      vals = STRSPLIT(linestring,',',/EXTRACT)
      alignout.lasy = vals(0)
      alignout.lasz = vals(1)
      READF,1,lineval
      READF,1,lineval
      alignout.fov = lineval
      READF,1,lineval
      alignout.smear = lineval
     END
   3:BEGIN
      ;no vignetting information transferred
     END
   4:BEGIN
      ;read first value only, same to all
      READF,1,linestring
      vals = STRSPLIT(linestring,',',/EXTRACT)
      alignout.laty = vals(0)
      alignout.latz = vals(0)
     END
   5:BEGIN
      FOR i=1,2 DO READF,1,lineval
      READF,1,lineval
      alignout.sketchopd = lineval
     END
   6:BEGIN
      READF,1,lineval
      alignout.apodtype = lineval
     END

  END
 ENDIF
ENDWHILE
CLOSE,/ALL

END

;*********************************
PRO writealigninp,alignout
;given the structure of the variable paramters, write it back into the
;align51.inp file, align is then executed.
CLOSE,/ALL
linestring = ''
lineval = 0.0
strnum = 0
CD,current=workingdir
OPENR,1,workingdir+'\master_align5.inp',ERROR = ioerr
OPENW,2,workingdir+'\align5.inp',ERROR = ioerr
IF ioerr NE 0 THEN STOP
WHILE (NOT EOF(1)) DO BEGIN
 READF,1,linestring
 strval = STRMID(linestring,0,1)
 PRINTF,2,linestring
 IF (strval EQ '$') THEN BEGIN
  strnum = strnum + 1
  CASE strnum OF
   1:BEGIN
      READF,1,linestring
      PRINTF,2,linestring
      READF,1,lineval
      PRINTF,2,alignout.opdmax
      READF,1,lineval
      PRINTF,2,alignout.wvnr
      FOR i=1,3 DO BEGIN
       READF,1,linestring
       PRINTF,2,linestring
      ENDFOR
     END
   2:BEGIN
      READF,1,lineval
      PRINTF,2,alignout.accuracy
      READF,1,linestring
      PRINTF,2,alignout.fovy,',',alignout.fovz
      READF,1,linestring
      PRINTF,2,alignout.lasy,',',alignout.lasz
      READF,1,lineval
      PRINTF,2,lineval
      READF,1,lineval
      PRINTF,2,alignout.fov
      READF,1,lineval
      PRINTF,2,alignout.smear
     END
   3:BEGIN
      ;no vignetting information transferred
     END
   4:BEGIN
      FOR i=1,20 DO BEGIN
       READF,1,lineval
       latstring = STRTRIM(STRING(alignout.laty),2) + ',' + STRTRIM(STRING(alignout.latz),2)
       PRINTF,2,latstring
      ENDFOR
     END
   5:BEGIN
      FOR i=1,2 DO BEGIN
       READF,1,lineval
       PRINTF,2,lineval
      ENDFOR
      READF,1,lineval
      PRINTF,2,alignout.sketchopd
     END
   6:BEGIN
      READF,1,lineval
      PRINTF,2,alignout.apodtype
       FOR i=1,2 DO BEGIN
       READF,1,lineval
       PRINTF,2,lineval
      ENDFOR
     END

  END
 ENDIF
ENDWHILE
CLOSE,/ALL
END



