"""
run_all_examples.py: run all windows examples with PROFAST.
The results are stored in `example/ergs`.
Run this file in the main PROFAST folder.

author: Lena Feld
date:5.5.2021
"""


import os
import shutil
import subprocess
import glob


def run_all(examples):
    """Run all examples and store results."""

    for example in examples:
        print(f"running {example} ...")

        replace_input_file(example)

        # run linefit
        lft_executable = "lft148.exe"
        subprocess.run(lft_executable)

        # copy ergs
        copy_ergs(example)


def replace_input_file(path):
    """Move examples/path/lft14.inp to lft14.inp."""
    src = os.path.join("examples-win", path, "lft14.inp")
    dst = "lft14.inp"
    shutil.copy(src, dst)


def copy_ergs(path):
    """Copy folder ergs to ergs-linux/path/ergs."""
    src = "ergs"
    dst = os.path.join("examples-win", path, "ergs")

    # remove existing results
    if os.path.isdir(dst):
        shutil.rmtree(dst)

    shutil.copytree(src, dst)


if __name__ == "__main__":

    input_files = glob.glob(r"examples-win\**\lft14.inp", recursive=True)
    examples = []
    for input_file in input_files:
        # remove lft14.inp ending
        examples.append(input_file[13:-10])

    run_all(examples)
