PRO gui_align60
;Dan Smale Jan2009
;d.smale@niwa.co.nz

;A basic graphical user interface for align60.

;PLEASE feel free to alter and improve this program...

;------------------------------
;REQUIREMENTS:
;This program requires the following:
;- The program is set up to run under the win32/64 environment due to
;  the SPAWN command, if running under a different OS, change the SPAWNED command
;
;- A file called 'master_align6.inp' this is used as the default inp file
;  If you don't have such a file, just rename a copy of align6.inp
;  This file needs to be in the same directory from where this program is run.
;
;- The IDL procedure align60_plot, also needs to be in the same directory
;
;- The code is hardwired to the read files from the directory 'ergsalign'. This
;  directory needs to be located in the same directory as this program.
;
;------------------------------
;NOTE:
;- this gui is set up to load and display only ONE Haidinger fringe plot: 'SKETCHA'
;
;- the output of align6 can be plotted independently of the GUI program, just run the
;  program align60_plot, with the correct input directory. ie, align60_plot,'ergsalign'
;
;----------------------------------------------------------------------------------
;Start main program

;---------------------
;load in align60.inp master file
read_align60_inp,inparr


;---------------------
;set up initial align6.inp file
write_align60_inp,outarr


;---------------------------
;set up GUI

main = widget_base (title='GUI for Align60: contact d.smale@niwa.co.nz', column=2,units = 0,ysize=780,xsize =1400)
cntl = widget_base (main,/column)

;input
b1=Widget_Text(cntl,value ='ALIGN 6.0 input file contents, Edit to your liking, then press the RUN ALIGN6 button',units=2,xsize=30)
b2=Widget_Text(cntl,/Editable,value =inparr,sensitive=1,xsize=100,ysize=50,/frame,uvalue='2',/scroll,/all_events)

;graph space
draw = widget_draw (main, uvalue='draw', /button,scr_xsize = 700,scr_ysize =760,retain = 2, yoffset = -600, xoffset = 600  )   ; graphics pane

;actions
btn1 =  widget_button (cntl, uvalue='RUN', value='RUN ALIGN6',/frame,xsize =50,units=0)
btn3 =  widget_button (cntl, uvalue='QUIT', value='QUIT ALIGN6',units=2,xsize =10,/frame)

;draw GUI and widgets
widget_control, main, /realize
widget_control, main, set_uvalue = outarr

;execute event manager
XMANAGER,'gui_align60',main

END

;------------------------------------------------------
;Event manager
PRO gui_align60_event, ev
 widget_control, ev.id, get_uvalue = uvalue

    CASE uvalue OF
     'QUIT': widget_control, ev.top, /destroy

      'RUN': BEGIN

              ;clear plot
              erase
              xyouts,0.3,0.7,'Running align6.exe.....',/normal,charsize =1.2

              widget_control,ev.id, get_value = value
              widget_control, ev.top, get_uvalue = outarr

              ;write outarr to file named align6.inp
              write_align60_inp,outarr

              ;execute align6.exe
              command = 'align6.exe'
              spawn, command,result,err

              ;display results
              align60_plot,'ergsalign'

             END

      '2'  : BEGIN
            ;get user changes in editted inp text
            widget_control,ev.id, get_value = value
            widget_control, ev.top, get_uvalue = outarr
            outarr = value
            widget_control, ev.top ,set_uvalue = outarr


           END

     END

END

;----------------------------------------------------
;----------------------------------------------------
;PROCEDURES

;---------------------------------------------------
PRO read_align60_inp,outarr
;read inp file into stringarr
;file name must be master_align60.inp

outarr = strarr(10000)
linestr = ''
i=0
fname = 'master_align6.inp'

openr,u,fname,/get_lun,error = err
IF err NE 0 THEN STOP,'Error opening file: ',fname

WHILE(NOT(EOF(u))) DO BEGIN
 readf,u,linestr
 outarr(i) = linestr
 i=i+1
ENDWHILE

;close file
FREE_LUN,u

;truncate
outarr = outarr(0:i-1)

END

;-----------------------------------------------
PRO write_align60_inp,inarr
;write inarr string to file and call the file: align60.inp
;inarr contains the modified master_align60.inp string

;open file
fname = 'align6.inp'
OPENW,u,fname,error =err,/get_lun
IF err NE 0 THEN STOP,'Error opening file: ',fname

;write string array to file
n = N_ELEMENTS(inarr)
FOR i=0,n-1 DO BEGIN
 PRINTF,u,inarr(i)
END

;close file
FREE_LUN,u

END
