PRO align60_plot,indir
;loads up the file format of sketcha.dat, the output from the program
;align60

;-Open and read, find number of elements per line, put into an array and
; read until EOF

;-Initialise
CLOSE,/ALL
linestr = ''
dum =''
opd = 0.0d
CD,current = workingdir

;-----------------------------------
;-----LOAD input files--------------
;-----------------------------------

;open and read sketcha
OPENR,1,workingdir+'\' + indir + '\sketcha.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening sketcha.dat'
READF,1,dum, opd
READF,1,linestr
;-find how many elements in line string
linedata = STRSPLIT(linestr,/EXTRACT)
linelen = size(linedata)
fgridtot = FLOAT(linedata)
fgrid = dblarr(linelen(1))

;Loop until EOF is found:
WHILE NOT EOF(1) DO BEGIN
 READF, 1, fgrid
 fgridtot = [[fgridtot],[fgrid]]
ENDWHILE
CLOSE,/ALL

;open and read in modulat.dat file
modfile = dblarr(3)
modfiletot = dblarr(3)
OPENR,1,workingdir+ '\' + indir + '\modulat.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening modulat.dat'
READF,1,modfiletot
WHILE NOT EOF(1) DO BEGIN
 READF, 1, modfile
 modfiletot = [[modfiletot],[modfile]]
ENDWHILE
CLOSE,/ALL

;open and read in ils.dat file
ilsfile = dblarr(3)
ilsfiletot = dblarr(3)

OPENR,1,workingdir+ '\' + indir + '\ils.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening ils.dat'
READF,1,ilsfiletot
WHILE NOT EOF(1) DO BEGIN
 READF, 1, ilsfile
 ilsfiletot = [[ilsfiletot],[ilsfile]]
ENDWHILE
CLOSE,/ALL

;open and read in cifg.dat file
cifgfile = dblarr(5)
cifgfiletot = dblarr(5)
OPENR,1,workingdir+ '\' + indir + '\cifg.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening cifg.dat'
READF,1,cifgfiletot
WHILE NOT EOF(1) DO BEGIN
 READF, 1, cifgfile
 cifgfiletot = [[cifgfiletot],[cifgfile]]
ENDWHILE
CLOSE,/ALL

;open and read in misalign.dat file
misfile = dblarr(3)
misfiletot = dblarr(3)
OPENR,1,workingdir+ '\' + indir + '\misalign.dat',ERROR=ioerr
IF ioerr NE 0 THEN STOP,'error opening misalign.dat'
READF,1,misfiletot
WHILE NOT EOF(1) DO BEGIN
 READF, 1, misfile
 misfiletot = [[misfiletot],[misfile]]
ENDWHILE
CLOSE,/ALL


;--------------------------------------------------
;---------PLOTTING---------------------------------
;--------------------------------------------------

LOADCT,3
!P.MULTI = [0,2,3]

;-plot fgridtot
CONTOUR,fgridtot, XSTYLE =1, YSTYLE = 1,/ISOTROPIC,NLEVELS=32,/FILL,$
title = 'Haidinger fringes'

maxval = max(ilsfiletot(1,*),maxplc)
xdps = 30

;plot ILS
PLOT,ilsfiletot(0,(maxplc - xdps):(maxplc + xdps)),ilsfiletot(1,(maxplc - xdps):(maxplc + xdps)),$
     ytitle = '[REAL] Abitrary units',title = 'ILS', xtitle = 'Wavenumber [cm-1]'
y1max = MAX(ilsfiletot(2,*))
y1min = MIN(ilsfiletot(2,*))
axis,yaxis=1,yrange = [y1min,y1max],ystyle=1,/SAVE, YTITLE = '[IMAG] [rad]'
oplot,ilsfiletot(0,*),ilsfiletot(2,*),linestyle = 1

;plot Modulation efficiency
PLOT,modfiletot(0,*),modfiletot(1,*),title = 'Apodization Function',xtitle = 'OPD [cm]',$
     ytitle = 'Modulation efficiency',ystyle = 8
y1max = MAX(modfiletot(2,*))
y1min = MIN(modfiletot(2,*))
axis,yaxis=1,yrange = [y1min,y1max],ystyle=1,/SAVE, YTITLE = 'Phase [rad]'
oplot,modfiletot(0,*),modfiletot(2,*),linestyle = 1

;plot CFIG function
;find zpd
zpdind = 0
zpdind = where(cifgfiletot(0,*) EQ 0)

PLOT,cifgfiletot(0,zpdind(0):*),cifgfiletot(1,zpdind(0):*),ytitle = 'REAL, modulation',title = 'CIFG',$
     xtitle = 'OPD [cm]',ystyle =8
y2max = MAX(cifgfiletot(2,zpdind(0):*))
y2min = MIN(cifgfiletot(2,zpdind(0):*))
axis,yaxis=1,yrange = [y2min,y2max],ystyle=1,/SAVE, YTITLE = 'Phase [rad]'
oplot,cifgfiletot(0,zpdind(0):*),cifgfiletot(2,zpdind(0):*),linestyle = 1

;plot misalignment parameters
PLOT,misfiletot(0,*),misfiletot(1,*),title = 'Shear Y (function of opd)',ytitle = 'OPD [cm]'
PLOT,misfiletot(0,*),misfiletot(2,*),title = 'Shear Z (function of opd)',ytitle = 'OPD [cm]'

;-------------------------
;reset
!P.MULTI = 0

END
