pro timeticks, ts, calendar, ticks, date_format, minor=minor

  range = max(ts) - min(ts) ; days
  interval = double(long((range/5.)*24.*60.*60.)) ; tick interval secs

  nj = 20
  julians = dblarr(nj)
  julians[*] = -9999999.d

  if strcmp(calendar,'gregorian',4,/fold_case) then begin
    caldat, min(ts), mn, dy, yr, hr, min, sec
  endif else begin
    caldat_365, min(ts), mn, dy, yr, hr, min, sec
  endelse


  onesec = 1.d
  onemin = 60.d
  onehr  = 60.d*onemin
  oneday = 24.d*onehr
  onemon = 30.d*oneday
  oneyr  = 356.d*oneday

  dsec = interval
  dmin = 0
  dhr = 0
  dday = 0
  dmon = 0
  dyr = 0

  if ( interval gt 2. and interval lt 5. ) then begin 
    dsec = 2.d
    date_format = '%I:%S'
    sec = 0
    minor = 2
  endif else if ( interval lt 10. ) then begin  
    dsec = 5.d
    date_format = '%I:%S'
    sec = 0
    minor = 5
  endif else if ( interval lt 20. ) then begin  
    dsec = 10.d
    date_format = '%I:%S'
    sec = 0
    minor = 5
  endif else if ( interval lt 60. ) then begin  
    dsec = 30.d
    date_format = '%I:%S'
    sec = 0
    minor = 5
  endif else if ( interval lt 2.*onemin ) then begin  
    dsec = 0.d
    dmin = 1
    date_format = '%H:%I'
    sec = 0
    min = 0
    minor = 6
  endif else if ( interval lt 5.*onemin ) then begin  
    dsec = 0.d
    dmin = 2
    date_format = '%H:%I'
    sec = 0
    min = 0
    minor = 2
  endif else if ( interval lt 10.*onemin ) then begin  
    dsec = 0.d
    dmin = 5
    date_format = '%H:%I'
    sec = 0
    min = 0
    minor = 5
  endif else if ( interval lt 20.*onemin ) then begin  
    dsec = 0.d
    dmin = 10
    date_format = '%H:%I'
    sec = 0
    min = 0
    minor = 5
  endif else if ( interval lt onehr ) then begin  
    dsec = 0.d
    dmin = 30
    date_format = '%H:%I'
    sec = 0
    min = 0
    minor = 5
  endif else if ( interval lt 2.*onehr ) then begin  
    dsec = 0.d
    dhr = 1
    date_format = '%H:%I'
    sec = 0
    min = 0
    minor = 6
  endif else if ( interval lt 4.*onehr ) then begin  
    dsec = 0.d
    dhr = 2
    date_format = '%H:%I'
    sec = 0
    min = 0
    hr = 0
    minor = 2
  endif else if ( interval lt 6.*onehr ) then begin  
    dsec = 0.d
    dhr = 4
    date_format = '%H:%I'
    sec = 0
    min = 0
    hr = 0
    minor = 4
  endif else if ( interval lt 12.*onehr ) then begin  
    dsec = 0.d
    dhr = 6
    date_format = '%H:%I'
    sec = 0
    min = 0
    hr = 0
    minor = 6
  endif else if ( interval lt 24.*onehr ) then begin  
    dsec = 0.d
    dhr = 12
    date_format = '%H:%I'
    sec = 0
    min = 0
    hr = 0
    minor = 6
  endif else if ( interval lt 2.*oneday ) then begin  
    dsec = 0.d
    dday = 1
    date_format = '%D!C%M'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    minor = 4
  endif else if ( interval lt 5.*oneday ) then begin  
    dsec = 0.d
    dday = 2
    date_format = '%D!C%M'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    minor = 2
  endif else if ( interval lt 10.*oneday ) then begin  
    dsec = 0.d
    dday = 5
    date_format = '%D!C%M'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    minor = 5
  endif else if ( interval lt 20.*oneday ) then begin  
    dsec = 0.d
    dday = 10
    date_format = '%D!C%M'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    minor = 10
  endif else if ( interval lt onemon ) then begin  
    dsec = 0.d
    dday = 20
    date_format = '%D!C%M'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    minor = 10
  endif else if ( interval lt 2.*onemon ) then begin  
    dsec = 0.d
    dmon = 1
    date_format = '%M!C%Y'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    mn= 1
    minor = 1
  endif else if ( interval lt 4.*onemon ) then begin  
    dsec = 0.d
    dmon = 2
    date_format = '%M!C%Y'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    mn= 1
    minor = 2
  endif else if ( interval lt 6.*onemon ) then begin  
    dsec = 0.d
    dmon = 4
    date_format = '%M!C%Y'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    mn= 1
    minor = 4
  endif else if ( interval lt 12.*onemon ) then begin  
    dsec = 0.d
    dmon = 6
    date_format = '%M!C%Y'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    mn= 1
    minor = 6
  endif else if ( interval lt 2.*oneyr ) then begin  
    dsec = 0.d
    dyr = 1
    date_format = '%Y'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    mn= 1
    minor = 12
  endif else if ( interval lt 5.*oneyr ) then begin  
    dsec = 0.d
    dyr = 2
    date_format = '%Y'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    mn= 1
    yr = yr - ( yr mod dyr )
    minor = 2
  endif else if ( interval lt 10.*oneyr ) then begin  
    dsec = 0.d
    dyr = 5
    date_format = '%Y'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    mn= 1
    yr = yr - ( yr mod dyr )
    minor = 5
  endif else begin
    dsec = 0.d
    dyr = 10
    date_format = '%Y'
    sec = 0
    min = 0
    hr = 0
    dy = 1
    mn= 1
    yr = yr - ( yr mod dyr )
    minor = 10
  endelse


  for i=0,nj-1 do begin

    if strcmp(calendar,'gregorian',4,/fold_case) then begin
      if (yr gt 0) then julians[i] = julday(mn,dy,yr,hr,min,sec)
    endif else begin
      julians[i] = julday_365(mn,dy,yr,hr,min,sec)
    endelse

    mn = mn+dmon
    dy = dy+dday
    yr = yr+dyr
    hr = hr+dhr
    min= min+dmin
    sec= sec+dsec
 
  endfor

  indxs = where( julians ge min(ts) and julians le max(ts) )

  ticks = julians[indxs]
  
end
pro test_timeticks

;  ts = [14.323, 23233.99]
  ts = [1.d, 12.d]
  calendar = 'noleap'

  timeticks, ts, calendar, ticks, date_format

  print, 'ticks = ',ticks

  print,'date_format = ',date_format

end
