

;; ***************************************************
;;  Replace all 'MGS_Object' with your object name
;;  Delete this comment
;; ***************************************************



;+
; NAME:
;    mgs_object
;
; PURPOSE:
;    This is a 
;
; CATEGORY:
;    (Objects)
;
; AUTHOR:
;    Martin G. Schultz
;    Max-Planck-Institut fuer Meteorologie
;    Bundesstr. 55
;    20146 Hamburg
;    email: martin.schultz@dkrz.de
;
; REQUIREMENTS:
;    Inherits from MGS_BaseObject (error handling, uvalue)
;
; MODIFICATION HISTORY:
;    mgs, dd MM yyyy: VERSION 1.0
;-
;
;###########################################################################
;
; LICENSE
;
; This software is OSI Certified Open Source Software.
; OSI Certified is a certification mark of the Open Source Initiative.
;
; Copyright  2000 Martin Schultz
;
; This software is provided "as-is", without any express or
; implied warranty. In no event will the authors be held liable
; for any damages arising from the use of this software.
;
; Permission is granted to anyone to use this software for any
; purpose, including commercial applications, and to alter it and
; redistribute it freely, subject to the following restrictions:
;
; 1. The origin of this software must not be misrepresented; you must
;    not claim you wrote the original software. If you use this software
;    in a product, an acknowledgment in the product documentation
;    would be appreciated, but is not required.
;
; 2. Altered source versions must be plainly marked as such, and must
;    not be misrepresented as being the original software.
;
; 3. This notice may not be removed or altered from any source distribution.
;
; For more information on Open Source Software, visit the Open Source
; web site: http://www.opensource.org.
;
;###########################################################################



; -----------------------------------------------------------------------------
; GetProperty:
; This method extracts specific object values and returns them to the
; user. 

PRO MGS_Object::GetProperty, $
   Dummy=dummy,           $     ; A dummy property
   _Ref_Extra=extra             ; Inherited and future keywords
                                ;
                                ; Inherited keywords:
                                ; name      : The variable name
                                ; uvalue    : a user-defined value


   ;; Get properties from base object
   self->MGS_BaseObject::GetProperty, _Extra=extra

   Catch, theError
   IF theError NE 0 THEN BEGIN
      self->ErrorMessage, 'Error retrieving object properties!'
      RETURN
   ENDIF

   ;; Get file properties
   dummy = self.dummy

   ;; (for pointer variables)
   ;; IF Arg_Present(gattr) THEN BEGIN
   ;;   IF Ptr_Valid(self.gattr) THEN $
   ;;     gattr = *self.gattr  $
   ;;   ELSE  $
   ;;     self->Undefine, gattr
   ;; ENDIF

END 


; -----------------------------------------------------------------------------
; SetProperty:
; This method sets specific object values. Derived objects may want to
; overwrite and extend this method to allow storing additional
; information.

PRO MGS_Object::SetProperty, $
   Dummy=dummy,              $ ; A dummy property
   _Ref_Extra=extra                ;
                                   ; Inherited keywords:
                                   ; name      : The variable name
                                   ; no_copy   : Don't keep local copy
                                   ;             of uvalue
                                   ; no_dialog : Don't display
                                   ;             interactive dialogs
                                   ; uvalue    : a user-defined value


   Catch, theError
   IF theError NE 0 THEN BEGIN
      Catch, /Cancel
      self->ErrorMessage, 'Error setting object properties!'
      RETURN
   ENDIF

   ;; Set Properties of base object
   self->MGS_BaseObject::SetProperty, _Extra=extra


   ;; Reset dummy value
   IF N_Elements(dummy) NE 0 THEN $
      self.dummy = dummy

   ;; (for pointer values)
   ;; IF N_Elements(gattr) GT 0 THEN BEGIN
   ;;   IF Ptr_Valid(self.gattr) THEN Ptr_Free, self.gattr
   ;;   self.gattr = Ptr_New(gattr)  
   ;;   IF ChkStru(gattr, 'title') THEN self.title = gattr.title
   ;; ENDIF 
   
END


; -----------------------------------------------------------------------------
; Cleanup:
; This method frees all data stored in the object.

PRO MGS_Object::CLEANUP

   ;; Destroy any GUI
   ;; self->KillGUI

   ;; Close the file if needed
   ;; self->Close

   ;; Destroy pointer variables
   ;; IF Ptr_Valid(self.gattr)    THEN Ptr_Free, self.gattr

   ;; Call parent's cleanup method
   self->MGS_BaseObject::Cleanup

END 




; -----------------------------------------------------------------------------
; Init:
;   This method initializes the file object. 

FUNCTION MGS_Object::INIT, $
      Dummy=dummy,           $         ; A dummy property
      _Ref_Extra=extra                 ; For inherited and future keywords
                                       ;
                                       ; Inherited keywords:
                                ; name      : The object name
                                ; no_copy   : Don't retain a copy
                                ;             of uvalue
                                ; no_dialog : Don't display
                                ;             interactive dialogs
                                ; uvalue    : a user-defined value
   


   ;; Initialize parent object first
   IF not self->MGS_BaseObject::Init(_Extra=extra) THEN RETURN, 0
   
   Catch, theError
   IF theError NE 0 THEN BEGIN
      Catch, /Cancel
      self->ErrorMessage, 'Error initializing object!'
      RETURN, 0
   ENDIF
   
   IF N_Elements(dummy) EQ 0 THEN dummy = 0
   
   RETURN, 1
END 



; -----------------------------------------------------------------------------
; MGS_Object__Define:
; This is the object definition for a generic object. It
; inherits from MGS_BaseObject the abilities to set and query an
; object name and a uvalue. The base object also provides a general
; method for display of error messages which can be directed to a
; message dialog or to the log screen via the no_dialog flag.

PRO MGS_Object__Define

   objectClass = { MGS_Object, $ ; The object class
           dummy: 0,           $ ; A dummy property
           ;;; heritage
           INHERITS MGS_BaseObject  $ ; provides basic general properties
     }

END
