function julian_day_to_date, julianDay, leap=leap

  julianDay = julianDay mod 365
  daysPerMonth = [31, 28, 31, 30,$
                  31, 30, 31, 31,$
                  30, 31, 30, 31]
  if (keyword_set(leap)) then daysPerMonth[1]=29

  daysGone = 0
  for i=0,11,+1 do begin
      if (daysGone + daysPerMonth[i] lt julianDay) then begin
          daysGone = daysGone + daysPerMonth[i]
      endif else begin
          mm = i+1
          dd = julianDay - daysGone
          date = string(format='(I2.2,A1,I2.2)',mm,'/',dd)
          return, date
      endelse
  endfor
  return,'??/??'
end
