; utility function to check if a given grid (latitudes or longitudes) is supposed to span a full circle
FUNCTION grid_goes_around, xs, span

  nxs = n_elements(*xs)
  if (nxs gt 1) then begin
      ; first and last grid points overlap
      if ( abs( (*xs)[0]+span-(*xs)[nxs-1] ) eq 0 ) then return, 1 
      ; first and last grid points differ by less than twice the grid spacing
      if ( abs( (*xs)[0]+span-(*xs)[nxs-1] ) lt 2*( (*xs)[1]-(*xs)[0] ) ) then return, 2
  endif
  return, 0

END
