function get_julian_day, date  ; 'yymmdd'

  if (strlen(date) eq 8) then date = strmid(date,2) ; 'yyyymmdd' --> 'yymmdd'

  reads,date,yy,mm,dd,format='(I2,I2,I2)'
  daysPerMonth = [31, 28, 31, 30,$
                  31, 30, 31, 31,$
                  30, 31, 30, 31]

  if ( (yy mod 4) eq 0 ) then daysPerMonth[1] = 29  ; leap year

  julianDay = dd
  for iMonth=mm-1,1,-1 do begin
      julianDay = julianDay + daysPerMonth[iMonth-1]
  endfor

  return, julianDay

end
