; function to retrieve selected data from given file
; NOTE: calling program must take care of deallocating memory
FUNCTION ncfile::get_data, vid, offsets, counts
   @geov_pars

   ; check
   if (vid lt 0 or vid gt self.nvars-1) then begin
      print,'ERROR 1 in ncfile::get_data:'
      print,' Invalid variable id:', vid, self.nvars-1
   ENDIF 
   if (   n_elements(offsets) ne (*self.vndims)[vid] $
       or n_elements(counts) ne (*self.vndims)[vid] ) then begin
       print,'ERROR 2 in ncfile::get_data:'
       print,'Inconsistent number of offsets or counts:', $
          n_elements(offsets), n_elements(counts), $
          '<>',(*self.vndims)[vid]
       print,'for variable ',(*self.vnames)[vid]
       print,'with dimension indices ',*((*self.v2dims)[vid])
    ENDIF 

   ; extract values
   NCDF_VARGET, self.fid, vid, data, offset=offsets, count=counts

   if n_elements(data) eq 1 then data = [data]
   data_ptr = ptr_new(data, /NO_COPY)  ; promotes data to heap variable and return pointer

   return, data_ptr
END
