; access methods
FUNCTION ncfile::get_ndims
  return, self.ndims
END
FUNCTION ncfile::get_dnames
  return, self.dnames
END
FUNCTION ncfile::get_dsizes
  return, self.dsizes
END

FUNCTION ncfile::get_nvars
  return, self.nvars
END
FUNCTION ncfile::get_vnames
  return, self.vnames
END
FUNCTION ncfile::get_vunits
  return, self.vunits
END
FUNCTION ncfile::get_vnulls
  return, self.vnulls
END
FUNCTION ncfile::get_vndims
  return, self.vndims
END

FUNCTION ncfile::get_fname
  return, self.fname
END

FUNCTION ncfile::get_fid
  return, self.fid
END

FUNCTION ncfile::get_vnull, vid
  return,(*self.vnulls)[vid]
END

FUNCTION ncfile::var_depends_on_ilevi, vid

  if self.ilevi lt 0 then return, 0 ; ilev does not exist in file

  xx = where( (*(*self.v2dims)[vid]) eq (*self.cdims)[self.ilevi], cnt )
  if cnt gt 0 then return, 1

  return, 0

end

FUNCTION ncfile::get_dimid_of_var, idim, vid
  ; check
  if (vid lt 0 or vid gt self.nvars-1) then $
      print,string('ERROR 1 in ncfile::get_dimid_of_var:',vid,self.nvars-1)
  if (idim lt 0 or idim gt (*self.vndims)[vid]-1) then $
      ;return, -1  ; indicate this variable is independent of specified dimension (idim)
      print,string('ERROR 2 in ncfile::get_dimid_of_var:',idim,(*self.vndims)[vid]-1),vid

  return, (*(*self.v2dims)[vid])[idim]
END

FUNCTION ncfile::get_vid, vname
  for vid = 0, self.nvars-1 do begin
     if ((*self.vnames)[vid] eq vname) then begin
        return, vid
     endif
  endfor
  return, -1
END

PRO ncfile::get
END
