; IDL object representing a netCDF file following the NCAR-CSM convention
PRO nccoordfile__define
    struct = { nccoordfile,            $ ; class name
               inherits ncfile,        $ ; superclass

               ; the following arrays have dimension ncoords 
               ; and are ordered as the coordinates (variables) appear in file:
               ncoords:0L,             $ ; number of coordinates
               cdims:ptr_new(),        $ ; array containing ids of coordinate dimensions
               cvars:ptr_new(),        $ ; array containing ids of coordinate variables 
               coords:ptr_new(),       $ ; pointer to array of pointers to coordinate values 
               cflags:ptr_new(),       $ ; flags for special coordinate processing
               clabels:ptr_new(),      $ ; model-customized coordinate labels

               ; dimension ndims
               d2coord:ptr_new(),      $ ; pointer from dimension id to coordinate number

               ; plottable variables
               npvars:0L,              $ ; number of plotting variables
               pvars:ptr_new()         $ ; array containing ids of plotting variables (ordered alphabetically)

    }
END
