; main mapper method which must be implemented by subclass
; default method simply draws a map with given parameters
PRO mapper::map
    @map_pars

    ; set map projection keywords
    ortho=0       & if (self.map_projection eq MAP_ORTHOGRAPHIC)  then ortho=1
    stereo=0      & if (self.map_projection eq MAP_STEREOGRAPHIC) then stereo=1
    gnomic=0      & if (self.map_projection eq MAP_GNOMIC)        then gnomic = 1
    azimuthal=0   & if (self.map_projection eq MAP_AZIMUTHAL)     then azimuthal=1
    aitoff=0      & if (self.map_projection eq MAP_AITOFF)        then aitoff=1
    lambert=0     & if (self.map_projection eq MAP_LAMBERT)       then lambert=1
    hammer=0      & if (self.map_projection eq MAP_HAMMER)        then hammer=1
    mercator=0    & if (self.map_projection eq MAP_MERCATOR)      then mercator=1
    transverse=0  & if (self.map_projection eq MAP_TRANSVERSE)    then transverse=1
    cylindrical=0 & if (self.map_projection eq MAP_CYLINDRICAL)   then cyl=1
    miller=0      & if (self.map_projection eq MAP_MILLER)        then miller=1
    conic=0       & if (self.map_projection eq MAP_CONIC)         then conic=1
    albers=0      & if (self.map_projection eq MAP_ALBERS)        then albers=1
    sinusoidal=0  & if (self.map_projection eq MAP_SINUSOIDAL)    then sinusoidal=1
    mollweide=0   & if (self.map_projection eq MAP_MOLLWEIDE)     then mollweide=1

    map_set, self.map_center[0], self.map_center[1],       $
             limit=self.map_limits,                        $
             ortho=ortho,                                  $
             stereo=stereo,                                $
             gnomic=gnomic,                                $
             azimuthal=azimuthal,                          $
             aitoff=aitoff,                                $
             lambert=lambert,                              $
             hammer=hammer,                                $
             mercator=mercator,                            $
             transverse=transverse,                        $
             cyl=cyl,                                      $
             miller=miller,                                $
             conic=conic,                                  $
             albers=albers,                                $
             sinusoidal=sinusoidal,                        $
             mollweide=mollweide,                          $
             isotropic=self.map_flags[MAP_FLAG_ISOTROPIC], $
             /continents

    if (self.map_flags[MAP_FLAG_BORDER]) then map_grid, /box_axes

END
